/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.subgit.stash.mirror.settings;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.annotations.Nullable;
import org.tmatesoft.subgit.stash.mirror.settings.SgSetting;
import org.tmatesoft.subgit.stash.mirror.settings.SgSettingsEditor;
import org.tmatesoft.subgit.stash.mirror.settings.SgSettingsSnapshot;
import org.tmatesoft.subgit.stash.mirror.settings.SgSettingsType;

public abstract class SgSettings
implements Serializable {
    private final SgSettingsType type;
    private final ReadWriteLock accessLock;
    private SgSettings parent;

    protected SgSettings(SgSettingsType sgSettingsType, SgSettings sgSettings) {
        this.parent = sgSettings;
        this.type = sgSettingsType;
        this.accessLock = new ReentrantReadWriteLock(true);
    }

    protected SgSettings getParent() {
        return this.parent;
    }

    public SgSettingsType getType() {
        return this.type;
    }

    protected void setParent(SgSettings sgSettings) {
        if (this.parent == null) {
            this.parent = sgSettings;
        } else if (sgSettings != null) {
            this.getParent().setParent(sgSettings);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object get(SgSetting sgSetting, SgSettingsType ... sgSettingsTypeArray) {
        this.accessLock.readLock().lock();
        try {
            Object object;
            Object object2 = object = this.hasType(sgSettingsTypeArray) ? this.doGet(sgSetting) : null;
            if (object == null && this.getParent() != null) {
                Object object3 = this.getParent().get(sgSetting, sgSettingsTypeArray);
                return object3;
            }
            if (object == null) {
                Object object4 = SgSettings.nullValue();
                return object4;
            }
            Object object5 = object;
            return object5;
        }
        finally {
            this.accessLock.readLock().unlock();
        }
    }

    private static Object nullValue() {
        return null;
    }

    protected boolean hasType(SgSettingsType[] sgSettingsTypeArray) {
        if (sgSettingsTypeArray == null || sgSettingsTypeArray.length == 0) {
            return true;
        }
        for (SgSettingsType sgSettingsType : sgSettingsTypeArray) {
            if (!sgSettingsType.matches(this.type)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final SgSettings set(SgSetting sgSetting, @Nullable Object object) {
        this.accessLock.writeLock().lock();
        try {
            SgSettings sgSettings = this.doSet(sgSetting, object);
            return sgSettings;
        }
        finally {
            this.accessLock.writeLock().unlock();
        }
    }

    protected abstract Object doGet(SgSetting var1);

    protected abstract SgSettings doSet(SgSetting var1, @Nullable Object var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SgSettingsSnapshot snapshot(Collection collection) {
        this.accessLock.readLock().lock();
        try {
            HashMap<SgSetting, Object> hashMap = new HashMap<SgSetting, Object>();
            for (SgSetting sgSetting : collection) {
                Object object = this.doGet(sgSetting);
                hashMap.put(sgSetting, object);
            }
            SgSettingsSnapshot sgSettingsSnapshot = new SgSettingsSnapshot(this.type, this.getParent() != null ? this.getParent().snapshot(collection) : null, this, hashMap);
            return sgSettingsSnapshot;
        }
        finally {
            this.accessLock.readLock().unlock();
        }
    }

    public SgSettingsEditor editor() {
        return new SgSettingsEditor(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void save(SgSettingsEditor sgSettingsEditor) {
        if (sgSettingsEditor.getParent() != this) {
            return;
        }
        this.accessLock.writeLock().lock();
        try {
            for (SgSetting sgSetting : sgSettingsEditor.changedKeys()) {
                this.set(sgSetting, sgSettingsEditor.get(sgSetting, SgSettingsType.EDITOR));
            }
        }
        finally {
            this.accessLock.writeLock().unlock();
        }
    }
}

