/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.subgit.stash.mirror.scheduler.proxy;

import com.atlassian.bitbucket.topic.MessageEvent;
import com.atlassian.bitbucket.topic.Topic;
import com.atlassian.bitbucket.topic.TopicListener;
import com.atlassian.bitbucket.topic.TopicService;
import com.atlassian.bitbucket.topic.TopicSettings;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.tmatesoft.subgit.stash.mirror.SgException;
import org.tmatesoft.subgit.stash.mirror.scheduler.ISgConsole;
import org.tmatesoft.subgit.stash.mirror.scheduler.ISgTask;
import org.tmatesoft.subgit.stash.mirror.scheduler.ISgTaskScheduler;
import org.tmatesoft.subgit.stash.mirror.scheduler.SgTaskSchedulerSnapshot;
import org.tmatesoft.subgit.stash.mirror.scheduler.SgTaskScope;
import org.tmatesoft.subgit.stash.mirror.scheduler.SgTaskState;
import org.tmatesoft.subgit.stash.mirror.scheduler.message.SgCancelTaskMessage;
import org.tmatesoft.subgit.stash.mirror.scheduler.message.SgClusterMessage;
import org.tmatesoft.subgit.stash.mirror.scheduler.message.SgConsoleMessage;
import org.tmatesoft.subgit.stash.mirror.scheduler.message.SgRequestSnapshotMessage;
import org.tmatesoft.subgit.stash.mirror.scheduler.message.SgScheduleTaskMessage;
import org.tmatesoft.subgit.stash.mirror.scheduler.message.SgSnapshotMessage;
import org.tmatesoft.subgit.stash.mirror.scheduler.message.SgTaskCancelledMessage;
import org.tmatesoft.subgit.stash.mirror.scheduler.message.SgTaskCompletedMessage;
import org.tmatesoft.subgit.stash.mirror.scheduler.message.SgTaskScheduledMessage;
import org.tmatesoft.subgit.stash.mirror.scheduler.proxy.SgProxyTask;
import org.tmatesoft.subgit.stash.mirror.scheduler.proxy.SgProxyTaskScheduler$TaskCancellationInfo;
import org.tmatesoft.subgit.stash.mirror.tasks.SgPushTaskParameters;
import org.tmatesoft.subgit.stash.mirror.util.SgTextUtil;

public class SgProxyTaskScheduler
implements TopicListener,
ISgTaskScheduler {
    private static final long CANCEL_TASK_TIMEOUT = 5000L;
    private final Map pollQueues;
    private final Logger logger;
    private final String nodeId;
    private final Map subscriptionIds;
    private final Map pendingTasks;
    private final Map scheduledTasks;
    private final Map cancelledTasks;
    private final Map consoles;
    private final Topic requestSnapshotTopic;
    private final Topic scheduleTaskTopic;
    private final Topic cancelTaskTopic;
    private final Topic releaseQueueTopic;

    public SgProxyTaskScheduler(String string, TopicService topicService, Logger logger) {
        this.logger = logger;
        this.nodeId = string;
        this.pollQueues = new HashMap();
        this.pendingTasks = new HashMap();
        this.scheduledTasks = new HashMap();
        this.cancelledTasks = new HashMap();
        this.consoles = new HashMap();
        this.subscriptionIds = new HashMap();
        Topic topic = topicService.getTopic("org.tmatesoft.subgit.stash.mirror.topic:snapshot", TopicSettings.builder((Class)null).build());
        Topic topic2 = topicService.getTopic("org.tmatesoft.subgit.stash.mirror.topic:taskCompleted", TopicSettings.builder((Class)null).build());
        Topic topic3 = topicService.getTopic("org.tmatesoft.subgit.stash.mirror.topic:taskScheduled", TopicSettings.builder((Class)null).build());
        Topic topic4 = topicService.getTopic("org.tmatesoft.subgit.stash.mirror.topic:taskStarted", TopicSettings.builder((Class)null).build());
        Topic topic5 = topicService.getTopic("org.tmatesoft.subgit.stash.mirror.topic:taskCancelled", TopicSettings.builder((Class)null).build());
        Topic topic6 = topicService.getTopic("org.tmatesoft.subgit.stash.mirror.topic:console", TopicSettings.builder((Class)null).build());
        this.subscriptionIds.put(topic, topic.subscribe((TopicListener)this));
        this.subscriptionIds.put(topic2, topic2.subscribe((TopicListener)this));
        this.subscriptionIds.put(topic3, topic3.subscribe((TopicListener)this));
        this.subscriptionIds.put(topic4, topic4.subscribe((TopicListener)this));
        this.subscriptionIds.put(topic5, topic5.subscribe((TopicListener)this));
        this.subscriptionIds.put(topic6, topic6.subscribe((TopicListener)this));
        this.requestSnapshotTopic = topicService.getTopic("org.tmatesoft.subgit.stash.mirror.topic:obtainQueue", TopicSettings.builder((Class)null).build());
        this.scheduleTaskTopic = topicService.getTopic("org.tmatesoft.subgit.stash.mirror.topic:scheduleTask", TopicSettings.builder((Class)null).build());
        this.cancelTaskTopic = topicService.getTopic("org.tmatesoft.subgit.stash.mirror.topic:cancelTask", TopicSettings.builder((Class)null).build());
        this.releaseQueueTopic = topicService.getTopic("org.tmatesoft.subgit.stash.mirror.topic:releaseQueue", TopicSettings.builder((Class)null).build());
    }

    @Override
    public synchronized BlockingQueue obtainQueue(SgTaskScope sgTaskScope) {
        BlockingQueue blockingQueue;
        this.logS(sgTaskScope, "queue requested", new Object[0]);
        if (!this.pollQueues.containsKey(sgTaskScope)) {
            this.pollQueues.put(sgTaskScope, new HashMap());
        }
        if (((Map)this.pollQueues.get(sgTaskScope)).containsKey(Thread.currentThread())) {
            blockingQueue = (BlockingQueue)((Map)this.pollQueues.get(sgTaskScope)).get(Thread.currentThread());
        } else {
            blockingQueue = new LinkedBlockingQueue();
            ((Map)this.pollQueues.get(sgTaskScope)).put(Thread.currentThread(), blockingQueue);
        }
        this.logS(sgTaskScope, "snapshot requested from the master", new Object[0]);
        this.requestSnapshotTopic.publish((Serializable)new SgRequestSnapshotMessage(sgTaskScope));
        return blockingQueue;
    }

    @Override
    public synchronized void releaseQueue(SgTaskScope sgTaskScope) {
        this.logS(sgTaskScope, "queue released", new Object[0]);
        if (this.pollQueues.containsKey(sgTaskScope)) {
            ((Map)this.pollQueues.get(sgTaskScope)).remove(Thread.currentThread());
            if (((Map)this.pollQueues.get(sgTaskScope)).isEmpty()) {
                this.pollQueues.remove(sgTaskScope);
                this.logS(sgTaskScope, "queue release requested from the master", new Object[0]);
                this.releaseQueueTopic.publish((Serializable)new SgRequestSnapshotMessage(sgTaskScope));
            }
        }
    }

    @Override
    public void refresh() {
    }

    @Override
    public synchronized void cleanup() {
        HashSet hashSet = new HashSet(this.pollQueues.keySet());
        for (SgTaskScope sgTaskScope : hashSet) {
            HashSet hashSet2 = new HashSet(((Map)this.pollQueues.get(sgTaskScope)).keySet());
            for (Thread thread : hashSet2) {
                if (thread.isAlive()) continue;
                this.logS(sgTaskScope, "thread queue (" + String.valueOf(thread) + ") is no longer alive, removing", new Object[0]);
                ((Map)this.pollQueues.get(sgTaskScope)).remove(thread);
                if (!((Map)this.pollQueues.get(sgTaskScope)).isEmpty()) continue;
                this.logS(sgTaskScope, "no scope queues, removing", new Object[0]);
                this.pollQueues.remove(sgTaskScope);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ISgTask schedule(SgTaskScope sgTaskScope, String string, Serializable serializable) {
        SgScheduleTaskMessage sgScheduleTaskMessage = new SgScheduleTaskMessage(sgTaskScope, string, serializable);
        SgProxyTask sgProxyTask = new SgProxyTask(sgTaskScope, this);
        Object object = this.pendingTasks;
        synchronized (object) {
            this.pendingTasks.put(sgScheduleTaskMessage.getMessageId(), sgProxyTask);
        }
        if (serializable instanceof SgPushTaskParameters) {
            object = (SgPushTaskParameters)serializable;
            Map map = this.consoles;
            synchronized (map) {
                this.consoles.put(sgScheduleTaskMessage.getMessageId(), ((SgPushTaskParameters)object).getConsole());
            }
        }
        this.scheduleTaskTopic.publish((Serializable)sgScheduleTaskMessage);
        sgProxyTask.waitForSchedule();
        return sgProxyTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long cancelTask(SgTaskScope sgTaskScope, long l2) {
        SgProxyTaskScheduler$TaskCancellationInfo sgProxyTaskScheduler$TaskCancellationInfo = new SgProxyTaskScheduler$TaskCancellationInfo();
        Map map = this.cancelledTasks;
        synchronized (map) {
            this.cancelledTasks.put(l2, sgProxyTaskScheduler$TaskCancellationInfo);
        }
        this.cancelTaskTopic.publish((Serializable)new SgCancelTaskMessage(sgTaskScope, l2));
        sgProxyTaskScheduler$TaskCancellationInfo.waitForResult(5000L);
        if (sgProxyTaskScheduler$TaskCancellationInfo.getErrorMessage() != null) {
            throw new SgException(sgProxyTaskScheduler$TaskCancellationInfo.getErrorMessage());
        }
        return sgProxyTaskScheduler$TaskCancellationInfo.getId();
    }

    public synchronized void shutdown() {
        this.logger.info("proxy scheduler shutdown");
        for (Object object : this.subscriptionIds.keySet()) {
            if (object == null || this.subscriptionIds.get(object) == null) continue;
            object.unsubscribe((String)this.subscriptionIds.get(object));
        }
        this.subscriptionIds.clear();
        for (Object object : this.pollQueues.keySet()) {
            SgTaskSchedulerSnapshot sgTaskSchedulerSnapshot = SgTaskSchedulerSnapshot.builder().setScope((SgTaskScope)object).setShutdown(true).build();
            for (BlockingQueue blockingQueue : ((Map)this.pollQueues.get(object)).values()) {
                try {
                    blockingQueue.put(sgTaskSchedulerSnapshot);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        for (Object object : this.pollQueues.keySet()) {
            this.releaseQueueTopic.publish((Serializable)new SgRequestSnapshotMessage((SgTaskScope)object));
            this.logS((SgTaskScope)object, "released", new Object[0]);
        }
        this.pollQueues.clear();
        this.pendingTasks.clear();
        this.scheduledTasks.clear();
        this.cancelledTasks.clear();
        this.consoles.clear();
        this.logger.info("proxy scheduler shutdown completed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(@NotNull MessageEvent messageEvent) {
        if (messageEvent.getMessage() == null) {
            return;
        }
        String string = ((SgClusterMessage)messageEvent.getMessage()).getDestination();
        if (string != null && !string.equals(this.nodeId)) {
            this.logger.info("message skipped: " + string);
            return;
        }
        if ("org.tmatesoft.subgit.stash.mirror.topic:snapshot".equals(messageEvent.getTopic())) {
            Object object;
            SgSnapshotMessage sgSnapshotMessage = (SgSnapshotMessage)messageEvent.getMessage();
            SgTaskSchedulerSnapshot sgTaskSchedulerSnapshot = sgSnapshotMessage.getSnapshot();
            SgTaskScope sgTaskScope = sgTaskSchedulerSnapshot.getScope();
            Object object2 = this;
            synchronized (object2) {
                if (this.pollQueues.containsKey(sgTaskScope)) {
                    this.logS(sgTaskScope, "snapshot received", new Object[0]);
                    for (BlockingQueue blockingQueue : ((Map)this.pollQueues.get(sgTaskScope)).values()) {
                        try {
                            blockingQueue.put(sgTaskSchedulerSnapshot);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
            object2 = this.pendingTasks;
            synchronized (object2) {
                object = (SgProxyTask)this.pendingTasks.get(sgTaskSchedulerSnapshot.getTask().getId());
                if (object != null) {
                    ((SgProxyTask)object).taskStateChanged(sgTaskSchedulerSnapshot.getTask().getState());
                }
            }
            object2 = this.scheduledTasks;
            synchronized (object2) {
                object = (SgProxyTask)this.scheduledTasks.get(sgTaskSchedulerSnapshot.getTask().getId());
                if (object != null) {
                    ((SgProxyTask)object).taskStateChanged(sgTaskSchedulerSnapshot.getTask().getState());
                }
            }
        }
        if ("org.tmatesoft.subgit.stash.mirror.topic:taskScheduled".equals(messageEvent.getTopic())) {
            SgTaskScheduledMessage sgTaskScheduledMessage = (SgTaskScheduledMessage)messageEvent.getMessage();
            this.logger.info("task scheduled: " + sgTaskScheduledMessage.getTaskId());
            Map map = this.pendingTasks;
            synchronized (map) {
                SgProxyTask sgProxyTask = (SgProxyTask)this.pendingTasks.remove(sgTaskScheduledMessage.getSourceMessageId());
                if (sgProxyTask != null) {
                    Map map2 = this.scheduledTasks;
                    synchronized (map2) {
                        this.scheduledTasks.put(sgTaskScheduledMessage.getTaskId(), sgProxyTask);
                    }
                    sgProxyTask.taskScheduled(sgTaskScheduledMessage);
                }
            }
        }
        if ("org.tmatesoft.subgit.stash.mirror.topic:taskStarted".equals(messageEvent.getTopic())) {
            SgTaskCompletedMessage sgTaskCompletedMessage = (SgTaskCompletedMessage)messageEvent.getMessage();
            this.logger.info("task started: " + sgTaskCompletedMessage.getTaskId() + "/" + String.valueOf((Object)sgTaskCompletedMessage.getState()));
            Map map = this.scheduledTasks;
            synchronized (map) {
                SgProxyTask sgProxyTask = (SgProxyTask)this.scheduledTasks.get(sgTaskCompletedMessage.getTaskId());
                if (sgProxyTask != null) {
                    sgProxyTask.taskStateChanged(SgTaskState.RUNNING);
                }
            }
        }
        if ("org.tmatesoft.subgit.stash.mirror.topic:taskCompleted".equals(messageEvent.getTopic())) {
            SgTaskCompletedMessage sgTaskCompletedMessage = (SgTaskCompletedMessage)messageEvent.getMessage();
            this.logger.info("task completed: " + sgTaskCompletedMessage.getTaskId() + "/" + String.valueOf((Object)sgTaskCompletedMessage.getState()));
            Map map = this.scheduledTasks;
            synchronized (map) {
                SgProxyTask sgProxyTask = (SgProxyTask)this.scheduledTasks.remove(sgTaskCompletedMessage.getTaskId());
                if (sgProxyTask != null) {
                    sgProxyTask.taskCompleted(sgTaskCompletedMessage);
                }
            }
            map = this.consoles;
            synchronized (map) {
                this.consoles.remove(sgTaskCompletedMessage.getTaskId());
            }
        }
        if ("org.tmatesoft.subgit.stash.mirror.topic:taskCancelled".equals(messageEvent.getTopic())) {
            SgProxyTaskScheduler$TaskCancellationInfo sgProxyTaskScheduler$TaskCancellationInfo;
            SgTaskCancelledMessage sgTaskCancelledMessage = (SgTaskCancelledMessage)messageEvent.getMessage();
            this.logger.info("task cancelled: " + sgTaskCancelledMessage.getTaskId());
            Map map = this.cancelledTasks;
            synchronized (map) {
                sgProxyTaskScheduler$TaskCancellationInfo = (SgProxyTaskScheduler$TaskCancellationInfo)this.cancelledTasks.remove(sgTaskCancelledMessage.getTaskId());
            }
            if (sgProxyTaskScheduler$TaskCancellationInfo != null) {
                sgProxyTaskScheduler$TaskCancellationInfo.setCancellationResult(sgTaskCancelledMessage);
            }
        } else if ("org.tmatesoft.subgit.stash.mirror.topic:console".equals(messageEvent.getTopic())) {
            SgConsoleMessage sgConsoleMessage = (SgConsoleMessage)messageEvent.getMessage();
            this.logger.info("console message: " + sgConsoleMessage.getTaskId());
            Map map = this.consoles;
            synchronized (map) {
                if (sgConsoleMessage.getText() == null) {
                    ISgConsole iSgConsole = (ISgConsole)this.consoles.remove(sgConsoleMessage.getTaskId());
                    if (iSgConsole != null) {
                        iSgConsole.flush();
                    }
                } else {
                    ISgConsole iSgConsole = (ISgConsole)this.consoles.get(sgConsoleMessage.getTaskId());
                    if (iSgConsole != null) {
                        iSgConsole.println(sgConsoleMessage.getText(), new Object[0]);
                        iSgConsole.flush();
                    }
                }
            }
        }
    }

    private void logS(SgTaskScope sgTaskScope, String string, Object ... objectArray) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info(SgTextUtil.formatString("[%s] %s", sgTaskScope, SgTextUtil.formatString(string, objectArray)));
        }
    }
}

