/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.subgit.stash.mirror.scheduler.proxy;

import org.tmatesoft.subgit.stash.mirror.SgException;
import org.tmatesoft.subgit.stash.mirror.scheduler.ISgTask;
import org.tmatesoft.subgit.stash.mirror.scheduler.ISgTaskScheduler;
import org.tmatesoft.subgit.stash.mirror.scheduler.SgTaskScope;
import org.tmatesoft.subgit.stash.mirror.scheduler.SgTaskState;
import org.tmatesoft.subgit.stash.mirror.scheduler.SgTaskStatus;
import org.tmatesoft.subgit.stash.mirror.scheduler.message.SgTaskCompletedMessage;
import org.tmatesoft.subgit.stash.mirror.scheduler.message.SgTaskScheduledMessage;

public class SgProxyTask
implements ISgTask {
    private static final long SCHEDULE_TIMEOUT = 25000L;
    private final ISgTaskScheduler scheduler;
    private final SgTaskScope scope;
    private long id;
    private SgTaskStatus status;
    private SgTaskState state;
    private Throwable scheduleError;

    public SgProxyTask(SgTaskScope sgTaskScope, ISgTaskScheduler iSgTaskScheduler) {
        this.scheduler = iSgTaskScheduler;
        this.scope = sgTaskScope;
    }

    @Override
    public synchronized long getId() {
        return this.id;
    }

    @Override
    public synchronized SgTaskStatus getStatus() {
        return this.status;
    }

    @Override
    public synchronized SgTaskState getState() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SgTaskState waitForCompletion(long l2) {
        this.waitForSchedule();
        if (l2 > 0L) {
            long l3 = System.currentTimeMillis();
            while (this.getState() == SgTaskState.PENDING) {
                SgProxyTask sgProxyTask = this;
                synchronized (sgProxyTask) {
                    try {
                        this.wait(l2);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (System.currentTimeMillis() - l3 < l2) continue;
            }
            if (this.getState() == SgTaskState.PENDING) {
                if (this.getId() > 0L) {
                    this.scheduler.cancelTask(this.scope, this.getId());
                }
                return SgTaskState.TIMEOUT;
            }
        }
        SgProxyTask sgProxyTask = this;
        synchronized (sgProxyTask) {
            while (!this.state.isFinal()) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        return this.state;
    }

    public synchronized void waitForSchedule() {
        while (this.state == null) {
            try {
                this.wait(25000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.state != null) continue;
            throw new SgException("Timeout waiting for task to be scheduled on a master node");
        }
        if (this.scheduleError != null) {
            throw SgException.wrap(this.scheduleError);
        }
    }

    public synchronized void taskStateChanged(SgTaskState sgTaskState) {
        this.state = sgTaskState;
        this.notifyAll();
    }

    public synchronized void taskScheduled(SgTaskScheduledMessage sgTaskScheduledMessage) {
        this.id = sgTaskScheduledMessage.getTaskId();
        this.scheduleError = sgTaskScheduledMessage.getError();
        this.state = SgTaskState.PENDING;
        this.notifyAll();
    }

    public synchronized void taskCompleted(SgTaskCompletedMessage sgTaskCompletedMessage) {
        this.status = sgTaskCompletedMessage.getStatus();
        this.state = sgTaskCompletedMessage.getState();
        this.notifyAll();
    }
}

