/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.subgit.stash.mirror.scheduler;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.bitbucket.cluster.ClusterService;
import com.atlassian.bitbucket.concurrent.LockService;
import com.atlassian.bitbucket.topic.TopicService;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.tmatesoft.subgit.stash.mirror.SgException;
import org.tmatesoft.subgit.stash.mirror.scheduler.ISgTaskScheduler;
import org.tmatesoft.subgit.stash.mirror.scheduler.SgClusterStatus;
import org.tmatesoft.subgit.stash.mirror.scheduler.SgMasterRecord;
import org.tmatesoft.subgit.stash.mirror.scheduler.SgTaskFactoryService;
import org.tmatesoft.subgit.stash.mirror.scheduler.SgTaskScheduler;
import org.tmatesoft.subgit.stash.mirror.scheduler.SgTaskSchedulerService$Heartbeat;
import org.tmatesoft.subgit.stash.mirror.scheduler.SgTaskSchedulerService$HeartbeatInit;
import org.tmatesoft.subgit.stash.mirror.util.ISgCleanable;
import org.tmatesoft.subgit.stash.mirror.util.SgLoggerFactory;
import org.tmatesoft.subgit.stash.web.SgPluginPropertiesService;

public class SgTaskSchedulerService
implements ISgCleanable {
    private static final int SCHEDULER_SHUTDOWN_TIMEOUT = 25000;
    private static final String MASTER_LOCK_NAME = "org.tmatesoft.subgit.stash.mirror.masterLock";
    private static final long MIN_HEARTBEAT_INTERVAL = 10000L;
    private static final long MAX_HEARTBEAT_INTERVAL = 20000L;
    private static final long HEARTBEAT_DB_WRITE_DELAY = 2000L;
    private static final long HEARTBEAT_DB_READ_DELAY = 1000L;
    private final SgLoggerFactory loggerFactory;
    private final SgTaskFactoryService taskFactoryService;
    private final ClusterService clusterService;
    private final SgPluginPropertiesService pluginPropertiesService;
    private final Logger logger;
    private final TopicService topicService;
    private final ActiveObjects ao;
    private final LockService lockService;
    private final ExecutorService executorService;
    private SgTaskSchedulerService$Heartbeat heartbeat;
    private volatile boolean isShutdown;

    public SgTaskSchedulerService(SgLoggerFactory sgLoggerFactory, SgTaskFactoryService sgTaskFactoryService, ClusterService clusterService, SgPluginPropertiesService sgPluginPropertiesService, TopicService topicService, LockService lockService, ActiveObjects activeObjects, ExecutorService executorService) {
        this.loggerFactory = sgLoggerFactory;
        this.taskFactoryService = sgTaskFactoryService;
        this.clusterService = clusterService;
        this.pluginPropertiesService = sgPluginPropertiesService;
        this.logger = sgLoggerFactory.getLogger("cluster");
        this.lockService = lockService;
        this.topicService = topicService;
        this.ao = activeObjects;
        this.executorService = executorService;
        this.isShutdown = false;
        this.heartbeat = new SgTaskSchedulerService$Heartbeat(this);
    }

    public ISgTaskScheduler getScheduler() {
        if (this.isShutdown) {
            throw new SgException("task scheduler service has been shut down");
        }
        ISgTaskScheduler iSgTaskScheduler = this.heartbeat.getActiveMasterScheduler();
        if (iSgTaskScheduler != null) {
            this.log("Heartbeat is running, master scheduler is active");
            return iSgTaskScheduler;
        }
        CompletableFuture completableFuture = new CompletableFuture();
        this.executorService.submit(new SgTaskSchedulerService$HeartbeatInit(this, this.heartbeat, completableFuture));
        try {
            return (ISgTaskScheduler)completableFuture.get();
        }
        catch (InterruptedException interruptedException) {
            this.log("Completable future interrupted", interruptedException);
            throw new SgException("Failed to update task scheduler: " + interruptedException.getMessage());
        }
        catch (ExecutionException executionException) {
            this.log("Failed to update task scheduler", executionException);
            throw SgException.wrap(executionException.getCause());
        }
    }

    public boolean isMasterScheduler() {
        try {
            return this.getScheduler() instanceof SgTaskScheduler;
        }
        catch (SgException sgException) {
            return false;
        }
    }

    public void shutdown() {
        this.isShutdown = true;
        this.log("task scheduler service shutdown");
        this.heartbeat.shutdown();
    }

    @Override
    public void cleanup() {
        this.heartbeat.cleanup();
    }

    private void log(String string) {
        try {
            this.logger.info(string);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void logError(String string) {
        try {
            this.logger.error(string);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void log(String string, Throwable throwable) {
        try {
            this.logger.error(string, throwable);
        }
        catch (Throwable throwable2) {
            // empty catch block
        }
    }

    public SgClusterStatus getClusterStatus() {
        Map map;
        String string = this.clusterService.getNodeId();
        try {
            map = this.heartbeat.readMasterRecordsMap();
        }
        catch (Throwable throwable) {
            this.logger.error("failed to read master record", throwable);
            return SgClusterStatus.unknownMaster(string);
        }
        SgMasterRecord sgMasterRecord = null;
        for (SgMasterRecord sgMasterRecord2 : map.values()) {
            if (sgMasterRecord != null && sgMasterRecord2.getTimestamp() <= sgMasterRecord.getTimestamp()) continue;
            sgMasterRecord = sgMasterRecord2;
        }
        if (sgMasterRecord != null) {
            return SgClusterStatus.build(sgMasterRecord.getNode(), string);
        }
        this.logger.error("no master record has been found");
        return SgClusterStatus.unknownMaster(string);
    }
}

