/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.subgit.stash.mirror.scheduler;

import com.atlassian.sal.api.transaction.TransactionCallback;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import javax.annotation.Nullable;
import org.tmatesoft.subgit.stash.mirror.SgException;
import org.tmatesoft.subgit.stash.mirror.scheduler.ISgTaskScheduler;
import org.tmatesoft.subgit.stash.mirror.scheduler.SgMasterRecord;
import org.tmatesoft.subgit.stash.mirror.scheduler.SgTaskScheduler;
import org.tmatesoft.subgit.stash.mirror.scheduler.SgTaskSchedulerService;
import org.tmatesoft.subgit.stash.mirror.scheduler.SgTaskSchedulerService$Heartbeat$1;
import org.tmatesoft.subgit.stash.mirror.scheduler.SgTaskSchedulerService$Heartbeat$2;
import org.tmatesoft.subgit.stash.mirror.scheduler.SgTaskSchedulerService$Heartbeat$3;
import org.tmatesoft.subgit.stash.mirror.scheduler.SgTaskSchedulerService$Heartbeat$4;
import org.tmatesoft.subgit.stash.mirror.scheduler.SgTaskSchedulerService$Heartbeat$5;
import org.tmatesoft.subgit.stash.mirror.scheduler.SgTaskSchedulerService$Heartbeat$6;
import org.tmatesoft.subgit.stash.mirror.scheduler.SgTaskSchedulerService$MasterCheckResult;
import org.tmatesoft.subgit.stash.mirror.scheduler.proxy.SgProxyTaskScheduler;
import org.tmatesoft.subgit.stash.mirror.tasks.SgBootstrapSchedule;
import org.tmatesoft.subgit.stash.mirror.tasks.SgMirrorScope;

class SgTaskSchedulerService$Heartbeat {
    private final Random random = new Random();
    private volatile boolean running = false;
    private volatile long masterExpireTime = -1L;
    private CountDownLatch shutdownLatch = new CountDownLatch(0);
    private SgTaskScheduler masterScheduler;
    private SgProxyTaskScheduler proxyScheduler;
    final /* synthetic */ SgTaskSchedulerService this$0;

    private SgTaskSchedulerService$Heartbeat(SgTaskSchedulerService sgTaskSchedulerService) {
        this.this$0 = sgTaskSchedulerService;
    }

    public boolean isActive() {
        return this.running && System.currentTimeMillis() <= this.masterExpireTime;
    }

    private synchronized ISgTaskScheduler getActiveMasterScheduler() {
        if (this.masterScheduler != null && this.isActive()) {
            return this.masterScheduler;
        }
        return null;
    }

    private synchronized void bootstrapMasterScheduler() {
        this.masterScheduler = new SgTaskScheduler(this.this$0.loggerFactory, this.this$0.taskFactoryService, this.this$0.topicService, this.this$0.pluginPropertiesService);
        if (this.proxyScheduler != null) {
            this.proxyScheduler.shutdown();
            this.proxyScheduler = null;
        }
        this.masterScheduler.bootstrap(SgMirrorScope.global(), SgBootstrapSchedule.scheduled());
    }

    private synchronized ISgTaskScheduler getTaskScheduler() {
        if (this.masterScheduler != null && this.proxyScheduler != null) {
            this.proxyScheduler.shutdown();
            this.proxyScheduler = null;
            return this.masterScheduler;
        }
        if (this.masterScheduler != null) {
            return this.masterScheduler;
        }
        if (this.proxyScheduler == null) {
            String string = this.this$0.clusterService.getNodeId();
            this.proxyScheduler = new SgProxyTaskScheduler(string, this.this$0.topicService, this.this$0.logger);
            this.this$0.log("proxy task scheduler created on node: " + string);
        }
        return this.proxyScheduler;
    }

    private void init(CompletableFuture completableFuture) {
        Lock lock = null;
        try {
            lock = this.updateTaskScheduler();
            completableFuture.complete(this.getTaskScheduler());
        }
        catch (Throwable throwable) {
            this.this$0.log("failed to initialize heartbeat", throwable);
            completableFuture.completeExceptionally(throwable);
            this.stop(lock);
            lock = null;
        }
        if (lock != null) {
            this.reset();
            try {
                lock = this.heartbeat(lock);
            }
            catch (Throwable throwable) {
                this.this$0.log("heartbeat failed", throwable);
            }
            try {
                this.stop(lock);
            }
            catch (Throwable throwable) {
                this.this$0.log("heartbeat stop failed", throwable);
            }
        }
    }

    private synchronized Lock updateTaskScheduler() {
        ISgTaskScheduler iSgTaskScheduler = this.getActiveMasterScheduler();
        if (iSgTaskScheduler != null) {
            return null;
        }
        Lock lock = this.tryLockMaster();
        if (lock != null) {
            try {
                this.bootstrapMasterScheduler();
            }
            catch (Throwable throwable) {
                try {
                    lock.unlock();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                this.this$0.log("failed to bootstrap master scheduler");
                throw throwable;
            }
        }
        return lock;
    }

    private Lock heartbeat(Lock lock) {
        SgTaskSchedulerService$MasterCheckResult sgTaskSchedulerService$MasterCheckResult;
        long l2 = System.currentTimeMillis();
        do {
            this.sleepUntil(l2);
            if (!this.running) break;
            Map map = this.readMasterRecordsMap();
            SgMasterRecord sgMasterRecord = (SgMasterRecord)map.get(this.this$0.clusterService.getNodeId());
            l2 = this.createOrUpdateMasterRecord(sgMasterRecord, map.values());
            this.masterExpireTime = l2 + 2000L;
            sgTaskSchedulerService$MasterCheckResult = this.checkMaster(map.values());
            if (sgTaskSchedulerService$MasterCheckResult.isMaster()) continue;
            this.this$0.logError("this node is not a master, stopping heartbeat");
            break;
        } while (sgTaskSchedulerService$MasterCheckResult != SgTaskSchedulerService$MasterCheckResult.MASTER_REFRESH_LOCK || (lock = this.refreshLock(lock)) != null);
        return lock;
    }

    private Lock refreshLock(Lock lock) {
        try {
            this.this$0.log("refresh lock: releasing master lock");
            lock.unlock();
            this.this$0.log("refresh lock: master lock released");
        }
        catch (Throwable throwable) {
            this.this$0.log("Failed to release master lock while refreshing it", throwable);
        }
        try {
            Lock lock2 = this.this$0.lockService.getLock("org.tmatesoft.subgit.stash.mirror.masterLock");
            this.this$0.log("refresh lock: trying to re-acquire master lock");
            boolean bl2 = lock2.tryLock(3L, TimeUnit.SECONDS);
            if (!bl2) {
                this.this$0.logError("refresh lock: failed to acquire master lock");
                return null;
            }
            this.this$0.log("refresh lock: acquired master lock");
            return lock2;
        }
        catch (Throwable throwable) {
            this.this$0.log("Failed to acquire master lock while refreshing it", throwable);
            return null;
        }
    }

    private synchronized void stop(Lock lock) {
        try {
            this.shutdownScheduler();
            this.deleteMasterRecord();
        }
        finally {
            if (lock != null) {
                this.this$0.log("releasing master lock");
                lock.unlock();
                this.this$0.log("master lock released");
            }
            this.running = false;
            this.masterExpireTime = -1L;
            this.shutdownLatch.countDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized void shutdownScheduler() {
        if (this.masterScheduler != null) {
            try {
                Object object = this.masterScheduler.shutdown();
                while (!this.masterScheduler.isShutdown()) {
                    Object object2 = object;
                    synchronized (object2) {
                        try {
                            object.wait(25000L);
                        }
                        catch (InterruptedException interruptedException) {
                            break;
                        }
                    }
                }
            }
            finally {
                this.masterScheduler = null;
                this.this$0.log("master scheduler shutdown");
            }
        }
        if (this.proxyScheduler == null) return;
        try {
            this.proxyScheduler.shutdown();
            return;
        }
        finally {
            this.proxyScheduler = null;
            this.this$0.log("proxy scheduler shutdown");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdown() {
        CountDownLatch countDownLatch;
        SgTaskSchedulerService$Heartbeat sgTaskSchedulerService$Heartbeat = this;
        synchronized (sgTaskSchedulerService$Heartbeat) {
            this.shutdownScheduler();
            if (!this.running) {
                return;
            }
            this.running = false;
            this.this$0.log("running flag set to false");
            countDownLatch = this.shutdownLatch;
            this.this$0.log("notifying waiters");
            this.notify();
            this.this$0.log("waiters notified");
        }
        try {
            countDownLatch.await(25000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            this.this$0.logError("shutdown interrupted");
        }
    }

    private synchronized void reset() {
        this.running = true;
        this.masterExpireTime = -1L;
        this.shutdownLatch = new CountDownLatch(1);
    }

    private void cleanup() {
        if (this.masterScheduler != null) {
            this.masterScheduler.cleanup();
        }
        if (this.proxyScheduler != null) {
            this.proxyScheduler.cleanup();
        }
    }

    private Lock tryLockMaster() {
        Lock lock;
        block8: {
            lock = this.this$0.lockService.getLock("org.tmatesoft.subgit.stash.mirror.masterLock");
            boolean bl2 = lock.tryLock();
            if (!bl2) {
                this.this$0.log("unable to acquire master lock; master task scheduler already present in the cluster");
                return null;
            }
            try {
                this.this$0.log("master lock acquired");
                SgTaskSchedulerService$MasterCheckResult sgTaskSchedulerService$MasterCheckResult = this.checkMaster(this.readMasterRecords());
                if (sgTaskSchedulerService$MasterCheckResult.isMaster()) break block8;
                try {
                    lock.unlock();
                    this.this$0.log("master lock released");
                }
                catch (Throwable throwable) {
                    this.this$0.log("failed to release master lock", throwable);
                }
                if (sgTaskSchedulerService$MasterCheckResult == SgTaskSchedulerService$MasterCheckResult.TOO_MANY_MASTERS) {
                    throw new SgException("Hazelcast cluster lock failure");
                }
                this.addWarningRecord();
                this.this$0.log("added lock warning record");
                return null;
            }
            catch (Throwable throwable) {
                try {
                    lock.unlock();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                this.this$0.log("failed to acquire master lock", throwable);
                throw throwable;
            }
        }
        return lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sleepUntil(long l2) {
        while (System.currentTimeMillis() < l2) {
            SgTaskSchedulerService$Heartbeat sgTaskSchedulerService$Heartbeat = this;
            synchronized (sgTaskSchedulerService$Heartbeat) {
                long l3 = l2 - System.currentTimeMillis();
                if (l3 > 0L) {
                    try {
                        this.wait(l3);
                    }
                    catch (InterruptedException interruptedException) {
                        this.this$0.log("thread sleep interrupted", interruptedException);
                    }
                }
                if (!this.running) {
                    break;
                }
            }
        }
    }

    private long getHeartbeatInterval(Collection collection) {
        long l2 = this.getMaxInterval(collection);
        if (l2 > 0L) {
            return (long)((float)(2000L + l2) + (float)Math.abs(20000L - l2) * this.random.nextFloat());
        }
        return (long)(10000.0f + (float)Math.abs(10000L) * this.random.nextFloat());
    }

    private SgTaskSchedulerService$MasterCheckResult checkMaster(Collection collection) {
        long l2;
        if (this.thisNodeSingleMaster(collection)) {
            this.this$0.log("this node is a single master");
            return SgTaskSchedulerService$MasterCheckResult.MASTER;
        }
        long l3 = this.getMaxInterval(collection);
        long l4 = System.currentTimeMillis() + l3;
        while ((l2 = l4 - System.currentTimeMillis()) > 0L) {
            try {
                Thread.sleep(l2);
            }
            catch (Throwable throwable) {
                this.this$0.log("Thread sleep interrupted", throwable);
            }
        }
        List list = this.readMasterRecords();
        List list2 = this.filterActiveRecords(list, collection);
        this.this$0.logError("this node: " + this.this$0.clusterService.getNodeId() + "; active master nodes: " + this.listNodeIds(list2));
        if (this.thisNodeSingleMaster(list2)) {
            this.this$0.log("this node is a single active master");
            this.removeInactiveRecords(list, list2);
            return this.hasWarningRecords(list) ? SgTaskSchedulerService$MasterCheckResult.MASTER_REFRESH_LOCK : SgTaskSchedulerService$MasterCheckResult.MASTER;
        }
        if (list2.size() > 1 && this.hasThisNode(list2)) {
            this.this$0.logError("too many master nodes detected");
            return SgTaskSchedulerService$MasterCheckResult.TOO_MANY_MASTERS;
        }
        return SgTaskSchedulerService$MasterCheckResult.NOT_MASTER;
    }

    private boolean hasWarningRecords(List list) {
        for (SgMasterRecord sgMasterRecord : list) {
            if (sgMasterRecord.getInterval() != 0L) continue;
            return true;
        }
        return false;
    }

    private boolean hasThisNode(List list) {
        String string = this.this$0.clusterService.getNodeId();
        for (SgMasterRecord sgMasterRecord : list) {
            if (!string.equals(sgMasterRecord.getNode())) continue;
            return true;
        }
        return false;
    }

    private String listNodeIds(Collection collection) {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            SgMasterRecord sgMasterRecord = (SgMasterRecord)iterator.next();
            if (sgMasterRecord != null) {
                stringBuilder.append(sgMasterRecord.getNode());
            } else {
                stringBuilder.append("[null]");
            }
            if (!iterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        return stringBuilder.toString();
    }

    private boolean thisNodeSingleMaster(Collection collection) {
        if (collection.isEmpty()) {
            return true;
        }
        if (collection.size() == 1) {
            SgMasterRecord sgMasterRecord = (SgMasterRecord)collection.iterator().next();
            String string = sgMasterRecord == null ? null : sgMasterRecord.getNode();
            String string2 = this.this$0.clusterService.getNodeId();
            if (string == null) {
                this.this$0.log("failed to get node ID for master record: " + String.valueOf(sgMasterRecord));
            }
            if (string2.equals(string)) {
                return true;
            }
        }
        return false;
    }

    private long getMaxInterval(Collection collection) {
        long l2 = 0L;
        for (SgMasterRecord sgMasterRecord : collection) {
            if (sgMasterRecord == null || this.this$0.clusterService.getNodeId().equals(sgMasterRecord.getNode()) || l2 >= sgMasterRecord.getInterval()) continue;
            l2 = sgMasterRecord.getInterval();
        }
        return l2;
    }

    private List filterActiveRecords(List list, Collection collection) {
        Map map = this.mapNodeToRecord(list);
        Map map2 = this.mapNodeToRecord(collection);
        ArrayList<SgMasterRecord> arrayList = new ArrayList<SgMasterRecord>(list.size());
        for (String string : map.keySet()) {
            SgMasterRecord sgMasterRecord = (SgMasterRecord)map.get(string);
            SgMasterRecord sgMasterRecord2 = (SgMasterRecord)map2.get(string);
            if (sgMasterRecord.getInterval() == 0L || sgMasterRecord2 != null && sgMasterRecord.getTimestamp() == sgMasterRecord2.getTimestamp()) continue;
            arrayList.add(sgMasterRecord);
        }
        return arrayList;
    }

    private Map mapNodeToRecord(Collection collection) {
        HashMap<String, SgMasterRecord> hashMap = new HashMap<String, SgMasterRecord>();
        for (SgMasterRecord sgMasterRecord : collection) {
            if (sgMasterRecord == null) continue;
            hashMap.put(sgMasterRecord.getNode(), sgMasterRecord);
        }
        return hashMap;
    }

    private SgMasterRecord createMasterRecord(long l2) {
        return (SgMasterRecord)this.this$0.ao.executeInTransaction((TransactionCallback)new SgTaskSchedulerService$Heartbeat$1(this, l2));
    }

    private void addWarningRecord() {
        this.this$0.ao.executeInTransaction((TransactionCallback)new SgTaskSchedulerService$Heartbeat$2(this));
    }

    private void updateMasterRecord(SgMasterRecord sgMasterRecord, long l2) {
        this.this$0.ao.executeInTransaction((TransactionCallback)new SgTaskSchedulerService$Heartbeat$3(this, sgMasterRecord, l2));
    }

    private long createOrUpdateMasterRecord(SgMasterRecord sgMasterRecord, Collection collection) {
        long l2 = this.getHeartbeatInterval(collection);
        if (sgMasterRecord == null) {
            sgMasterRecord = this.createMasterRecord(l2);
        } else {
            this.updateMasterRecord(sgMasterRecord, l2);
        }
        if (sgMasterRecord == null || !this.running) {
            return System.currentTimeMillis() + l2;
        }
        return sgMasterRecord.getTimestamp() + sgMasterRecord.getInterval() - 2000L;
    }

    private List readMasterRecords() {
        SgMasterRecord[] sgMasterRecordArray = this.loadMasterRecords();
        this.logRecords(sgMasterRecordArray);
        if (sgMasterRecordArray == null) {
            return Collections.emptyList();
        }
        ArrayList<SgMasterRecord> arrayList = new ArrayList<SgMasterRecord>();
        for (SgMasterRecord sgMasterRecord : sgMasterRecordArray) {
            if (sgMasterRecord == null) continue;
            arrayList.add(sgMasterRecord);
        }
        return arrayList;
    }

    @Nullable
    private SgMasterRecord[] loadMasterRecords() {
        return (SgMasterRecord[])this.this$0.ao.executeInTransaction((TransactionCallback)new SgTaskSchedulerService$Heartbeat$4(this));
    }

    public Map readMasterRecordsMap() {
        List list = this.readMasterRecords();
        HashMap<String, SgMasterRecord> hashMap = new HashMap<String, SgMasterRecord>(list.size());
        for (SgMasterRecord sgMasterRecord : list) {
            hashMap.put(sgMasterRecord.getNode(), sgMasterRecord);
        }
        return hashMap;
    }

    private void logRecords(SgMasterRecord[] sgMasterRecordArray) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("this node: ");
        stringBuilder.append(this.this$0.clusterService.getNodeId());
        stringBuilder.append("; detected master records: ");
        if (sgMasterRecordArray == null) {
            stringBuilder.append("none");
        } else {
            for (int i2 = 0; i2 < sgMasterRecordArray.length; ++i2) {
                SgMasterRecord sgMasterRecord = sgMasterRecordArray[i2];
                if (sgMasterRecord != null) {
                    stringBuilder.append(sgMasterRecord.getNode());
                } else {
                    stringBuilder.append("[null]");
                }
                if (i2 == sgMasterRecordArray.length - 1) continue;
                stringBuilder.append(", ");
            }
        }
        this.this$0.log(stringBuilder.toString());
    }

    private void removeInactiveRecords(Collection collection, List list) {
        this.this$0.ao.executeInTransaction((TransactionCallback)new SgTaskSchedulerService$Heartbeat$5(this, collection, list));
    }

    private void deleteMasterRecord() {
        this.this$0.ao.executeInTransaction((TransactionCallback)new SgTaskSchedulerService$Heartbeat$6(this));
    }
}

