/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.subgit.stash.mirror.scheduler;

import com.a.a.a.b.e;
import com.atlassian.bitbucket.topic.MessageEvent;
import com.atlassian.bitbucket.topic.Topic;
import com.atlassian.bitbucket.topic.TopicListener;
import com.atlassian.bitbucket.topic.TopicService;
import com.atlassian.bitbucket.topic.TopicSettings;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.tmatesoft.subgit.stash.mirror.SgException;
import org.tmatesoft.subgit.stash.mirror.scheduler.ISgTask;
import org.tmatesoft.subgit.stash.mirror.scheduler.ISgTaskScheduler;
import org.tmatesoft.subgit.stash.mirror.scheduler.SgTask;
import org.tmatesoft.subgit.stash.mirror.scheduler.SgTaskFactoryService;
import org.tmatesoft.subgit.stash.mirror.scheduler.SgTaskScheduler$1;
import org.tmatesoft.subgit.stash.mirror.scheduler.SgTaskScheduler$2;
import org.tmatesoft.subgit.stash.mirror.scheduler.SgTaskScheduler$SnapshotPublisher;
import org.tmatesoft.subgit.stash.mirror.scheduler.SgTaskScheduler$State;
import org.tmatesoft.subgit.stash.mirror.scheduler.SgTaskScheduler$TaskWrapper;
import org.tmatesoft.subgit.stash.mirror.scheduler.SgTaskScheduler$TrackingThreadFactory;
import org.tmatesoft.subgit.stash.mirror.scheduler.SgTaskSchedulerSnapshot;
import org.tmatesoft.subgit.stash.mirror.scheduler.SgTaskSchedulerSnapshot$Builder;
import org.tmatesoft.subgit.stash.mirror.scheduler.SgTaskScope;
import org.tmatesoft.subgit.stash.mirror.scheduler.SgTaskState;
import org.tmatesoft.subgit.stash.mirror.scheduler.SgTaskStatus;
import org.tmatesoft.subgit.stash.mirror.scheduler.message.SgCancelTaskMessage;
import org.tmatesoft.subgit.stash.mirror.scheduler.message.SgReloadDataMessage;
import org.tmatesoft.subgit.stash.mirror.scheduler.message.SgRequestSnapshotMessage;
import org.tmatesoft.subgit.stash.mirror.scheduler.message.SgScheduleTaskMessage;
import org.tmatesoft.subgit.stash.mirror.scheduler.message.SgTaskCancelledMessage;
import org.tmatesoft.subgit.stash.mirror.scheduler.message.SgTaskCompletedMessage;
import org.tmatesoft.subgit.stash.mirror.scheduler.message.SgTaskScheduledMessage;
import org.tmatesoft.subgit.stash.mirror.scheduler.proxy.SgProxyConsole;
import org.tmatesoft.subgit.stash.mirror.tasks.SgPushTaskParameters;
import org.tmatesoft.subgit.stash.mirror.util.SgLoggerFactory;
import org.tmatesoft.subgit.stash.mirror.util.SgTextUtil;
import org.tmatesoft.subgit.stash.web.SgPluginPropertiesService;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.translator.util.a;

public class SgTaskScheduler
implements TopicListener,
Runnable,
ISgTaskScheduler {
    private static final long QUEUE_TTL = 10000L;
    private static final long SHUTDOWN_TIMEOUT = 20000L;
    private static final long REMOTE_QUEUE_TTL = 600000L;
    private static final Serializable QUEUE_LOAD_BOOTSTRAP = new SgTaskScheduler$1();
    public static final Serializable REFRESH_BOOTSTRAP = new SgTaskScheduler$2();
    public static final String CORE_EXECUTOR_NAME = "core";
    private static final long SNAPSHOT_PUBLISHING_INTERVAL = 250L;
    private static final long REMOTE_SNAPSHOT_PUBLISHING_RATIO = 4L;
    private static final Object ALL_QUEUES = new Object();
    private final Topic snapshotBroadcastTopic;
    private final Topic taskCompletedTopic;
    private final Topic taskScheduledTopic;
    private final Topic taskStartedTopic;
    private final Topic taskCancelledTopic;
    private final Logger log;
    private final TopicService topicService;
    private final SgTaskScheduler$SnapshotPublisher snapshotPublisher;
    private final SgPluginPropertiesService pluginPropertiesService;
    private final Map queues;
    private final Map running;
    private final Map snapshots;
    private final Map pollQueues;
    private final Map executors;
    private final SgTaskFactoryService taskFactoryService;
    private final Map releaseTimes;
    private final Map remoteScopes;
    private final Map subscriberIds;
    private final ReadWriteLock stateLock;
    private final Object shutdownMonitor = new Object();
    private volatile SgTaskScheduler$State state;
    private boolean isUpdateParentScopes;

    public SgTaskScheduler(SgLoggerFactory sgLoggerFactory, SgTaskFactoryService sgTaskFactoryService, TopicService topicService, SgPluginPropertiesService sgPluginPropertiesService) {
        this.log = sgLoggerFactory.getLogger("scheduler");
        this.queues = new HashMap();
        this.running = new HashMap();
        this.snapshots = new HashMap();
        this.releaseTimes = new HashMap();
        this.remoteScopes = new HashMap();
        this.subscriberIds = new HashMap();
        this.pollQueues = new HashMap();
        this.taskFactoryService = sgTaskFactoryService;
        this.topicService = topicService;
        this.snapshotPublisher = new SgTaskScheduler$SnapshotPublisher(this, topicService, this.log);
        this.pluginPropertiesService = sgPluginPropertiesService;
        this.state = SgTaskScheduler$State.NOT_RUNNING;
        this.stateLock = new ReentrantReadWriteLock(true);
        this.executors = new HashMap();
        this.isUpdateParentScopes = true;
        this.snapshotBroadcastTopic = topicService.getTopic("org.tmatesoft.subgit.stash.mirror.topic:snapshot", TopicSettings.builder((Class)null).build());
        this.taskCompletedTopic = topicService.getTopic("org.tmatesoft.subgit.stash.mirror.topic:taskCompleted", TopicSettings.builder((Class)null).build());
        this.taskScheduledTopic = topicService.getTopic("org.tmatesoft.subgit.stash.mirror.topic:taskScheduled", TopicSettings.builder((Class)null).build());
        this.taskStartedTopic = topicService.getTopic("org.tmatesoft.subgit.stash.mirror.topic:taskStarted", TopicSettings.builder((Class)null).build());
        this.taskCancelledTopic = topicService.getTopic("org.tmatesoft.subgit.stash.mirror.topic:taskCancelled", TopicSettings.builder((Class)null).build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExecutorPoolSize(String string, int n2) {
        if (n2 <= 0) {
            n2 = Integer.MAX_VALUE;
        }
        Map map = this.executors;
        synchronized (map) {
            ThreadPoolExecutor threadPoolExecutor = this.getExecutor(string);
            if (threadPoolExecutor.getCorePoolSize() != n2) {
                this.log.info(string + " maximum thread pool size set to " + (n2 == Integer.MAX_VALUE ? "unlimited" : Integer.toString(n2)));
                threadPoolExecutor.setCorePoolSize(n2);
            }
        }
    }

    private ThreadPoolExecutor getExecutorForTask(SgTaskScope sgTaskScope, String string) {
        return this.getExecutor(this.taskFactoryService.getExecutorName(sgTaskScope, string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ThreadPoolExecutor getExecutor(String string) {
        Map map = this.executors;
        synchronized (map) {
            if (!this.executors.containsKey(string)) {
                SgTaskScheduler$TrackingThreadFactory sgTaskScheduler$TrackingThreadFactory = new SgTaskScheduler$TrackingThreadFactory(string);
                ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(1, Integer.MAX_VALUE, 70L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), sgTaskScheduler$TrackingThreadFactory, new ThreadPoolExecutor.AbortPolicy());
                threadPoolExecutor.allowCoreThreadTimeOut(true);
                this.executors.put(string, threadPoolExecutor);
            }
            return (ThreadPoolExecutor)this.executors.get(string);
        }
    }

    public synchronized void setUpdateParentScopes(boolean bl2) {
        boolean bl3 = bl2 && !this.isUpdateParentScopes;
        this.isUpdateParentScopes = bl2;
        if (bl3) {
            for (SgTaskScope sgTaskScope : this.snapshots.keySet()) {
                if (!this.taskFactoryService.hasChildren(sgTaskScope, ((SgTaskSchedulerSnapshot)this.snapshots.get(sgTaskScope)).getData())) continue;
                this.pushSnapshot(sgTaskScope, ALL_QUEUES);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long cancelTask(SgTaskScope sgTaskScope, long l2) {
        long l3;
        Object object;
        Object object2;
        this.stateLock.readLock().lock();
        try {
            this.state.assumeRunning();
            SgTaskScheduler sgTaskScheduler = this;
            synchronized (sgTaskScheduler) {
                object2 = this.getQueue(sgTaskScope).iterator();
                while (object2.hasNext()) {
                    object = (SgTask)object2.next();
                    if (((SgTask)object).getId() != l2) continue;
                    object2.remove();
                    ((SgTask)object).setState(SgTaskState.CANCELLED);
                    ((SgTask)object).setCompleted(true);
                    this.log((SgTask)object, "cancelled", new Object[0]);
                    long l4 = ((SgTask)object).getId();
                    // MONITOREXIT @DISABLED, blocks:[0, 5, 7] lbl15 : MonitorExitStatement: MONITOREXIT : var4_3
                    this.stateLock.readLock().unlock();
                    return l4;
                }
            }
        }
        catch (Throwable throwable) {
            this.stateLock.readLock().unlock();
            throw throwable;
        }
        {
            object2 = (SgTask)this.running.get(sgTaskScope);
            if (object2 != null && ((SgTask)object2).getId() == l2 && ((SgTask)object2).isCancellable()) {
                ((SgTask)object2).setState(SgTaskState.CANCELLED);
                this.log((SgTask)object2, "cancelling", new Object[0]);
                object = this.getExecutorForTask(((SgTask)object2).getScope(), ((SgTask)object2).getName());
                if (((ThreadPoolExecutor)object).remove(new SgTaskScheduler$TaskWrapper(this, (SgTask)object2))) {
                    this.log((SgTask)object2, "removed from execution queue", new Object[0]);
                    ((SgTask)object2).setCompleted(true);
                    this.internalStatusChanged(((SgTask)object2).getScope());
                    this.running.remove(sgTaskScope);
                    this.notify();
                    long l5 = ((SgTask)object2).getId();
                    // MONITOREXIT @DISABLED, blocks:[5, 8, 9] lbl35 : MonitorExitStatement: MONITOREXIT : var4_3
                    this.stateLock.readLock().unlock();
                    return l5;
                }
            }
            l3 = -1L;
        }
        this.stateLock.readLock().unlock();
        return l3;
    }

    @Override
    public ISgTask schedule(SgTaskScope sgTaskScope, String string, Serializable serializable) {
        return this.schedule(sgTaskScope, string, -1L, serializable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public SgTask schedule(SgTaskScope sgTaskScope, String string, long l2, Serializable serializable) {
        SgTask sgTask;
        SgTask sgTask2;
        this.stateLock.readLock().lock();
        try {
            this.state.assumeRunning();
            sgTask2 = this.taskFactoryService.createTask(this, string, sgTaskScope, l2, serializable);
            if (sgTask2 == null) {
                this.logS(sgTaskScope, "unknown task '%s'", string);
                SgTask sgTask3 = null;
                this.stateLock.readLock().unlock();
                return sgTask3;
            }
            SgTaskScheduler sgTaskScheduler = this;
            synchronized (sgTaskScheduler) {
                if (this.shouldReject(sgTask2)) {
                    sgTask2.setState(SgTaskState.REJECTED);
                    sgTask2.setCompleted(true);
                    SgTask sgTask4 = sgTask2;
                    // MONITOREXIT @DISABLED, blocks:[0, 5, 7] lbl16 : MonitorExitStatement: MONITOREXIT : var7_7
                    this.stateLock.readLock().unlock();
                    return sgTask4;
                }
                this.log(sgTask2, "adding to queue", new Object[0]);
                Queue queue = this.addTaskToQueue(this.getQueue(sgTaskScope), sgTask2);
                this.cancelScheduledTasks(sgTask2, queue);
                this.queues.put(sgTaskScope, queue);
            }
        }
        catch (Throwable throwable) {
            this.stateLock.readLock().unlock();
            throw throwable;
        }
        {
            this.log(sgTask2, "added to queue", new Object[0]);
            this.cancelRunningTask(sgTaskScope, sgTask2, SgTaskState.AUTO_CANCELLED);
            sgTask2.setState(SgTaskState.PENDING);
            this.notify();
            sgTask = sgTask2;
        }
        this.stateLock.readLock().unlock();
        return sgTask;
    }

    private boolean shouldReject(SgTask sgTask) {
        if (this.state == SgTaskScheduler$State.SHUTDOWN || this.state == SgTaskScheduler$State.SHUTTING_DOWN) {
            this.log(sgTask, "rejected, scheduler is shutting down", new Object[0]);
            return true;
        }
        if (this.isBootstrap(sgTask) && sgTask.getParameters() == QUEUE_LOAD_BOOTSTRAP) {
            boolean bl2;
            boolean bl3 = bl2 = this.isIdle(sgTask.getScope()) && this.snapshots.get(sgTask.getScope()) == null;
            if (!bl2) {
                this.log(sgTask, "queue load rejected, queue already present", new Object[0]);
            } else {
                this.log(sgTask, "will run to init queue", new Object[0]);
            }
            return !bl2;
        }
        if (this.isIdle(sgTask.getScope())) {
            SgTaskSchedulerSnapshot sgTaskSchedulerSnapshot = (SgTaskSchedulerSnapshot)this.snapshots.get(sgTask.getScope());
            if (sgTaskSchedulerSnapshot != null && sgTaskSchedulerSnapshot.getData() != null && !sgTask.isApplicableFor(sgTaskSchedulerSnapshot.getData())) {
                this.log(sgTask, "rejected, state is not applicable: " + this.taskFactoryService.toString(sgTask.getScope(), sgTaskSchedulerSnapshot.getData()), new Object[0]);
                return true;
            }
            if (!(sgTaskSchedulerSnapshot != null && sgTaskSchedulerSnapshot.getData() != null || sgTask.isRunnable())) {
                this.log(sgTask, "rejected, not runnable", new Object[0]);
                return true;
            }
            return false;
        }
        return false;
    }

    private boolean isIdle(SgTaskScope sgTaskScope) {
        Queue queue = (Queue)this.queues.get(sgTaskScope);
        SgTask sgTask = (SgTask)this.running.get(sgTaskScope);
        return (queue == null || queue.isEmpty()) && sgTask == null;
    }

    private void cancelRunningTask(SgTaskScope sgTaskScope, SgTask sgTask, SgTaskState sgTaskState) {
        SgTask sgTask2 = (SgTask)this.running.get(sgTaskScope);
        if (sgTask2 != null && sgTask2.isCancellable() && (sgTask == null || sgTask.shouldCancel(sgTask2))) {
            ThreadPoolExecutor threadPoolExecutor;
            sgTask2.setState(sgTaskState);
            this.log(sgTask2, "cancelling", new Object[0]);
            if (!sgTask2.isStarted() && (threadPoolExecutor = this.getExecutorForTask(sgTask2.getScope(), sgTask2.getName())).remove(new SgTaskScheduler$TaskWrapper(this, sgTask2))) {
                this.log(sgTask2, "removed from execution queue", new Object[0]);
                sgTask2.setCompleted(true);
                this.internalStatusChanged(sgTask2.getScope());
                this.running.remove(sgTaskScope);
                this.notify();
            }
        } else if (sgTask2 != null) {
            this.log(sgTask2, "kept", new Object[0]);
        }
    }

    private void cancelScheduledTasks(SgTask sgTask, Queue queue) {
        SgTask sgTask2;
        Iterator iterator = queue.iterator();
        while (iterator.hasNext() && (sgTask2 = (SgTask)iterator.next()) != sgTask) {
            if (sgTask == null || sgTask.shouldCancel(sgTask2)) {
                iterator.remove();
                sgTask2.setState(SgTaskState.CANCELLED);
                sgTask2.setCompleted(true);
                this.log(sgTask2, "cancelled", new Object[0]);
                continue;
            }
            this.log(sgTask2, "kept", new Object[0]);
        }
    }

    private boolean cancelScheduledInapplicableTasks(Serializable serializable, Queue queue) {
        if (serializable == null || queue == null || queue.isEmpty()) {
            return false;
        }
        boolean bl2 = false;
        Iterator iterator = queue.iterator();
        while (iterator.hasNext()) {
            SgTask sgTask = (SgTask)iterator.next();
            if (!sgTask.isApplicableFor(serializable)) {
                iterator.remove();
                sgTask.setState(SgTaskState.CANCELLED);
                sgTask.setCompleted(true);
                this.log(sgTask, "cancelled", new Object[0]);
                bl2 = true;
                continue;
            }
            this.log(sgTask, "kept", new Object[0]);
            break;
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh() {
        this.stateLock.readLock().lock();
        try {
            if (this.state != SgTaskScheduler$State.RUNNING) {
                return;
            }
            SgTaskScheduler sgTaskScheduler = this;
            synchronized (sgTaskScheduler) {
                for (SgTaskScope sgTaskScope : this.snapshots.keySet()) {
                    try {
                        this.schedule(sgTaskScope, this.taskFactoryService.getBootstrapTaskName(), REFRESH_BOOTSTRAP);
                    }
                    catch (SgException sgException) {
                        this.log(sgException);
                    }
                }
            }
        }
        finally {
            this.stateLock.readLock().unlock();
        }
    }

    public SgTask bootstrap(SgTaskScope sgTaskScope, Serializable serializable) {
        return this.bootstrap(sgTaskScope, -1L, serializable);
    }

    public SgTask bootstrap(SgTaskScope sgTaskScope, long l2, Serializable serializable) {
        try {
            return this.schedule(sgTaskScope, this.taskFactoryService.getBootstrapTaskName(), l2, serializable);
        }
        catch (SgException sgException) {
            this.logS(sgTaskScope, "failed to schedule bootstrap task", new Object[0]);
            this.log(sgException);
            return null;
        }
    }

    private Queue addTaskToQueue(Queue queue, SgTask sgTask) {
        if (sgTask.getTimeToRun() < 0L && !queue.isEmpty()) {
            LinkedList<SgTask> linkedList = new LinkedList<SgTask>();
            LinkedList<SgTask> linkedList2 = new LinkedList<SgTask>();
            if (this.isBootstrap(sgTask)) {
                linkedList.add(sgTask);
            }
            while (!queue.isEmpty()) {
                if (((SgTask)queue.peek()).getTimeToRun() < 0L) {
                    linkedList.add((SgTask)queue.poll());
                    continue;
                }
                linkedList2.add((SgTask)queue.poll());
            }
            if (!this.isBootstrap(sgTask)) {
                linkedList.add(sgTask);
            }
            linkedList.addAll(linkedList2);
            return linkedList;
        }
        queue.add(sgTask);
        ((LinkedList)queue).sort(Collections.reverseOrder());
        return queue;
    }

    private Queue getQueue(SgTaskScope sgTaskScope) {
        this.ensureSchedulerIsRunning();
        if (!this.queues.containsKey(sgTaskScope)) {
            this.queues.put(sgTaskScope, new LinkedList());
        }
        return (Queue)this.queues.get(sgTaskScope);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureSchedulerIsRunning() {
        if (this.state != SgTaskScheduler$State.NOT_RUNNING) {
            return;
        }
        this.log.info("starting scheduler threads");
        this.stateLock.readLock().unlock();
        this.stateLock.writeLock().lock();
        try {
            this.state = SgTaskScheduler$State.RUNNING;
            Thread thread = new Thread(this);
            thread.setDaemon(true);
            thread.setName("sg-scheduler");
            thread.start();
            Thread thread2 = new Thread(this.snapshotPublisher);
            thread2.setDaemon(true);
            thread2.setName("sg-publisher");
            thread2.start();
            Topic topic = this.topicService.getTopic("org.tmatesoft.subgit.stash.mirror.topic:obtainQueue", TopicSettings.builder((Class)null).build());
            Topic topic2 = this.topicService.getTopic("org.tmatesoft.subgit.stash.mirror.topic:releaseQueue", TopicSettings.builder((Class)null).build());
            Topic topic3 = this.topicService.getTopic("org.tmatesoft.subgit.stash.mirror.topic:scheduleTask", TopicSettings.builder((Class)null).build());
            Topic topic4 = this.topicService.getTopic("org.tmatesoft.subgit.stash.mirror.topic:cancelTask", TopicSettings.builder((Class)null).build());
            Topic topic5 = this.topicService.getTopic("org.tmatesoft.subgit.stash.mirror.topic:reloadData", TopicSettings.builder((Class)null).build());
            this.subscriberIds.put(topic, topic.subscribe((TopicListener)this));
            this.subscriberIds.put(topic2, topic2.subscribe((TopicListener)this));
            this.subscriberIds.put(topic3, topic3.subscribe((TopicListener)this));
            this.subscriberIds.put(topic4, topic4.subscribe((TopicListener)this));
            this.subscriberIds.put(topic5, topic5.subscribe((TopicListener)this));
            this.stateLock.readLock().lock();
        }
        finally {
            this.stateLock.writeLock().unlock();
        }
    }

    public void statusChanged(SgTaskScope sgTaskScope) {
        this.stateLock.readLock().lock();
        try {
            if (this.state != SgTaskScheduler$State.RUNNING) {
                return;
            }
            this.internalStatusChanged(sgTaskScope);
        }
        finally {
            this.stateLock.readLock().unlock();
        }
    }

    private synchronized void internalStatusChanged(SgTaskScope sgTaskScope) {
        SgTaskSchedulerSnapshot$Builder sgTaskSchedulerSnapshot$Builder = SgTaskSchedulerSnapshot.builder();
        sgTaskSchedulerSnapshot$Builder.fromSnapshot((SgTaskSchedulerSnapshot)this.snapshots.get(sgTaskScope)).setScope(sgTaskScope);
        this.updateSnapshot(sgTaskScope, null, sgTaskSchedulerSnapshot$Builder);
        this.snapshots.put(sgTaskScope, sgTaskSchedulerSnapshot$Builder.build());
        boolean bl2 = this.isUpdateParentScopes && this.taskFactoryService.publishParentOnChildChanges(sgTaskScope, ((SgTaskSchedulerSnapshot)this.snapshots.get(sgTaskScope)).getData());
        this.pushSnapshot(sgTaskScope, bl2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dataChanged(SgTaskScope sgTaskScope, Serializable serializable) {
        this.stateLock.readLock().lock();
        try {
            if (this.state != SgTaskScheduler$State.RUNNING) {
                return;
            }
            SgTaskScheduler sgTaskScheduler = this;
            synchronized (sgTaskScheduler) {
                SgTaskSchedulerSnapshot sgTaskSchedulerSnapshot;
                block10: {
                    sgTaskSchedulerSnapshot = (SgTaskSchedulerSnapshot)this.snapshots.get(sgTaskScope);
                    if (sgTaskSchedulerSnapshot == null || !serializable.equals(sgTaskSchedulerSnapshot.getData())) break block10;
                    return;
                }
                SgTaskSchedulerSnapshot$Builder sgTaskSchedulerSnapshot$Builder = SgTaskSchedulerSnapshot.builder();
                sgTaskSchedulerSnapshot$Builder.fromSnapshot(sgTaskSchedulerSnapshot).setScope(sgTaskScope);
                this.updateSnapshot(sgTaskScope, serializable, sgTaskSchedulerSnapshot$Builder);
                this.snapshots.put(sgTaskScope, sgTaskSchedulerSnapshot$Builder.build());
                boolean bl2 = this.isUpdateParentScopes && (this.taskFactoryService.publishParentOnChildChanges(sgTaskScope, serializable) || sgTaskSchedulerSnapshot != null && this.taskFactoryService.publishParentOnChildChanges(sgTaskScope, sgTaskSchedulerSnapshot.getData()));
                this.pushSnapshot(sgTaskScope, bl2, false);
            }
        }
        finally {
            this.stateLock.readLock().unlock();
        }
    }

    private void updateSnapshot(SgTaskScope sgTaskScope, Serializable serializable, SgTaskSchedulerSnapshot$Builder sgTaskSchedulerSnapshot$Builder) {
        Object object;
        SgTaskStatus sgTaskStatus;
        SgTask sgTask = (SgTask)this.running.get(sgTaskScope);
        ArrayList<SgTaskStatus> arrayList = new ArrayList<SgTaskStatus>();
        if (sgTask != null && sgTask.getState() == SgTaskState.PENDING) {
            arrayList.add(sgTask.getStatus());
            sgTaskStatus = null;
        } else {
            SgTaskStatus sgTaskStatus2 = sgTaskStatus = sgTask != null ? sgTask.getStatus() : null;
        }
        if (this.queues.containsKey(sgTaskScope)) {
            object = ((Queue)this.queues.get(sgTaskScope)).iterator();
            while (object.hasNext()) {
                SgTask sgTask2 = (SgTask)object.next();
                arrayList.add(sgTask2.getStatus());
            }
        }
        if (sgTaskStatus != null && ((object = sgTask.getState()) == SgTaskState.CANCELLED || object == SgTaskState.AUTO_CANCELLED || object == SgTaskState.SHUTDOWN)) {
            sgTaskStatus = sgTask.isCompleted() ? SgTaskStatus.builder().fromStatus(sgTaskStatus).setState(SgTaskState.CANCELLED).build() : SgTaskStatus.builder().fromStatus(sgTaskStatus).setState(SgTaskState.CANCELLING).build();
        }
        sgTaskSchedulerSnapshot$Builder.setPending(arrayList.toArray(new SgTaskStatus[0]));
        if (sgTaskStatus != null) {
            sgTaskSchedulerSnapshot$Builder.setTask(sgTaskStatus);
        }
        if (serializable != null) {
            sgTaskSchedulerSnapshot$Builder.setData(serializable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BlockingQueue obtainQueue(SgTaskScope sgTaskScope) {
        this.stateLock.readLock().lock();
        try {
            this.state.assumeRunning();
            LinkedBlockingQueue linkedBlockingQueue = new LinkedBlockingQueue();
            SgTaskScheduler sgTaskScheduler = this;
            synchronized (sgTaskScheduler) {
                if (!this.pollQueues.containsKey(sgTaskScope)) {
                    this.pollQueues.put(sgTaskScope, new HashMap());
                }
                if (((Map)this.pollQueues.get(sgTaskScope)).containsKey(Thread.currentThread())) {
                    throw new SgException("poll queue already obtained by this thread for repository (" + String.valueOf(sgTaskScope) + ")");
                }
                ((Map)this.pollQueues.get(sgTaskScope)).put(Thread.currentThread(), linkedBlockingQueue);
                this.bootstrap(sgTaskScope, QUEUE_LOAD_BOOTSTRAP);
                this.pushSnapshot(sgTaskScope, Thread.currentThread());
                LinkedBlockingQueue linkedBlockingQueue2 = linkedBlockingQueue;
                return linkedBlockingQueue2;
            }
        }
        finally {
            this.stateLock.readLock().unlock();
        }
    }

    @Override
    public synchronized void releaseQueue(SgTaskScope sgTaskScope) {
        Map map = (Map)this.pollQueues.get(sgTaskScope);
        if (map == null) {
            return;
        }
        map.remove(Thread.currentThread());
        if (map.isEmpty()) {
            this.pollQueues.remove(sgTaskScope);
        }
        this.releaseTimes.put(sgTaskScope, System.currentTimeMillis());
    }

    private void pushSnapshot(SgTaskScope sgTaskScope, boolean bl2, boolean bl3) {
        for (SgTaskScope sgTaskScope2 : this.pollQueues.keySet()) {
            if (!sgTaskScope.equals(sgTaskScope2) && (!bl2 || !sgTaskScope2.includes(sgTaskScope)) && (!bl3 || !sgTaskScope.includes(sgTaskScope2))) continue;
            this.pushSnapshot(sgTaskScope2, ALL_QUEUES);
        }
        for (SgTaskScope sgTaskScope2 : this.remoteScopes.keySet()) {
            if (!sgTaskScope.equals(sgTaskScope2) && (!bl2 || !sgTaskScope2.includes(sgTaskScope)) && (!bl3 || !sgTaskScope.includes(sgTaskScope2))) continue;
            this.pushSnapshot(sgTaskScope2, this.topicService);
        }
    }

    private void pushSnapshot(SgTaskScope sgTaskScope, Object object) {
        this.snapshotPublisher.publish(sgTaskScope, object);
    }

    private SgTaskSchedulerSnapshot populateChildren(SgTaskSchedulerSnapshot sgTaskSchedulerSnapshot) {
        SgTaskScope sgTaskScope = sgTaskSchedulerSnapshot.getScope();
        if (!this.taskFactoryService.hasChildren(sgTaskScope, sgTaskSchedulerSnapshot.getData())) {
            return sgTaskSchedulerSnapshot;
        }
        HashMap<String, SgTaskSchedulerSnapshot> hashMap = new HashMap<String, SgTaskSchedulerSnapshot>();
        for (SgTaskScope sgTaskScope2 : this.snapshots.keySet()) {
            Serializable serializable;
            SgTaskSchedulerSnapshot sgTaskSchedulerSnapshot2;
            if (sgTaskScope2.equals(sgTaskScope) || !sgTaskScope.includes(sgTaskScope2) || (sgTaskSchedulerSnapshot2 = (SgTaskSchedulerSnapshot)this.snapshots.get(sgTaskScope2)) == null || sgTaskSchedulerSnapshot2.getTask() == null || sgTaskSchedulerSnapshot2.getData() == null || (serializable = this.taskFactoryService.getChildView(sgTaskScope2, sgTaskSchedulerSnapshot2.getData())) == null) continue;
            SgTaskSchedulerSnapshot sgTaskSchedulerSnapshot3 = SgTaskSchedulerSnapshot.builder().fromSnapshot(sgTaskSchedulerSnapshot2).setData(serializable).build();
            hashMap.put(sgTaskScope2.toString(), sgTaskSchedulerSnapshot3);
        }
        if (hashMap.isEmpty()) {
            return sgTaskSchedulerSnapshot;
        }
        return SgTaskSchedulerSnapshot.builder().fromSnapshot(sgTaskSchedulerSnapshot).setChildren(hashMap).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object shutdown() {
        this.stateLock.readLock().lock();
        try {
            this.state = SgTaskScheduler$State.SHUTTING_DOWN;
        }
        finally {
            this.stateLock.readLock().unlock();
        }
        SgTaskScheduler sgTaskScheduler = this;
        synchronized (sgTaskScheduler) {
            Object object;
            Object object2;
            for (SgTaskScope sgTaskScope : this.snapshots.keySet()) {
                object2 = (SgTaskSchedulerSnapshot)this.snapshots.get(sgTaskScope);
                object = SgTaskSchedulerSnapshot.builder().fromSnapshot((SgTaskSchedulerSnapshot)object2).setShutdown(true).build();
                this.snapshots.put(sgTaskScope, object);
                this.pushSnapshot(sgTaskScope, false, false);
            }
            for (SgTaskScope sgTaskScope : this.subscriberIds.keySet()) {
                if (sgTaskScope == null || this.subscriberIds.get(sgTaskScope) == null) continue;
                sgTaskScope.unsubscribe((String)this.subscriberIds.get(sgTaskScope));
            }
            this.subscriberIds.clear();
            for (SgTaskScope sgTaskScope : this.queues.keySet()) {
                this.cancelScheduledTasks(null, (Queue)this.queues.get(sgTaskScope));
            }
            for (SgTaskScope sgTaskScope : new HashSet(this.running.keySet())) {
                object2 = (SgTask)this.running.get(sgTaskScope);
                ((SgTask)object2).setState(SgTaskState.SHUTDOWN);
                if (((SgTask)object2).isStarted()) continue;
                object = this.getExecutorForTask(sgTaskScope, ((SgTask)object2).getName());
                ((ThreadPoolExecutor)object).remove(new SgTaskScheduler$TaskWrapper(this, (SgTask)object2));
                this.running.remove(sgTaskScope);
            }
            this.notify();
            return this.shutdownMonitor;
        }
    }

    public boolean isShutdown() {
        this.stateLock.readLock().lock();
        try {
            boolean bl2 = this.state == SgTaskScheduler$State.SHUTDOWN;
            return bl2;
        }
        finally {
            this.stateLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ArrayList<Object> arrayList;
        while (true) {
            block35: {
                this.log("waked up on changes in queues", new Object[0]);
                this.stateLock.readLock().lock();
                try {
                    if (this.state != SgTaskScheduler$State.SHUTTING_DOWN) break block35;
                    arrayList = this;
                    synchronized (arrayList) {
                        block36: {
                            if (!this.running.isEmpty()) break block36;
                            this.log("could shut down now, exiting", new Object[0]);
                            break;
                        }
                    }
                }
                finally {
                    this.stateLock.readLock().unlock();
                }
            }
            arrayList = new HashSet();
            long l2 = System.currentTimeMillis();
            long l3 = Long.MAX_VALUE;
            SgTaskScheduler sgTaskScheduler = this;
            synchronized (sgTaskScheduler) {
                Object object;
                for (Object object2 : this.queues.keySet()) {
                    if (this.running.containsKey(object2) || (object = (SgTask)((Queue)this.queues.get(object2)).peek()) == null) continue;
                    if (((SgTask)object).getTimeToRun() < 0L || ((SgTask)object).getTimeToRun() - l2 <= 0L) {
                        ((Queue)this.queues.get(object2)).poll();
                        arrayList.add(object);
                        continue;
                    }
                    l3 = Math.min(l3, ((SgTask)object).getTimeToRun() - l2);
                }
                for (Object object2 : arrayList) {
                    object = (Queue)this.queues.get(((SgTask)object2).getScope());
                    this.cancelScheduledTasks((SgTask)object2, (Queue)object);
                    this.running.put(((SgTask)object2).getScope(), object2);
                    this.internalStatusChanged(((SgTask)object2).getScope());
                    this.log((SgTask)object2, "executing", new Object[0]);
                    this.getExecutorForTask(((SgTask)object2).getScope(), ((SgTask)object2).getName()).execute(new SgTaskScheduler$TaskWrapper(this, (SgTask)object2));
                }
                try {
                    if (l3 != Long.MAX_VALUE) {
                        this.log("will sleep for %sms", l3);
                        this.wait(l3);
                    } else {
                        this.log("will sleep until queues change", new Object[0]);
                        this.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    this.log(interruptedException);
                }
            }
        }
        this.snapshotPublisher.shutdown();
        arrayList = this;
        synchronized (arrayList) {
            this.snapshots.clear();
            this.pollQueues.clear();
            this.releaseTimes.clear();
            this.remoteScopes.clear();
        }
        arrayList = new ArrayList<Object>();
        Object object = this.executors;
        synchronized (object) {
            for (String string : this.executors.keySet()) {
                ((ThreadPoolExecutor)this.executors.get(string)).shutdown();
                arrayList.add((ThreadPoolExecutor)this.executors.get(string));
            }
        }
        this.stateLock.readLock().lock();
        try {
            this.state = SgTaskScheduler$State.SHUTDOWN;
        }
        finally {
            this.stateLock.readLock().unlock();
        }
        try {
            this.log.info("waiting for all task to shut down");
            for (Object object3 : arrayList) {
                ((ThreadPoolExecutor)object3).awaitTermination(20000L, TimeUnit.MILLISECONDS);
            }
        }
        catch (InterruptedException interruptedException) {
            this.log.info(interruptedException.getMessage(), (Throwable)interruptedException);
        }
        this.log.info("all tasks have been shut down or timeout occurred");
        object = this.shutdownMonitor;
        synchronized (object) {
            this.shutdownMonitor.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanup() {
        this.stateLock.readLock().lock();
        try {
            if (this.state != SgTaskScheduler$State.RUNNING) {
                this.log("no cleanup (%s)", new Object[]{this.state});
                return;
            }
            SgTaskScheduler sgTaskScheduler = this;
            synchronized (sgTaskScheduler) {
                for (SgTaskScope sgTaskScope : new HashSet(this.queues.keySet())) {
                    this.cleanup(sgTaskScope);
                }
                long l2 = System.currentTimeMillis();
                for (SgTaskScope sgTaskScope : new HashSet(this.remoteScopes.keySet())) {
                    if (l2 - (Long)this.remoteScopes.get(sgTaskScope) <= 600000L) continue;
                    this.remoteScopes.remove(sgTaskScope);
                    this.logS(sgTaskScope, "remote scope expired, not tracked", new Object[0]);
                }
            }
        }
        finally {
            this.stateLock.readLock().unlock();
        }
    }

    private void cleanup(SgTaskScope sgTaskScope) {
        SgTaskSchedulerSnapshot sgTaskSchedulerSnapshot = (SgTaskSchedulerSnapshot)this.snapshots.get(sgTaskScope);
        if (this.isIdle(sgTaskScope) && !this.hasListeners(sgTaskScope, sgTaskSchedulerSnapshot) && !this.isInteresting(sgTaskSchedulerSnapshot)) {
            this.queues.remove(sgTaskScope);
            this.snapshots.remove(sgTaskScope);
            this.releaseTimes.remove(sgTaskScope);
            this.logS(sgTaskScope, "not tracked (%s)", this.taskFactoryService.toString(sgTaskScope, sgTaskSchedulerSnapshot.getData()));
        }
    }

    private boolean isInteresting(SgTaskSchedulerSnapshot sgTaskSchedulerSnapshot) {
        return this.taskFactoryService.keepIdleSnapshot(sgTaskSchedulerSnapshot.getScope(), sgTaskSchedulerSnapshot.getData());
    }

    private boolean hasListeners(SgTaskScope sgTaskScope, SgTaskSchedulerSnapshot sgTaskSchedulerSnapshot) {
        boolean bl2 = true;
        while (sgTaskScope != null) {
            if (this.pollQueues.containsKey(sgTaskScope) || this.remoteScopes.containsKey(sgTaskScope)) {
                return true;
            }
            long l2 = System.currentTimeMillis();
            Long l3 = (Long)this.releaseTimes.get(sgTaskScope);
            if (l3 != null && l2 - l3 < 10000L) {
                return true;
            }
            if (bl2 && !this.taskFactoryService.publishParentOnChildChanges(sgTaskScope, sgTaskSchedulerSnapshot.getData())) {
                return false;
            }
            bl2 = false;
            sgTaskScope = sgTaskScope.parent();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(@NotNull MessageEvent messageEvent) {
        block22: {
            if (messageEvent.getMessage() == null) {
                return;
            }
            if ("org.tmatesoft.subgit.stash.mirror.topic:obtainQueue".equals(messageEvent.getTopic())) {
                SgRequestSnapshotMessage sgRequestSnapshotMessage = (SgRequestSnapshotMessage)messageEvent.getMessage();
                SgTaskScope sgTaskScope = sgRequestSnapshotMessage.getScope();
                this.logS(sgTaskScope, "remote snapshot request", new Object[0]);
                SgTaskScheduler sgTaskScheduler = this;
                synchronized (sgTaskScheduler) {
                    this.remoteScopes.put(sgTaskScope, System.currentTimeMillis());
                    this.bootstrap(sgTaskScope, QUEUE_LOAD_BOOTSTRAP);
                    this.pushSnapshot(sgTaskScope, this.topicService);
                }
            }
            if ("org.tmatesoft.subgit.stash.mirror.topic:releaseQueue".equals(messageEvent.getTopic())) {
                SgRequestSnapshotMessage sgRequestSnapshotMessage = (SgRequestSnapshotMessage)messageEvent.getMessage();
                SgTaskScope sgTaskScope = sgRequestSnapshotMessage.getScope();
                this.logS(sgTaskScope, "remote scope release", new Object[0]);
                SgTaskScheduler sgTaskScheduler = this;
                synchronized (sgTaskScheduler) {
                    this.remoteScopes.remove(sgTaskScope);
                }
            }
            if ("org.tmatesoft.subgit.stash.mirror.topic:cancelTask".equals(messageEvent.getTopic())) {
                SgCancelTaskMessage sgCancelTaskMessage = (SgCancelTaskMessage)messageEvent.getMessage();
                String string = messageEvent.getSource().getId();
                this.logS(sgCancelTaskMessage.getScope(), "remote request to cancel task received, source: " + string + ", task id: " + sgCancelTaskMessage.getTaskId(), new Object[0]);
                try {
                    long l2 = this.cancelTask(sgCancelTaskMessage.getScope(), sgCancelTaskMessage.getTaskId());
                    this.logS(sgCancelTaskMessage.getScope(), "task cancelled, id: " + l2, new Object[0]);
                    this.taskCancelledTopic.publish((Serializable)new SgTaskCancelledMessage(sgCancelTaskMessage.getTaskId(), l2 >= 0L, null, string));
                }
                catch (SgException sgException) {
                    this.logS(sgCancelTaskMessage.getScope(), "task cancellation failed", new Object[0]);
                    this.logS(sgCancelTaskMessage.getScope(), sgException.getMessage(), new Object[0]);
                    this.taskCancelledTopic.publish((Serializable)new SgTaskCancelledMessage(sgCancelTaskMessage.getTaskId(), false, sgException.getMessage(), string));
                }
            } else if ("org.tmatesoft.subgit.stash.mirror.topic:scheduleTask".equals(messageEvent.getTopic())) {
                SgScheduleTaskMessage sgScheduleTaskMessage = (SgScheduleTaskMessage)messageEvent.getMessage();
                String string = messageEvent.getSource().getId();
                long l3 = sgScheduleTaskMessage.getMessageId();
                Serializable serializable = sgScheduleTaskMessage.getParameters();
                this.logS(sgScheduleTaskMessage.getScope(), "remote request to schedule task received, source: " + string + ", message id: " + l3, new Object[0]);
                try {
                    SgTask sgTask;
                    if (serializable instanceof SgPushTaskParameters) {
                        ((SgPushTaskParameters)serializable).setConsole(new SgProxyConsole(this.topicService, string, l3));
                    }
                    if ((sgTask = this.schedule(sgScheduleTaskMessage.getScope(), sgScheduleTaskMessage.getTaskName(), -1L, serializable)) != null) {
                        this.logS(sgScheduleTaskMessage.getScope(), "task scheduled on remote request: " + sgScheduleTaskMessage.getTaskName(), new Object[0]);
                        this.taskScheduledTopic.publish((Serializable)new SgTaskScheduledMessage(sgTask.getId(), null, string, l3));
                        sgTask.onStarted(() -> this.taskStartedTopic.publish((Serializable)new SgTaskCompletedMessage(sgTask.getId(), sgTask.getState(), sgTask.getStatus(), string)));
                        sgTask.onCompletion(() -> this.taskCompletedTopic.publish((Serializable)new SgTaskCompletedMessage(sgTask.getId(), sgTask.getState(), sgTask.getStatus(), string)));
                        break block22;
                    }
                    this.logS(sgScheduleTaskMessage.getScope(), "task not scheduled (null): " + sgScheduleTaskMessage.getTaskName(), new Object[0]);
                    this.taskScheduledTopic.publish((Serializable)new SgTaskScheduledMessage(-1L, new SgException("Task '" + sgScheduleTaskMessage.getTaskName() + "' was not scheduled"), string, l3));
                }
                catch (SgException sgException) {
                    this.log.error(sgException.getMessage(), (Throwable)sgException);
                    this.taskScheduledTopic.publish((Serializable)new SgTaskScheduledMessage(-1L, sgException, string, l3));
                }
            } else if ("org.tmatesoft.subgit.stash.mirror.topic:reloadData".equals(messageEvent.getTopic())) {
                SgReloadDataMessage sgReloadDataMessage = (SgReloadDataMessage)messageEvent.getMessage();
                SgTaskScope sgTaskScope = sgReloadDataMessage.getScope();
                try {
                    this.dataChanged(sgTaskScope, this.taskFactoryService.loadData(sgTaskScope));
                }
                catch (SgException sgException) {
                    this.log.error(sgException.getMessage(), (Throwable)sgException);
                }
            }
        }
    }

    private void log(SgTask sgTask, String string, Object ... objectArray) {
        if (this.log.isInfoEnabled()) {
            this.log.info(SgTextUtil.formatString("[%s][%s-%03d] %s", sgTask.getScope(), sgTask.getName(), sgTask.hashCode() % 1000, SgTextUtil.formatString(string, objectArray)));
        }
    }

    private void logS(SgTaskScope sgTaskScope, String string, Object ... objectArray) {
        if (this.log.isInfoEnabled()) {
            this.log.info(SgTextUtil.formatString("[%s] %s", sgTaskScope, SgTextUtil.formatString(string, objectArray)));
        }
    }

    private void log(String string, Object ... objectArray) {
        if (this.log.isInfoEnabled()) {
            this.log.info(SgTextUtil.formatString(string, objectArray));
        }
    }

    private void log(Throwable throwable) {
        if (this.log.isInfoEnabled()) {
            this.log.info(throwable.getMessage(), throwable);
        }
    }

    private boolean isBootstrap(SgTask sgTask) {
        return sgTask != null && this.taskFactoryService.getBootstrapTaskName().equals(sgTask.getName());
    }

    private static boolean isCancelException(Throwable throwable, Set set) {
        Set set2 = set = set == null ? new HashSet() : set;
        if (throwable == null) {
            return false;
        }
        if (throwable instanceof a || throwable instanceof SVNCancelException || throwable instanceof e) {
            return true;
        }
        if (set.contains(throwable)) {
            return false;
        }
        return SgTaskScheduler.isCancelException(throwable.getCause(), set);
    }
}

