/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.subgit.stash.mirror.scheduler;

import java.io.Serializable;
import java.util.Queue;
import org.jetbrains.annotations.NotNull;
import org.tmatesoft.subgit.stash.mirror.scheduler.SgTask;
import org.tmatesoft.subgit.stash.mirror.scheduler.SgTaskScheduler;
import org.tmatesoft.subgit.stash.mirror.scheduler.SgTaskScheduler$State;
import org.tmatesoft.subgit.stash.mirror.scheduler.SgTaskSchedulerSnapshot;
import org.tmatesoft.subgit.stash.mirror.scheduler.SgTaskState;

class SgTaskScheduler$TaskWrapper
implements Runnable {
    @NotNull
    private final SgTask task;
    final /* synthetic */ SgTaskScheduler this$0;

    public SgTaskScheduler$TaskWrapper(@NotNull SgTaskScheduler sgTaskScheduler, SgTask sgTask) {
        this.this$0 = sgTaskScheduler;
        this.task = sgTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.task.setStarted(true);
        this.this$0.taskFactoryService.preRun(this.task);
        try {
            this.runTask();
        }
        finally {
            this.this$0.taskFactoryService.postRun(this.task);
            SgTaskScheduler sgTaskScheduler = this.this$0;
            synchronized (sgTaskScheduler) {
                this.this$0.internalStatusChanged(this.task.getScope());
                this.this$0.running.remove(this.task.getScope());
                this.this$0.log(this.task, "notifying scheduler upon completion", new Object[0]);
                this.this$0.notify();
            }
            this.this$0.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTask() {
        Serializable serializable;
        try {
            this.reloadData();
            SgTaskScheduler sgTaskScheduler = this.this$0;
            synchronized (sgTaskScheduler) {
                serializable = ((SgTaskSchedulerSnapshot)this.this$0.snapshots.get(this.task.getScope())).getData();
            }
            if (!this.task.isApplicableFor(serializable)) {
                this.this$0.log(this.task, "not applicable", new Object[0]);
                this.task.setState(SgTaskState.REJECTED);
                this.task.setCompleted(true);
                return;
            }
        }
        catch (Throwable throwable) {
            this.task.getLogger().error(throwable.getMessage(), throwable);
            this.this$0.log(this.task, "pre-run data load failed", new Object[0]);
            this.this$0.log(throwable);
            this.task.setState(SgTaskState.FAILED, throwable.getMessage());
            return;
        }
        try {
            this.task.checkCancelled();
            this.this$0.log(this.task, "about to run", new Object[0]);
            this.this$0.log(this.task, this.this$0.pluginPropertiesService.getServerInformation(), new Object[0]);
            this.task.setState(SgTaskState.RUNNING);
            this.task.run(serializable);
            this.reloadData();
            if (this.task.getState() == SgTaskState.FAILING) {
                this.task.setState(SgTaskState.FAILED, "Unexpected Error has occurred, check 'Support' tab");
                this.this$0.log(this.task, "run completed as failed", new Object[0]);
            } else {
                this.task.setState(SgTaskState.SUCCESS);
                this.this$0.log(this.task, "run completed as success", new Object[0]);
            }
        }
        catch (Throwable throwable) {
            this.this$0.log.warn(throwable.getMessage(), throwable);
            if (SgTaskScheduler.isCancelException(throwable, null)) {
                this.this$0.log(this.task, "run cancelled (%s)", new Object[]{this.task.getState()});
            } else {
                this.this$0.log(this.task, "run failed (%s)", new Object[]{this.task.getState()});
                this.task.getLogger().error(throwable.getMessage(), throwable);
                this.this$0.log(throwable);
                this.task.setState(SgTaskState.FAILED, throwable.getMessage());
            }
        }
        finally {
            this.postRun(serializable);
        }
    }

    private void reloadData() {
        try {
            this.this$0.dataChanged(this.task.getScope(), this.this$0.taskFactoryService.loadData(this.task.getScope()));
        }
        catch (Throwable throwable) {
            this.task.getLogger().error(throwable.getMessage(), throwable);
            this.this$0.log(this.task, "data load failed", new Object[0]);
            this.this$0.log(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postRun(Serializable serializable) {
        block14: {
            if (this.task.needsRollback()) {
                try {
                    this.this$0.log(this.task, "rollback", new Object[0]);
                    this.task.rollback(serializable);
                }
                catch (Throwable throwable) {
                    this.task.getLogger().error(throwable.getMessage(), throwable);
                    this.this$0.log(this.task, "rollback failed", new Object[0]);
                    this.this$0.log(throwable);
                }
                this.reloadData();
            } else {
                this.this$0.log(this.task, "no rollback", new Object[0]);
            }
            this.this$0.stateLock.readLock().lock();
            try {
                if (this.this$0.state == SgTaskScheduler$State.RUNNING) {
                    SgTaskScheduler sgTaskScheduler = this.this$0;
                    synchronized (sgTaskScheduler) {
                        Serializable serializable2 = ((SgTaskSchedulerSnapshot)this.this$0.snapshots.get(this.task.getScope())).getData();
                        Queue queue = (Queue)this.this$0.queues.get(this.task.getScope());
                        if (this.this$0.cancelScheduledInapplicableTasks(serializable2, queue)) {
                            this.this$0.logS(this.task.getScope(), "some of scheduled tasks removed, state is no longer applicable", new Object[0]);
                        }
                    }
                    try {
                        this.task.postRun(serializable);
                    }
                    catch (Throwable throwable) {
                        this.task.getLogger().error(throwable.getMessage(), throwable);
                        this.this$0.log(this.task, "post-run failed", new Object[0]);
                        this.this$0.log(throwable);
                    }
                    break block14;
                }
                this.this$0.log(this.task, "no post-run (%s)", new Object[]{this.this$0.state});
            }
            finally {
                this.this$0.stateLock.readLock().unlock();
            }
        }
        this.task.setCompleted(true);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        SgTaskScheduler$TaskWrapper sgTaskScheduler$TaskWrapper = (SgTaskScheduler$TaskWrapper)object;
        return sgTaskScheduler$TaskWrapper.task == this.task;
    }

    public int hashCode() {
        return this.task.hashCode();
    }
}

