/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.subgit.stash.mirror.scheduler;

import com.atlassian.bitbucket.topic.TopicService;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import org.slf4j.Logger;
import org.tmatesoft.subgit.stash.mirror.scheduler.SgTaskScheduler;
import org.tmatesoft.subgit.stash.mirror.scheduler.SgTaskSchedulerSnapshot;
import org.tmatesoft.subgit.stash.mirror.scheduler.SgTaskScope;
import org.tmatesoft.subgit.stash.mirror.scheduler.message.SgSnapshotMessage;

class SgTaskScheduler$SnapshotPublisher
implements Runnable {
    private final TopicService topicService;
    private final Logger logger;
    private volatile boolean isStopped;
    private boolean isShutdown;
    private final Set remoteTargets = new HashSet();
    private final Set localTargets = new HashSet();
    private final Map localQueueTargets = new HashMap();
    final /* synthetic */ SgTaskScheduler this$0;

    public SgTaskScheduler$SnapshotPublisher(SgTaskScheduler sgTaskScheduler, TopicService topicService, Logger logger) {
        this.this$0 = sgTaskScheduler;
        this.topicService = topicService;
        this.logger = logger;
        this.isStopped = false;
    }

    public synchronized void publish(SgTaskScope sgTaskScope, Object object) {
        if (object == this.topicService) {
            this.remoteTargets.add(sgTaskScope);
        } else if (object == SgTaskScheduler.ALL_QUEUES) {
            this.localTargets.add(sgTaskScope);
            this.localQueueTargets.remove(sgTaskScope);
        } else if (!this.localTargets.contains(sgTaskScope) && object instanceof Thread) {
            if (!this.localQueueTargets.containsKey(sgTaskScope)) {
                this.localQueueTargets.put(sgTaskScope, new HashSet());
            }
            ((Collection)this.localQueueTargets.get(sgTaskScope)).add((Thread)object);
        }
    }

    public synchronized void shutdown() {
        this.isStopped = true;
        this.logger.info("shutting down snapshot publisher");
        this.notify();
        try {
            this.wait(10000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!this.isShutdown) {
            this.logger.info("snapshot publisher shut down didn't complete");
        } else {
            this.logger.info("snapshot publisher shut down");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            try {
                this.doRun();
                break;
            }
            catch (Throwable throwable) {
                this.this$0.log.error(throwable.getMessage(), throwable);
                SgTaskScheduler$SnapshotPublisher sgTaskScheduler$SnapshotPublisher = this;
                synchronized (sgTaskScheduler$SnapshotPublisher) {
                    if (this.isShutdown || this.isStopped) {
                        break;
                    }
                }
            }
        }
        this.logger.info("snapshot publisher exits");
        SgTaskScheduler$SnapshotPublisher sgTaskScheduler$SnapshotPublisher = this;
        synchronized (sgTaskScheduler$SnapshotPublisher) {
            this.isShutdown = true;
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRun() {
        HashSet hashSet = new HashSet();
        HashSet hashSet2 = new HashSet();
        HashMap hashMap = new HashMap();
        HashMap<Object, Object> hashMap2 = new HashMap<Object, Object>();
        HashMap hashMap3 = new HashMap();
        int n2 = 0;
        while (!this.isStopped) {
            Thread thread;
            Object object;
            Object object22;
            hashMap.clear();
            hashSet2.clear();
            hashSet.clear();
            hashMap2.clear();
            hashMap3.clear();
            ++n2;
            Iterator<Object> iterator = this;
            synchronized (iterator) {
                try {
                    this.wait(250L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if ((long)n2 == 4L) {
                    hashSet.addAll(this.remoteTargets);
                    this.remoteTargets.clear();
                    n2 = 0;
                }
                hashSet2.addAll(this.localTargets);
                this.localTargets.clear();
                hashMap.putAll(this.localQueueTargets);
                this.localQueueTargets.clear();
            }
            iterator = this.this$0;
            synchronized (iterator) {
                for (Object object22 : hashSet) {
                    object = this.prepareSnapshot((SgTaskSchedulerSnapshot)this.this$0.snapshots.get(object22));
                    if (object == null) continue;
                    hashMap2.put(object22, object);
                }
                if (!hashSet2.isEmpty() || !hashMap.isEmpty()) {
                    for (Object object22 : this.this$0.pollQueues.keySet()) {
                        hashMap3.put((SgTaskScope)object22, new HashMap());
                        object = ((Map)this.this$0.pollQueues.get(object22)).keySet().iterator();
                        while (object.hasNext()) {
                            thread = (Thread)object.next();
                            BlockingQueue blockingQueue = (BlockingQueue)((Map)this.this$0.pollQueues.get(object22)).get(thread);
                            ((Map)hashMap3.get(object22)).put(thread, blockingQueue);
                        }
                    }
                    hashMap3.putAll(this.this$0.pollQueues);
                    for (Object object22 : hashSet2) {
                        if (hashMap2.containsKey(object22) || !hashMap3.containsKey(object22) || (object = this.prepareSnapshot((SgTaskSchedulerSnapshot)this.this$0.snapshots.get(object22))) == null) continue;
                        hashMap2.put(object22, object);
                    }
                    for (Object object22 : hashMap.keySet()) {
                        if (hashMap2.containsKey(object22) || !hashMap3.containsKey(object22) || (object = this.prepareSnapshot((SgTaskSchedulerSnapshot)this.this$0.snapshots.get(object22))) == null) continue;
                        hashMap2.put(object22, object);
                    }
                }
            }
            if (hashMap2.isEmpty()) continue;
            for (Object object3 : hashSet) {
                if (!hashMap2.containsKey(object3)) continue;
                this.this$0.snapshotBroadcastTopic.publish((Serializable)new SgSnapshotMessage((SgTaskSchedulerSnapshot)hashMap2.get(object3)));
            }
            if (this.this$0.log.isInfoEnabled() && !hashSet.isEmpty()) {
                this.this$0.log.info("snapshots to proxy nodes: " + hashSet.stream().map(Object::toString).reduce(null, (string, string2) -> string != null ? string + "," + string2 : string2));
            }
            if (hashMap3.isEmpty()) continue;
            for (Object object3 : hashSet2) {
                if (!hashMap2.containsKey(object3) || (object22 = (Map)hashMap3.get(object3)) == null) continue;
                object = object22.keySet().iterator();
                while (object.hasNext()) {
                    thread = (Thread)object.next();
                    ((BlockingQueue)object22.get(thread)).add((SgTaskSchedulerSnapshot)hashMap2.get(object3));
                }
            }
            if (this.this$0.log.isInfoEnabled() && !hashSet2.isEmpty()) {
                this.this$0.log.info("snapshots to all local listeners: " + hashSet2.stream().map(Object::toString).reduce(null, (string, string2) -> string != null ? string + "," + string2 : string2));
            }
            for (Object object3 : hashMap.keySet()) {
                if (!hashMap2.containsKey(object3)) continue;
                object22 = (Map)hashMap3.get(object3);
                object = ((Collection)hashMap.get(object3)).iterator();
                while (object.hasNext()) {
                    thread = (Thread)object.next();
                    if (!object22.containsKey(thread)) continue;
                    ((BlockingQueue)object22.get(thread)).add((SgTaskSchedulerSnapshot)hashMap2.get(object3));
                }
            }
            if (!this.this$0.log.isInfoEnabled() || hashMap.isEmpty()) continue;
            this.this$0.log.info("snapshots to local queues: " + hashMap.keySet().stream().map(Object::toString).reduce(null, (string, string2) -> string != null ? string + "," + string2 : string2));
        }
    }

    private SgTaskSchedulerSnapshot prepareSnapshot(SgTaskSchedulerSnapshot sgTaskSchedulerSnapshot) {
        if (sgTaskSchedulerSnapshot == null || !sgTaskSchedulerSnapshot.isShutdown() && sgTaskSchedulerSnapshot.getData() == null || sgTaskSchedulerSnapshot.getTask() == null) {
            this.this$0.log("snapshot is empty: " + String.valueOf(sgTaskSchedulerSnapshot), new Object[0]);
            return null;
        }
        return this.this$0.populateChildren(sgTaskSchedulerSnapshot);
    }
}

