/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.subgit.stash.mirror.scheduler;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.tmatesoft.subgit.stash.mirror.SgException;
import org.tmatesoft.subgit.stash.mirror.scheduler.ISgTask;
import org.tmatesoft.subgit.stash.mirror.scheduler.SgTaskScheduler;
import org.tmatesoft.subgit.stash.mirror.scheduler.SgTaskScope;
import org.tmatesoft.subgit.stash.mirror.scheduler.SgTaskState;
import org.tmatesoft.subgit.stash.mirror.scheduler.SgTaskStatus;
import org.tmatesoft.subgit.stash.mirror.scheduler.SgTaskStatus$Builder;
import org.tmatesoft.subgit.stash.mirror.util.SgTextUtil;
import org.tmatesoft.translator.util.a;

public abstract class SgTask
implements Comparable,
ISgTask,
org.tmatesoft.translator.m.a {
    private final String name;
    private final SgTaskScope scope;
    private final long id;
    private final long timeToRun;
    private final Serializable parameters;
    private final SgTaskScheduler scheduler;
    private volatile SgTaskStatus status;
    private Logger logger;
    private volatile boolean isCompleted;
    private volatile boolean isStarted;
    private volatile boolean needsRollback;
    private volatile boolean cancelExceptionWasThrown;
    private static final AtomicLong taskCounter = new AtomicLong(0L);
    private Runnable onCompletion;
    private Runnable onStarted;

    protected SgTask(SgTaskScheduler sgTaskScheduler, String string, SgTaskScope sgTaskScope, long l2, Serializable serializable) {
        this.name = string;
        this.scope = sgTaskScope;
        this.id = taskCounter.incrementAndGet();
        this.status = SgTaskStatus.builder().setId(this.id).setState(SgTaskState.CREATED).setName(this.getName()).setCancellable(true).setCompleted(-1L).setScheduled(l2).build();
        this.parameters = serializable;
        this.timeToRun = l2;
        this.scheduler = sgTaskScheduler;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public long getId() {
        return this.id;
    }

    protected Serializable getParameters() {
        return this.parameters;
    }

    public long getTimeToRun() {
        return this.timeToRun;
    }

    public SgTaskScope getScope() {
        return this.scope;
    }

    public boolean isApplicableFor(Serializable serializable) {
        return true;
    }

    public boolean isRunnable() {
        return true;
    }

    public boolean shouldCancel(SgTask sgTask) {
        return true;
    }

    protected void schedule(String string) {
        this.schedule(string, -1L);
    }

    protected void schedule(String string, long l2) {
        if (this.getState().isFinal() && this.getState() != SgTaskState.SHUTDOWN) {
            this.scheduler.schedule(this.getScope(), string, l2, null);
        }
    }

    public abstract void run(Serializable var1);

    public abstract void postRun(Serializable var1);

    public abstract void rollback(Serializable var1);

    @Override
    public synchronized void checkCancelled() {
        if (this.cancelExceptionWasThrown) {
            return;
        }
        SgTaskState sgTaskState = this.status.getState();
        if (sgTaskState == SgTaskState.CANCELLED || sgTaskState == SgTaskState.AUTO_CANCELLED || sgTaskState == SgTaskState.SHUTDOWN) {
            this.cancelExceptionWasThrown = true;
            throw new a("task cancelled", new Object[0]);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setState(SgTaskState sgTaskState) {
        this.setState(sgTaskState, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SgTaskState getState() {
        SgTaskScheduler sgTaskScheduler = this.scheduler;
        synchronized (sgTaskScheduler) {
            return this.status.getState();
        }
    }

    public void setState(SgTaskState sgTaskState, String string) {
        this.updateStatus(sgTaskState, string, -1, new Object[0]);
    }

    public void setMessage(String string, Object ... objectArray) {
        this.updateStatus(null, string, -1, objectArray);
    }

    protected void setProgressMessage(String string, int n2, Object ... objectArray) {
        this.updateStatus(null, string, n2, objectArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateStatus(SgTaskState sgTaskState, String string, int n2, Object ... objectArray) {
        boolean bl2;
        Object object = this.scheduler;
        synchronized (object) {
            if (sgTaskState != SgTaskState.SHUTDOWN && this.status.getState().isFinal()) {
                return;
            }
            bl2 = this.getState() == SgTaskState.CREATED && sgTaskState == SgTaskState.REJECTED;
            SgTaskStatus$Builder sgTaskStatus$Builder = SgTaskStatus.builder().fromStatus(this.status);
            if (sgTaskState == SgTaskState.FAILED && string != null) {
                string = this.formatErrorMessage(string);
            }
            sgTaskStatus$Builder.setMessage(SgTextUtil.formatString(string, objectArray));
            if (sgTaskState != null) {
                sgTaskStatus$Builder.setState(sgTaskState);
                if (sgTaskState.isFinal()) {
                    sgTaskStatus$Builder.setCompleted(System.currentTimeMillis());
                }
                sgTaskStatus$Builder.setCancellable(this.isCancellable());
            }
            sgTaskStatus$Builder.setPercentage(n2);
            this.status = sgTaskStatus$Builder.build();
        }
        if (!bl2) {
            this.scheduler.statusChanged(this.getScope());
        }
        object = this;
        synchronized (object) {
            this.notifyAll();
        }
    }

    protected abstract String formatErrorMessage(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SgTaskState waitForCompletion(long l2) {
        if (l2 > 0L) {
            long l3 = System.currentTimeMillis();
            while (this.getState() == SgTaskState.PENDING) {
                SgTask sgTask = this;
                synchronized (sgTask) {
                    try {
                        this.wait(l2);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (System.currentTimeMillis() - l3 < l2) continue;
            }
            if (this.getState() == SgTaskState.PENDING) {
                this.scheduler.cancelTask(this.getScope(), this.getId());
                return SgTaskState.TIMEOUT;
            }
        }
        SgTask sgTask = this;
        synchronized (sgTask) {
            while (!this.isCompleted) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    throw new SgException("Operation was interrupted");
                }
            }
        }
        return this.getState();
    }

    public int compareTo(@NotNull SgTask sgTask) {
        if (sgTask == this) {
            return 0;
        }
        return -Long.compare(this.timeToRun, sgTask.timeToRun);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SgTaskStatus getStatus() {
        SgTaskScheduler sgTaskScheduler = this.scheduler;
        synchronized (sgTaskScheduler) {
            return this.status;
        }
    }

    protected void setNeedsRollback(boolean bl2) {
        this.needsRollback = bl2;
    }

    public boolean needsRollback() {
        return this.needsRollback;
    }

    public boolean isStarted() {
        return this.isStarted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStarted(boolean bl2) {
        boolean bl3;
        SgTask sgTask = this;
        synchronized (sgTask) {
            this.isStarted = bl2;
            bl3 = bl2 && this.onStarted != null;
        }
        if (bl3) {
            this.onStarted.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCompleted(boolean bl2) {
        boolean bl3;
        SgTask sgTask = this;
        synchronized (sgTask) {
            bl3 = bl2 && !this.isCompleted;
            this.isCompleted = bl2;
            this.notifyAll();
        }
        if (bl3 && this.onCompletion != null) {
            this.onCompletion.run();
        }
    }

    public boolean isCompleted() {
        return this.isCompleted;
    }

    public boolean isCancellable() {
        return !this.getState().isFinal() && this.getState() != SgTaskState.CANCELLING;
    }

    protected SgTaskScheduler getScheduler() {
        return this.scheduler;
    }

    public void onCompletion(Runnable runnable) {
        if (this.isCompleted) {
            runnable.run();
        } else {
            this.onCompletion = runnable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onStarted(Runnable runnable) {
        boolean bl2;
        SgTask sgTask = this;
        synchronized (sgTask) {
            bl2 = this.isStarted;
            if (!bl2) {
                this.onStarted = runnable;
            }
        }
        if (bl2) {
            runnable.run();
        }
    }
}

