/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.subgit.stash.mirror.scheduler;

import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.config.JobRunnerKey;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.tmatesoft.subgit.stash.mirror.SgException;
import org.tmatesoft.subgit.stash.mirror.scheduler.SgTaskSchedulerService;
import org.tmatesoft.subgit.stash.mirror.util.SgLoggerFactory;

public class SgBootstrapJobRunner
implements JobRunner {
    public static JobRunnerKey KEY = JobRunnerKey.of((String)"org.tmatesoft.subgit:SgBootstrapJobRunner");
    private final SgTaskSchedulerService schedulerService;
    private final AtomicBoolean pluginActive;
    private final Logger log;

    public SgBootstrapJobRunner(SgTaskSchedulerService sgTaskSchedulerService, AtomicBoolean atomicBoolean, SgLoggerFactory sgLoggerFactory) {
        this.schedulerService = sgTaskSchedulerService;
        this.pluginActive = atomicBoolean;
        this.log = sgLoggerFactory.getLogger("bootstrap");
    }

    @Nullable
    public JobRunnerResponse runJob(@NotNull JobRunnerRequest jobRunnerRequest) {
        if (!this.pluginActive.get()) {
            return JobRunnerResponse.aborted((String)"add-on has been shut down");
        }
        try {
            this.schedulerService.getScheduler();
            return JobRunnerResponse.success();
        }
        catch (SgException sgException) {
            this.log.error(sgException.getMessage(), (Throwable)sgException);
            return JobRunnerResponse.failed((String)sgException.getMessage());
        }
    }
}

