/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.subgit.stash.mirror.rest;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

@XmlRootElement
public class SgSvnSyncInfo {
    @XmlElement
    private long revision;
    @XmlElement
    private String changedPaths;
    @XmlElement
    private String uuid;
    private Set affectedPaths;

    public static SgSvnSyncInfo forUUID(String string) {
        return new SgSvnSyncInfo(string);
    }

    private SgSvnSyncInfo() {
        this.affectedPaths = null;
        this.revision = -1L;
    }

    private SgSvnSyncInfo(String string) {
        this.uuid = string;
        this.revision = -1L;
        this.changedPaths = null;
        this.affectedPaths = Collections.emptySet();
    }

    public long getRevision() {
        return this.revision;
    }

    public String getUuid() {
        return this.uuid;
    }

    public Set getAffectedPaths() {
        if (this.affectedPaths == null) {
            this.affectedPaths = SgSvnSyncInfo.getAffectedPaths(this.changedPaths);
        }
        return this.affectedPaths;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("uuid=");
        stringBuilder.append(this.uuid);
        stringBuilder.append(";revision=");
        stringBuilder.append(this.revision);
        stringBuilder.append(";paths=[");
        for (String string : this.getAffectedPaths()) {
            stringBuilder.append(string);
            stringBuilder.append(",");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    private static Set getAffectedPaths(String string) {
        if (string == null) {
            return Collections.emptySet();
        }
        String[] stringArray = string.split("\n");
        HashSet<String> hashSet = new HashSet<String>();
        for (String string2 : stringArray) {
            if (string2.length() <= 4 || string2.charAt(0) == ' ') continue;
            hashSet.add(string2.substring(4, string2.length()));
        }
        return hashSet;
    }
}

