/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.subgit.stash.mirror.rest;

import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.project.ProjectService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageRequestImpl;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.tmatesoft.subgit.stash.mirror.SgAuthorsService;
import org.tmatesoft.subgit.stash.mirror.SgException;
import org.tmatesoft.subgit.stash.mirror.SgMirrorOption;
import org.tmatesoft.subgit.stash.mirror.SgMirrorService;
import org.tmatesoft.subgit.stash.mirror.json.SgJsonService;
import org.tmatesoft.subgit.stash.mirror.rest.SgConfigureInfo;
import org.tmatesoft.subgit.stash.mirror.rest.SgSvnSyncInfo;
import org.tmatesoft.subgit.stash.mirror.scheduler.ISgTask;
import org.tmatesoft.subgit.stash.mirror.scheduler.ISgTaskScheduler;
import org.tmatesoft.subgit.stash.mirror.scheduler.SgClusterStatus;
import org.tmatesoft.subgit.stash.mirror.scheduler.SgTaskSchedulerService;
import org.tmatesoft.subgit.stash.mirror.scheduler.SgTaskSchedulerSnapshot;
import org.tmatesoft.subgit.stash.mirror.scheduler.SgTaskState;
import org.tmatesoft.subgit.stash.mirror.settings.SgSetting;
import org.tmatesoft.subgit.stash.mirror.settings.SgSettings;
import org.tmatesoft.subgit.stash.mirror.tasks.SgMirrorScope;
import org.tmatesoft.subgit.stash.mirror.tasks.SgMirrorStartType;
import org.tmatesoft.subgit.stash.mirror.tasks.SgSingleSettingParameter;
import org.tmatesoft.subgit.stash.mirror.util.SgLoggerFactory;

@Provider
@Path(value="/")
public class SgMirrorRestService {
    private final Logger log;
    private final SgTaskSchedulerService taskSchedulerService;
    private final RepositoryService repositoryService;
    private final SgMirrorService mirrorService;
    private final SecurityService securityService;
    private final ProjectService projectService;
    private final SgAuthorsService authorsService;
    private final SgJsonService jsonService;

    @Inject
    public SgMirrorRestService(RepositoryService repositoryService, ProjectService projectService, SecurityService securityService, SgTaskSchedulerService sgTaskSchedulerService, SgAuthorsService sgAuthorsService, SgJsonService sgJsonService, SgLoggerFactory sgLoggerFactory, SgMirrorService sgMirrorService) {
        this.repositoryService = repositoryService;
        this.projectService = projectService;
        this.securityService = securityService;
        this.log = sgLoggerFactory.getLogger("rest");
        this.taskSchedulerService = sgTaskSchedulerService;
        this.mirrorService = sgMirrorService;
        this.authorsService = sgAuthorsService;
        this.jsonService = sgJsonService;
    }

    @AnonymousSiteAccess
    @POST
    @Path(value="projects/{projectKey}/repos/{repositorySlug}")
    public Response runCommand(@PathParam(value="projectKey") String string, @PathParam(value="repositorySlug") String string2, @QueryParam(value="command") String string3) {
        this.log.info("REST request received: " + string + "/" + string2 + " : " + string3);
        if (string3 == null || string3.isEmpty()) {
            return Response.noContent().build();
        }
        String string4 = string3.trim() + "-rest";
        try {
            return (Response)this.securityService.withPermission(Permission.REPO_ADMIN, "REST command").call(() -> this.scheduleCommand(string, string2, string4, null));
        }
        catch (Throwable throwable) {
            this.log.info(throwable.getMessage(), throwable);
            return Response.serverError().build();
        }
    }

    @AnonymousSiteAccess
    @POST
    @Path(value="svnUUID/{svnUUID}")
    public Response runCommandForUUID(@PathParam(value="svnUUID") String string, @QueryParam(value="command") String string2) {
        if (string2 == null || "".equals(string2.trim())) {
            string2 = "sync";
        }
        this.log.info("REST request received: " + string + " : " + string2);
        this.log.info("command: " + string2);
        if (string == null || string.isEmpty()) {
            return Response.noContent().build();
        }
        String string3 = string2.trim() + "-rest";
        try {
            return (Response)this.securityService.withPermission(Permission.REPO_ADMIN, "REST command").call(() -> this.scheduleCommand(SgSvnSyncInfo.forUUID(string), string3));
        }
        catch (Throwable throwable) {
            this.log.info(throwable.getMessage(), throwable);
            return Response.serverError().build();
        }
    }

    @AnonymousSiteAccess
    @POST
    @Path(value="sync")
    @Consumes(value={"application/json", "application/xml"})
    public Response runSync(@QueryParam(value="command") String string, SgSvnSyncInfo sgSvnSyncInfo) {
        this.log.info("REST request received: " + String.valueOf(sgSvnSyncInfo));
        if (string == null || "".equals(string.trim())) {
            string = "sync";
        }
        this.log.info("command: " + string);
        String string2 = string.trim() + "-rest";
        try {
            return (Response)this.securityService.withPermission(Permission.REPO_ADMIN, "REST command").call(() -> this.scheduleCommand(sgSvnSyncInfo, string2));
        }
        catch (Throwable throwable) {
            this.log.info(throwable.getMessage(), throwable);
            return Response.serverError().build();
        }
    }

    @AnonymousSiteAccess
    @POST
    @Path(value="projects/{projectKey}/repos/{repositorySlug}/configure")
    @Consumes(value={"application/json", "application/xml"})
    public Response runConfigure(@PathParam(value="projectKey") String string, @PathParam(value="repositorySlug") String string2, @DefaultValue(value="MIRROR") @QueryParam(value="start") String string3, @DefaultValue(value="false") @QueryParam(value="async") boolean bl2, SgConfigureInfo sgConfigureInfo) {
        this.log.info("REST configure request received: " + String.valueOf(sgConfigureInfo));
        SgMirrorScope sgMirrorScope = this.getScope(string, string2);
        if (sgMirrorScope == null) {
            return Response.status((int)404).build();
        }
        try {
            SgSettings sgSettings = sgConfigureInfo.toSettings(this.authorsService, this.jsonService);
            sgSettings.set(SgMirrorOption.START_MODE, (Object)SgMirrorStartType.fromString(string3));
            ISgTask iSgTask = this.taskSchedulerService.getScheduler().schedule(sgMirrorScope, "configure-rest", sgSettings.snapshot(SgMirrorOption.all()));
            if (iSgTask == null || iSgTask.getState() == SgTaskState.REJECTED) {
                return Response.serverError().entity((Object)(string + "/" + string2 + ": configure task failed to schedule, inapplicable target repository state")).build();
            }
            if (!bl2) {
                this.log.info("REST configure waiting for task completion");
                SgTaskState sgTaskState = iSgTask.waitForCompletion(0L);
                this.log.info("REST configure task completed with status: " + String.valueOf((Object)sgTaskState));
                if (sgTaskState == SgTaskState.CANCELLED || sgTaskState == SgTaskState.AUTO_CANCELLED) {
                    return Response.serverError().entity((Object)(string + "/" + string2 + ": configure task cancelled: " + iSgTask.getStatus().getMessage())).build();
                }
                if (sgTaskState == SgTaskState.FAILED) {
                    return Response.serverError().entity((Object)(string + "/" + string2 + ": configure task failed: " + iSgTask.getStatus().getMessage())).build();
                }
                if (sgTaskState == SgTaskState.TIMEOUT) {
                    return Response.serverError().entity((Object)(string + "/" + string2 + ": configure task timed out")).build();
                }
                if (sgTaskState == SgTaskState.SHUTDOWN) {
                    return Response.serverError().entity((Object)(string + "/" + string2 + ": configure task cancelled due to the add-on shutdown")).build();
                }
                if (sgTaskState == SgTaskState.REJECTED) {
                    return Response.serverError().entity((Object)(string + "/" + string2 + ": configure task failed to schedule, inapplicable target repository state")).build();
                }
                return Response.ok().entity((Object)("Git/SVN mirror configure task completed for '" + string + "/" + string2 + "' repository")).build();
            }
        }
        catch (SgException sgException) {
            return Response.serverError().entity((Object)(string + "/" + string2 + ": configure task failed: " + sgException.getMessage())).build();
        }
        return Response.ok().entity((Object)("Git/SVN mirror configure task scheduled for '" + string + "/" + string2 + "' repository")).build();
    }

    @AnonymousSiteAccess
    @GET
    @Path(value="projects/{projectKey}/repos/{repositorySlug}/status")
    @Produces(value={"application/json"})
    public Response status(@PathParam(value="projectKey") String string, @PathParam(value="repositorySlug") String string2) {
        this.log.info("REST status request received: " + string + "/" + string2);
        SgMirrorScope sgMirrorScope = this.getScope(string, string2);
        if (sgMirrorScope == null) {
            return Response.status((int)404).build();
        }
        try {
            SgTaskSchedulerSnapshot sgTaskSchedulerSnapshot = this.obtainSnapshot(sgMirrorScope);
            if (sgTaskSchedulerSnapshot == null) {
                return Response.status((int)404).build();
            }
            StringWriter stringWriter = new StringWriter();
            this.jsonService.write(sgTaskSchedulerSnapshot, sgMirrorScope, stringWriter);
            return Response.ok().entity((Object)stringWriter.toString()).build();
        }
        catch (IOException | SgException exception) {
            this.log.error(exception.getMessage(), (Throwable)exception);
            return Response.status((int)500).entity((Object)exception.getMessage()).build();
        }
    }

    @AnonymousSiteAccess
    @GET
    @Path(value="projects/{projectKey}/status")
    @Produces(value={"application/json"})
    public Response status(@PathParam(value="projectKey") String string) {
        this.log.info("REST status request received: " + string);
        SgMirrorScope sgMirrorScope = this.getScope(string, null);
        if (sgMirrorScope == null) {
            return Response.status((int)404).build();
        }
        try {
            SgTaskSchedulerSnapshot sgTaskSchedulerSnapshot = this.obtainSnapshot(sgMirrorScope);
            if (sgTaskSchedulerSnapshot == null) {
                return Response.status((int)404).build();
            }
            StringWriter stringWriter = new StringWriter();
            this.jsonService.write(sgTaskSchedulerSnapshot, sgMirrorScope, stringWriter);
            return Response.ok().entity((Object)stringWriter.toString()).build();
        }
        catch (IOException | SgException exception) {
            this.log.error(exception.getMessage(), (Throwable)exception);
            return Response.status((int)500).entity((Object)exception.getMessage()).build();
        }
    }

    @AnonymousSiteAccess
    @GET
    @Path(value="status")
    @Produces(value={"application/json"})
    public Response status() {
        this.log.info("REST status request received");
        SgMirrorScope sgMirrorScope = SgMirrorScope.global();
        if (sgMirrorScope == null) {
            return Response.status((int)404).build();
        }
        try {
            SgTaskSchedulerSnapshot sgTaskSchedulerSnapshot = this.obtainSnapshot(sgMirrorScope);
            if (sgTaskSchedulerSnapshot == null) {
                return Response.status((int)404).build();
            }
            StringWriter stringWriter = new StringWriter();
            this.jsonService.write(sgTaskSchedulerSnapshot, sgMirrorScope, stringWriter);
            return Response.ok().entity((Object)stringWriter.toString()).build();
        }
        catch (IOException | SgException exception) {
            this.log.error(exception.getMessage(), (Throwable)exception);
            return Response.status((int)500).entity((Object)exception.getMessage()).build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SgTaskSchedulerSnapshot obtainSnapshot(SgMirrorScope sgMirrorScope) {
        ISgTaskScheduler iSgTaskScheduler = this.taskSchedulerService.getScheduler();
        try {
            BlockingQueue blockingQueue = iSgTaskScheduler.obtainQueue(sgMirrorScope);
            SgTaskSchedulerSnapshot sgTaskSchedulerSnapshot = (SgTaskSchedulerSnapshot)blockingQueue.poll(10L, TimeUnit.SECONDS);
            return sgTaskSchedulerSnapshot;
        }
        catch (InterruptedException | SgException exception) {
        }
        finally {
            iSgTaskScheduler.releaseQueue(sgMirrorScope);
        }
        return null;
    }

    @AnonymousSiteAccess
    @POST
    @Path(value="config")
    @Produces(value={"application/json"})
    public Response setGlobalOption(@QueryParam(value="name") String string, @QueryParam(value="value") String string2, InputStream inputStream) {
        try {
            return this.setOption(null, null, string, SgMirrorRestService.asStringValue(string2, inputStream));
        }
        catch (IOException iOException) {
            this.log.info(iOException.getMessage(), (Throwable)iOException);
            return Response.serverError().entity(Collections.singletonMap("error", iOException.getMessage())).build();
        }
    }

    @AnonymousSiteAccess
    @POST
    @Path(value="projects/{projectKey}/config")
    @Produces(value={"application/json"})
    public Response setProjectOption(@PathParam(value="projectKey") String string, @QueryParam(value="name") String string2, @QueryParam(value="value") String string3, InputStream inputStream) {
        try {
            return this.setOption(string, null, string2, SgMirrorRestService.asStringValue(string3, inputStream));
        }
        catch (IOException iOException) {
            this.log.info(iOException.getMessage(), (Throwable)iOException);
            return Response.serverError().entity(Collections.singletonMap("error", iOException.getMessage())).build();
        }
    }

    @AnonymousSiteAccess
    @POST
    @Path(value="projects/{projectKey}/repos/{repositorySlug}/config")
    @Produces(value={"application/json"})
    public Response setRepositoryOption(@PathParam(value="projectKey") String string, @PathParam(value="repositorySlug") String string2, @QueryParam(value="name") String string3, @QueryParam(value="value") String string4, InputStream inputStream) {
        try {
            return this.setOption(string, string2, string3, SgMirrorRestService.asStringValue(string4, inputStream));
        }
        catch (IOException iOException) {
            this.log.info(iOException.getMessage(), (Throwable)iOException);
            return Response.serverError().entity(Collections.singletonMap("error", iOException.getMessage())).build();
        }
    }

    @AnonymousSiteAccess
    @GET
    @Path(value="cluster")
    @Produces(value={"application/json"})
    public Response clusterStatus() {
        this.log.info("REST cluster status request received");
        SgMirrorScope sgMirrorScope = SgMirrorScope.global();
        if (sgMirrorScope == null) {
            return Response.status((int)404).build();
        }
        try {
            SgClusterStatus sgClusterStatus = this.taskSchedulerService.getClusterStatus();
            if (sgClusterStatus == null) {
                return Response.status((int)404).build();
            }
            StringWriter stringWriter = new StringWriter();
            this.jsonService.write(sgClusterStatus, SgMirrorScope.global(), stringWriter);
            return Response.ok().entity((Object)stringWriter.toString()).build();
        }
        catch (IOException iOException) {
            this.log.error(iOException.getMessage(), (Throwable)iOException);
            return Response.serverError().entity(Collections.singletonMap("error", iOException.getMessage())).build();
        }
    }

    private Response setOption(String string, String string2, String string3, String string4) {
        if (string3 == null || string3.isEmpty()) {
            return Response.serverError().build();
        }
        for (SgSetting sgSetting : SgMirrorOption.all()) {
            Object object;
            if (!sgSetting.getConfigKey().equals(string3)) continue;
            if (SgMirrorOption.isSynthetic(sgSetting)) {
                return Response.serverError().build();
            }
            Class clazz = sgSetting.getType();
            try {
                object = this.jsonService.getGson().fromJson(string4, clazz);
            }
            catch (Throwable throwable) {
                this.log.info(throwable.getMessage(), throwable);
                return Response.serverError().entity(Collections.singletonMap("error", throwable.getMessage())).build();
            }
            try {
                return (Response)this.securityService.withPermission(Permission.REPO_ADMIN, "REST command").call(() -> this.scheduleCommand(string, string2, "apply-rest", new SgSingleSettingParameter(sgSetting, object)));
            }
            catch (Throwable throwable) {
                this.log.info(throwable.getMessage(), throwable);
                return Response.serverError().entity(Collections.singletonMap("error", throwable.getMessage())).build();
            }
        }
        return Response.status((int)404).entity(Collections.singletonMap("error", "no such configuration option: " + string3)).build();
    }

    private Response scheduleCommand(SgSvnSyncInfo sgSvnSyncInfo, String string) {
        Page page;
        PageRequestImpl pageRequestImpl = new PageRequestImpl(0, 10);
        int n2 = 0;
        do {
            page = this.repositoryService.findAll((PageRequest)pageRequestImpl);
            for (Repository repository : page.getValues()) {
                boolean bl2;
                SgMirrorScope sgMirrorScope = SgMirrorScope.forRepository(repository);
                try {
                    bl2 = this.mirrorService.shouldSync(repository, sgSvnSyncInfo);
                }
                catch (Throwable throwable) {
                    this.log.info(throwable.getMessage(), throwable);
                    String string2 = this.mirrorService.getGitRepositoryKey(repository).a();
                    this.log.info("An error occurred while trying to figure out sync-info applicability, not synchronizing repository \"" + string2 + "\"");
                    bl2 = false;
                }
                if (bl2) {
                    try {
                        this.log.info("scheduling '" + string + "' for [" + String.valueOf(sgMirrorScope) + "]");
                        ISgTask iSgTask = this.taskSchedulerService.getScheduler().schedule(sgMirrorScope, string, null);
                        if (iSgTask == null || iSgTask.getState() == SgTaskState.REJECTED) {
                            this.log.info("'" + string + "' rejected for [" + String.valueOf(sgMirrorScope) + "]");
                        } else {
                            this.log.info("'" + string + "' scheduled for [" + String.valueOf(sgMirrorScope) + "]");
                        }
                        ++n2;
                    }
                    catch (SgException sgException) {
                        this.log.error(sgException.getMessage(), (Throwable)sgException);
                    }
                    continue;
                }
                this.log.info("[" + String.valueOf(sgMirrorScope) + "] SVN uuid or modified paths are not synced by this repository");
            }
        } while ((pageRequestImpl = page.getIsLastPage() ? null : page.getNextPageRequest()) != null);
        if (n2 == 0) {
            return Response.noContent().build();
        }
        return Response.ok().build();
    }

    private SgMirrorScope getScope(String string, String string2) {
        SgMirrorScope sgMirrorScope;
        if (string != null && string2 != null) {
            Repository repository = this.repositoryService.getBySlug(string, string2);
            if (repository == null) {
                return null;
            }
            sgMirrorScope = SgMirrorScope.forRepository(repository);
        } else if (string != null) {
            Project project = this.projectService.getByKey(string);
            if (project == null) {
                return null;
            }
            sgMirrorScope = SgMirrorScope.forProject(project);
        } else {
            sgMirrorScope = SgMirrorScope.global();
        }
        return sgMirrorScope;
    }

    private Response scheduleCommand(String string, String string2, String string3, Serializable serializable) {
        SgMirrorScope sgMirrorScope = this.getScope(string, string2);
        if (sgMirrorScope == null) {
            return Response.status((int)404).build();
        }
        try {
            ISgTask iSgTask = this.taskSchedulerService.getScheduler().schedule(sgMirrorScope, string3, serializable);
            if (iSgTask == null || iSgTask.getState() == SgTaskState.REJECTED) {
                return Response.serverError().build();
            }
        }
        catch (SgException sgException) {
            return Response.serverError().build();
        }
        return Response.ok().build();
    }

    private static String asStringValue(String string, InputStream inputStream) {
        String string2 = string != null && !"".equals(string.trim()) ? string : (string = inputStream != null ? IOUtils.toString(inputStream, StandardCharsets.UTF_8) : "");
        if ("".equals(string.trim())) {
            string = "null";
        }
        return string;
    }
}

