/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.subgit.stash.mirror.rest;

import com.a.a.a.b.k;
import com.a.a.a.d.a;
import com.google.gson.Gson;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.lib.Config;
import org.tmatesoft.subgit.stash.mirror.SgAuthorsService;
import org.tmatesoft.subgit.stash.mirror.SgException;
import org.tmatesoft.subgit.stash.mirror.SgMirrorOption;
import org.tmatesoft.subgit.stash.mirror.json.SgJsonService;
import org.tmatesoft.subgit.stash.mirror.rest.SgConfigureInfo$CredentialsInfo;
import org.tmatesoft.subgit.stash.mirror.rest.SgConfigureInfo$LayoutInfo;
import org.tmatesoft.subgit.stash.mirror.settings.SgMapSettings;
import org.tmatesoft.subgit.stash.mirror.settings.SgSetting;
import org.tmatesoft.subgit.stash.mirror.settings.SgSettings;
import org.tmatesoft.subgit.stash.mirror.util.SgLayoutType;

@XmlRootElement
public class SgConfigureInfo {
    @XmlElement(required=true)
    private String url;
    @XmlElement(required=true)
    private SgConfigureInfo$CredentialsInfo credentials;
    @XmlElement(required=true)
    private SgConfigureInfo$LayoutInfo layout;
    @XmlElement
    private Map config;
    @XmlElement
    private Map authors;
    @XmlElement
    private String defaultDomain;

    public SgSettings toSettings(SgAuthorsService sgAuthorsService, SgJsonService sgJsonService) {
        Object object;
        Object object2;
        Object object3;
        SgMapSettings sgMapSettings = new SgMapSettings(SgMirrorOption.USER, null);
        if (this.url == null) {
            throw new SgException("SVN URL is required for 'configure' end-point.");
        }
        sgMapSettings.set(SgMirrorOption.SVN_URL, this.url);
        if (this.credentials == null) {
            throw new SgException("SVN credentials are required for 'configure' end-point.");
        }
        sgMapSettings.set(SgMirrorOption.CREDENTIALS, this.credentials.toCredentials());
        if (this.defaultDomain == null) {
            this.defaultDomain = sgAuthorsService.findDefaultDomain();
        }
        sgMapSettings.set(SgMirrorOption.CORE_DEFAULT_DOMAIN, this.defaultDomain);
        sgMapSettings.set(SgMirrorOption.LAYOUT_TYPE, (Object)this.layout.type);
        if (this.layout == null) {
            this.layout = new SgConfigureInfo$LayoutInfo();
            this.layout.type = SgLayoutType.AUTO;
            this.layout.trunkPath = "trunk";
        }
        if (this.layout.type == SgLayoutType.AUTO) {
            sgMapSettings.set(SgMirrorOption.TRUNK_PATH, this.layout.trunkPath != null ? this.layout.trunkPath : "trunk");
        } else if (this.layout.type == SgLayoutType.MANUAL) {
            if (this.layout.trunk != null) {
                this.validateBinding(this.layout.trunk);
                sgMapSettings.set(SgMirrorOption.TRUNK_BINDING, this.layout.trunk);
            }
            if (this.layout.branches != null) {
                this.validateBindings(this.layout.branches);
                sgMapSettings.set(SgMirrorOption.BRANCHES_BINDINGS, this.layout.branches.toArray(new String[0]));
            }
            if (this.layout.tags != null) {
                this.validateBindings(this.layout.tags);
                sgMapSettings.set(SgMirrorOption.TAGS_BINDINGS, this.layout.tags.toArray(new String[0]));
            }
            if (this.layout.shelves != null) {
                this.validateBindings(this.layout.shelves);
                sgMapSettings.set(SgMirrorOption.SHELVES_BINDINGS, this.layout.shelves.toArray(new String[0]));
            }
            if (this.layout.excludeBranches != null) {
                sgMapSettings.set(SgMirrorOption.EXCLUDE_BRANCHES, this.layout.excludeBranches.toArray(new String[0]));
            }
            if (this.layout.excludePaths != null) {
                sgMapSettings.set(SgMirrorOption.EXCLUDE_PATHS, this.layout.excludePaths.toArray(new String[0]));
            }
            if (this.layout.includePaths != null) {
                sgMapSettings.set(SgMirrorOption.INCLUDE_PATHS, this.layout.includePaths.toArray(new String[0]));
            }
        }
        if (this.authors != null && !this.authors.isEmpty()) {
            object3 = new StringBuilder();
            for (Object object4 : this.authors.keySet()) {
                Object object5 = (List)this.authors.get(object4);
                if (object5 == null || object5.size() < 1) continue;
                object2 = (String)object5.get(0);
                object = object5.size() > 1 ? (String)object5.get(1) : ((String)object4).replaceAll("\\s+", ".") + "@" + this.defaultDomain;
                ((StringBuilder)object3).append((String)object4);
                ((StringBuilder)object3).append(" = ");
                ((StringBuilder)object3).append((String)object2);
                ((StringBuilder)object3).append(" <");
                ((StringBuilder)object3).append((String)object);
                ((StringBuilder)object3).append(">\n");
            }
            sgMapSettings.set(SgMirrorOption.USER_AUTHORS, ((StringBuilder)object3).toString());
        }
        if (this.config != null && !this.config.isEmpty()) {
            object3 = sgJsonService.getGson();
            Config config = new Config();
            for (Object object5 : this.config.keySet()) {
                Object object6;
                String string;
                object2 = this.config.get(object5);
                object = SgMirrorOption.byKey((String)object5);
                if (object == null && object2 != null && ((String)object5).indexOf(46) > 0 && ((String)object5).indexOf(46) < ((String)object5).length() - 1) {
                    string = ((String)object5).substring(0, ((String)object5).indexOf(46));
                    object6 = ((String)object5).substring(string.length() + 1);
                    config.setString(string, null, (String)object6, object2.toString());
                    continue;
                }
                if (object2 == null) {
                    sgMapSettings.set((SgSetting)object, null);
                    continue;
                }
                if (object == null) continue;
                string = ((Gson)object3).toJson(object2);
                object6 = new Gson().fromJson(string, ((SgSetting)object).getType());
                sgMapSettings.set((SgSetting)object, object6);
            }
            if (!config.getSections().isEmpty()) {
                sgMapSettings.set(SgMirrorOption.CONFIG, config.toText());
            }
        }
        return sgMapSettings;
    }

    private void validateBindings(List list) {
        if (list != null) {
            for (String string : list) {
                this.validateBinding(string);
            }
        }
    }

    private void validateBinding(String string) {
        try {
            new a(string).d();
        }
        catch (k k2) {
            throw SgException.wrap(k2);
        }
    }

    public String toString() {
        return "SgConfigureInfo{url='" + this.url + "', credentials=" + String.valueOf(this.credentials) + ", layout=" + String.valueOf(this.layout) + ", config=" + String.valueOf(this.config) + ", authors=" + String.valueOf(this.authors) + ", defaultDomain='" + this.defaultDomain + "'}";
    }
}

