/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.subgit.stash.mirror.rest;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.File;
import java.nio.charset.StandardCharsets;
import org.tmatesoft.subgit.stash.mirror.SgCredentials;
import org.tmatesoft.subgit.stash.mirror.SgCredentials$Builder;
import org.tmatesoft.subgit.stash.mirror.SgCredentials$Type;

@XmlRootElement
public class SgConfigureInfo$CredentialsInfo {
    @XmlElement(required=true, type=SgCredentials$Type.class, defaultValue="SIMPLE")
    private SgCredentials$Type type;
    @XmlElement
    private String username;
    @XmlElement
    private String password;
    @XmlElement
    private String sshPrivateKey;
    @XmlElement
    private String sslPrivateCert;
    @XmlElement
    private String passphrase;
    @XmlElement
    private String cachePath;
    @XmlElement(required=true, defaultValue="false")
    private boolean useCache;

    public SgCredentials toCredentials() {
        SgCredentials$Builder sgCredentials$Builder = SgCredentials.builder();
        sgCredentials$Builder.setType(this.type);
        if (this.username != null) {
            sgCredentials$Builder.setUserName(this.username);
        }
        if (this.password != null) {
            sgCredentials$Builder.setPassword(this.password.toCharArray());
            sgCredentials$Builder.setSslPassword(this.password.toCharArray());
        }
        if (this.passphrase != null) {
            sgCredentials$Builder.setPassphrase(this.passphrase.toCharArray());
        }
        sgCredentials$Builder.setUseCache(this.useCache);
        if (this.cachePath != null) {
            sgCredentials$Builder.setCachePath(new File(this.cachePath));
        }
        if (this.sshPrivateKey != null) {
            sgCredentials$Builder.setSshKeyValue(this.sshPrivateKey.getBytes(StandardCharsets.UTF_8));
        }
        if (this.sslPrivateCert != null) {
            sgCredentials$Builder.setSslCertValue(this.sslPrivateCert.getBytes(StandardCharsets.UTF_8));
        }
        return sgCredentials$Builder.build();
    }

    public String toString() {
        return "CredentialsInfo{type=" + String.valueOf((Object)this.type) + ", cachePath='" + this.cachePath + "', useCache=" + this.useCache + "}";
    }
}

