/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.subgit.stash.mirror.json;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.nio.charset.StandardCharsets;
import java.util.BitSet;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.net.URLCodec;

public class SgJsonStringEncodingAdapter
extends TypeAdapter {
    private final BitSet safeCharacters = this.initUriSafeChars();

    protected BitSet initUriSafeChars() {
        BitSet bitSet = new BitSet(256);
        bitSet.set(97, 123, true);
        bitSet.set(65, 91, true);
        bitSet.set(48, 58, true);
        bitSet.set(45);
        bitSet.set(95);
        bitSet.set(46);
        bitSet.set(42);
        return bitSet;
    }

    public void write(JsonWriter jsonWriter, String string) {
        if (string == null) {
            jsonWriter.nullValue();
            return;
        }
        byte[] byArray = string.getBytes(StandardCharsets.UTF_8);
        byte[] byArray2 = URLCodec.encodeUrl((BitSet)this.safeCharacters, (byte[])byArray);
        jsonWriter.value(new String(byArray2, StandardCharsets.UTF_8));
    }

    @Override
    public String read(JsonReader jsonReader) {
        byte[] byArray;
        if (jsonReader.peek() == JsonToken.NULL) {
            jsonReader.nextNull();
            return null;
        }
        String string = jsonReader.nextString();
        byte[] byArray2 = string.getBytes(StandardCharsets.UTF_8);
        try {
            byArray = URLCodec.decodeUrl((byte[])byArray2);
        }
        catch (DecoderException decoderException) {
            return string;
        }
        return new String(byArray, StandardCharsets.UTF_8);
    }
}

