/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.subgit.stash.mirror.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.internal.bind.JsonTreeWriter;
import com.google.gson.stream.JsonReader;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.output.NullWriter;
import org.slf4j.Logger;
import org.tmatesoft.subgit.stash.mirror.json.ISgJsonAdapterFactoryService;
import org.tmatesoft.subgit.stash.mirror.json.SgJsonAdapterFactory;
import org.tmatesoft.subgit.stash.mirror.json.SgJsonEncryptionAdapterFactory;
import org.tmatesoft.subgit.stash.mirror.json.SgJsonSecureReader;
import org.tmatesoft.subgit.stash.mirror.json.SgJsonSecureStorage;
import org.tmatesoft.subgit.stash.mirror.json.SgJsonSecureWriter;
import org.tmatesoft.subgit.stash.mirror.util.ISgCleanable;
import org.tmatesoft.subgit.stash.mirror.util.SgLoggerFactory;

public class SgJsonService
implements ISgCleanable {
    private static final long SESSION_TTL = 10000L;
    private static final JsonPrimitive DELETE_NODE_MARKER = new JsonPrimitive(new BigDecimal("2E+2048"));
    private final Gson gson;
    private final Gson encryptedGson;
    private final Map sessions;
    private final Map users;
    private final Map releaseTime;
    private final Logger log;

    public SgJsonService(SgLoggerFactory sgLoggerFactory, ISgJsonAdapterFactoryService iSgJsonAdapterFactoryService) {
        this.log = sgLoggerFactory != null ? sgLoggerFactory.getLogger("json") : null;
        Set set = iSgJsonAdapterFactoryService.getTypeAdapterFactories();
        this.gson = SgJsonService.createGson(new SgJsonAdapterFactory(), set);
        this.encryptedGson = SgJsonService.createGson(new SgJsonEncryptionAdapterFactory(), set);
        this.sessions = new HashMap();
        this.users = new HashMap();
        this.releaseTime = new HashMap();
    }

    public Gson getGson() {
        return this.gson;
    }

    public Gson getEncryptedGson() {
        return this.encryptedGson;
    }

    private static Gson createGson(TypeAdapterFactory typeAdapterFactory, Set set) {
        GsonBuilder gsonBuilder = new GsonBuilder().serializeNulls().registerTypeAdapterFactory(typeAdapterFactory);
        for (TypeAdapterFactory typeAdapterFactory2 : set) {
            gsonBuilder.registerTypeAdapterFactory(typeAdapterFactory2);
        }
        return gsonBuilder.create();
    }

    public synchronized SgJsonSecureStorage openSession(Object object) {
        if (!this.sessions.containsKey(object)) {
            this.sessions.put(object, new SgJsonSecureStorage());
        }
        this.users.put(object, this.users.containsKey(object) ? (Integer)this.users.get(object) + 1 : 1);
        return (SgJsonSecureStorage)this.sessions.get(object);
    }

    public synchronized SgJsonSecureStorage getStorage(Object object) {
        SgJsonSecureStorage sgJsonSecureStorage = (SgJsonSecureStorage)this.sessions.get(object);
        if (sgJsonSecureStorage != null) {
            return sgJsonSecureStorage;
        }
        return this.openSession(object);
    }

    public synchronized void releaseSession(Object object) {
        if (this.users.containsKey(object) && (Integer)this.users.get(object) > 0) {
            this.users.put(object, (Integer)this.users.get(object) - 1);
        } else {
            this.users.put(object, 0);
        }
        this.releaseTime.put(object, System.currentTimeMillis());
    }

    @Override
    public synchronized void cleanup() {
        HashSet hashSet = new HashSet(this.releaseTime.keySet());
        long l2 = System.currentTimeMillis();
        for (Object e2 : hashSet) {
            if (this.users.containsKey(e2) && (Integer)this.users.get(e2) != 0 || l2 - (Long)this.releaseTime.get(e2) <= 10000L) continue;
            this.users.remove(e2);
            this.sessions.remove(e2);
            this.releaseTime.remove(e2);
            this.log.info("session data removed for [" + String.valueOf(e2) + "]");
        }
    }

    public void write(Object object, Object object2, Writer writer) {
        if (object == null) {
            writer.write("null");
            return;
        }
        SgJsonSecureStorage sgJsonSecureStorage = this.getStorage(object2);
        SgJsonSecureWriter sgJsonSecureWriter = new SgJsonSecureWriter(writer, sgJsonSecureStorage);
        this.gson.toJson(object, object.getClass(), sgJsonSecureWriter);
        sgJsonSecureWriter.flush();
    }

    public Object read(Reader reader, Object object, Class clazz) {
        SgJsonSecureStorage sgJsonSecureStorage = this.getStorage(object);
        return this.gson.fromJson((JsonReader)new SgJsonSecureReader(reader, sgJsonSecureStorage), (Type)clazz);
    }

    public JsonElement writeDiff(JsonElement jsonElement, Object object, Object object2, Map map, Writer writer) {
        Object object3;
        JsonElement jsonElement2 = this.writeToTree(object, object2);
        if (map != null && jsonElement2.isJsonObject()) {
            object3 = map.entrySet().iterator();
            while (object3.hasNext()) {
                Map.Entry entry = (Map.Entry)object3.next();
                if (entry.getValue() == null) continue;
                JsonElement jsonElement3 = this.gson.toJsonTree(entry.getValue(), entry.getValue().getClass());
                jsonElement2.getAsJsonObject().add((String)entry.getKey(), jsonElement3);
            }
        }
        Object object4 = object3 = jsonElement != null ? this.computeDiff(jsonElement2, jsonElement) : jsonElement2;
        if (object3 != null) {
            this.gson.toJson((JsonElement)object3, (Appendable)writer);
        }
        return jsonElement2;
    }

    private JsonElement computeDiff(JsonElement jsonElement, JsonElement jsonElement2) {
        if (jsonElement.getClass() != jsonElement2.getClass()) {
            return jsonElement;
        }
        if (jsonElement.isJsonPrimitive()) {
            JsonPrimitive jsonPrimitive = jsonElement.getAsJsonPrimitive();
            JsonPrimitive jsonPrimitive2 = jsonElement.getAsJsonPrimitive();
            if (jsonPrimitive.isBoolean() != jsonPrimitive2.isBoolean() || jsonPrimitive.isNumber() != jsonPrimitive2.isNumber() || jsonPrimitive.isString() != jsonPrimitive2.isString()) {
                return jsonElement;
            }
            return !jsonElement.getAsString().equals(jsonElement2.getAsString()) ? jsonElement : null;
        }
        if (jsonElement.isJsonObject()) {
            String string;
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            JsonObject jsonObject2 = jsonElement2.getAsJsonObject();
            HashSet hashSet = new HashSet(jsonObject.entrySet());
            Set set = jsonObject2.entrySet();
            JsonObject jsonObject3 = new JsonObject();
            for (Map.Entry entry : set) {
                string = (String)entry.getKey();
                if (jsonObject.has(string)) continue;
                jsonObject3.add(string, DELETE_NODE_MARKER);
            }
            for (Map.Entry entry : hashSet) {
                string = (String)entry.getKey();
                JsonElement jsonElement3 = (JsonElement)entry.getValue();
                if (!jsonObject2.has(string)) {
                    jsonObject3.add(string, jsonElement3);
                    continue;
                }
                JsonElement jsonElement4 = this.computeDiff(jsonElement3, jsonObject2.get(string));
                if (jsonElement4 == null) continue;
                jsonObject3.add(string, jsonElement4);
            }
            return !jsonObject3.entrySet().isEmpty() ? jsonObject3 : null;
        }
        if (jsonElement.isJsonArray()) {
            JsonArray jsonArray = jsonElement.getAsJsonArray();
            JsonArray jsonArray2 = jsonElement2.getAsJsonArray();
            if (jsonArray.size() != jsonArray2.size()) {
                return jsonArray;
            }
            for (int i2 = 0; i2 < jsonArray.size(); ++i2) {
                if (this.computeDiff(jsonArray.get(i2), jsonArray2.get(i2)) == null) continue;
                return jsonArray;
            }
        }
        return null;
    }

    private JsonElement writeToTree(Object object, Object object2) {
        SgJsonSecureStorage sgJsonSecureStorage = this.getStorage(object2);
        SgJsonSecureWriter sgJsonSecureWriter = new SgJsonSecureWriter(new NullWriter(), sgJsonSecureStorage, new JsonTreeWriter());
        this.gson.toJson(object, object.getClass(), sgJsonSecureWriter);
        return sgJsonSecureWriter.getTree();
    }
}

