/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.subgit.stash.mirror.json;

import com.google.gson.JsonElement;
import com.google.gson.internal.bind.JsonTreeWriter;
import com.google.gson.stream.JsonWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.tmatesoft.subgit.stash.mirror.json.SgJsonSecureStorage;

public class SgJsonSecureWriter
extends JsonWriter {
    private final SgJsonSecureStorage storage;
    private final JsonTreeWriter tree;

    public SgJsonSecureWriter(Writer writer, SgJsonSecureStorage sgJsonSecureStorage) {
        this(writer, sgJsonSecureStorage, null);
    }

    public SgJsonSecureWriter(Writer writer, SgJsonSecureStorage sgJsonSecureStorage, JsonTreeWriter jsonTreeWriter) {
        super(writer);
        this.storage = sgJsonSecureStorage;
        this.tree = jsonTreeWriter;
    }

    public JsonElement getTree() {
        return this.tree != null ? this.tree.get() : null;
    }

    public SgJsonSecureStorage getStorage() {
        return this.storage;
    }

    @Override
    public JsonWriter beginArray() {
        super.beginArray();
        if (this.tree != null) {
            this.tree.beginArray();
        }
        return this;
    }

    @Override
    public JsonWriter endArray() {
        super.endArray();
        if (this.tree != null) {
            this.tree.endArray();
        }
        return this;
    }

    @Override
    public JsonWriter beginObject() {
        super.beginObject();
        if (this.tree != null) {
            this.tree.beginObject();
        }
        return this;
    }

    @Override
    public JsonWriter endObject() {
        super.endObject();
        if (this.tree != null) {
            this.tree.endObject();
        }
        return this;
    }

    @Override
    public JsonWriter name(String string) {
        super.name(string);
        if (this.tree != null) {
            this.tree.name(string);
        }
        return this;
    }

    @Override
    public JsonWriter value(String string) {
        super.value(string);
        if (this.tree != null && string != null) {
            this.tree.value(string);
        }
        return this;
    }

    @Override
    public JsonWriter nullValue() {
        super.nullValue();
        if (this.tree != null) {
            this.tree.nullValue();
        }
        return this;
    }

    @Override
    public JsonWriter value(boolean bl2) {
        super.value(bl2);
        if (this.tree != null) {
            this.tree.value(bl2);
        }
        return this;
    }

    @Override
    public JsonWriter value(double d2) {
        super.value(d2);
        if (this.tree != null) {
            this.tree.value(d2);
        }
        return this;
    }

    @Override
    public JsonWriter value(long l2) {
        super.value(l2);
        if (this.tree != null) {
            this.tree.value(l2);
        }
        return this;
    }

    @Override
    public JsonWriter value(Number number) {
        super.value(number);
        if (this.tree != null && number != null) {
            this.tree.value(number);
        }
        return this;
    }

    @Override
    public JsonWriter jsonValue(String string) {
        if (string == null) {
            return this.nullValue();
        }
        try {
            Method method = this.getClass().getMethod("writeDeferredName", new Class[0]);
            method.setAccessible(true);
            method.invoke((Object)this, new Object[0]);
            Method method2 = this.getClass().getMethod("beforeValue", new Class[0]);
            method2.setAccessible(true);
            method2.invoke((Object)this, new Object[0]);
            Field field = this.getClass().getField("out");
            field.setAccessible(true);
            Object object = field.get(this);
            if (object instanceof Writer) {
                ((Writer)object).append(string);
            }
            if (this.tree != null) {
                Method method3 = this.tree.getClass().getMethod("jsonValue", String.class);
                method3.invoke((Object)this.tree, string);
            }
        }
        catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
        return this;
    }

    @Override
    public JsonWriter value(Boolean bl2) {
        if (bl2 == null) {
            return this.nullValue();
        }
        return this.value((boolean)bl2);
    }

    @Override
    public void flush() {
        super.flush();
        if (this.tree != null) {
            this.tree.flush();
        }
    }

    @Override
    public void close() {
        super.close();
        if (this.tree != null) {
            this.tree.close();
        }
    }
}

