/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.subgit.stash.mirror.cmdline;

import com.a.a.a.a.p;
import com.a.a.a.b.j;
import com.a.a.a.c.c;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.CommandErrorHandler;
import com.atlassian.bitbucket.scm.CommandExitHandler;
import com.atlassian.bitbucket.scm.CommandFailedException;
import com.atlassian.bitbucket.scm.CommandInputHandler;
import com.atlassian.bitbucket.scm.CommandOutputHandler;
import com.atlassian.bitbucket.scm.git.command.GitCommand;
import com.atlassian.bitbucket.scm.git.command.GitCommandBuilderFactory;
import com.atlassian.bitbucket.scm.git.command.GitScmCommandBuilder;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tmatesoft.subgit.stash.mirror.cmdline.SgCommandInputHandler;
import org.tmatesoft.subgit.stash.mirror.cmdline.SgCommandOutputHandler;
import org.tmatesoft.subgit.stash.mirror.cmdline.SgCommandSmallOutputHandler;
import org.tmatesoft.subgit.stash.mirror.cmdline.SgGitCommandRunner$ExitHandler;

public class SgGitCommandRunner
implements p {
    public static final String GIT_ALTERNATE_OBJECT_DIRECTORIES = "GIT_ALTERNATE_OBJECT_DIRECTORIES";
    public static final String GIT_DIR = "GIT_DIR";
    private final GitCommandBuilderFactory gitCommandBuilderFactory;
    private final File[] alternates;
    private final Repository bitbucketRepository;
    private final String repositoryId;
    private File gitDirectory;
    private final Logger log = LoggerFactory.getLogger((String)"command.runner");
    private final Logger rootLog = LoggerFactory.getLogger((String)"sg.command");

    public SgGitCommandRunner(GitCommandBuilderFactory gitCommandBuilderFactory, Repository repository, File[] fileArray) {
        this.gitCommandBuilderFactory = gitCommandBuilderFactory;
        this.bitbucketRepository = repository;
        this.alternates = fileArray;
        this.repositoryId = "R_" + repository.getProject().getId() + "_" + repository.getId();
    }

    public void setGitDirectory(File file) {
        this.gitDirectory = file;
    }

    @Override
    public boolean supportsSymbolicRefs() {
        return false;
    }

    @Override
    public p newInstanceWithAlternates(File[] fileArray) {
        if (fileArray == null || fileArray.length == 0) {
            return this;
        }
        if (this.alternates == null || this.alternates.length == 0) {
            SgGitCommandRunner sgGitCommandRunner = new SgGitCommandRunner(this.gitCommandBuilderFactory, this.bitbucketRepository, fileArray);
            if (this.gitDirectory != null) {
                sgGitCommandRunner.setGitDirectory(this.gitDirectory);
            }
            return sgGitCommandRunner;
        }
        File[] fileArray2 = new File[this.alternates.length + fileArray.length];
        System.arraycopy(this.alternates, 0, fileArray2, 0, this.alternates.length);
        System.arraycopy(fileArray, 0, fileArray2, this.alternates.length, fileArray.length);
        SgGitCommandRunner sgGitCommandRunner = new SgGitCommandRunner(this.gitCommandBuilderFactory, this.bitbucketRepository, fileArray2);
        if (this.gitDirectory != null) {
            sgGitCommandRunner.setGitDirectory(this.gitDirectory);
        }
        return sgGitCommandRunner;
    }

    @Override
    @NotNull
    public byte[] runGitCommand(@NotNull List list, @Nullable Map map, @Nullable InputStream inputStream) {
        assert (!list.isEmpty());
        GitScmCommandBuilder gitScmCommandBuilder = this.createScmCommandBuilder(list, map, inputStream);
        SgGitCommandRunner$ExitHandler sgGitCommandRunner$ExitHandler = new SgGitCommandRunner$ExitHandler();
        SgCommandSmallOutputHandler sgCommandSmallOutputHandler = new SgCommandSmallOutputHandler();
        gitScmCommandBuilder.exitHandler((CommandExitHandler)sgGitCommandRunner$ExitHandler);
        gitScmCommandBuilder.errorHandler((CommandErrorHandler)sgCommandSmallOutputHandler);
        GitCommand gitCommand = gitScmCommandBuilder.build((CommandOutputHandler)new SgCommandSmallOutputHandler());
        gitCommand.setExecutionTimeout(Integer.MAX_VALUE);
        gitCommand.setIdleTimeout(Integer.MAX_VALUE);
        this.log.info("about to execute command (not streamed) {}", (Object)String.join((CharSequence)" ", list));
        this.rootLog.info("[{}] about to execute command (not streamed) {}", (Object)this.repositoryId, (Object)String.join((CharSequence)" ", list));
        try {
            byte[] byArray = (byte[])c.a((byte[])gitCommand.call());
            int n2 = sgGitCommandRunner$ExitHandler.getExitCode();
            if (n2 != 0) {
                byte[] byArray2 = sgCommandSmallOutputHandler.getOutput();
                String string = byArray2 == null ? "stderr is empty" : new String(byArray2, StandardCharsets.UTF_8);
                this.log.info("command failed, code {}, stderr:\n{}", (Object)n2, (Object)string);
                this.rootLog.info("[{}] command failed, code {}, stderr:\n{}", new Object[]{this.repositoryId, n2, string});
                throw new j(n2, string);
            }
            return byArray;
        }
        catch (CommandFailedException commandFailedException) {
            byte[] byArray = sgCommandSmallOutputHandler.getOutput();
            String string = byArray == null ? "stderr is empty" : new String(byArray, StandardCharsets.UTF_8);
            this.log.info("command failed with exception, code {}, stderr:\n{}", (Object)sgGitCommandRunner$ExitHandler.getExitCode(), (Object)string);
            this.log.info(commandFailedException.getMessage(), (Throwable)commandFailedException);
            this.rootLog.info("[{}] command failed with exception, code {}, stderr:\n{}", new Object[]{this.repositoryId, sgGitCommandRunner$ExitHandler.getExitCode(), string});
            this.rootLog.info(String.format("[%s] %s", this.repositoryId, commandFailedException.getMessage()), (Throwable)commandFailedException);
            throw new j(sgGitCommandRunner$ExitHandler.getExitCode(), commandFailedException.getMessage() + "\nstderr:\n" + string, commandFailedException);
        }
    }

    @Override
    @NotNull
    public InputStream runGitCommandAsStream(@NotNull List list, @Nullable Map map, @Nullable InputStream inputStream) {
        assert (!list.isEmpty());
        GitScmCommandBuilder gitScmCommandBuilder = this.createScmCommandBuilder(list, map, inputStream);
        SgCommandOutputHandler sgCommandOutputHandler = new SgCommandOutputHandler();
        GitCommand gitCommand = gitScmCommandBuilder.build((CommandOutputHandler)sgCommandOutputHandler);
        gitCommand.setExecutionTimeout(Integer.MAX_VALUE);
        gitCommand.setIdleTimeout(Integer.MAX_VALUE);
        this.log.warn("about to execute (streamed): {}", (Object)String.join((CharSequence)" ", list));
        this.rootLog.info("[{}] about to execute command (streamed): {}", (Object)this.repositoryId, (Object)String.join((CharSequence)" ", list));
        gitCommand.asynchronous().start();
        return sgCommandOutputHandler.waitForCompletion();
    }

    @NotNull
    private GitScmCommandBuilder createScmCommandBuilder(@NotNull List list, @Nullable Map map, @Nullable InputStream inputStream) {
        GitScmCommandBuilder gitScmCommandBuilder = (GitScmCommandBuilder)this.gitCommandBuilderFactory.builder(this.bitbucketRepository).command((String)list.get(0));
        for (int i2 = 1; i2 < list.size(); ++i2) {
            gitScmCommandBuilder.argument((String)list.get(i2));
        }
        if (this.gitDirectory != null) {
            SgGitCommandRunner.addEnvironment(gitScmCommandBuilder, GIT_DIR, this.gitDirectory.getAbsolutePath());
        }
        if ((map = this.withAlternates(map)) != null) {
            for (Map.Entry entry : map.entrySet()) {
                SgGitCommandRunner.addEnvironment(gitScmCommandBuilder, (String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (inputStream != null) {
            SgCommandInputHandler sgCommandInputHandler = new SgCommandInputHandler(inputStream);
            sgCommandInputHandler.setLogger(this.log);
            gitScmCommandBuilder.inputHandler((CommandInputHandler)sgCommandInputHandler);
        }
        return gitScmCommandBuilder;
    }

    private Map withAlternates(Map map) {
        String string;
        if (this.alternates == null || this.alternates.length == 0) {
            return map;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (map != null) {
            hashMap.putAll(map);
            string = (String)map.get(GIT_ALTERNATE_OBJECT_DIRECTORIES);
            if (string == null) {
                string = "";
            }
        } else {
            string = "";
        }
        StringBuilder stringBuilder = new StringBuilder(string);
        for (File file : this.alternates) {
            stringBuilder.append(File.pathSeparator);
            stringBuilder.append(file.getAbsolutePath());
        }
        if (string.isEmpty()) {
            stringBuilder.deleteCharAt(0);
        }
        hashMap.put(GIT_ALTERNATE_OBJECT_DIRECTORIES, stringBuilder.toString());
        return hashMap;
    }

    private static void addEnvironment(GitScmCommandBuilder gitScmCommandBuilder, String string, String string2) {
        try {
            Method method = gitScmCommandBuilder.getClass().getDeclaredMethod("withEnvironment", String.class, String.class);
            method.invoke((Object)gitScmCommandBuilder, string, string2);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            try {
                Method method = gitScmCommandBuilder.getClass().getDeclaredMethod("environment", String.class, String.class);
                method.invoke((Object)gitScmCommandBuilder, string, string2);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException2) {
                // empty catch block
            }
        }
    }
}

