/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.subgit.stash.mirror;

import com.a.a.a.d.P;
import com.atlassian.bitbucket.ServiceException;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestSearchRequest;
import com.atlassian.bitbucket.pull.PullRequestService;
import com.atlassian.bitbucket.pull.PullRequestState;
import com.atlassian.bitbucket.repository.Ref;
import com.atlassian.bitbucket.repository.RefService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryBranchesRequest;
import com.atlassian.bitbucket.repository.RepositoryTagsRequest;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageRequestImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.tmatesoft.subgit.stash.mirror.SgUnsyncedRef;
import org.tmatesoft.subgit.stash.mirror.SgUnsyncedRef$Builder;
import org.tmatesoft.subgit.stash.mirror.util.SgLoggerFactory;
import org.tmatesoft.svn.core.io.ISVNTunnelProvider;
import org.tmatesoft.translator.m.B;
import org.tmatesoft.translator.m.C;
import org.tmatesoft.translator.m.D;
import org.tmatesoft.translator.m.aj;
import org.tmatesoft.translator.m.o;
import org.tmatesoft.translator.m.w;
import org.tmatesoft.translator.util.f;

public class SgUnsyncedService {
    private static final Pattern CONFLICT_NOTE_DATE_PATTERN = Pattern.compile("^Unsynced commit '.+' referred by '.+' has been detected at (.+);.*$", 40);
    private final Logger log;
    private RefService refService;
    private final PullRequestService pullRequestService;

    public SgUnsyncedService(SgLoggerFactory sgLoggerFactory, RefService refService, PullRequestService pullRequestService) {
        this.log = sgLoggerFactory.getLogger("unsynced-refs");
        this.refService = refService;
        this.pullRequestService = pullRequestService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List loadConflicts(Repository repository, aj aj2) {
        List list;
        ArrayList<SgUnsyncedRef> arrayList = new ArrayList<SgUnsyncedRef>();
        if (repository == null) {
            return arrayList;
        }
        try {
            list = aj2.n();
        }
        catch (f f2) {
            return arrayList;
        }
        if (list.isEmpty()) {
            return arrayList;
        }
        P p2 = null;
        try {
            p2 = aj2.a(o.a, (ISVNTunnelProvider)null);
            w w2 = w.a(p2, aj.b);
            Map map = this.collectBranches(repository);
            Map map2 = this.collectTags(repository);
            for (B b2 : list) {
                for (C c2 : b2.b()) {
                    String string = c2.b().a();
                    String string2 = c2.a().a();
                    boolean bl2 = map2.containsKey(string2) || c2.a().a().startsWith("refs/tags/");
                    boolean bl3 = map.containsKey(string2) || map2.containsKey(string2);
                    SgUnsyncedRef$Builder sgUnsyncedRef$Builder = SgUnsyncedRef.builder();
                    sgUnsyncedRef$Builder.setRef(string).setTargetRef(string2).setTargetExists(bl3).setIsTag(bl2).setConflictId(c2.c()).setCommitId(c2.d().b().getName()).setDetectionTime(this.getDetectionTime(this.loadConflictNote(w2, c2))).setPullRequestId(-1L);
                    if (bl3) {
                        PullRequest pullRequest;
                        PullRequestSearchRequest.Builder builder = new PullRequestSearchRequest.Builder();
                        builder.fromRefId(string);
                        builder.toRefId(string2);
                        builder.fromRepositoryId(Integer.valueOf(repository.getId()));
                        builder.toRepositoryId(Integer.valueOf(repository.getId()));
                        builder.state(PullRequestState.OPEN);
                        Page page = this.pullRequestService.search(builder.build(), (PageRequest)new PageRequestImpl(0, 1));
                        if (page.getSize() == 1 && (pullRequest = (PullRequest)page.getValues().iterator().next()) != null) {
                            sgUnsyncedRef$Builder.setPullRequestId(pullRequest.getId());
                        }
                    }
                    arrayList.add(sgUnsyncedRef$Builder.build());
                }
            }
        }
        catch (f f3) {
            this.log.error("Failed to load conflicts", (Throwable)f3);
        }
        finally {
            if (p2 != null) {
                p2.h();
            }
        }
        return arrayList;
    }

    private Map collectBranches(Repository repository) {
        HashMap<String, Ref> hashMap = new HashMap<String, Ref>();
        RepositoryBranchesRequest repositoryBranchesRequest = new RepositoryBranchesRequest.Builder(repository).build();
        PageRequestImpl pageRequestImpl = new PageRequestImpl(0, 100);
        do {
            try {
                Page page = this.refService.getBranches(repositoryBranchesRequest, (PageRequest)pageRequestImpl);
                for (Ref ref : page.getValues()) {
                    hashMap.put(ref.getId(), ref);
                }
                pageRequestImpl = page.getIsLastPage() ? null : page.getNextPageRequest();
            }
            catch (ServiceException serviceException) {
                pageRequestImpl = null;
                this.log.error("Failed to read branches", (Throwable)serviceException);
            }
        } while (pageRequestImpl != null);
        return hashMap;
    }

    private Map collectTags(Repository repository) {
        HashMap<String, Ref> hashMap = new HashMap<String, Ref>();
        RepositoryTagsRequest repositoryTagsRequest = new RepositoryTagsRequest.Builder(repository).build();
        PageRequestImpl pageRequestImpl = new PageRequestImpl(0, 100);
        do {
            try {
                Page page = this.refService.getTags(repositoryTagsRequest, (PageRequest)pageRequestImpl);
                for (Ref ref : page.getValues()) {
                    hashMap.put(ref.getId(), ref);
                }
                pageRequestImpl = page.getIsLastPage() ? null : page.getNextPageRequest();
            }
            catch (ServiceException serviceException) {
                pageRequestImpl = null;
                this.log.error("Failed to read tags", (Throwable)serviceException);
            }
        } while (pageRequestImpl != null);
        return hashMap;
    }

    private D loadConflictNote(w w2, C c2) {
        if (w2 == null || c2 == null) {
            return null;
        }
        try {
            return c2.a(w2);
        }
        catch (f f2) {
            this.log.error("Failed to load conflict note", (Throwable)f2);
            return null;
        }
    }

    private String getDetectionTime(D d2) {
        if (d2 == null) {
            return null;
        }
        String string = d2.a();
        Matcher matcher = CONFLICT_NOTE_DATE_PATTERN.matcher(string);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return null;
    }
}

