/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.subgit.stash.mirror;

import com.a.a.a.b.i;
import com.a.a.a.c.C;
import com.atlassian.bitbucket.cluster.ClusterService;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.project.ProjectService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.server.StorageService;
import com.atlassian.bitbucket.topic.MessageEvent;
import com.atlassian.bitbucket.topic.Topic;
import com.atlassian.bitbucket.topic.TopicListener;
import com.atlassian.bitbucket.topic.TopicService;
import com.atlassian.bitbucket.topic.TopicSettings;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageRequestImpl;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.tmatesoft.subgit.stash.mirror.SgAuthorsService;
import org.tmatesoft.subgit.stash.mirror.SgException;
import org.tmatesoft.subgit.stash.mirror.SgMirrorOption;
import org.tmatesoft.subgit.stash.mirror.scheduler.message.SgLogsRequestMessage;
import org.tmatesoft.subgit.stash.mirror.scheduler.message.SgReloadDataMessage;
import org.tmatesoft.subgit.stash.mirror.tasks.SgMirrorScope;
import org.tmatesoft.subgit.stash.mirror.util.SgLoggerFactory;
import org.tmatesoft.subgit.stash.mirror.util.SgSupportZip;
import org.tmatesoft.subgit.stash.mirror.util.SgSupportZipRequest;
import org.tmatesoft.subgit.stash.mirror.util.SgTextUtil;
import org.tmatesoft.subgit.stash.web.SgPluginPropertiesService;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.translator.m.d.c;

public class SgSupportZipService
implements TopicListener,
LifecycleAware {
    private static final String SUPPORT_ZIP_NAME_PREFIX = "svnmirror_support_";
    private static final Pattern SUPPORT_ZIP_FILE_PATTERN = Pattern.compile("svnmirror_support_([rp][0-9]+_)?([0-9_]+).zip");
    private static final int MAX_SUPPORT_ZIPS = 5;
    private static final int COLLECT_LOGS_TIMEOUT = 30000;
    private final RepositoryService repositoryService;
    private final ClusterService clusterService;
    private final SgPluginPropertiesService pluginPropertiesService;
    private final SgAuthorsService authorsService;
    private final SgLoggerFactory loggerFactory;
    private final ProjectService projectService;
    private final Map requestsMap = new HashMap();
    private final StorageService storageService;
    private final Logger log;
    private final Topic logRequestTopic;
    private final Topic reloadDataTopic;
    private String subscriptionId;

    public SgSupportZipService(StorageService storageService, ProjectService projectService, RepositoryService repositoryService, TopicService topicService, ClusterService clusterService, SgPluginPropertiesService sgPluginPropertiesService, SgAuthorsService sgAuthorsService, SgLoggerFactory sgLoggerFactory) {
        this.storageService = storageService;
        this.log = sgLoggerFactory.getLogger("support-zip");
        this.projectService = projectService;
        this.repositoryService = repositoryService;
        this.clusterService = clusterService;
        this.pluginPropertiesService = sgPluginPropertiesService;
        this.authorsService = sgAuthorsService;
        this.loggerFactory = sgLoggerFactory;
        this.logRequestTopic = topicService.getTopic("org.tmatesoft.subgit.stash.mirror.topic:logsRequest", TopicSettings.builder((Class)null).build());
        this.reloadDataTopic = topicService.getTopic("org.tmatesoft.subgit.stash.mirror.topic:reloadData", TopicSettings.builder((Class)null).build());
    }

    public void onStart() {
        this.log.info("on start");
        if (this.logRequestTopic != null) {
            this.subscriptionId = this.logRequestTopic.subscribe((TopicListener)this);
            this.log.info("subscribed to log requests: " + this.subscriptionId);
        }
    }

    public void onStop() {
        if (this.logRequestTopic != null && this.subscriptionId != null) {
            boolean bl2 = this.logRequestTopic.unsubscribe(this.subscriptionId);
            this.log.info("unsubscribed from log requests: " + this.subscriptionId + " (" + bl2 + ")");
            this.subscriptionId = null;
        }
        this.log.info("on stop");
    }

    public void populateSupportZipOptions(SgMirrorScope sgMirrorScope, Map map) {
        File file = this.getSupportDirectory(sgMirrorScope);
        File[] fileArray = file.listFiles();
        TreeSet<SgSupportZip> treeSet = new TreeSet<SgSupportZip>(Comparator.comparing(SgSupportZip::getTime));
        for (int i2 = 0; fileArray != null && i2 < fileArray.length; ++i2) {
            String string = fileArray[i2].getName();
            if (!SgSupportZipService.fileExists(fileArray[i2]) || !SgSupportZipService.isSupportZipFile(string)) continue;
            treeSet.add(new SgSupportZip(string, fileArray[i2].lastModified(), fileArray[i2].length()));
        }
        map.put(SgMirrorOption.SUPPORT_ZIPS, new ArrayList<SgSupportZip>(treeSet).subList(Math.max(0, treeSet.size() - 5), treeSet.size()).toArray(new SgSupportZip[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SgSupportZip createSupportArchive(SgMirrorScope sgMirrorScope, SgSupportZipRequest sgSupportZipRequest) {
        Object object;
        block22: {
            this.log(sgMirrorScope, "about to create support zip", new Object[0]);
            long l2 = System.currentTimeMillis();
            File file2 = this.getSupportDirectory(sgMirrorScope);
            Files.createDirectories(file2.toPath(), new FileAttribute[0]);
            File file3 = File.createTempFile("svnmirror.", ".zip", file2);
            File file4 = null;
            try {
                Object object2;
                Object object3;
                StringBuilder stringBuilder = new StringBuilder();
                if (sgSupportZipRequest.isIncludeServerLogs() || sgSupportZipRequest.isIncludeGlobalLogs()) {
                    file4 = Files.createTempDirectory(file2.toPath(), "nodes", new FileAttribute[0]).toFile();
                    object3 = SgSupportZipService.getLockFile(file4);
                    Files.write(((File)object3).toPath(), new byte[0], new OpenOption[0]);
                    try {
                        object2 = this.collectServerLogs(sgMirrorScope, sgSupportZipRequest.copy(file4.getName()));
                        object = object2.iterator();
                        while (object.hasNext()) {
                            String string = (String)object.next();
                            stringBuilder.append(String.format("Node %s logs were not fully collected in %dms.\n", string, 30000));
                        }
                    }
                    finally {
                        try {
                            C.i((File)object3);
                        }
                        catch (i i2) {}
                    }
                }
                object3 = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(file3)));
                try {
                    object2 = (arg_0, arg_1) -> SgSupportZipService.lambda$createSupportArchive$0((ZipOutputStream)object3, arg_0, arg_1);
                    this.visitScopeFiles(sgMirrorScope, (BiConsumer)object2);
                    if (file4 != null) {
                        this.visitDirectoryFiles("bitbucket", file4, (BiConsumer)object2, file -> true);
                    }
                    if (sgSupportZipRequest.isIncludeGlobalAuthorsMapping()) {
                        this.visitExistingFile("bitbucket/authors.txt", this.authorsService.getGlobalAuthorsFile(), (BiConsumer)object2);
                        this.visitExistingFile("bitbucket/legacy-authors.txt", this.authorsService.getLegacyGlobalAuthorsFile(), (BiConsumer)object2);
                    }
                    if (stringBuilder.length() > 0) {
                        ((ZipOutputStream)object3).putNextEntry(new ZipEntry("NOTES"));
                        ((FilterOutputStream)object3).write(stringBuilder.toString().getBytes(StandardCharsets.UTF_8));
                        ((ZipOutputStream)object3).closeEntry();
                    }
                }
                finally {
                    ((ZipOutputStream)object3).close();
                }
                object3 = this.createSupportZipFileName(sgMirrorScope, l2);
                object2 = new File(file2, (String)object3);
                Files.move(file3.toPath(), ((File)object2).toPath(), StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
                object = new SgSupportZip((String)object3, l2, ((File)object2).length());
                if (file4 == null) break block22;
            }
            catch (Throwable throwable) {
                if (file4 != null) {
                    C.b(file4);
                }
                this.reloadDataTopic.publish((Serializable)new SgReloadDataMessage(sgMirrorScope));
                throw throwable;
            }
            C.b(file4);
        }
        this.reloadDataTopic.publish((Serializable)new SgReloadDataMessage(sgMirrorScope));
        return object;
    }

    public int removeSupportArchives(SgMirrorScope sgMirrorScope) {
        File file = this.getSupportDirectory(sgMirrorScope);
        File[] fileArray = file.listFiles();
        int n2 = 0;
        for (int i2 = 0; fileArray != null && i2 < fileArray.length; ++i2) {
            File file2 = fileArray[i2];
            if (!SgSupportZipService.fileExists(file2) || !SgSupportZipService.isSupportZipFile(file2.getName())) continue;
            try {
                SVNFileUtil.deleteFile(file2);
                ++n2;
                continue;
            }
            catch (SVNException sVNException) {
                throw SgException.wrap(sVNException);
            }
        }
        this.reloadDataTopic.publish((Serializable)new SgReloadDataMessage(sgMirrorScope));
        return n2;
    }

    private void visitScopeFiles(SgMirrorScope sgMirrorScope, BiConsumer biConsumer) {
        block4: {
            block5: {
                block3: {
                    if (!sgMirrorScope.isRepository()) break block3;
                    this.visitRepositoryFiles(sgMirrorScope, biConsumer);
                    break block4;
                }
                if (!sgMirrorScope.isProject()) break block5;
                Project project = this.projectService.getById(sgMirrorScope.getProjectId());
                if (project == null) break block4;
                PageRequestImpl pageRequestImpl = new PageRequestImpl(0, 50);
                while (pageRequestImpl != null) {
                    Page page = this.repositoryService.findByProjectKey(project.getKey(), (PageRequest)pageRequestImpl);
                    for (Repository repository : page.getValues()) {
                        this.visitScopeFiles(SgMirrorScope.forRepository(repository), biConsumer);
                    }
                    pageRequestImpl = page.getNextPageRequest();
                }
                break block4;
            }
            for (String string : this.projectService.findAllKeys()) {
                Project project = this.projectService.getByKey(string);
                if (project == null) continue;
                this.visitScopeFiles(SgMirrorScope.forProject(project), biConsumer);
            }
        }
    }

    private void visitRepositoryFiles(SgMirrorScope sgMirrorScope, BiConsumer biConsumer) {
        File file2 = this.pluginPropertiesService.getMetadataDirectory(sgMirrorScope.getRepositoryId());
        c c2 = c.b(file2);
        String string = "repositories/" + sgMirrorScope.getRepositoryId();
        File file3 = c2.l();
        if (file3.isDirectory()) {
            this.visitDirectoryFiles(string + "/logs", file3, biConsumer, file -> true);
        }
        this.visitExistingFile(string + "/config", c2.g(), biConsumer);
        this.visitExistingFile(string + "/stash.config", new File(c2.i(), "stash.config"), biConsumer);
        this.visitExistingFile(string + "/format", c2.j(), biConsumer);
        this.visitExistingFile(string + "/authors.txt", c2.m(), biConsumer);
        this.visitExistingFile(string + "/.run/config", c2.e(), biConsumer);
        this.visitExistingFile(string + "/.run/config.backup", new File(c2.h(), "config.backup"), biConsumer);
        this.visitExistingFile(string + "/.run/info", c2.r(), biConsumer);
        this.visitExistingFile(string + "/.run/report", c2.n(), biConsumer);
        this.visitExistingFile(string + "/.run/stash.config", new File(c2.h(), "stash.config"), biConsumer);
        this.visitDirectoryFiles(string + "/svn", new File(file2, "svn"), biConsumer, file -> true);
        this.visitDirectoryFiles(string + "/db", new File(file2, "sb"), biConsumer, file -> true);
        Repository repository = this.repositoryService.getById(sgMirrorScope.getRepositoryId());
        if (repository != null) {
            try {
                File file4 = this.pluginPropertiesService.getRepositoryDirectory(repository, this.loggerFactory);
                this.visitExistingFile(string + "/git-packed-refs", new File(file4, "packed-refs"), biConsumer);
                this.visitDirectoryFiles(string + "/git-refs", new File(file4, "refs"), biConsumer, file -> true);
            }
            catch (SgException sgException) {
                this.log.error(sgException.getMessage(), (Throwable)sgException);
            }
        }
    }

    private void visitExistingFile(String string, File file, BiConsumer biConsumer) {
        if (SgSupportZipService.fileExists(file)) {
            biConsumer.accept(string, file);
        }
    }

    private static boolean fileExists(File file) {
        return file.exists() && file.isFile() && file.canRead();
    }

    private void visitDirectoryFiles(String string, File file, BiConsumer biConsumer, Predicate predicate) {
        File[] fileArray = file.listFiles();
        for (int i2 = 0; fileArray != null && i2 < fileArray.length; ++i2) {
            File file2 = fileArray[i2];
            if (!predicate.test(file2)) continue;
            String string2 = (String)("".equals(string) ? "" : string + "/") + file2.getName();
            if (file2.isDirectory()) {
                this.visitDirectoryFiles(string2, file2, biConsumer, predicate);
                continue;
            }
            this.visitExistingFile(string2, file2, biConsumer);
        }
    }

    public File getSupportDirectory(SgMirrorScope sgMirrorScope) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("subgit/support/");
        if (sgMirrorScope.isRepository()) {
            stringBuilder.append("repositories/");
            stringBuilder.append(sgMirrorScope.getRepositoryId());
        } else if (sgMirrorScope.isProject()) {
            stringBuilder.append("projects/");
            stringBuilder.append(sgMirrorScope.getProjectId());
        } else {
            stringBuilder.append("bitbucket/");
        }
        return new File(this.storageService.getDataDir().toFile(), stringBuilder.toString());
    }

    private String createSupportZipFileName(SgMirrorScope sgMirrorScope, long l2) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss_SSS");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(SUPPORT_ZIP_NAME_PREFIX);
        if (sgMirrorScope.isRepository()) {
            stringBuilder.append("r");
            stringBuilder.append(sgMirrorScope.getRepositoryId());
            stringBuilder.append("_");
        } else if (sgMirrorScope.isProject()) {
            stringBuilder.append("p");
            stringBuilder.append(sgMirrorScope.getProjectId());
            stringBuilder.append("_");
        }
        stringBuilder.append(simpleDateFormat.format(new Date(l2)));
        stringBuilder.append(".zip");
        return stringBuilder.toString();
    }

    private static boolean isSupportZipFile(String string) {
        Matcher matcher = SUPPORT_ZIP_FILE_PATTERN.matcher(string);
        return matcher.matches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set collectServerLogs(SgMirrorScope sgMirrorScope, SgSupportZipRequest sgSupportZipRequest) {
        Object object2;
        Set set = this.clusterService.getInformation().getNodes();
        Map map = this.requestsMap;
        synchronized (map) {
            this.requestsMap.put(sgSupportZipRequest.getId(), new HashSet());
            for (Object object2 : set) {
                this.logRequestTopic.publish((Serializable)new SgLogsRequestMessage(object2.getId(), sgMirrorScope, sgSupportZipRequest, false));
                this.log(sgMirrorScope, "logs request sent to node %s", object2.getId());
                ((Set)this.requestsMap.get(sgSupportZipRequest.getId())).add(object2.getId());
            }
        }
        long l2 = System.currentTimeMillis() + 30000L;
        this.log(sgMirrorScope, "waiting for logs to be collected for at most %s ms.", 30000);
        object2 = this.requestsMap;
        synchronized (object2) {
            while (l2 >= System.currentTimeMillis() && ((Set)this.requestsMap.get(sgSupportZipRequest.getId())).size() > 0) {
                try {
                    this.requestsMap.wait(Math.max(1L, l2 - System.currentTimeMillis()));
                }
                catch (InterruptedException interruptedException) {
                    this.log.error(interruptedException.getMessage(), (Throwable)interruptedException);
                }
            }
            return (Set)this.requestsMap.remove(sgSupportZipRequest.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(@Nonnull MessageEvent messageEvent) {
        this.log.info("processing log request message");
        SgLogsRequestMessage sgLogsRequestMessage = (SgLogsRequestMessage)messageEvent.getMessage();
        String string = messageEvent.getSource().getId();
        String string2 = sgLogsRequestMessage.getDestination();
        String string3 = this.clusterService.getNodeId();
        SgMirrorScope sgMirrorScope = sgLogsRequestMessage.getScope();
        SgSupportZipRequest sgSupportZipRequest = sgLogsRequestMessage.getRequest();
        this.log(sgMirrorScope, "for node: %s on node %s", string2, string3);
        if (Objects.equals(string2, string3)) {
            if (sgLogsRequestMessage.isCompleted()) {
                this.log(sgLogsRequestMessage.getScope(), "ack received: logs collected by node %s.", string);
                Map map = this.requestsMap;
                synchronized (map) {
                    if (this.requestsMap.containsKey(sgSupportZipRequest.getId())) {
                        ((Set)this.requestsMap.get(sgSupportZipRequest.getId())).remove(string);
                    }
                    this.requestsMap.notifyAll();
                }
            } else {
                this.log(sgMirrorScope, "logs are about to be collected at node %s.", string3);
                CompletableFuture.runAsync(() -> {
                    try {
                        this.doCopyServerLogs(sgLogsRequestMessage);
                    }
                    catch (Throwable throwable) {
                        try {
                            this.log(throwable);
                        }
                        catch (Throwable throwable2) {
                            this.log(sgMirrorScope, "node %s : sending log collection ack to node %s.", string3, string);
                            this.logRequestTopic.publish((Serializable)new SgLogsRequestMessage(string, sgMirrorScope, sgSupportZipRequest, true));
                            throw throwable2;
                        }
                        this.log(sgMirrorScope, "node %s : sending log collection ack to node %s.", string3, string);
                        this.logRequestTopic.publish((Serializable)new SgLogsRequestMessage(string, sgMirrorScope, sgSupportZipRequest, true));
                    }
                    this.log(sgMirrorScope, "node %s : sending log collection ack to node %s.", string3, string);
                    this.logRequestTopic.publish((Serializable)new SgLogsRequestMessage(string, sgMirrorScope, sgSupportZipRequest, true));
                });
            }
        }
    }

    private void doCopyServerLogs(SgLogsRequestMessage sgLogsRequestMessage) {
        File file2 = new File(this.storageService.getHomeDir().toFile(), "log");
        File file4 = new File(this.getSupportDirectory(sgLogsRequestMessage.getScope()), sgLogsRequestMessage.getRequest().getId());
        File file5 = SgSupportZipService.getLockFile(file4);
        this.visitDirectoryFiles("node-" + this.clusterService.getNodeId() + "/log", file2, (string, file3) -> {
            try {
                if (!Files.isRegularFile(file5.toPath(), new LinkOption[0])) {
                    throw new IOException("destination no longer exists");
                }
                Path path = new File(file4, (String)string).toPath();
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                Files.copy(file3.toPath(), path, new CopyOption[0]);
            }
            catch (IOException iOException) {
                this.log(iOException);
                throw new RuntimeException(iOException);
            }
        }, file -> file.isDirectory() || sgLogsRequestMessage.getRequest().isIncludeGlobalLogs() && file.getName().startsWith("svnmirror") || sgLogsRequestMessage.getRequest().isIncludeServerLogs() && !file.getName().startsWith("svnmirror"));
    }

    private void log(SgMirrorScope sgMirrorScope, String string, Object ... objectArray) {
        String string2 = SgTextUtil.formatString("[%s] ", sgMirrorScope) + SgTextUtil.formatString(string, objectArray);
        this.log.info(string2);
    }

    private void log(Throwable throwable) {
        if (throwable != null) {
            this.log.error(throwable.getMessage(), throwable);
        }
    }

    private static File getLockFile(File file) {
        return new File(file.getParentFile(), file.getName() + ".lck");
    }

    private static /* synthetic */ void lambda$createSupportArchive$0(ZipOutputStream zipOutputStream, String string, File file) {
        try {
            zipOutputStream.putNextEntry(new ZipEntry(string));
            try (BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));){
                C.a(bufferedInputStream, zipOutputStream);
            }
            zipOutputStream.closeEntry();
        }
        catch (i | IOException exception) {
            throw new RuntimeException(exception);
        }
    }
}

