/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.subgit.stash.mirror;

import ch.qos.logback.classic.Level;
import com.a.a.a.a.p;
import com.a.a.a.b.k;
import com.a.a.a.c.M;
import com.a.a.a.c.aB;
import com.a.a.a.c.aC;
import com.a.a.a.c.ae;
import com.a.a.a.c.ah;
import com.a.a.a.c.ai;
import com.a.a.a.c.e;
import com.a.a.a.d.H;
import com.a.a.a.d.aA;
import com.a.a.a.d.aS;
import com.a.a.a.d.au;
import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.commit.CommitRequest;
import com.atlassian.bitbucket.commit.CommitService;
import com.atlassian.bitbucket.commit.NoSuchCommitException;
import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.project.ProjectService;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.request.RequestManager;
import com.atlassian.bitbucket.scm.git.command.GitCommandBuilderFactory;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.server.StorageService;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.Person;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.user.ServiceUser;
import com.atlassian.bitbucket.user.ServiceUserCreateRequest;
import com.atlassian.bitbucket.user.UserAdminService;
import com.atlassian.bitbucket.user.UserSearchRequest;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.bitbucket.util.Operation;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageRequestImpl;
import com.atlassian.event.api.EventPublisher;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.tmatesoft.subgit.stash.mirror.SgAuthorsService;
import org.tmatesoft.subgit.stash.mirror.SgException;
import org.tmatesoft.subgit.stash.mirror.SgGitRepositoryFactory;
import org.tmatesoft.subgit.stash.mirror.SgMeshService;
import org.tmatesoft.subgit.stash.mirror.SgMirrorOption;
import org.tmatesoft.subgit.stash.mirror.SgMirrorStage;
import org.tmatesoft.subgit.stash.mirror.SgSupportZipService;
import org.tmatesoft.subgit.stash.mirror.SgUnsyncedRef;
import org.tmatesoft.subgit.stash.mirror.SgUnsyncedService;
import org.tmatesoft.subgit.stash.mirror.rest.SgSvnSyncInfo;
import org.tmatesoft.subgit.stash.mirror.settings.SgSetting;
import org.tmatesoft.subgit.stash.mirror.settings.SgSettings;
import org.tmatesoft.subgit.stash.mirror.settings.SgSettingsService;
import org.tmatesoft.subgit.stash.mirror.settings.SgSettingsSnapshot;
import org.tmatesoft.subgit.stash.mirror.settings.SgSettingsType;
import org.tmatesoft.subgit.stash.mirror.svn.SgSubversionService;
import org.tmatesoft.subgit.stash.mirror.tasks.SgMirrorScope;
import org.tmatesoft.subgit.stash.mirror.util.SgFileUtil;
import org.tmatesoft.subgit.stash.mirror.util.SgLoggerFactory;
import org.tmatesoft.subgit.stash.mirror.util.SgTextUtil;
import org.tmatesoft.subgit.stash.web.SgLicenseManager;
import org.tmatesoft.subgit.stash.web.SgPluginPropertiesService;
import org.tmatesoft.subgit.stash.web.SgRefChange;
import org.tmatesoft.subgit.stash.web.SvnFetchEvent;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.translator.b.F;
import org.tmatesoft.translator.b.G;
import org.tmatesoft.translator.e.i;
import org.tmatesoft.translator.h.d;
import org.tmatesoft.translator.k.n;
import org.tmatesoft.translator.m.O;
import org.tmatesoft.translator.m.Z;
import org.tmatesoft.translator.m.aG;
import org.tmatesoft.translator.m.ab;
import org.tmatesoft.translator.m.aj;
import org.tmatesoft.translator.m.d.b;
import org.tmatesoft.translator.m.d.c;
import org.tmatesoft.translator.m.g;
import org.tmatesoft.translator.m.m;
import org.tmatesoft.translator.util.f;
import org.tmatesoft.translator.util.r;
import org.tmatesoft.translator.util.z;

public class SgMirrorService {
    private static final String SERVICE_USER_NAME = z.r().a() + "RefUpdater";
    private static final String SERVICE_USER_LABEL = z.r().b();
    private static final String SERVICE_EMAIL = "admin@localhost";
    private static final String FETCH_SECURITY_MESSAGE = "New changes were fetched from SVN repository";
    private final Logger log;
    private final SgSubversionService subversionService;
    private final SecurityService securityService;
    private final UserAdminService userAdminService;
    private final UserService userService;
    private final RepositoryService repositoryService;
    private final CommitService commitService;
    private final AuthenticationContext authenticationContext;
    private final ProjectService projectService;
    private final ApplicationPropertiesService applicationPropertiesService;
    private final EventPublisher eventPublisher;
    private final NavBuilder navBuilder;
    private final GitCommandBuilderFactory gitCommandBuilderFactory;
    private final SgGitRepositoryFactory gitRepositoryFactory;
    private final RequestManager requestManager;
    private final SgLicenseManager licenseManager;
    private final SgAuthorsService authorsService;
    private final SgUnsyncedService conflictsService;
    private final SgSettingsService settingsService;
    private final SgLoggerFactory loggerFactory;
    private final SgSupportZipService supportZipService;
    private final SgPluginPropertiesService pluginPropertiesService;
    private final r platform;
    private final StorageService storageService;
    private final SgMeshService meshService;

    public SgMirrorService(ApplicationPropertiesService applicationPropertiesService, StorageService storageService, RepositoryService repositoryService, ProjectService projectService, EventPublisher eventPublisher, SgLicenseManager sgLicenseManager, SgSubversionService sgSubversionService, SecurityService securityService, UserAdminService userAdminService, UserService userService, CommitService commitService, AuthenticationContext authenticationContext, SgGitRepositoryFactory sgGitRepositoryFactory, RequestManager requestManager, SgAuthorsService sgAuthorsService, SgUnsyncedService sgUnsyncedService, SgSettingsService sgSettingsService, SgSupportZipService sgSupportZipService, SgLoggerFactory sgLoggerFactory, NavBuilder navBuilder, GitCommandBuilderFactory gitCommandBuilderFactory, SgPluginPropertiesService sgPluginPropertiesService, SgMeshService sgMeshService) {
        this.log = sgLoggerFactory.getLogger("service");
        this.storageService = storageService;
        this.loggerFactory = sgLoggerFactory;
        this.projectService = projectService;
        this.conflictsService = sgUnsyncedService;
        this.navBuilder = navBuilder;
        this.gitCommandBuilderFactory = gitCommandBuilderFactory;
        this.subversionService = sgSubversionService;
        this.eventPublisher = eventPublisher;
        this.applicationPropertiesService = applicationPropertiesService;
        this.gitRepositoryFactory = sgGitRepositoryFactory;
        this.requestManager = requestManager;
        this.repositoryService = repositoryService;
        this.commitService = commitService;
        this.securityService = securityService;
        this.userAdminService = userAdminService;
        this.userService = userService;
        this.authenticationContext = authenticationContext;
        this.licenseManager = sgLicenseManager;
        this.authorsService = sgAuthorsService;
        this.settingsService = sgSettingsService;
        this.supportZipService = sgSupportZipService;
        this.pluginPropertiesService = sgPluginPropertiesService;
        this.meshService = sgMeshService;
        this.platform = r.a(sgGitRepositoryFactory);
    }

    public SgSettings createSettings(SgMirrorScope sgMirrorScope) {
        return this.settingsService.createSettingsForScope(sgMirrorScope);
    }

    public SgPluginPropertiesService getPluginPropertiesService() {
        return this.pluginPropertiesService;
    }

    @NotNull
    public File getUserVisibleConfigFile(m m2) {
        return new File(m2.i(), "config");
    }

    @NotNull
    public File getUserHiddenConfigFile(m m2) {
        return new File(m2.i(), "stash.config");
    }

    @NotNull
    public File getActiveUserVisibleConfigFile(m m2) {
        return new File(m2.h(), "stash.config");
    }

    public void forceRepositoryRefresh(com.atlassian.bitbucket.repository.Repository repository, Collection collection) {
        if (collection == null || collection.isEmpty() || repository == null) {
            return;
        }
        try {
            ApplicationUser applicationUser;
            Operation operation = () -> {
                ArrayList arrayList = new ArrayList(collection);
                this.eventPublisher.publish((Object)new SvnFetchEvent(this, repository, SgRefChange.toRefChanges(arrayList)));
                return null;
            };
            try {
                applicationUser = this.getApplicationUser(repository, collection);
            }
            catch (Throwable throwable) {
                this.log.error("Failed to detect application user for RepositoryRefChangedEvent", throwable);
                applicationUser = null;
            }
            if (applicationUser == null) {
                this.log.info("Raising RepositoryRefChangedEvent on behalf of authenticated user");
                this.securityService.withPermission(Permission.REPO_ADMIN, FETCH_SECURITY_MESSAGE).call(operation);
            } else {
                this.log.info("Raising RepositoryRefChangedEvent on behalf of " + applicationUser.getType().toString().toLowerCase() + " user '" + applicationUser.getName() + "'");
                this.securityService.impersonating(applicationUser, FETCH_SECURITY_MESSAGE).withPermission(Permission.REPO_ADMIN).call(operation);
            }
        }
        catch (Throwable throwable) {
            this.log.info("Failed to refresh repository '" + repository.getName() + "'", throwable);
        }
    }

    @Nullable
    public ApplicationUser getApplicationUser(com.atlassian.bitbucket.repository.Repository repository, Collection collection) {
        ApplicationUser applicationUser = this.authenticationContext.getCurrentUser();
        if (applicationUser != null) {
            return null;
        }
        ApplicationUser applicationUser2 = this.getAuthor(repository, collection);
        if (applicationUser2 != null) {
            return applicationUser2;
        }
        ApplicationUser applicationUser3 = this.getRepositoryAdmin(repository);
        if (applicationUser3 != null) {
            return applicationUser3;
        }
        ApplicationUser applicationUser4 = this.getProjectAdmin(repository.getProject());
        if (applicationUser4 != null) {
            return applicationUser4;
        }
        ApplicationUser applicationUser5 = this.getSysAdmin();
        if (applicationUser5 != null) {
            return applicationUser5;
        }
        return this.findOrCreateServiceUser();
    }

    @Nullable
    private ApplicationUser getAuthor(com.atlassian.bitbucket.repository.Repository repository, Collection collection) {
        try {
            return (ApplicationUser)this.securityService.withPermission(Permission.SYS_ADMIN, FETCH_SECURITY_MESSAGE).call(() -> this.doGetAuthor(repository, collection));
        }
        catch (Throwable throwable) {
            this.log.error("Ignored failure while fetching commits author", throwable);
            return null;
        }
    }

    private ApplicationUser doGetAuthor(com.atlassian.bitbucket.repository.Repository repository, Collection collection) {
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        for (i i2 : collection) {
            Commit commit;
            CommitRequest commitRequest = new CommitRequest.Builder(repository, i2.c().toString()).build();
            try {
                commit = this.commitService.getCommit(commitRequest);
            }
            catch (NoSuchCommitException noSuchCommitException) {
                this.log.info("Failed to resolve commit for ref delta " + String.valueOf(i2));
                continue;
            }
            Person person = commit.getAuthor();
            if (person.getEmailAddress() == null || person.getEmailAddress().isEmpty()) continue;
            UserSearchRequest.Builder builder = new UserSearchRequest.Builder();
            builder.filter(person.getEmailAddress());
            ApplicationUser applicationUser = this.findUserByRequest(builder.build());
            if (applicationUser == null) continue;
            return applicationUser;
        }
        return null;
    }

    @Nullable
    private ApplicationUser getRepositoryAdmin(com.atlassian.bitbucket.repository.Repository repository) {
        UserSearchRequest.Builder builder = new UserSearchRequest.Builder();
        builder.repositoryPermission(repository, Permission.REPO_ADMIN);
        return this.findUserByRequest(builder.build());
    }

    @Nullable
    private ApplicationUser getProjectAdmin(Project project) {
        UserSearchRequest.Builder builder = new UserSearchRequest.Builder();
        builder.projectPermission(project, Permission.PROJECT_ADMIN);
        return this.findUserByRequest(builder.build());
    }

    @Nullable
    private ApplicationUser getSysAdmin() {
        UserSearchRequest.Builder builder = new UserSearchRequest.Builder();
        builder.permission(Permission.SYS_ADMIN);
        return this.findUserByRequest(builder.build());
    }

    @Nullable
    private ApplicationUser findUserByRequest(UserSearchRequest userSearchRequest) {
        try {
            return (ApplicationUser)this.securityService.withPermission(Permission.SYS_ADMIN, FETCH_SECURITY_MESSAGE).call(() -> this.doFindUserByRequest(userSearchRequest));
        }
        catch (Throwable throwable) {
            this.log.info("Ignored failure on fetching user by request", throwable);
            return null;
        }
    }

    @Nullable
    private ApplicationUser doFindUserByRequest(UserSearchRequest userSearchRequest) {
        PageRequestImpl pageRequestImpl = new PageRequestImpl(0, 1);
        Page page = this.userService.search(userSearchRequest, (PageRequest)pageRequestImpl);
        Iterator iterator = page.getValues().iterator();
        if (iterator.hasNext()) {
            return (ApplicationUser)iterator.next();
        }
        return null;
    }

    @Nullable
    private ApplicationUser findOrCreateServiceUser() {
        try {
            return (ApplicationUser)this.securityService.withPermission(Permission.ADMIN, "Obtain SVN Mirror service account").call(this::doFindOrCreateServiceUser);
        }
        catch (Throwable throwable) {
            this.log.info("Failed to obtain service user: " + SERVICE_USER_NAME, throwable);
            return null;
        }
    }

    @NotNull
    private ApplicationUser doFindOrCreateServiceUser() {
        ServiceUser serviceUser = this.userService.getServiceUserByName(SERVICE_USER_NAME);
        if (serviceUser == null) {
            serviceUser = this.userService.findUserByNameOrEmail(SERVICE_EMAIL);
        }
        if (serviceUser != null) {
            return serviceUser;
        }
        ServiceUserCreateRequest.Builder builder = new ServiceUserCreateRequest.Builder();
        builder.name(SERVICE_USER_NAME);
        builder.label(SERVICE_USER_LABEL);
        builder.emailAddress(SERVICE_EMAIL);
        builder.active(true);
        return this.userAdminService.createServiceUser(builder.build());
    }

    public NavBuilder getNavBuilder() {
        return this.navBuilder;
    }

    public GitCommandBuilderFactory getGitCommandBuilderFactory() {
        return this.gitCommandBuilderFactory;
    }

    public SgSubversionService getSubversionService() {
        return this.subversionService;
    }

    public RepositoryService getRepositoryService() {
        return this.repositoryService;
    }

    public ProjectService getProjectService() {
        return this.projectService;
    }

    public ApplicationPropertiesService getApplicationPropertiesService() {
        return this.applicationPropertiesService;
    }

    public StorageService getStorageService() {
        return this.storageService;
    }

    public SgAuthorsService getAuthorsService() {
        return this.authorsService;
    }

    public SgLicenseManager getLicenseManager() {
        return this.licenseManager;
    }

    public void setLogLevel(String string) {
        Level level = Level.toLevel((String)string, (Level)Level.WARN);
        this.loggerFactory.setLevel(level);
        this.log.warn("log level set to [" + String.valueOf(level) + "]");
    }

    @NotNull
    public File getMetadataDirectory(com.atlassian.bitbucket.repository.Repository repository) {
        return this.pluginPropertiesService.getMetadataDirectory(repository);
    }

    @NotNull
    public File getRepositoryDirectory(com.atlassian.bitbucket.repository.Repository repository) {
        return this.pluginPropertiesService.getRepositoryDirectory(repository, this.loggerFactory);
    }

    @Nullable
    public File getRepositoryDirectoryOrNull(com.atlassian.bitbucket.repository.Repository repository) {
        try {
            return this.pluginPropertiesService.getRepositoryDirectory(repository, this.loggerFactory);
        }
        catch (SgException sgException) {
            this.log.error(sgException.getMessage(), (Throwable)sgException);
            return null;
        }
    }

    @NotNull
    public g getGitRepositoryFactory() {
        return this.gitRepositoryFactory;
    }

    public RequestManager getRequestManager() {
        return this.requestManager;
    }

    @NotNull
    public r getPlatform() {
        return this.platform;
    }

    public Z getGitRepositoryKey(com.atlassian.bitbucket.repository.Repository repository) {
        String string = repository.getProject().getKey() + " / " + repository.getName() + " ID: " + repository.getId();
        return Z.a(String.valueOf(repository.getId()), string);
    }

    public b createProxyRepository(com.atlassian.bitbucket.repository.Repository repository) {
        c c2 = c.b(this.getMetadataDirectory(repository));
        return b.a(this.getGitRepositoryKey(repository), c2, this.getPlatform());
    }

    @NotNull
    public SgMirrorStage getRepositoryStage(com.atlassian.bitbucket.repository.Repository repository) {
        File file = null;
        try {
            file = this.getRepositoryDirectory(repository);
        }
        catch (SgException sgException) {
            // empty catch block
        }
        File file2 = this.getMetadataDirectory(repository);
        if (file != null && SgMirrorService.isLocalMirrorInstalled(file)) {
            return SgMirrorStage.EXTERNAL_LOCAL;
        }
        c c2 = c.b(file2);
        File file3 = c2.g();
        File file4 = c2.e();
        File file5 = this.getUserHiddenConfigFile(c2);
        File file6 = this.getActiveUserVisibleConfigFile(c2);
        File file7 = new File(c2.i(), "status");
        boolean bl2 = SgFileUtil.isFileExistsAndReadable(file3);
        if (file == null && !bl2) {
            return SgMirrorStage.INITIAL;
        }
        if (bl2) {
            boolean bl3 = SgFileUtil.isFileExistsAndReadable(file4);
            boolean bl4 = SgFileUtil.isFileExistsAndReadable(file5);
            if (!bl3 && bl4) {
                return SgMirrorStage.CONFIGURED;
            }
            boolean bl5 = SgFileUtil.isFileExistsAndReadable(file6);
            if (bl3 && bl5) {
                return SgMirrorStage.INSTALLED;
            }
            if (this.loadLegacyStatus(file7) != null) {
                return SgMirrorStage.LEGACY;
            }
            return SgMirrorStage.UNKNOWN;
        }
        c c3 = c.b(file);
        File file8 = c3.g();
        File file9 = c3.e();
        File file10 = this.getUserHiddenConfigFile(c3);
        File file11 = this.getActiveUserVisibleConfigFile(c3);
        File file12 = new File(c3.i(), "status");
        boolean bl6 = SgFileUtil.isFileExistsAndReadable(file8);
        if (!bl6) {
            return SgMirrorStage.INITIAL;
        }
        if (bl6) {
            if (SgFileUtil.isFileExistsAndReadable(file10)) {
                return SgMirrorStage.PENDING_METADATA_MOVE;
            }
            if (SgFileUtil.isFileExistsAndReadable(file11)) {
                return SgMirrorStage.PENDING_METADATA_MOVE;
            }
            if (this.loadLegacyStatus(file12) != null) {
                return SgMirrorStage.PENDING_METADATA_MOVE;
            }
            if (SgFileUtil.isFileExistsAndReadable(file9)) {
                try {
                    F f2 = F.a(this.getPlatform(), c3);
                    f2.a();
                    if (f2.j() != null && f2.g(f2.j())) {
                        return SgMirrorStage.PENDING_METADATA_MOVE;
                    }
                }
                catch (f f3) {
                    // empty catch block
                }
            }
            return SgMirrorStage.EXTERNAL_REMOTE;
        }
        return SgMirrorStage.UNKNOWN;
    }

    public SgSettingsSnapshot loadState(SgMirrorScope sgMirrorScope) {
        File file;
        HashMap<SgSetting, Object> hashMap = new HashMap<SgSetting, Object>();
        if (!this.getLicenseManager().hasLicense()) {
            hashMap.put(SgMirrorOption.STAGE, (Object)SgMirrorStage.NO_LICENSE);
            return this.settingsService.createValuesSettings(SgMirrorScope.global().getSettingsType(), this.createSettings(SgMirrorScope.global()), hashMap).snapshot(SgMirrorOption.all());
        }
        if (sgMirrorScope.isGlobal()) {
            SgSettings sgSettings = this.createSettings(sgMirrorScope);
            String string = SgTextUtil.loadTextFileContents(this.getAuthorsService().getGlobalAuthorsFile(), this.log);
            hashMap.put(SgMirrorOption.AUTHORS, string);
            hashMap.put(SgMirrorOption.STAGE, (Object)SgMirrorStage.GLOBAL);
            this.supportZipService.populateSupportZipOptions(sgMirrorScope, hashMap);
            SgMirrorService.initDefaultSetting(sgSettings, SgMirrorOption.SCHEDULER_OPTIONS, sgMirrorScope.getSettingsType(), hashMap);
            SgMirrorService.initDefaultSetting(sgSettings, SgMirrorOption.LONG_POLL_OPTIONS, sgMirrorScope.getSettingsType(), hashMap);
            SgMirrorService.initDefaultSetting(sgSettings, SgMirrorOption.AUTHORISATION_OPTIONS, sgMirrorScope.getSettingsType(), hashMap);
            SgMirrorService.initDefaultSetting(sgSettings, SgMirrorOption.MIRROR_TRACKING_MODE, sgMirrorScope.getSettingsType(), hashMap);
            SgMirrorService.initDefaultSetting(sgSettings, SgMirrorOption.REPOSITORY_ACCESS_TYPE, sgMirrorScope.getSettingsType(), hashMap);
            return this.settingsService.createValuesSettings(sgMirrorScope.getSettingsType(), sgSettings, hashMap).snapshot(SgMirrorOption.all());
        }
        if (sgMirrorScope.isProject()) {
            Project project = this.projectService.getById(sgMirrorScope.getProjectId());
            hashMap.put(SgMirrorOption.STAGE, (Object)SgMirrorStage.PROJECT);
            if (project != null) {
                hashMap.put(SgMirrorOption.PROJECT_KEY, project.getKey());
                hashMap.put(SgMirrorOption.PROJECT_NAME, project.getName());
            }
            this.supportZipService.populateSupportZipOptions(sgMirrorScope, hashMap);
            return this.settingsService.createValuesSettings(sgMirrorScope.getSettingsType(), this.createSettings(sgMirrorScope), hashMap).snapshot(SgMirrorOption.all());
        }
        int n2 = sgMirrorScope.getRepositoryId();
        com.atlassian.bitbucket.repository.Repository repository = this.repositoryService.getById(n2);
        if (repository == null || repository.getProject().getId() != sgMirrorScope.getProjectId()) {
            SgSettings sgSettings = this.createSettings(sgMirrorScope);
            hashMap.put(SgMirrorOption.STAGE, (Object)SgMirrorStage.MISSING);
            sgSettings = this.settingsService.createValuesSettings(sgMirrorScope.getSettingsType(), sgSettings, hashMap);
            return sgSettings.snapshot(SgMirrorOption.all());
        }
        hashMap.put(SgMirrorOption.ON_MESH, this.meshService.isOnMesh(repository));
        File file2 = this.getMetadataDirectory(repository);
        c c2 = c.b(file2);
        try {
            file = this.getRepositoryDirectory(repository);
        }
        catch (SgException sgException) {
            this.log.error(sgException.getMessage(), (Throwable)sgException);
            file = null;
        }
        SgMirrorStage sgMirrorStage = this.getRepositoryStage(repository);
        SgSettings sgSettings = this.createSettings(sgMirrorScope);
        if (sgMirrorStage == SgMirrorStage.CONFIGURED) {
            sgSettings = this.loadInstallConfiguration(sgMirrorScope, c2, sgSettings, false);
        } else if (sgMirrorStage == SgMirrorStage.INSTALLED) {
            boolean bl2 = (Boolean)(sgSettings = this.loadInstallConfiguration(sgMirrorScope, c2, sgSettings, true)).get(SgMirrorOption.PAUSED, new SgSettingsType[0]);
            sgMirrorStage = bl2 ? SgMirrorStage.PAUSED : sgMirrorStage;
        } else if (sgMirrorStage == SgMirrorStage.PENDING_METADATA_MOVE && file != null) {
            c c3 = c.b(file);
            boolean bl3 = SgFileUtil.isFileExistsAndReadable(c3.e());
            sgSettings = this.loadInstallConfiguration(sgMirrorScope, c3, sgSettings, bl3);
        }
        SgUnsyncedRef[] sgUnsyncedRefArray = this.loadConflicts(repository);
        hashMap.put(SgMirrorOption.STAGE, (Object)sgMirrorStage);
        hashMap.put(SgMirrorOption.DEFAULT_SVN_CACHE_PATH, this.getSubversionService().getDefaultCachePath());
        if (file != null) {
            hashMap.put(SgMirrorOption.REPOSITORY_PATH, file);
        }
        hashMap.put(SgMirrorOption.METADATA_PATH, file2);
        hashMap.put(SgMirrorOption.REPOSITORY_EMPTY, this.repositoryService.isEmpty(repository));
        hashMap.put(SgMirrorOption.REPOSITORY_NAME, repository.getName());
        hashMap.put(SgMirrorOption.REPOSITORY_SLUG, repository.getSlug());
        hashMap.put(SgMirrorOption.PROJECT_KEY, repository.getProject().getKey());
        hashMap.put(SgMirrorOption.PROJECT_NAME, repository.getProject().getName());
        hashMap.put(SgMirrorOption.UNSYNCED_REFS, sgUnsyncedRefArray.length > 0 ? sgUnsyncedRefArray : null);
        hashMap.put(SgMirrorOption.HAS_UNSYNCED_REFS, sgUnsyncedRefArray.length > 0);
        hashMap.put(SgMirrorOption.SVN_UUID, this.loadSvnUUID(repository));
        if (sgMirrorStage == SgMirrorStage.INITIAL) {
            SgMirrorService.initDefaultSetting(sgSettings, SgMirrorOption.CREDENTIALS, sgMirrorScope.getSettingsType(), hashMap);
            SgMirrorService.initDefaultSetting(sgSettings, SgMirrorOption.CORE_DEFAULT_DOMAIN, sgMirrorScope.getSettingsType(), hashMap);
            SgMirrorService.initDefaultSetting(sgSettings, SgMirrorOption.LAYOUT_TYPE, sgMirrorScope.getSettingsType(), hashMap);
            SgMirrorService.initDefaultSetting(sgSettings, SgMirrorOption.GENERATE_AUTHORS_MAPPING_ON_CONFIGURE, sgMirrorScope.getSettingsType(), hashMap);
        } else if (sgMirrorStage == SgMirrorStage.CONFIGURED || sgMirrorStage == SgMirrorStage.INSTALLED || sgMirrorStage == SgMirrorStage.PENDING_METADATA_MOVE || sgMirrorStage == SgMirrorStage.PAUSED) {
            this.supportZipService.populateSupportZipOptions(sgMirrorScope, hashMap);
            SgMirrorService.initDefaultSetting(sgSettings, SgMirrorOption.SVN_MINIMAL_REVISION, sgMirrorScope.getSettingsType(), hashMap);
            SgMirrorService.initDefaultSetting(sgSettings, SgMirrorOption.TRANSLATE_IGNORES, sgMirrorScope.getSettingsType(), hashMap);
            SgMirrorService.initDefaultSetting(sgSettings, SgMirrorOption.TRANSLATE_EOLS, sgMirrorScope.getSettingsType(), hashMap);
            SgMirrorService.initDefaultSetting(sgSettings, SgMirrorOption.AUTHORS_MAPPING, sgMirrorScope.getSettingsType(), hashMap);
            SgMirrorService.initDefaultSetting(sgSettings, SgMirrorOption.SVN_FETCH_INTERVAL, sgMirrorScope.getSettingsType(), hashMap);
            SgMirrorService.initDefaultSetting(sgSettings, SgMirrorOption.CREDENTIALS, sgMirrorScope.getSettingsType(), hashMap);
            SgMirrorService.initDefaultSetting(sgSettings, SgMirrorOption.CORE_DEFAULT_DOMAIN, sgMirrorScope.getSettingsType(), hashMap);
        }
        sgSettings = this.settingsService.createValuesSettings(sgMirrorScope.getSettingsType(), sgSettings, hashMap);
        return sgSettings.snapshot(SgMirrorOption.all());
    }

    public SgSettings loadInstallConfiguration(SgMirrorScope sgMirrorScope, m m2, SgSettings sgSettings, boolean bl2) {
        String string = SgTextUtil.loadTextFileContents(bl2 ? this.getActiveUserVisibleConfigFile(m2) : this.getUserVisibleConfigFile(m2), this.log);
        SgSettings sgSettings2 = this.settingsService.createConfigSettings(sgMirrorScope.getSettingsType(), sgSettings, string);
        HashMap<SgSetting, String> hashMap = new HashMap<SgSetting, String>();
        hashMap.put(SgMirrorOption.CONFIG, string);
        String string2 = SgTextUtil.loadTextFileContents(m2.m(), this.log);
        hashMap.put(SgMirrorOption.AUTHORS, string2);
        return this.settingsService.createValuesSettings(sgMirrorScope.getSettingsType(), sgSettings2, hashMap);
    }

    public Map loadLegacyStatus(File file) {
        String string = SgTextUtil.loadTextFileContents(file, this.log);
        Map map = (Map)new GsonBuilder().create().fromJson(string, Map.class);
        if (map != null && map.get("status") instanceof Map) {
            return (Map)map.get("status");
        }
        return null;
    }

    public String loadSvnUUID(com.atlassian.bitbucket.repository.Repository repository) {
        c c2 = c.b(this.getMetadataDirectory(repository));
        return SgTextUtil.loadTextFileContents(c2.x(), this.log);
    }

    private SgUnsyncedRef[] loadConflicts(com.atlassian.bitbucket.repository.Repository repository) {
        try {
            b b2 = this.createProxyRepository(repository);
            G g2 = b2.G();
            List list = b2.b(g2);
            if (list.size() > 0) {
                aj aj2 = (aj)list.get(0);
                List list2 = this.conflictsService.loadConflicts(repository, aj2);
                return list2.toArray(new SgUnsyncedRef[0]);
            }
        }
        catch (f f2) {
            d.getLogger().info(f2.getMessage(), f2);
        }
        return new SgUnsyncedRef[0];
    }

    private static void initDefaultSetting(SgSettings sgSettings, SgSetting sgSetting, SgSettingsType sgSettingsType, Map map) {
        if (sgSettings.get(sgSetting, sgSettingsType) == null) {
            map.put(sgSetting, sgSettings.get(sgSetting, new SgSettingsType[0]));
        }
    }

    private static boolean isLocalMirrorInstalled(File file) {
        O o2 = new O();
        ab ab2 = Z.a(file);
        Repository repository = o2.createGitRepositoryInstance(ab2, false);
        try {
            m m2 = aG.a(repository, o2, ab2);
            boolean bl2 = m2 instanceof org.tmatesoft.translator.m.c.c;
            if (repository != null) {
                repository.close();
            }
            return bl2;
        }
        catch (Throwable throwable) {
            try {
                if (repository != null) {
                    try {
                        repository.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Throwable throwable3) {
                return false;
            }
        }
    }

    public boolean shouldSync(com.atlassian.bitbucket.repository.Repository repository, SgSvnSyncInfo sgSvnSyncInfo) {
        if (sgSvnSyncInfo == null || sgSvnSyncInfo.getUuid() == null) {
            return false;
        }
        ae ae2 = null;
        Repository repository2 = null;
        try {
            Z z2 = this.getGitRepositoryKey(repository);
            repository2 = this.getGitRepositoryFactory().createGitRepositoryInstance(z2, true);
            c c2 = c.b(this.getMetadataDirectory(repository));
            File file = this.getGitRepositoryFactory().getSgkRepositoryRoot(z2);
            p p2 = this.getGitRepositoryFactory().getGitCommandRunner(z2, null);
            ae2 = ae.a(repository2, file, aA.a, aS.a, false, true, p2);
            boolean bl2 = ae2.x();
            if (!bl2) {
                File file2 = ae2.k().g();
                this.log.debug("\"" + file2.getAbsolutePath() + "\" is missing, the synchronization will not be performed");
                boolean bl3 = false;
                return bl3;
            }
            File file3 = c2.x();
            if (!SgFileUtil.isFileExistsAndReadable(file3)) {
                throw new SgException("\"" + file3.getAbsolutePath() + "\" is missing, the synchronization will not be performed");
            }
            String string = SgTextUtil.loadTextFileContents(file3, this.log);
            if (!sgSvnSyncInfo.getUuid().equals(string)) {
                this.log.debug("Not synchronizing repository '" + z2.a() + "' because it's SVN UUID '" + string + "' doesn't match '" + sgSvnSyncInfo.getUuid() + "' from the REST request");
                boolean bl4 = false;
                return bl4;
            }
            if (sgSvnSyncInfo.getAffectedPaths().isEmpty()) {
                this.log.debug("No paths provided to the REST request, synchronizing the repository '" + z2.a() + "'");
                boolean bl5 = true;
                return bl5;
            }
            ah ah2 = ae2.i();
            Collection collection = ah2.b();
            if (collection.size() != 1) {
                throw new SgException("Wrong '" + z2.a() + "' repository configuration, the synchronization will not be performed");
            }
            aB aB2 = ae2.a((aC)collection.iterator().next());
            long l2 = aB2.e();
            if (SVNRevision.isValidRevisionNumber(l2) && l2 >= sgSvnSyncInfo.getRevision()) {
                this.log.debug("Revision '" + sgSvnSyncInfo.getRevision() + "' has been already synced for repository at '" + z2.a() + "'");
                boolean bl6 = false;
                return bl6;
            }
            String string2 = aB2.k();
            this.log.debug("Path prefix '" + string2 + "'");
            M m2 = SgMirrorService.buildLogEntry(string2, sgSvnSyncInfo);
            if (m2 == null) {
                throw new SgException("Failed to build log entry, wrong REST request");
            }
            if (m2.b().c()) {
                this.log.debug("No changes within the path prefix '" + string2 + "', the synchronization will not be performed");
                boolean bl7 = false;
                return bl7;
            }
            this.log.debug("Log entry for synchronization: '" + String.valueOf(m2) + "'");
            this.log.debug("Log entry changes for synchronization: '" + String.valueOf(m2.b()) + "'");
            ai ai2 = aB2.b().e();
            this.log.debug("Layout: '" + String.valueOf(ai2) + "'");
            boolean bl8 = H.a(m2, ai2);
            return bl8;
        }
        catch (com.a.a.a.b.i | f exception) {
            throw SgException.wrap(exception);
        }
        finally {
            if (repository2 != null) {
                repository2.close();
            }
            if (ae2 != null) {
                ae2.C();
            }
        }
    }

    private static M buildLogEntry(String string, SgSvnSyncInfo sgSvnSyncInfo) {
        com.a.a.a.c.f f2 = new com.a.a.a.c.f();
        for (String string2 : sgSvnSyncInfo.getAffectedPaths()) {
            if (!"".equals(string) && string2.startsWith(string + "/")) {
                string2 = string2.substring((string + "/").length());
            } else if (!"".equals(string)) {
                string2 = null;
            }
            if (string2 == null) continue;
            if (string2.endsWith("/")) {
                string2 = string2.substring(0, string2.length() - "/".length());
            }
            f2.a(new e(string2, sgSvnSyncInfo.getRevision(), 'M', false));
        }
        try {
            return new M(sgSvnSyncInfo.getRevision(), f2, new PersonIdent("name", "email"), "name", "", au.a(SVNURL.parseURIEncoded("http://host/path")), sgSvnSyncInfo.getUuid());
        }
        catch (k | SVNException exception) {
            return null;
        }
    }

    public n getDummyConsole() {
        return new n(new PrintStream(SVNFileUtil.DUMMY_OUT), new PrintStream(SVNFileUtil.DUMMY_OUT));
    }

    public Repository createGitRepository(com.atlassian.bitbucket.repository.Repository repository) {
        return this.getGitRepositoryFactory().createGitRepositoryInstance(this.getGitRepositoryKey(repository), true);
    }
}

