/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.subgit.stash.mirror;

import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.tmatesoft.subgit.stash.mirror.SgAuthorsMappingOptions;
import org.tmatesoft.subgit.stash.mirror.SgCredentials;
import org.tmatesoft.subgit.stash.mirror.SgMirrorOption$OptionType;
import org.tmatesoft.subgit.stash.mirror.SgMirrorStage;
import org.tmatesoft.subgit.stash.mirror.SgUnsyncedRef;
import org.tmatesoft.subgit.stash.mirror.settings.SgSetting;
import org.tmatesoft.subgit.stash.mirror.settings.SgSettingsType;
import org.tmatesoft.subgit.stash.mirror.tasks.SgMirrorStartType;
import org.tmatesoft.subgit.stash.mirror.tasks.SgRepositoryAccessType;
import org.tmatesoft.subgit.stash.mirror.util.SgAuthorisationOptions;
import org.tmatesoft.subgit.stash.mirror.util.SgLayoutType;
import org.tmatesoft.subgit.stash.mirror.util.SgLongPollOptions;
import org.tmatesoft.subgit.stash.mirror.util.SgPerformanceOption;
import org.tmatesoft.subgit.stash.mirror.util.SgSchedulerOptions;
import org.tmatesoft.subgit.stash.mirror.util.SgSupportZip;
import org.tmatesoft.subgit.stash.mirror.util.SgVerifyInfo;

public class SgMirrorOption {
    public static SgSettingsType USER = new SgSettingsType("user");
    public static SgSettingsType USER_FILE = new SgSettingsType("user_file");
    public static SgSettingsType REPOSITORY = new SgSettingsType("repository");
    public static SgSettingsType PROJECT = new SgSettingsType("project");
    public static SgSettingsType GLOBAL = new SgSettingsType("global");
    private static final Map settingGroups = new HashMap();
    public static final SgSetting HOOK_TIMEOUT = SgMirrorOption.register(SgSetting.create("hookTimeout", Integer.class, 20), new SgMirrorOption$OptionType[0]);
    public static final SgSetting SCHEDULER_OPTIONS = SgMirrorOption.register(SgSetting.create("schedulerOptions", SgSchedulerOptions.class, new SgSchedulerOptions(8, 60, 13)), new SgMirrorOption$OptionType[0]);
    public static final SgSetting LONG_POLL_OPTIONS = SgMirrorOption.register(SgSetting.create("longPollOptions", SgLongPollOptions.class, new SgLongPollOptions(120, true)), new SgMirrorOption$OptionType[0]);
    public static final SgSetting AUTHORISATION_OPTIONS = SgMirrorOption.register(SgSetting.create("authorisationOptions", SgAuthorisationOptions.class, new SgAuthorisationOptions("svn-mirror", "svn-import", false, true)), new SgMirrorOption$OptionType[0]);
    public static final SgSetting LOG_LEVEL = SgMirrorOption.register(SgSetting.create("logLevel", String.class, "WARN"), new SgMirrorOption$OptionType[0]);
    public static final SgSetting MIRROR_TRACKING_MODE = SgMirrorOption.register(SgSetting.create("mirrorTrackingMode", SgPerformanceOption.class, (Object)SgPerformanceOption.TRACK_ACTIVE), new SgMirrorOption$OptionType[0]);
    public static final SgSetting BOOTSTRAP_POOL_SIZE = SgMirrorOption.register(SgSetting.create("bootstrapPoolSize", Integer.class, 32), new SgMirrorOption$OptionType[0]);
    public static final SgSetting INTERACTIVE_POOL_SIZE = SgMirrorOption.register(SgSetting.create("interactivePoolSize", Integer.class, -1), new SgMirrorOption$OptionType[0]);
    public static final SgSetting REST_POOL_SIZE = SgMirrorOption.register(SgSetting.create("restPoolSize", Integer.class, 8), new SgMirrorOption$OptionType[0]);
    public static final SgSetting STAGE = SgMirrorOption.register(SgSetting.create("stage", SgMirrorStage.class, (Object)SgMirrorStage.INITIAL), SgMirrorOption$OptionType.SYNTHETIC);
    public static final SgSetting ON_MESH = SgMirrorOption.register(SgSetting.create("onMesh", Boolean.class, false), SgMirrorOption$OptionType.SYNTHETIC);
    public static final SgSetting UNSYNCED_REFS = SgMirrorOption.register(SgSetting.create("unsyncedRefs", SgUnsyncedRef[].class, null), SgMirrorOption$OptionType.SYNTHETIC);
    public static final SgSetting UNSYNCED_REFS_COMMANDS = SgMirrorOption.register(SgSetting.create("unsyncedRefsCommands", SgUnsyncedRef[].class, null), new SgMirrorOption$OptionType[0]);
    public static final SgSetting FORCE_REFETCH = SgMirrorOption.register(SgSetting.create("forceRefetch", Boolean.class, false), new SgMirrorOption$OptionType[0]);
    public static final SgSetting FORCE_REBUILD = SgMirrorOption.register(SgSetting.create("forceRebuild", Boolean.class, false), new SgMirrorOption$OptionType[0]);
    public static final SgSetting HAS_UNSYNCED_REFS = SgMirrorOption.register(SgSetting.create("hasUnsyncedRefs", Boolean.class, false), SgMirrorOption$OptionType.SYNTHETIC);
    public static final SgSetting REPOSITORY_PATH = SgMirrorOption.register(SgSetting.create("repositoryPath", File.class), SgMirrorOption$OptionType.SYNTHETIC);
    public static final SgSetting METADATA_PATH = SgMirrorOption.register(SgSetting.create("metadataPath", File.class), SgMirrorOption$OptionType.SYNTHETIC);
    public static final SgSetting REPOSITORY_EMPTY = SgMirrorOption.register(SgSetting.create("repositoryEmpty", Boolean.class), SgMirrorOption$OptionType.SYNTHETIC);
    public static final SgSetting REPOSITORY_SLUG = SgMirrorOption.register(SgSetting.create("repositorySlug", String.class), SgMirrorOption$OptionType.SYNTHETIC);
    public static final SgSetting REPOSITORY_NAME = SgMirrorOption.register(SgSetting.create("repositoryName", String.class), SgMirrorOption$OptionType.SYNTHETIC);
    public static final SgSetting PROJECT_KEY = SgMirrorOption.register(SgSetting.create("projectKey", String.class), SgMirrorOption$OptionType.SYNTHETIC);
    public static final SgSetting PROJECT_NAME = SgMirrorOption.register(SgSetting.create("projectName", String.class), SgMirrorOption$OptionType.SYNTHETIC);
    public static final SgSetting DEFAULT_SVN_CACHE_PATH = SgMirrorOption.register(SgSetting.create("defaultCachePath", File.class), SgMirrorOption$OptionType.SYNTHETIC);
    public static final SgSetting SVN_UUID = SgMirrorOption.register(SgSetting.create("svnUUID", String.class), SgMirrorOption$OptionType.SYNTHETIC);
    public static final SgSetting SYNCED = SgMirrorOption.register(SgSetting.create("synced", Long.class, 0L), SgMirrorOption$OptionType.SYNTHETIC);
    public static final SgSetting SUPPORT_ZIPS = SgMirrorOption.register(SgSetting.create("supportZips", SgSupportZip[].class, new SgSupportZip[0]), SgMirrorOption$OptionType.SYNTHETIC);
    public static final SgSetting PAUSED = SgMirrorOption.register(SgSetting.create("paused", true), new SgMirrorOption$OptionType[0]);
    public static final SgSetting IMPORT = SgMirrorOption.register(SgSetting.create("importRequested", false), new SgMirrorOption$OptionType[0]);
    public static final SgSetting CONFIG = SgMirrorOption.register(SgSetting.create("config", String.class), new SgMirrorOption$OptionType[0]);
    public static final SgSetting AUTHORS = SgMirrorOption.register(SgSetting.create("authors", String.class), new SgMirrorOption$OptionType[0]);
    public static final SgSetting CREDENTIALS = SgMirrorOption.register(SgSetting.create("credentials", SgCredentials.class, SgCredentials.builder().setUseCache(true).build()), new SgMirrorOption$OptionType[0]);
    public static final SgSetting AUTHORS_MAPPING = SgMirrorOption.register(SgSetting.create("authorsMapping", SgAuthorsMappingOptions.DEFAULT), new SgMirrorOption$OptionType[0]);
    public static final SgSetting TRUNK_PATH = SgMirrorOption.register(SgSetting.create("trunkPath", String.class, null), new SgMirrorOption$OptionType[0]);
    public static final SgSetting LAYOUT_TYPE = SgMirrorOption.register(SgSetting.create("layoutType", SgLayoutType.class, (Object)SgLayoutType.AUTO), new SgMirrorOption$OptionType[0]);
    public static final SgSetting GENERATE_AUTHORS_MAPPING_ON_CONFIGURE = SgMirrorOption.register(SgSetting.create("generateAuthorsMappingOnConfigure", Boolean.class, true), new SgMirrorOption$OptionType[0]);
    public static final SgSetting CORE_DEFAULT_DOMAIN = SgMirrorOption.register(SgSetting.create("core.defaultDomain", String.class, null), new SgMirrorOption$OptionType[0]);
    public static final SgSetting CORE_AUTHORS_FILE_ENCODING = SgMirrorOption.register(SgSetting.create("core.authorsFileEncoding", StandardCharsets.UTF_8.name()), new SgMirrorOption$OptionType[0]);
    public static final SgSetting CORE_AUTHORS_FILE = SgMirrorOption.register(SgSetting.create("core.authorsFile", String.class, null), new SgMirrorOption$OptionType[0]);
    public static final SgSetting SVN_URL = SgMirrorOption.register(SgSetting.create("svn.url", String.class), new SgMirrorOption$OptionType[0]);
    public static final SgSetting SVN_MINIMAL_REVISION = SgMirrorOption.register(SgSetting.create("svn.minimalRevision", Long.class, 1L), new SgMirrorOption$OptionType[0]);
    public static final SgSetting SVN_READ_TIMEOUT = SgMirrorOption.register(SgSetting.create("svn.readTimeout", 600), new SgMirrorOption$OptionType[0]);
    public static final SgSetting SVN_CONNECT_TIMEOUT = SgMirrorOption.register(SgSetting.create("svn.connectTimeout", 300), new SgMirrorOption$OptionType[0]);
    public static final SgSetting SVN_HTTP_SPOOLING = SgMirrorOption.register(SgSetting.create("svn.httpSpooling", true), new SgMirrorOption$OptionType[0]);
    public static final SgSetting SVN_FETCH_INTERVAL = SgMirrorOption.register(SgSetting.create("svn.fetchInterval", 60), new SgMirrorOption$OptionType[0]);
    public static final SgSetting TRANSLATE_EOLS = SgMirrorOption.register(SgSetting.create("translate.eols", Boolean.class, false), new SgMirrorOption$OptionType[0]);
    public static final SgSetting TRANSLATE_IGNORES = SgMirrorOption.register(SgSetting.create("translate.ignores", Boolean.class, true), new SgMirrorOption$OptionType[0]);
    public static final SgSetting VERIFY_INFO = SgMirrorOption.register(SgSetting.create("verifyInfo", SgVerifyInfo.class, null), new SgMirrorOption$OptionType[0]);
    public static final SgSetting TRUNK_BINDING = SgMirrorOption.register(SgSetting.create("trunkBinding", String.class, null), new SgMirrorOption$OptionType[0]);
    public static final SgSetting SHELVES_BINDINGS = SgMirrorOption.register(SgSetting.create("shelvesBindings", String[].class, null), new SgMirrorOption$OptionType[0]);
    public static final SgSetting BRANCHES_BINDINGS = SgMirrorOption.register(SgSetting.create("branchesBindings", String[].class, null), new SgMirrorOption$OptionType[0]);
    public static final SgSetting TAGS_BINDINGS = SgMirrorOption.register(SgSetting.create("tagsBindings", String[].class, null), new SgMirrorOption$OptionType[0]);
    public static final SgSetting EXCLUDE_PATHS = SgMirrorOption.register(SgSetting.create("excludePaths", String[].class, null), new SgMirrorOption$OptionType[0]);
    public static final SgSetting EXCLUDE_BRANCHES = SgMirrorOption.register(SgSetting.create("excludeBranches", String[].class, null), new SgMirrorOption$OptionType[0]);
    public static final SgSetting INCLUDE_PATHS = SgMirrorOption.register(SgSetting.create("includePaths", String[].class, null), new SgMirrorOption$OptionType[0]);
    public static final SgSetting USER_AUTHORS = SgMirrorOption.register(SgSetting.create("userAuthors", String.class, null), new SgMirrorOption$OptionType[0]);
    public static final SgSetting START_MODE = SgMirrorOption.register(SgSetting.create("startMode", (Object)SgMirrorStartType.NONE), new SgMirrorOption$OptionType[0]);
    public static final SgSetting REPOSITORY_ACCESS_TYPE = SgMirrorOption.register(SgSetting.create("repositoryAccess", (Object)SgRepositoryAccessType.FILE), new SgMirrorOption$OptionType[0]);
    public static final SgSetting REPOSITORY_CACHE_EXPIRE_DELAY = SgMirrorOption.register(SgSetting.create("repositoryCacheExpireDelay", 2000L), new SgMirrorOption$OptionType[0]);
    public static final SgSetting REPOSITORY_CACHE_CLEANUP_DELAY = SgMirrorOption.register(SgSetting.create("repositoryCacheCleanupDelay", 1000L), new SgMirrorOption$OptionType[0]);

    private static SgSetting register(SgSetting sgSetting, SgMirrorOption$OptionType ... sgMirrorOption$OptionTypeArray) {
        SgMirrorOption.registerForGroup(sgSetting, SgMirrorOption$OptionType.ANY);
        if (sgMirrorOption$OptionTypeArray != null) {
            for (SgMirrorOption$OptionType sgMirrorOption$OptionType : sgMirrorOption$OptionTypeArray) {
                SgMirrorOption.registerForGroup(sgSetting, sgMirrorOption$OptionType);
            }
        }
        return sgSetting;
    }

    private static void registerForGroup(SgSetting sgSetting, SgMirrorOption$OptionType sgMirrorOption$OptionType) {
        if (!settingGroups.containsKey((Object)sgMirrorOption$OptionType)) {
            settingGroups.put(sgMirrorOption$OptionType, new HashSet());
        }
        ((Set)settingGroups.get((Object)sgMirrorOption$OptionType)).add(sgSetting);
    }

    public static Collection all() {
        return SgMirrorOption.settings(SgMirrorOption$OptionType.ANY);
    }

    public static Collection synthetic() {
        return SgMirrorOption.settings(SgMirrorOption$OptionType.SYNTHETIC);
    }

    public static Collection nonSynthetic() {
        HashSet hashSet = new HashSet(SgMirrorOption.all());
        hashSet.removeAll(SgMirrorOption.synthetic());
        return hashSet;
    }

    public static boolean isSynthetic(SgSetting sgSetting) {
        return sgSetting != null && SgMirrorOption.settings(SgMirrorOption$OptionType.SYNTHETIC).contains(sgSetting);
    }

    public static SgSetting byJsonName(String string) {
        for (SgSetting sgSetting : SgMirrorOption.all()) {
            if (!string.equals(sgSetting.getJsonKey())) continue;
            return sgSetting;
        }
        return null;
    }

    public static SgSetting byKey(String string) {
        for (SgSetting sgSetting : SgMirrorOption.all()) {
            if (!string.equals(sgSetting.getSettingsKey())) continue;
            return sgSetting;
        }
        return null;
    }

    private static Collection settings(SgMirrorOption$OptionType sgMirrorOption$OptionType) {
        if (settingGroups.containsKey((Object)sgMirrorOption$OptionType)) {
            return (Collection)settingGroups.get((Object)sgMirrorOption$OptionType);
        }
        return Collections.emptySet();
    }
}

