/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.subgit.stash.mirror;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Set;
import org.tmatesoft.subgit.stash.mirror.SgMirrorOption;
import org.tmatesoft.subgit.stash.mirror.settings.SgConfigSettings;
import org.tmatesoft.subgit.stash.mirror.settings.SgMapSettings;
import org.tmatesoft.subgit.stash.mirror.settings.SgSetting;
import org.tmatesoft.subgit.stash.mirror.settings.SgSettingsSnapshot;
import org.tmatesoft.subgit.stash.mirror.settings.SgSettingsType;

class SgMirrorJsonAdapterFactory$SgSettingsAdapter
extends TypeAdapter {
    private final Gson gson;

    public SgMirrorJsonAdapterFactory$SgSettingsAdapter(Gson gson) {
        this.gson = gson;
    }

    public void write(JsonWriter jsonWriter, SgSettingsSnapshot sgSettingsSnapshot) {
        if (sgSettingsSnapshot == null) {
            jsonWriter.nullValue();
            return;
        }
        jsonWriter.beginObject();
        SgSettingsType sgSettingsType = sgSettingsSnapshot.getType();
        SgSettingsType sgSettingsType2 = sgSettingsType.negate();
        Set set = sgSettingsSnapshot.keys(new SgSettingsType[0]);
        this.writeSettings(jsonWriter, sgSettingsSnapshot, sgSettingsType, set, true);
        jsonWriter.name("defaults");
        jsonWriter.beginObject();
        this.writeSettings(jsonWriter, sgSettingsSnapshot, sgSettingsType2, set, false);
        jsonWriter.endObject();
        jsonWriter.endObject();
    }

    private void writeSettings(JsonWriter jsonWriter, SgSettingsSnapshot sgSettingsSnapshot, SgSettingsType sgSettingsType, Collection collection, boolean bl2) {
        for (SgSetting sgSetting : collection) {
            if (!bl2 && SgMirrorOption.isSynthetic(sgSetting)) continue;
            String string = sgSetting.getJsonKey();
            Object object = sgSettingsSnapshot.get(sgSetting, sgSettingsType);
            jsonWriter.name(string);
            if (object != null) {
                this.gson.toJson(object, object.getClass(), jsonWriter);
                continue;
            }
            jsonWriter.nullValue();
        }
    }

    @Override
    public SgSettingsSnapshot read(JsonReader jsonReader) {
        if (jsonReader.peek() == JsonToken.NULL) {
            jsonReader.nextNull();
            return null;
        }
        SgMapSettings sgMapSettings = new SgMapSettings(SgMirrorOption.USER_FILE, null);
        SgMapSettings sgMapSettings2 = new SgMapSettings(SgMirrorOption.USER, sgMapSettings);
        SgConfigSettings sgConfigSettings = new SgConfigSettings(SgMirrorOption.USER, sgMapSettings2, this.gson);
        jsonReader.beginObject();
        while (jsonReader.peek() != JsonToken.END_OBJECT) {
            String string;
            Object object;
            String string2 = jsonReader.nextName();
            SgSetting sgSetting = SgMirrorOption.byJsonName(string2);
            if (sgSetting == null) {
                this.gson.fromJson(jsonReader, (Type)((Object)Object.class));
                continue;
            }
            if (SgMirrorOption.CONFIG.equals(sgSetting) && jsonReader.peek() == JsonToken.STRING) {
                object = jsonReader.nextString();
                string = (String)this.gson.fromJson((String)object, String.class);
                sgMapSettings.set(sgSetting, string);
                if (string == null) continue;
                sgConfigSettings.load(string);
                continue;
            }
            if (SgMirrorOption.AUTHORS.equals(sgSetting) && jsonReader.peek() == JsonToken.STRING) {
                object = jsonReader.nextString();
                string = (String)this.gson.fromJson((String)object, String.class);
                sgMapSettings.set(sgSetting, string);
                continue;
            }
            object = this.gson.fromJson(jsonReader, (Type)sgSetting.getType());
            if (SgMirrorOption.isSynthetic(sgSetting)) continue;
            sgMapSettings2.set(sgSetting, object);
        }
        jsonReader.endObject();
        return sgConfigSettings.snapshot(SgMirrorOption.nonSynthetic());
    }
}

