/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.subgit.stash.mirror;

import com.a.a.a.a.p;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.scm.git.command.GitCommandBuilderFactory;
import java.io.File;
import java.util.Collection;
import org.eclipse.jgit.lib.Repository;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.tmatesoft.subgit.stash.mirror.SgGitRepositoryFactory$CmdlineFactory;
import org.tmatesoft.subgit.stash.mirror.SgGitRepositoryFactory$FileFactory;
import org.tmatesoft.subgit.stash.mirror.SgMeshService;
import org.tmatesoft.subgit.stash.mirror.SgMirrorOption;
import org.tmatesoft.subgit.stash.mirror.settings.SgSettingsService;
import org.tmatesoft.subgit.stash.mirror.settings.SgSettingsType;
import org.tmatesoft.subgit.stash.mirror.tasks.SgMirrorScope;
import org.tmatesoft.subgit.stash.mirror.tasks.SgRepositoryAccessType;
import org.tmatesoft.subgit.stash.mirror.util.SgLoggerFactory;
import org.tmatesoft.subgit.stash.web.SgPluginPropertiesService;
import org.tmatesoft.translator.b.G;
import org.tmatesoft.translator.m.Z;
import org.tmatesoft.translator.m.g;
import org.tmatesoft.translator.util.f;
import org.tmatesoft.translator.util.l;

public class SgGitRepositoryFactory
implements g {
    private final SgPluginPropertiesService pluginPropertiesService;
    private final SgLoggerFactory loggerFactory;
    private final SgSettingsService settingsService;
    private final SgMeshService meshService;
    private final RepositoryService repositoryService;
    private final GitCommandBuilderFactory commandBuilderFactory;
    private final Logger log;
    private final SgGitRepositoryFactory$FileFactory fileFactory;
    private final SgGitRepositoryFactory$CmdlineFactory cmdlineFactory;

    public SgGitRepositoryFactory(SgPluginPropertiesService sgPluginPropertiesService, SgLoggerFactory sgLoggerFactory, SgSettingsService sgSettingsService, SgMeshService sgMeshService, RepositoryService repositoryService, GitCommandBuilderFactory gitCommandBuilderFactory) {
        this.log = sgLoggerFactory.getLogger("repository-factory");
        this.pluginPropertiesService = sgPluginPropertiesService;
        this.loggerFactory = sgLoggerFactory;
        this.settingsService = sgSettingsService;
        this.meshService = sgMeshService;
        this.repositoryService = repositoryService;
        this.commandBuilderFactory = gitCommandBuilderFactory;
        this.fileFactory = new SgGitRepositoryFactory$FileFactory(this);
        this.cmdlineFactory = new SgGitRepositoryFactory$CmdlineFactory(this);
    }

    @NotNull
    private g getFactory(com.atlassian.bitbucket.repository.Repository repository) {
        SgRepositoryAccessType sgRepositoryAccessType = this.getAccessType(repository);
        if (sgRepositoryAccessType == SgRepositoryAccessType.FILE) {
            return this.fileFactory;
        }
        if (sgRepositoryAccessType == SgRepositoryAccessType.CMDLINE) {
            return this.cmdlineFactory;
        }
        throw f.b("Unknown repository access type: %s", new Object[]{sgRepositoryAccessType});
    }

    @NotNull
    public SgRepositoryAccessType getAccessType(com.atlassian.bitbucket.repository.Repository repository) {
        if (this.meshService.isOnMesh(repository)) {
            this.log.debug("[R-{}] is on Mesh, forcing 'cmdline' access type", (Object)repository.getId());
            return SgRepositoryAccessType.CMDLINE;
        }
        return (SgRepositoryAccessType)((Object)this.settingsService.createSettingsForScope(SgMirrorScope.global()).get(SgMirrorOption.REPOSITORY_ACCESS_TYPE, new SgSettingsType[0]));
    }

    @NotNull
    private com.atlassian.bitbucket.repository.Repository getBitbucketRepository(Z z2) {
        com.atlassian.bitbucket.repository.Repository repository = this.getRepositoryOrNull(z2);
        if (repository == null) {
            throw new l(z2, "Invalid repository key: '%s'", z2.a());
        }
        return repository;
    }

    @Override
    @NotNull
    public Repository createGitRepositoryInstance(@NotNull Z z2, boolean bl2) {
        return this.getFactory(this.getBitbucketRepository(z2)).createGitRepositoryInstance(z2, bl2);
    }

    @Override
    @NotNull
    public org.tmatesoft.translator.m.f createGitRepositoryArea(@NotNull Z z2) {
        return this.getFactory(this.getBitbucketRepository(z2)).createGitRepositoryArea(z2);
    }

    @Override
    @NotNull
    public p getGitCommandRunner(@NotNull Z z2, @Nullable G g2) {
        return this.getFactory(this.getBitbucketRepository(z2)).getGitCommandRunner(z2, g2);
    }

    @Override
    public void removeFromGitRepositoryCache(@NotNull Z z2) {
        this.fileFactory.removeFromGitRepositoryCache(z2);
        this.cmdlineFactory.removeFromGitRepositoryCache(z2);
    }

    @Override
    public void updateGitCachedRepositoryPacks(@NotNull Z z2, @NotNull Collection collection) {
        this.fileFactory.updateGitCachedRepositoryPacks(z2, collection);
        this.cmdlineFactory.updateGitCachedRepositoryPacks(z2, collection);
    }

    @Override
    @NotNull
    public File getSgkRepositoryRoot(@NotNull Z z2) {
        return this.pluginPropertiesService.getMetadataDirectory(z2.c().e());
    }

    @Nullable
    private com.atlassian.bitbucket.repository.Repository getRepositoryOrNull(Z z2) {
        return this.repositoryService.getById(z2.c().e());
    }
}

