/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.subgit.stash.mirror;

import com.a.a.a.b.i;
import com.a.a.a.c.a.b;
import com.a.a.a.c.a.e;
import com.atlassian.bitbucket.server.StorageService;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.UserAdminService;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageRequestImpl;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.tmatesoft.subgit.stash.mirror.SgAuthorsMappingOptions;
import org.tmatesoft.subgit.stash.mirror.SgAuthorsService$StashAuthorsMapping;
import org.tmatesoft.subgit.stash.mirror.SgException;
import org.tmatesoft.subgit.stash.mirror.SgMirrorOption;
import org.tmatesoft.subgit.stash.mirror.settings.SgSettings;
import org.tmatesoft.subgit.stash.mirror.settings.SgSettingsType;
import org.tmatesoft.subgit.stash.mirror.util.SgFileUtil;
import org.tmatesoft.subgit.stash.mirror.util.SgLoggerFactory;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.translator.b.D;
import org.tmatesoft.translator.b.a;
import org.tmatesoft.translator.b.c;
import org.tmatesoft.translator.h.d;
import org.tmatesoft.translator.m.J;
import org.tmatesoft.translator.m.m;
import org.tmatesoft.translator.util.u;

public class SgAuthorsService {
    private final UserAdminService userAdminService;
    private final StorageService storageService;
    private final Logger log;
    private final UserService userService;
    private String defaultDomain;

    public SgAuthorsService(StorageService storageService, UserAdminService userAdminService, UserService userService, SgLoggerFactory sgLoggerFactory) {
        this.storageService = storageService;
        this.log = sgLoggerFactory.getLogger("authors");
        this.userAdminService = userAdminService;
        this.userService = userService;
    }

    public void generateAuthorsMapping(SVNRepository sVNRepository, String string, String string2, File file) {
        TreeSet treeSet = new TreeSet();
        d.getLogger().info("generating authors mapping from Subversion history at '%s'", sVNRepository.getLocation());
        try {
            sVNRepository.log(null, -1L, 0L, false, false, sVNLogEntry -> {
                if (sVNLogEntry.getAuthor() != null) {
                    treeSet.add(sVNLogEntry.getAuthor());
                }
            });
        }
        catch (SVNException sVNException) {
            d.getLogger().info(sVNException);
            throw SgException.wrap(sVNException);
        }
        finally {
            sVNRepository.closeSession();
        }
        d.getLogger().info("  %s authors found", treeSet.size());
        com.a.a.a.c.a.c c2 = new com.a.a.a.c.a.c();
        for (String string3 : treeSet) {
            c2.a(string3, string3, this.getEmailForShortName(string3, string));
        }
        com.a.a.a.c.a.a a2 = c2.a();
        try {
            com.a.a.a.c.a.d.a(a2, file, string2);
            d.getLogger().info("  authors mapping saved to '%s'", file);
        }
        catch (i i2) {
            d.getLogger().info(i2);
        }
    }

    private String getEmailForShortName(String string, String string2) {
        return string.replaceAll("\\s+", ".") + "@" + string2;
    }

    public void processStashAndExplicitlySpecifiedUsers(File file, String string, String string2) {
        Object object;
        Object object22;
        if (!SgFileUtil.isFileExistsAndReadable(file)) {
            return;
        }
        com.a.a.a.c.a.a a2 = null;
        if (string != null) {
            a2 = com.a.a.a.c.a.d.a(new ByteArrayInputStream(string.getBytes(string2)), null, string2, false);
        }
        d.getLogger().info("updating authors mapping to exclude Bitbucket users");
        com.a.a.a.c.a.a a3 = com.a.a.a.c.a.d.a(file, StandardCharsets.UTF_8.name());
        TreeMap<String, b> treeMap = new TreeMap<String, b>();
        for (Object object22 : a3) {
            treeMap.put(((b)object22).b(), (b)object22);
        }
        Set set = this.userService.getUsersByName(new HashSet(treeMap.keySet()));
        d.getLogger().info("  %s matching Bitbucket users found", set.size());
        object22 = new HashMap();
        Object object3 = set.iterator();
        while (object3.hasNext()) {
            object = (ApplicationUser)object3.next();
            object22.put(object.getName(), object);
        }
        object3 = new StringBuilder();
        object = new StringBuilder();
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        String string3 = u.a().f("authors");
        String string4 = org.tmatesoft.translator.b.e.a(string3 != null ? string3 : "");
        stringBuilder2.append(string4);
        stringBuilder2.append("#\n");
        StringBuilder stringBuilder3 = new StringBuilder();
        stringBuilder3.append("#\n");
        stringBuilder3.append("# Mappings below are commented out because there are matching Bitbucket users.\n");
        stringBuilder3.append("# Uncomment those mappings in case 'Map Subversion Users to Bitbucket Users' option is disabled\n");
        stringBuilder3.append("# or if you would like to override Bitbucket user mapping with the custom values.\n");
        stringBuilder3.append("#\n");
        StringBuilder stringBuilder4 = new StringBuilder();
        stringBuilder4.append("#\n");
        stringBuilder4.append("# These mappings from SVN history below are commented out because\n");
        stringBuilder4.append("# they conflict with explicitly specified users.\n");
        stringBuilder4.append("#\n");
        for (String string5 : treeMap.keySet()) {
            b b2 = (b)treeMap.get(string5);
            ApplicationUser applicationUser = (ApplicationUser)object22.get(string5);
            b b3 = null;
            if (a2 != null) {
                for (b b4 : a2) {
                    if (!b4.a(string5) && !b4.b(b2.c())) continue;
                    b3 = b4;
                }
            }
            if (b3 != null) {
                if (b3.b(b2.c()) && b3.a(b2.a()) && b3.c(b2.b())) continue;
                stringBuilder.append("# ");
                stringBuilder.append(string5);
                stringBuilder.append(" = ");
                stringBuilder.append(b2.b());
                stringBuilder.append(" <");
                stringBuilder.append(b2.c());
                stringBuilder.append(">\n");
                continue;
            }
            if (applicationUser == null) {
                ((StringBuilder)object3).append(string5);
                ((StringBuilder)object3).append(" = ");
                ((StringBuilder)object3).append(b2.b());
                ((StringBuilder)object3).append(" <");
                ((StringBuilder)object3).append(b2.c());
                ((StringBuilder)object3).append(">\n");
                continue;
            }
            ((StringBuilder)object).append("# ");
            ((StringBuilder)object).append(string5);
            ((StringBuilder)object).append(" = ");
            ((StringBuilder)object).append(applicationUser.getDisplayName());
            if (applicationUser.getEmailAddress() != null) {
                ((StringBuilder)object).append(" <");
                ((StringBuilder)object).append(applicationUser.getEmailAddress());
                ((StringBuilder)object).append(">\n");
                continue;
            }
            ((StringBuilder)object).append(" <");
            ((StringBuilder)object).append(b2.c());
            ((StringBuilder)object).append(">\n");
        }
        if (((StringBuilder)object3).length() > 0 && ((StringBuilder)object).length() > 0) {
            ((StringBuilder)object3).append("\n");
        }
        d.getLogger().info("  authors mapping generated");
        try (BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));){
            if (((StringBuilder)object3).length() > 0) {
                stringBuilder2.append("\n");
            }
            ((OutputStream)bufferedOutputStream).write(stringBuilder2.toString().getBytes(string2));
            if (((StringBuilder)object3).length() > 0) {
                ((OutputStream)bufferedOutputStream).write(((StringBuilder)object3).toString().getBytes(string2));
            }
            if (((StringBuilder)object).length() > 0) {
                ((OutputStream)bufferedOutputStream).write(stringBuilder3.toString().getBytes(string2));
                ((OutputStream)bufferedOutputStream).write(((StringBuilder)object).toString().getBytes(string2));
            }
            if (stringBuilder.length() > 0) {
                ((OutputStream)bufferedOutputStream).write("\n".getBytes(string2));
                ((OutputStream)bufferedOutputStream).write(stringBuilder4.toString().getBytes(string2));
                ((OutputStream)bufferedOutputStream).write(stringBuilder.toString().getBytes(string2));
            }
            if (string != null && string.length() > 0) {
                ((OutputStream)bufferedOutputStream).write("\n".getBytes(string2));
                ((OutputStream)bufferedOutputStream).write(string.getBytes(string2));
            }
        }
        catch (IOException iOException) {
            d.getLogger().info(iOException);
        }
        d.getLogger().info("  authors mapping saved to '%s'", file);
    }

    public e loadAuthorsMapping(SgSettings sgSettings, m m2) {
        String string = (String)sgSettings.get(SgMirrorOption.CORE_AUTHORS_FILE_ENCODING, new SgSettingsType[0]);
        String string2 = (String)sgSettings.get(SgMirrorOption.CORE_DEFAULT_DOMAIN, new SgSettingsType[0]);
        File file = m2.m();
        File file2 = this.getGlobalAuthorsFile();
        String string3 = (String)sgSettings.get(SgMirrorOption.CORE_AUTHORS_FILE, new SgSettingsType[0]);
        e e2 = new J(string2);
        SgAuthorsMappingOptions sgAuthorsMappingOptions = (SgAuthorsMappingOptions)sgSettings.get(SgMirrorOption.AUTHORS_MAPPING, new SgSettingsType[0]);
        if (sgAuthorsMappingOptions.useGlobal() && SgFileUtil.isFileExistsAndReadable(file2)) {
            try {
                e2 = com.a.a.a.c.a.d.a(file2, e2, string, false);
            }
            catch (i i2) {
                // empty catch block
            }
        }
        if (sgAuthorsMappingOptions.useStash()) {
            e2 = new SgAuthorsService$StashAuthorsMapping(this, e2, string2);
        }
        if (sgAuthorsMappingOptions.useLocal() && SgFileUtil.isFileExistsAndReadable(file)) {
            try {
                e2 = com.a.a.a.c.a.d.a(file, e2, string, false);
            }
            catch (i i3) {
                // empty catch block
            }
        }
        if (string3 != null) {
            D d2 = D.a(string3, m2.i());
            if (d2 != null && d2.c()) {
                e2 = new c(m2.d(), d2, string, e2);
            } else if (d2 != null && d2.a() != null) {
                e2 = new a(d2.a(), string, e2, false);
            }
        }
        return e2;
    }

    public File getGlobalAuthorsFile() {
        File file = new File(this.storageService.getDataDir().toFile(), "subgit");
        return new File(file, "authors.txt");
    }

    public File getLegacyGlobalAuthorsFile() {
        File file = new File(this.storageService.getHomeDir().toFile(), "subgit");
        return new File(file, "authors.txt");
    }

    public synchronized String findDefaultDomain() {
        if (this.defaultDomain == null) {
            try {
                this.log.info("discovering default email domain to use");
                this.defaultDomain = this.doFindDefaultDomain();
                this.log.info("default email domain: '" + this.defaultDomain + "'");
            }
            catch (Throwable throwable) {
                this.log.info("failed to discover default email domain");
                this.log.info(throwable.getMessage(), throwable);
            }
            if (this.defaultDomain == null) {
                this.defaultDomain = SgAuthorsService.resolveLocalHostName();
            }
        }
        return this.defaultDomain;
    }

    private String doFindDefaultDomain() {
        Object object;
        PageRequestImpl pageRequestImpl = new PageRequestImpl(0, 100);
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        do {
            object = this.userAdminService.findUsers((PageRequest)pageRequestImpl);
            for (Object object2 : object.getValues()) {
                String string = SgAuthorsService.getUserEmailDomain(object2);
                if (string == null) continue;
                if (hashMap.containsKey(string)) {
                    hashMap.put(string, (Integer)hashMap.get(string) + 1);
                    continue;
                }
                hashMap.put(string, 1);
            }
        } while (!object.getIsLastPage() && (pageRequestImpl = object.getNextPageRequest()) != null);
        object = new TreeMap(Collections.reverseOrder());
        for (Object object2 : hashMap.keySet()) {
            object.put((Integer)hashMap.get(object2), object2);
        }
        return object.isEmpty() ? SgAuthorsService.resolveLocalHostName() : (String)object.get(object.keySet().iterator().next());
    }

    private static String getUserEmailDomain(ApplicationUser applicationUser) {
        String string;
        if (applicationUser == null) {
            return null;
        }
        String string2 = applicationUser.getEmailAddress();
        if (string2 != null && string2.indexOf(64) >= 0 && (string = string2.substring(string2.indexOf(64) + 1)).length() > 0) {
            return string;
        }
        return null;
    }

    @NotNull
    private static String resolveLocalHostName() {
        try {
            String string;
            InetAddress inetAddress = InetAddress.getLocalHost();
            if (inetAddress != null && (string = inetAddress.getHostName()) != null && string.contains(".")) {
                return string;
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return "localhost";
    }

    public boolean isGlobalMappingFile(String string) {
        return string != null && this.getGlobalAuthorsFile().equals(new File(string));
    }

    public boolean isLocalMappingFile(String string) {
        if (string == null) {
            return false;
        }
        string = string.replace(File.separatorChar, '/');
        return "subgit/authors.txt".equals(string);
    }
}

