/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.table.engine;

import java.io.File;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.tmatesoft.sqljet.core.ISqlJetMutex;
import org.tmatesoft.sqljet.core.SqlJetErrorCode;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.SqlJetTransactionMode;
import org.tmatesoft.sqljet.core.internal.ISqlJetBtree;
import org.tmatesoft.sqljet.core.internal.ISqlJetDbHandle;
import org.tmatesoft.sqljet.core.internal.ISqlJetFile;
import org.tmatesoft.sqljet.core.internal.ISqlJetFileSystem;
import org.tmatesoft.sqljet.core.internal.ISqlJetFileSystemsManager;
import org.tmatesoft.sqljet.core.internal.SqlJetBtreeFlags;
import org.tmatesoft.sqljet.core.internal.SqlJetFileOpenPermission;
import org.tmatesoft.sqljet.core.internal.SqlJetFileType;
import org.tmatesoft.sqljet.core.internal.SqlJetPagerJournalMode;
import org.tmatesoft.sqljet.core.internal.SqlJetSafetyLevel;
import org.tmatesoft.sqljet.core.internal.SqlJetUtility;
import org.tmatesoft.sqljet.core.internal.btree.SqlJetBtree;
import org.tmatesoft.sqljet.core.internal.db.SqlJetDbHandle;
import org.tmatesoft.sqljet.core.internal.fs.SqlJetFileSystemsManager;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetSchema;
import org.tmatesoft.sqljet.core.table.ISqlJetBusyHandler;
import org.tmatesoft.sqljet.core.table.ISqlJetOptions;
import org.tmatesoft.sqljet.core.table.SqlJetDefaultBusyHandler;
import org.tmatesoft.sqljet.core.table.engine.ISqlJetEngineSynchronized;
import org.tmatesoft.sqljet.core.table.engine.ISqlJetEngineTransaction;
import org.tmatesoft.sqljet.core.table.engine.SqlJetEngine$1;
import org.tmatesoft.sqljet.core.table.engine.SqlJetEngine$10;
import org.tmatesoft.sqljet.core.table.engine.SqlJetEngine$11;
import org.tmatesoft.sqljet.core.table.engine.SqlJetEngine$12;
import org.tmatesoft.sqljet.core.table.engine.SqlJetEngine$2;
import org.tmatesoft.sqljet.core.table.engine.SqlJetEngine$3;
import org.tmatesoft.sqljet.core.table.engine.SqlJetEngine$4;
import org.tmatesoft.sqljet.core.table.engine.SqlJetEngine$5;
import org.tmatesoft.sqljet.core.table.engine.SqlJetEngine$6;
import org.tmatesoft.sqljet.core.table.engine.SqlJetEngine$7;
import org.tmatesoft.sqljet.core.table.engine.SqlJetEngine$8;
import org.tmatesoft.sqljet.core.table.engine.SqlJetEngine$9;

public class SqlJetEngine {
    private static final Set READ_FLAGS = Collections.unmodifiableSet(SqlJetUtility.of(SqlJetBtreeFlags.READONLY));
    private static final Set READ_PERMISSIONS = Collections.unmodifiableSet(SqlJetUtility.of(SqlJetFileOpenPermission.READONLY));
    private static final Set WRITE_FLAGS = Collections.unmodifiableSet(SqlJetUtility.of((Enum)SqlJetBtreeFlags.READWRITE, (Enum)SqlJetBtreeFlags.CREATE));
    private static final Set WRITE_PREMISSIONS = Collections.unmodifiableSet(SqlJetUtility.of((Enum)SqlJetFileOpenPermission.READWRITE, (Enum)SqlJetFileOpenPermission.CREATE));
    protected static final ISqlJetFileSystemsManager FILE_SYSTEM_MANAGER = SqlJetFileSystemsManager.getManager();
    protected ISqlJetFileSystem fileSystem = FILE_SYSTEM_MANAGER.find(null);
    protected boolean writable;
    protected ISqlJetDbHandle dbHandle;
    protected ISqlJetBtree btree;
    protected boolean open = false;
    protected File file;
    private boolean transaction;
    private SqlJetTransactionMode transactionMode;

    public SqlJetEngine(File file, boolean bl2) {
        this.writable = bl2;
        this.file = file;
    }

    public SqlJetEngine(File file, boolean bl2, ISqlJetFileSystem iSqlJetFileSystem) {
        this.writable = bl2;
        this.file = file;
        this.fileSystem = iSqlJetFileSystem;
    }

    public SqlJetEngine(File file, boolean bl2, String string) {
        this.writable = bl2;
        this.file = file;
        this.fileSystem = FILE_SYSTEM_MANAGER.find(string);
        if (this.fileSystem == null) {
            throw new SqlJetException(String.format("File system '%s' not found", string));
        }
    }

    public void registerFileSystem(ISqlJetFileSystem iSqlJetFileSystem, boolean bl2) {
        FILE_SYSTEM_MANAGER.register(iSqlJetFileSystem, bl2);
    }

    public void unregisterFileSystem(ISqlJetFileSystem iSqlJetFileSystem) {
        FILE_SYSTEM_MANAGER.unregister(iSqlJetFileSystem);
    }

    public File getFile() {
        return this.file;
    }

    public boolean isWritable() {
        return this.writable;
    }

    public ISqlJetFileSystem getFileSystem() {
        return this.fileSystem;
    }

    public boolean isOpen() {
        return this.open;
    }

    protected void checkOpen() {
        if (!this.isOpen()) {
            throw new SqlJetException(SqlJetErrorCode.MISUSE, "Database closed");
        }
    }

    public synchronized void open() {
        if (!this.open) {
            this.dbHandle = new SqlJetDbHandle(this.fileSystem);
            this.dbHandle.setBusyHandler(new SqlJetDefaultBusyHandler());
            this.btree = new SqlJetBtree();
            EnumSet enumSet = EnumSet.copyOf(this.writable ? WRITE_FLAGS : READ_FLAGS);
            EnumSet enumSet2 = EnumSet.copyOf(this.writable ? WRITE_PREMISSIONS : READ_PERMISSIONS);
            SqlJetFileType sqlJetFileType = this.file != null ? SqlJetFileType.MAIN_DB : SqlJetFileType.TEMP_DB;
            this.btree.open(this.file, this.dbHandle, enumSet, sqlJetFileType, enumSet2);
            ISqlJetFile iSqlJetFile = this.btree.getPager().getFile();
            if (iSqlJetFile != null) {
                Set set = this.btree.getPager().getFile().getPermissions();
                this.writable = set.contains((Object)SqlJetFileOpenPermission.READWRITE);
            }
        } else {
            throw new SqlJetException(SqlJetErrorCode.MISUSE, "Database is open already");
        }
        this.open = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object runSynchronized(ISqlJetEngineSynchronized iSqlJetEngineSynchronized) {
        this.checkOpen();
        this.dbHandle.getMutex().enter();
        try {
            Object object = iSqlJetEngineSynchronized.runSynchronized(this);
            Object var4_3 = null;
            this.dbHandle.getMutex().leave();
            return object;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.dbHandle.getMutex().leave();
            throw throwable;
        }
    }

    public void close() {
        if (this.open) {
            this.runSynchronized(new SqlJetEngine$1(this));
            if (!this.open) {
                this.dbHandle = null;
            }
        }
    }

    protected void closeResources() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() {
        try {
            if (this.open) {
                this.close();
            }
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            super.finalize();
            throw throwable;
        }
        super.finalize();
    }

    protected void readSchema() {
        this.runSynchronized(new SqlJetEngine$2(this));
    }

    public ISqlJetOptions getOptions() {
        this.checkOpen();
        if (null == this.btree.getSchema()) {
            this.readSchema();
        }
        return this.dbHandle.getOptions();
    }

    public void refreshSchema() {
        if (null == this.btree.getSchema() || !this.getOptions().verifySchemaVersion(false)) {
            this.readSchema();
        }
    }

    protected SqlJetSchema getSchemaInternal() {
        this.checkOpen();
        this.refreshSchema();
        return this.btree.getSchema();
    }

    public ISqlJetBusyHandler getBusyHandler() {
        return this.dbHandle.getBusyHandler();
    }

    public void setBusyHandler(ISqlJetBusyHandler iSqlJetBusyHandler) {
        this.dbHandle.setBusyHandler(iSqlJetBusyHandler);
    }

    public ISqlJetMutex getMutex() {
        return this.dbHandle.getMutex();
    }

    public void setCacheSize(int n2) {
        this.checkOpen();
        this.runSynchronized(new SqlJetEngine$3(this, n2));
    }

    public int getCacheSize() {
        this.checkOpen();
        this.refreshSchema();
        return (Integer)this.runSynchronized(new SqlJetEngine$4(this));
    }

    public void setSafetyLevel(SqlJetSafetyLevel sqlJetSafetyLevel) {
        this.checkOpen();
        this.runSynchronized(new SqlJetEngine$5(this, sqlJetSafetyLevel));
    }

    public void setJournalMode(SqlJetPagerJournalMode sqlJetPagerJournalMode) {
        this.checkOpen();
        this.runSynchronized(new SqlJetEngine$6(this, sqlJetPagerJournalMode));
    }

    public SqlJetSafetyLevel getSafetyLevel() {
        this.checkOpen();
        this.refreshSchema();
        return (SqlJetSafetyLevel)((Object)this.runSynchronized(new SqlJetEngine$7(this)));
    }

    public SqlJetPagerJournalMode getJournalMode() {
        this.checkOpen();
        this.refreshSchema();
        return (SqlJetPagerJournalMode)((Object)this.runSynchronized(new SqlJetEngine$8(this)));
    }

    public boolean isInTransaction() {
        return this.transaction;
    }

    public SqlJetTransactionMode getTransactionMode() {
        return this.transactionMode;
    }

    public void beginTransaction(SqlJetTransactionMode sqlJetTransactionMode) {
        this.checkOpen();
        this.runSynchronized(new SqlJetEngine$9(this, sqlJetTransactionMode));
    }

    public void commit() {
        this.checkOpen();
        this.runSynchronized(new SqlJetEngine$10(this));
    }

    public void rollback() {
        this.checkOpen();
        this.runSynchronized(new SqlJetEngine$11(this));
    }

    protected Object runEngineTransaction(ISqlJetEngineTransaction iSqlJetEngineTransaction, SqlJetTransactionMode sqlJetTransactionMode) {
        this.checkOpen();
        return this.runSynchronized(new SqlJetEngine$12(this, sqlJetTransactionMode, iSqlJetEngineTransaction));
    }

    private boolean isTransactionStarted(SqlJetTransactionMode sqlJetTransactionMode) {
        return this.transaction && (this.transactionMode == sqlJetTransactionMode || sqlJetTransactionMode == SqlJetTransactionMode.READ_ONLY);
    }

    private void doBeginTransaction(SqlJetTransactionMode sqlJetTransactionMode) {
        this.btree.beginTrans(sqlJetTransactionMode);
        this.refreshSchema();
        this.transaction = true;
        this.transactionMode = sqlJetTransactionMode;
    }

    private void doCommitTransaction() {
        this.btree.closeAllCursors();
        this.btree.commit();
        this.transaction = false;
        this.transactionMode = null;
    }

    private void doRollbackTransaction() {
        this.btree.closeAllCursors();
        this.btree.rollback();
        this.transaction = false;
        this.transactionMode = null;
    }

    static /* synthetic */ boolean access$000(SqlJetEngine sqlJetEngine, SqlJetTransactionMode sqlJetTransactionMode) {
        return sqlJetEngine.isTransactionStarted(sqlJetTransactionMode);
    }

    static /* synthetic */ void access$100(SqlJetEngine sqlJetEngine, SqlJetTransactionMode sqlJetTransactionMode) {
        sqlJetEngine.doBeginTransaction(sqlJetTransactionMode);
    }

    static /* synthetic */ void access$200(SqlJetEngine sqlJetEngine) {
        sqlJetEngine.doCommitTransaction();
    }

    static /* synthetic */ void access$300(SqlJetEngine sqlJetEngine) {
        sqlJetEngine.doRollbackTransaction();
    }

    static /* synthetic */ boolean access$402(SqlJetEngine sqlJetEngine, boolean bl2) {
        sqlJetEngine.transaction = bl2;
        return sqlJetEngine.transaction;
    }

    static /* synthetic */ SqlJetTransactionMode access$502(SqlJetEngine sqlJetEngine, SqlJetTransactionMode sqlJetTransactionMode) {
        sqlJetEngine.transactionMode = sqlJetTransactionMode;
        return sqlJetEngine.transactionMode;
    }
}

