/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.table;

import org.tmatesoft.sqljet.core.internal.SqlJetUtility;
import org.tmatesoft.sqljet.core.table.ISqlJetBusyHandler;

public class SqlJetDefaultBusyHandler
implements ISqlJetBusyHandler {
    public static final String SQLJET_BUSY_RETRIES_PROPERTY = "SQLJET_BUSY_RETRIES";
    public static final String SQLJET_BUSY_SLEEP_PROPERTY = "SQLJET_BUSY_SLEEP";
    private static final int DEFAULT_RETRIES = 10;
    private static final int DEFAULT_SLEEP = 100;
    private int retries;
    private int sleep;
    private boolean cancel = false;

    public SqlJetDefaultBusyHandler() {
        this.retries = SqlJetUtility.getIntSysProp(SQLJET_BUSY_RETRIES_PROPERTY, 10);
        this.sleep = SqlJetUtility.getIntSysProp(SQLJET_BUSY_SLEEP_PROPERTY, 100);
    }

    public SqlJetDefaultBusyHandler(int n2, int n3) {
        this.retries = n2 > 0 ? n2 : SqlJetUtility.getIntSysProp(SQLJET_BUSY_RETRIES_PROPERTY, 10);
        this.sleep = n3 > 0 ? n3 : SqlJetUtility.getIntSysProp(SQLJET_BUSY_SLEEP_PROPERTY, 100);
    }

    public int getRetries() {
        return this.retries;
    }

    public void setRetries(int n2) {
        this.retries = n2;
    }

    public int getSleep() {
        return this.sleep;
    }

    public void setSleep(int n2) {
        this.sleep = n2;
    }

    public void setCancel(boolean bl2) {
        this.cancel = bl2;
    }

    public boolean isCancel() {
        return this.cancel;
    }

    public boolean call(int n2) {
        if (this.cancel) {
            this.cancel = false;
            return false;
        }
        if (n2 > this.retries) {
            return false;
        }
        try {
            Thread.sleep(this.sleep);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return true;
    }
}

