/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.table;

import java.io.File;
import java.io.IOException;
import org.tmatesoft.sqljet.core.SqlJetErrorCode;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.SqlJetTransactionMode;
import org.tmatesoft.sqljet.core.internal.ISqlJetBtree;
import org.tmatesoft.sqljet.core.internal.ISqlJetFileSystem;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetSchema;
import org.tmatesoft.sqljet.core.internal.table.SqlJetTable;
import org.tmatesoft.sqljet.core.schema.ISqlJetIndexDef;
import org.tmatesoft.sqljet.core.schema.ISqlJetSchema;
import org.tmatesoft.sqljet.core.schema.ISqlJetTableDef;
import org.tmatesoft.sqljet.core.schema.ISqlJetTriggerDef;
import org.tmatesoft.sqljet.core.schema.ISqlJetViewDef;
import org.tmatesoft.sqljet.core.schema.ISqlJetVirtualTableDef;
import org.tmatesoft.sqljet.core.table.ISqlJetRunnableWithLock;
import org.tmatesoft.sqljet.core.table.ISqlJetTable;
import org.tmatesoft.sqljet.core.table.ISqlJetTransaction;
import org.tmatesoft.sqljet.core.table.SqlJetDb$1;
import org.tmatesoft.sqljet.core.table.SqlJetDb$10;
import org.tmatesoft.sqljet.core.table.SqlJetDb$11;
import org.tmatesoft.sqljet.core.table.SqlJetDb$12;
import org.tmatesoft.sqljet.core.table.SqlJetDb$13;
import org.tmatesoft.sqljet.core.table.SqlJetDb$14;
import org.tmatesoft.sqljet.core.table.SqlJetDb$15;
import org.tmatesoft.sqljet.core.table.SqlJetDb$2;
import org.tmatesoft.sqljet.core.table.SqlJetDb$3;
import org.tmatesoft.sqljet.core.table.SqlJetDb$4;
import org.tmatesoft.sqljet.core.table.SqlJetDb$5;
import org.tmatesoft.sqljet.core.table.SqlJetDb$6;
import org.tmatesoft.sqljet.core.table.SqlJetDb$7;
import org.tmatesoft.sqljet.core.table.SqlJetDb$8;
import org.tmatesoft.sqljet.core.table.SqlJetDb$9;
import org.tmatesoft.sqljet.core.table.engine.SqlJetEngine;

public class SqlJetDb
extends SqlJetEngine {
    public static final File IN_MEMORY = new File(":memory:");
    private SqlJetDb temporaryDb;

    public SqlJetDb(File file, boolean bl2) {
        super(file, bl2);
    }

    public SqlJetDb(File file, boolean bl2, ISqlJetFileSystem iSqlJetFileSystem) {
        super(file, bl2, iSqlJetFileSystem);
    }

    public SqlJetDb(File file, boolean bl2, String string) {
        super(file, bl2, string);
    }

    public static SqlJetDb open(File file, boolean bl2) {
        SqlJetDb sqlJetDb = new SqlJetDb(file, bl2);
        sqlJetDb.open();
        return sqlJetDb;
    }

    public static SqlJetDb open(File file, boolean bl2, ISqlJetFileSystem iSqlJetFileSystem) {
        SqlJetDb sqlJetDb = new SqlJetDb(file, bl2, iSqlJetFileSystem);
        sqlJetDb.open();
        return sqlJetDb;
    }

    public static SqlJetDb open(File file, boolean bl2, String string) {
        SqlJetDb sqlJetDb = new SqlJetDb(file, bl2, string);
        sqlJetDb.open();
        return sqlJetDb;
    }

    public Object runWithLock(ISqlJetRunnableWithLock iSqlJetRunnableWithLock) {
        return this.runSynchronized(new SqlJetDb$1(this, iSqlJetRunnableWithLock));
    }

    public ISqlJetSchema getSchema() {
        return this.getSchemaInternal();
    }

    public ISqlJetTable getTable(String string) {
        this.checkOpen();
        this.refreshSchema();
        return (SqlJetTable)this.runWithLock(new SqlJetDb$2(this, string));
    }

    public Object runWriteTransaction(ISqlJetTransaction iSqlJetTransaction) {
        this.checkOpen();
        if (this.writable) {
            return this.runTransaction(iSqlJetTransaction, SqlJetTransactionMode.WRITE);
        }
        throw new SqlJetException(SqlJetErrorCode.MISUSE, "Can't start write transaction on read-only database");
    }

    public Object runReadTransaction(ISqlJetTransaction iSqlJetTransaction) {
        this.checkOpen();
        return this.runTransaction(iSqlJetTransaction, SqlJetTransactionMode.READ_ONLY);
    }

    public Object runTransaction(ISqlJetTransaction iSqlJetTransaction, SqlJetTransactionMode sqlJetTransactionMode) {
        return this.runEngineTransaction(new SqlJetDb$3(this, iSqlJetTransaction), sqlJetTransactionMode);
    }

    public Object pragma(String string) {
        this.checkOpen();
        this.refreshSchema();
        return this.runWithLock(new SqlJetDb$4(this, string));
    }

    public ISqlJetTableDef createTable(String string) {
        this.checkOpen();
        return (ISqlJetTableDef)this.runWriteTransaction(new SqlJetDb$5(this, string));
    }

    public ISqlJetIndexDef createIndex(String string) {
        this.checkOpen();
        return (ISqlJetIndexDef)this.runWriteTransaction(new SqlJetDb$6(this, string));
    }

    public void dropTable(String string) {
        this.checkOpen();
        this.runWriteTransaction(new SqlJetDb$7(this, string));
    }

    public void dropIndex(String string) {
        this.checkOpen();
        this.runWriteTransaction(new SqlJetDb$8(this, string));
    }

    public void dropView(String string) {
        this.checkOpen();
        this.runWriteTransaction(new SqlJetDb$9(this, string));
    }

    public void dropTrigger(String string) {
        this.checkOpen();
        this.runWriteTransaction(new SqlJetDb$10(this, string));
    }

    public ISqlJetTableDef alterTable(String string) {
        this.checkOpen();
        return (ISqlJetTableDef)this.runWriteTransaction(new SqlJetDb$11(this, string));
    }

    public ISqlJetVirtualTableDef createVirtualTable(String string) {
        this.checkOpen();
        return (ISqlJetVirtualTableDef)this.runWriteTransaction(new SqlJetDb$12(this, string));
    }

    public ISqlJetViewDef createView(String string) {
        this.checkOpen();
        return (ISqlJetViewDef)this.runWriteTransaction(new SqlJetDb$13(this, string));
    }

    public ISqlJetTriggerDef createTrigger(String string) {
        this.checkOpen();
        return (ISqlJetTriggerDef)this.runWriteTransaction(new SqlJetDb$14(this, string));
    }

    public SqlJetDb getTemporaryDatabase() {
        return this.getTemporaryDatabase(false);
    }

    public SqlJetDb getTemporaryDatabase(boolean bl2) {
        this.checkOpen();
        return (SqlJetDb)this.runWithLock(new SqlJetDb$15(this, bl2));
    }

    protected void closeResources() {
        this.closeTemporaryDatabase();
    }

    private void closeTemporaryDatabase() {
        if (this.temporaryDb != null) {
            this.temporaryDb.close();
            File file = this.temporaryDb.getFile();
            if (file != null && !IN_MEMORY.equals(file)) {
                this.getFileSystem().delete(file, false);
            }
        }
        this.temporaryDb = null;
    }

    private File getTemporaryDatabaseFile(boolean bl2) {
        if (bl2) {
            return IN_MEMORY;
        }
        File file = null;
        try {
            file = this.getFileSystem().getTempFile();
        }
        catch (IOException iOException) {
            throw new SqlJetException(SqlJetErrorCode.CANTOPEN, (Throwable)iOException);
        }
        if (file == null) {
            throw new SqlJetException(SqlJetErrorCode.CANTOPEN);
        }
        return file;
    }

    static /* synthetic */ ISqlJetBtree access$000(SqlJetDb sqlJetDb) {
        return sqlJetDb.btree;
    }

    static /* synthetic */ boolean access$100(SqlJetDb sqlJetDb) {
        return sqlJetDb.writable;
    }

    static /* synthetic */ SqlJetSchema access$200(SqlJetDb sqlJetDb) {
        return sqlJetDb.getSchemaInternal();
    }

    static /* synthetic */ SqlJetSchema access$300(SqlJetDb sqlJetDb) {
        return sqlJetDb.getSchemaInternal();
    }

    static /* synthetic */ SqlJetSchema access$400(SqlJetDb sqlJetDb) {
        return sqlJetDb.getSchemaInternal();
    }

    static /* synthetic */ SqlJetSchema access$500(SqlJetDb sqlJetDb) {
        return sqlJetDb.getSchemaInternal();
    }

    static /* synthetic */ SqlJetSchema access$600(SqlJetDb sqlJetDb) {
        return sqlJetDb.getSchemaInternal();
    }

    static /* synthetic */ SqlJetSchema access$700(SqlJetDb sqlJetDb) {
        return sqlJetDb.getSchemaInternal();
    }

    static /* synthetic */ SqlJetSchema access$800(SqlJetDb sqlJetDb) {
        return sqlJetDb.getSchemaInternal();
    }

    static /* synthetic */ SqlJetSchema access$900(SqlJetDb sqlJetDb) {
        return sqlJetDb.getSchemaInternal();
    }

    static /* synthetic */ SqlJetSchema access$1000(SqlJetDb sqlJetDb) {
        return sqlJetDb.getSchemaInternal();
    }

    static /* synthetic */ SqlJetSchema access$1100(SqlJetDb sqlJetDb) {
        return sqlJetDb.getSchemaInternal();
    }

    static /* synthetic */ SqlJetDb access$1200(SqlJetDb sqlJetDb) {
        return sqlJetDb.temporaryDb;
    }

    static /* synthetic */ void access$1300(SqlJetDb sqlJetDb) {
        sqlJetDb.closeTemporaryDatabase();
    }

    static /* synthetic */ File access$1400(SqlJetDb sqlJetDb, boolean bl2) {
        return sqlJetDb.getTemporaryDatabaseFile(bl2);
    }

    static /* synthetic */ SqlJetDb access$1202(SqlJetDb sqlJetDb, SqlJetDb sqlJetDb2) {
        sqlJetDb.temporaryDb = sqlJetDb2;
        return sqlJetDb.temporaryDb;
    }
}

