/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.map;

import java.io.File;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.tmatesoft.sqljet.core.SqlJetErrorCode;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.SqlJetTransactionMode;
import org.tmatesoft.sqljet.core.internal.ISqlJetBtree;
import org.tmatesoft.sqljet.core.internal.map.SqlJetMapDef;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetSchema;
import org.tmatesoft.sqljet.core.map.ISqlJetMap;
import org.tmatesoft.sqljet.core.map.ISqlJetMapDef;
import org.tmatesoft.sqljet.core.map.ISqlJetMapTransaction;
import org.tmatesoft.sqljet.core.map.SqlJetMapDb$1;
import org.tmatesoft.sqljet.core.map.SqlJetMapDb$2;
import org.tmatesoft.sqljet.core.map.SqlJetMapDb$3;
import org.tmatesoft.sqljet.core.map.SqlJetMapDb$4;
import org.tmatesoft.sqljet.core.map.SqlJetMapDb$5;
import org.tmatesoft.sqljet.core.map.SqlJetMapDb$6;
import org.tmatesoft.sqljet.core.schema.ISqlJetIndexDef;
import org.tmatesoft.sqljet.core.schema.ISqlJetVirtualTableDef;
import org.tmatesoft.sqljet.core.table.engine.SqlJetEngine;

public class SqlJetMapDb
extends SqlJetEngine {
    private static final String MAP_TABLE_DOES_NOT_EXIST = "Map table '%s' does not exist";
    public static final File IN_MEMORY = new File(":memory:");
    public static final String MODULE_NAME = "sqljetmap";
    private static final String MAP_EXISTS = "Map '%s' exists";
    private volatile Map mapDefs;

    public SqlJetMapDb(File file, boolean bl2) {
        super(file, bl2);
    }

    public static SqlJetMapDb open(File file, boolean bl2) {
        SqlJetMapDb sqlJetMapDb = new SqlJetMapDb(file, bl2);
        sqlJetMapDb.open();
        return sqlJetMapDb;
    }

    public Object runTransaction(SqlJetTransactionMode sqlJetTransactionMode, ISqlJetMapTransaction iSqlJetMapTransaction) {
        this.checkOpen();
        return this.runEngineTransaction(new SqlJetMapDb$1(this, iSqlJetMapTransaction), sqlJetTransactionMode);
    }

    public Object runWriteTransaction(ISqlJetMapTransaction iSqlJetMapTransaction) {
        return this.runTransaction(SqlJetTransactionMode.WRITE, iSqlJetMapTransaction);
    }

    public Object runReadTransaction(ISqlJetMapTransaction iSqlJetMapTransaction) {
        return this.runTransaction(SqlJetTransactionMode.READ_ONLY, iSqlJetMapTransaction);
    }

    public Object runSynchronized(ISqlJetMapTransaction iSqlJetMapTransaction) {
        return this.runSynchronized(new SqlJetMapDb$2(this, iSqlJetMapTransaction));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map getMapDefs() {
        if (this.mapDefs == null) {
            SqlJetMapDb sqlJetMapDb = this;
            synchronized (sqlJetMapDb) {
                if (this.mapDefs == null) {
                    this.mapDefs = new TreeMap(String.CASE_INSENSITIVE_ORDER);
                }
            }
        }
        return this.mapDefs;
    }

    protected void readSchema() {
        super.readSchema();
        this.readMapDefs();
    }

    private void readMapDefs() {
        SqlJetSchema sqlJetSchema = this.getSchemaInternal();
        Set set = sqlJetSchema.getVirtualTableNames();
        if (set != null && set.size() > 0) {
            this.getMapDefs().clear();
            for (String string : set) {
                ISqlJetVirtualTableDef iSqlJetVirtualTableDef = sqlJetSchema.getVirtualTable(string);
                if (!MODULE_NAME.equalsIgnoreCase(iSqlJetVirtualTableDef.getModuleName())) continue;
                ISqlJetIndexDef iSqlJetIndexDef = sqlJetSchema.getIndex(this.getMapIndexName(string));
                if (iSqlJetIndexDef != null) {
                    SqlJetMapDef sqlJetMapDef = new SqlJetMapDef(string, iSqlJetVirtualTableDef, iSqlJetIndexDef);
                    this.getMapDefs().put(string, sqlJetMapDef);
                    continue;
                }
                throw new SqlJetException(SqlJetErrorCode.CORRUPT, String.format("Map '%s' does not have index", string));
            }
        }
    }

    public Set getMapNames() {
        return (Set)this.runSynchronized(new SqlJetMapDb$3(this));
    }

    public ISqlJetMapDef getMapDef(String string) {
        return (ISqlJetMapDef)this.runSynchronized(new SqlJetMapDb$4(this, string));
    }

    public ISqlJetMapDef createMap(String string) {
        if (this.getMapDefs().containsKey(string)) {
            throw new SqlJetException(String.format(MAP_EXISTS, string));
        }
        return (ISqlJetMapDef)this.runWriteTransaction(new SqlJetMapDb$5(this, string));
    }

    private String getMapIndexName(String string) {
        return String.format("%s_%s_%d", MODULE_NAME, string, 1);
    }

    public ISqlJetMap getMap(String string) {
        this.checkOpen();
        return (ISqlJetMap)this.runSynchronized(new SqlJetMapDb$6(this, string));
    }

    static /* synthetic */ Map access$000(SqlJetMapDb sqlJetMapDb) {
        return sqlJetMapDb.getMapDefs();
    }

    static /* synthetic */ ISqlJetBtree access$100(SqlJetMapDb sqlJetMapDb) {
        return sqlJetMapDb.btree;
    }

    static /* synthetic */ SqlJetSchema access$200(SqlJetMapDb sqlJetMapDb) {
        return sqlJetMapDb.getSchemaInternal();
    }

    static /* synthetic */ String access$300(SqlJetMapDb sqlJetMapDb, String string) {
        return sqlJetMapDb.getMapIndexName(string);
    }

    static /* synthetic */ ISqlJetBtree access$400(SqlJetMapDb sqlJetMapDb) {
        return sqlJetMapDb.btree;
    }

    static /* synthetic */ boolean access$500(SqlJetMapDb sqlJetMapDb) {
        return sqlJetMapDb.writable;
    }
}

