/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.vdbe;

import org.tmatesoft.sqljet.core.SqlJetValueType;
import org.tmatesoft.sqljet.core.internal.ISqlJetMemoryPointer;
import org.tmatesoft.sqljet.core.internal.SqlJetUtility;
import org.tmatesoft.sqljet.core.internal.vdbe.SqlJetVdbeMem;
import org.tmatesoft.sqljet.core.internal.vdbe.SqlJetVdbeMemFlags;

public class SqlJetVdbeSerialType {
    private static final byte[] aSize = new byte[]{0, 1, 2, 3, 4, 6, 8, 8, 0, 0, 0, 0};

    public static int serialTypeLen(int n2) {
        if (n2 >= 12) {
            return (n2 - 12) / 2;
        }
        return aSize[n2];
    }

    public static int serialGet(ISqlJetMemoryPointer iSqlJetMemoryPointer, int n2, SqlJetVdbeMem sqlJetVdbeMem) {
        return SqlJetVdbeSerialType.serialGet(iSqlJetMemoryPointer, 0, n2, sqlJetVdbeMem);
    }

    public static int serialGet(ISqlJetMemoryPointer iSqlJetMemoryPointer, int n2, int n3, SqlJetVdbeMem sqlJetVdbeMem) {
        switch (n3) {
            case 0: 
            case 10: 
            case 11: {
                sqlJetVdbeMem.flags = SqlJetUtility.of(SqlJetVdbeMemFlags.Null);
                sqlJetVdbeMem.type = SqlJetValueType.NULL;
                break;
            }
            case 1: {
                sqlJetVdbeMem.i = iSqlJetMemoryPointer.getByte(n2);
                sqlJetVdbeMem.flags = SqlJetUtility.of(SqlJetVdbeMemFlags.Int);
                sqlJetVdbeMem.type = SqlJetValueType.INTEGER;
                return 1;
            }
            case 2: {
                sqlJetVdbeMem.i = SqlJetUtility.fromUnsigned(SqlJetUtility.getUnsignedByte(iSqlJetMemoryPointer, n2) << 8 | SqlJetUtility.getUnsignedByte(iSqlJetMemoryPointer, n2 + 1));
                sqlJetVdbeMem.flags = SqlJetUtility.of(SqlJetVdbeMemFlags.Int);
                sqlJetVdbeMem.type = SqlJetValueType.INTEGER;
                return 2;
            }
            case 3: {
                sqlJetVdbeMem.i = iSqlJetMemoryPointer.getByte(n2) << 16 | SqlJetUtility.getUnsignedByte(iSqlJetMemoryPointer, n2 + 1) << 8 | SqlJetUtility.getUnsignedByte(iSqlJetMemoryPointer, n2 + 2);
                sqlJetVdbeMem.flags = SqlJetUtility.of(SqlJetVdbeMemFlags.Int);
                sqlJetVdbeMem.type = SqlJetValueType.INTEGER;
                return 3;
            }
            case 4: {
                sqlJetVdbeMem.i = SqlJetUtility.fromUnsigned((long)(SqlJetUtility.getUnsignedByte(iSqlJetMemoryPointer, n2) << 24 | SqlJetUtility.getUnsignedByte(iSqlJetMemoryPointer, n2 + 1) << 16 | SqlJetUtility.getUnsignedByte(iSqlJetMemoryPointer, n2 + 2) << 8 | SqlJetUtility.getUnsignedByte(iSqlJetMemoryPointer, n2 + 3)));
                sqlJetVdbeMem.flags = SqlJetUtility.of(SqlJetVdbeMemFlags.Int);
                sqlJetVdbeMem.type = SqlJetValueType.INTEGER;
                return 4;
            }
            case 5: {
                long l2 = SqlJetUtility.getUnsignedByte(iSqlJetMemoryPointer, n2) << 8 | SqlJetUtility.getUnsignedByte(iSqlJetMemoryPointer, n2 + 1);
                int n4 = SqlJetUtility.getUnsignedByte(iSqlJetMemoryPointer, n2 + 2) << 24 | SqlJetUtility.getUnsignedByte(iSqlJetMemoryPointer, n2 + 3) << 16 | SqlJetUtility.getUnsignedByte(iSqlJetMemoryPointer, n2 + 4) << 8 | SqlJetUtility.getUnsignedByte(iSqlJetMemoryPointer, n2 + 5);
                sqlJetVdbeMem.i = l2 = (long)((short)l2) << 32 | SqlJetUtility.toUnsigned(n4);
                sqlJetVdbeMem.flags = SqlJetUtility.of(SqlJetVdbeMemFlags.Int);
                sqlJetVdbeMem.type = SqlJetValueType.INTEGER;
                return 6;
            }
            case 6: 
            case 7: {
                long l3 = SqlJetUtility.getUnsignedByte(iSqlJetMemoryPointer, n2) << 24 | SqlJetUtility.getUnsignedByte(iSqlJetMemoryPointer, n2 + 1) << 16 | SqlJetUtility.getUnsignedByte(iSqlJetMemoryPointer, n2 + 2) << 8 | SqlJetUtility.getUnsignedByte(iSqlJetMemoryPointer, n2 + 3);
                int n5 = SqlJetUtility.getUnsignedByte(iSqlJetMemoryPointer, n2 + 4) << 24 | SqlJetUtility.getUnsignedByte(iSqlJetMemoryPointer, n2 + 5) << 16 | SqlJetUtility.getUnsignedByte(iSqlJetMemoryPointer, n2 + 6) << 8 | SqlJetUtility.getUnsignedByte(iSqlJetMemoryPointer, n2 + 7);
                l3 = (long)((int)l3) << 32 | SqlJetUtility.toUnsigned(n5);
                if (n3 == 6) {
                    sqlJetVdbeMem.i = l3;
                    sqlJetVdbeMem.flags = SqlJetUtility.of(SqlJetVdbeMemFlags.Int);
                    sqlJetVdbeMem.type = SqlJetValueType.INTEGER;
                } else {
                    sqlJetVdbeMem.r = Double.longBitsToDouble(l3);
                    sqlJetVdbeMem.flags = SqlJetUtility.of(sqlJetVdbeMem.r == Double.NaN ? SqlJetVdbeMemFlags.Null : SqlJetVdbeMemFlags.Real);
                    sqlJetVdbeMem.type = sqlJetVdbeMem.r == Double.NaN ? SqlJetValueType.NULL : SqlJetValueType.FLOAT;
                }
                return 8;
            }
            case 8: 
            case 9: {
                sqlJetVdbeMem.i = n3 - 8;
                sqlJetVdbeMem.flags = SqlJetUtility.of(SqlJetVdbeMemFlags.Int);
                sqlJetVdbeMem.type = SqlJetValueType.INTEGER;
                return 0;
            }
            default: {
                int n6 = (n3 - 12) / 2;
                sqlJetVdbeMem.z = SqlJetUtility.pointer(iSqlJetMemoryPointer, n2);
                sqlJetVdbeMem.z.limit(n6);
                sqlJetVdbeMem.n = n6;
                sqlJetVdbeMem.xDel = null;
                if ((n3 & 1) != 0) {
                    sqlJetVdbeMem.flags = SqlJetUtility.of((Enum)SqlJetVdbeMemFlags.Str, (Enum)SqlJetVdbeMemFlags.Ephem);
                    sqlJetVdbeMem.type = SqlJetValueType.TEXT;
                } else {
                    sqlJetVdbeMem.flags = SqlJetUtility.of((Enum)SqlJetVdbeMemFlags.Blob, (Enum)SqlJetVdbeMemFlags.Ephem);
                    sqlJetVdbeMem.type = SqlJetValueType.BLOB;
                }
                return n6;
            }
        }
        return 0;
    }

    public static int serialType(SqlJetVdbeMem sqlJetVdbeMem, int n2) {
        if (sqlJetVdbeMem.flags.contains((Object)SqlJetVdbeMemFlags.Null)) {
            return 0;
        }
        if (sqlJetVdbeMem.flags.contains((Object)SqlJetVdbeMemFlags.Int)) {
            long l2 = 0x7FFFFFFFFFFFL;
            long l3 = sqlJetVdbeMem.i;
            if (n2 >= 4 && (l3 & 1L) == l3) {
                return 8 + (int)l3;
            }
            long l4 = SqlJetUtility.absolute(l3);
            if (l4 <= 127L) {
                return 1;
            }
            if (l4 <= 32767L) {
                return 2;
            }
            if (l4 <= 0x7FFFFFL) {
                return 3;
            }
            if (l4 <= Integer.MAX_VALUE) {
                return 4;
            }
            if (l4 <= l2) {
                return 5;
            }
            return 6;
        }
        if (sqlJetVdbeMem.flags.contains((Object)SqlJetVdbeMemFlags.Real)) {
            return 7;
        }
        int n3 = sqlJetVdbeMem.n;
        if (sqlJetVdbeMem.flags.contains((Object)SqlJetVdbeMemFlags.Zero)) {
            n3 += sqlJetVdbeMem.nZero;
        }
        assert (n3 >= 0);
        return n3 * 2 + 12 + (sqlJetVdbeMem.flags.contains((Object)SqlJetVdbeMemFlags.Str) ? 1 : 0);
    }

    public static int serialPut(ISqlJetMemoryPointer iSqlJetMemoryPointer, int n2, SqlJetVdbeMem sqlJetVdbeMem, int n3) {
        int n4 = SqlJetVdbeSerialType.serialType(sqlJetVdbeMem, n3);
        if (n4 <= 7 && n4 > 0) {
            int n5;
            long l2 = n4 == 7 ? Double.doubleToLongBits(sqlJetVdbeMem.r) : sqlJetVdbeMem.i;
            int n6 = n5 = SqlJetVdbeSerialType.serialTypeLen(n4);
            assert (n6 <= n2);
            while (n5-- > 0) {
                iSqlJetMemoryPointer.putByteUnsigned(n5, (int)l2);
                l2 >>>= 8;
            }
            return n6;
        }
        if (n4 >= 12) {
            assert (sqlJetVdbeMem.n + (sqlJetVdbeMem.flags.contains((Object)SqlJetVdbeMemFlags.Zero) ? sqlJetVdbeMem.nZero : 0) == SqlJetVdbeSerialType.serialTypeLen(n4));
            assert (sqlJetVdbeMem.n <= n2);
            int n7 = sqlJetVdbeMem.n;
            SqlJetUtility.memcpy(iSqlJetMemoryPointer, sqlJetVdbeMem.z, n7);
            if (sqlJetVdbeMem.flags.contains((Object)SqlJetVdbeMemFlags.Zero)) {
                if ((n7 += sqlJetVdbeMem.nZero) > n2) {
                    n7 = n2;
                }
                SqlJetUtility.memset(iSqlJetMemoryPointer, sqlJetVdbeMem.n, (byte)0, n7 - sqlJetVdbeMem.n);
            }
            return n7;
        }
        return 0;
    }
}

