/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.vdbe;

import java.util.EnumSet;
import java.util.Iterator;
import java.util.Set;
import org.tmatesoft.sqljet.core.SqlJetEncoding;
import org.tmatesoft.sqljet.core.SqlJetErrorCode;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.SqlJetValueType;
import org.tmatesoft.sqljet.core.internal.ISqlJetBtreeCursor;
import org.tmatesoft.sqljet.core.internal.ISqlJetCallback;
import org.tmatesoft.sqljet.core.internal.ISqlJetCollSeq;
import org.tmatesoft.sqljet.core.internal.ISqlJetDbHandle;
import org.tmatesoft.sqljet.core.internal.ISqlJetFuncDef;
import org.tmatesoft.sqljet.core.internal.ISqlJetMemoryPointer;
import org.tmatesoft.sqljet.core.internal.ISqlJetRowSet;
import org.tmatesoft.sqljet.core.internal.ISqlJetVdbeMem;
import org.tmatesoft.sqljet.core.internal.SqlJetCloneable;
import org.tmatesoft.sqljet.core.internal.SqlJetUtility;
import org.tmatesoft.sqljet.core.internal.vdbe.SqlJetRowSet;
import org.tmatesoft.sqljet.core.internal.vdbe.SqlJetVdbeMemFlags;
import org.tmatesoft.sqljet.core.internal.vdbe.SqlJetVdbeMemPool;
import org.tmatesoft.sqljet.core.schema.SqlJetTypeAffinity;

public class SqlJetVdbeMem
extends SqlJetCloneable
implements ISqlJetVdbeMem {
    public static long instanceCounter = 0L;
    long i;
    int nZero;
    ISqlJetFuncDef pDef;
    ISqlJetRowSet pRowSet;
    double r;
    ISqlJetDbHandle db = null;
    ISqlJetMemoryPointer z;
    int n;
    EnumSet flags = SqlJetUtility.of(SqlJetVdbeMemFlags.Null);
    SqlJetValueType type = SqlJetValueType.NULL;
    SqlJetEncoding enc;
    ISqlJetCallback xDel;
    ISqlJetMemoryPointer zMalloc;
    public static final SqlJetVdbeMemPool pool = new SqlJetVdbeMemPool();

    public static SqlJetVdbeMem obtainInstance() {
        return pool.obtain();
    }

    SqlJetVdbeMem(SqlJetVdbeMemPool sqlJetVdbeMemPool) {
    }

    public void reset() {
        this.z = null;
        this.zMalloc = null;
        this.xDel = null;
    }

    public void release() {
        this.i = 0L;
        this.nZero = 0;
        this.pDef = null;
        this.pRowSet = null;
        this.r = 0.0;
        this.db = null;
        this.z = null;
        this.n = 0;
        this.flags = SqlJetUtility.of(SqlJetVdbeMemFlags.Null);
        this.type = SqlJetValueType.NULL;
        this.enc = null;
        this.xDel = null;
        this.zMalloc = null;
        pool.release(this);
    }

    public static int compare(SqlJetVdbeMem sqlJetVdbeMem, SqlJetVdbeMem sqlJetVdbeMem2, ISqlJetCollSeq iSqlJetCollSeq) {
        int n2;
        EnumSet enumSet = sqlJetVdbeMem.flags;
        EnumSet enumSet2 = sqlJetVdbeMem2.flags;
        EnumSet enumSet3 = EnumSet.copyOf(enumSet);
        enumSet3.addAll(enumSet2);
        assert (!enumSet3.contains((Object)SqlJetVdbeMemFlags.RowSet));
        if (enumSet3.contains((Object)SqlJetVdbeMemFlags.Null)) {
            return (enumSet2.contains((Object)SqlJetVdbeMemFlags.Null) ? 1 : 0) - (enumSet.contains((Object)SqlJetVdbeMemFlags.Null) ? 1 : 0);
        }
        if (enumSet3.contains((Object)SqlJetVdbeMemFlags.Int) || enumSet3.contains((Object)SqlJetVdbeMemFlags.Real)) {
            if (!enumSet.contains((Object)SqlJetVdbeMemFlags.Int) && !enumSet.contains((Object)SqlJetVdbeMemFlags.Real)) {
                return 1;
            }
            if (!enumSet2.contains((Object)SqlJetVdbeMemFlags.Int) && !enumSet2.contains((Object)SqlJetVdbeMemFlags.Real)) {
                return -1;
            }
            if (enumSet.contains((Object)SqlJetVdbeMemFlags.Real) || enumSet2.contains((Object)SqlJetVdbeMemFlags.Real)) {
                double d2;
                double d3 = !enumSet.contains((Object)SqlJetVdbeMemFlags.Real) ? (double)sqlJetVdbeMem.i : sqlJetVdbeMem.r;
                if (d3 < (d2 = !enumSet2.contains((Object)SqlJetVdbeMemFlags.Real) ? (double)sqlJetVdbeMem2.i : sqlJetVdbeMem2.r)) {
                    return -1;
                }
                if (d3 > d2) {
                    return 1;
                }
                return 0;
            }
            assert (enumSet.contains((Object)SqlJetVdbeMemFlags.Int));
            assert (enumSet2.contains((Object)SqlJetVdbeMemFlags.Int));
            if (sqlJetVdbeMem.i < sqlJetVdbeMem2.i) {
                return -1;
            }
            if (sqlJetVdbeMem.i > sqlJetVdbeMem2.i) {
                return 1;
            }
            return 0;
        }
        if (enumSet3.contains((Object)SqlJetVdbeMemFlags.Str)) {
            if (!enumSet.contains((Object)SqlJetVdbeMemFlags.Str)) {
                return 1;
            }
            if (!enumSet2.contains((Object)SqlJetVdbeMemFlags.Str)) {
                return -1;
            }
            assert (sqlJetVdbeMem.enc == sqlJetVdbeMem2.enc);
            assert (sqlJetVdbeMem.enc == SqlJetEncoding.UTF8 || sqlJetVdbeMem.enc == SqlJetEncoding.UTF16LE || sqlJetVdbeMem.enc == SqlJetEncoding.UTF16BE);
            if (iSqlJetCollSeq != null) {
                if (sqlJetVdbeMem.enc == iSqlJetCollSeq.getEnc()) {
                    return iSqlJetCollSeq.cmp(iSqlJetCollSeq.getUserData(), sqlJetVdbeMem.n, sqlJetVdbeMem.z, sqlJetVdbeMem2.n, sqlJetVdbeMem2.z);
                }
                SqlJetVdbeMem sqlJetVdbeMem3 = (SqlJetVdbeMem)sqlJetVdbeMem.shallowCopy(SqlJetVdbeMemFlags.Ephem);
                SqlJetVdbeMem sqlJetVdbeMem4 = (SqlJetVdbeMem)sqlJetVdbeMem2.shallowCopy(SqlJetVdbeMemFlags.Ephem);
                ISqlJetMemoryPointer iSqlJetMemoryPointer = sqlJetVdbeMem3.valueText(iSqlJetCollSeq.getEnc());
                int n3 = iSqlJetMemoryPointer == null ? 0 : sqlJetVdbeMem3.n;
                ISqlJetMemoryPointer iSqlJetMemoryPointer2 = sqlJetVdbeMem4.valueText(iSqlJetCollSeq.getEnc());
                int n4 = iSqlJetMemoryPointer2 == null ? 0 : sqlJetVdbeMem4.n;
                sqlJetVdbeMem3.reset();
                sqlJetVdbeMem4.reset();
                return iSqlJetCollSeq.cmp(iSqlJetCollSeq.getUserData(), n3, iSqlJetMemoryPointer, n4, iSqlJetMemoryPointer2);
            }
        }
        if ((n2 = SqlJetUtility.memcmp(sqlJetVdbeMem.z, sqlJetVdbeMem2.z, sqlJetVdbeMem.n > sqlJetVdbeMem2.n ? sqlJetVdbeMem2.n : sqlJetVdbeMem.n)) == 0) {
            n2 = sqlJetVdbeMem.n - sqlJetVdbeMem2.n;
        }
        return n2;
    }

    public ISqlJetVdbeMem shallowCopy(SqlJetVdbeMemFlags sqlJetVdbeMemFlags) {
        SqlJetVdbeMem sqlJetVdbeMem = this;
        assert (!sqlJetVdbeMem.flags.contains((Object)SqlJetVdbeMemFlags.RowSet));
        SqlJetVdbeMem sqlJetVdbeMem2 = (SqlJetVdbeMem)SqlJetUtility.memcpy(sqlJetVdbeMem);
        if (sqlJetVdbeMem.flags.contains((Object)SqlJetVdbeMemFlags.Dyn) || sqlJetVdbeMem.z == sqlJetVdbeMem.zMalloc) {
            sqlJetVdbeMem2.flags.removeAll(SqlJetUtility.of((Enum)SqlJetVdbeMemFlags.Dyn, (Enum)SqlJetVdbeMemFlags.Static, (Enum)SqlJetVdbeMemFlags.Ephem));
            assert (sqlJetVdbeMemFlags == SqlJetVdbeMemFlags.Ephem || sqlJetVdbeMemFlags == SqlJetVdbeMemFlags.Static);
            sqlJetVdbeMem2.flags.add(sqlJetVdbeMemFlags);
        }
        return sqlJetVdbeMem2;
    }

    public ISqlJetVdbeMem copy() {
        SqlJetVdbeMem sqlJetVdbeMem = this;
        assert (!sqlJetVdbeMem.flags.contains((Object)SqlJetVdbeMemFlags.RowSet));
        SqlJetVdbeMem sqlJetVdbeMem2 = (SqlJetVdbeMem)SqlJetUtility.memcpy(sqlJetVdbeMem);
        sqlJetVdbeMem2.flags.remove((Object)SqlJetVdbeMemFlags.Dyn);
        if ((sqlJetVdbeMem2.flags.contains((Object)SqlJetVdbeMemFlags.Str) || sqlJetVdbeMem2.flags.contains((Object)SqlJetVdbeMemFlags.Blob)) && !sqlJetVdbeMem.flags.contains((Object)SqlJetVdbeMemFlags.Static)) {
            sqlJetVdbeMem2.flags.add(SqlJetVdbeMemFlags.Ephem);
            sqlJetVdbeMem2.makeWriteable();
        }
        return sqlJetVdbeMem2;
    }

    public ISqlJetVdbeMem move() {
        assert (this.db == null || SqlJetUtility.mutex_held(this.db.getMutex()));
        SqlJetVdbeMem sqlJetVdbeMem = (SqlJetVdbeMem)SqlJetUtility.memcpy(this);
        this.flags = SqlJetUtility.of(SqlJetVdbeMemFlags.Null);
        this.xDel = null;
        this.zMalloc = null;
        return sqlJetVdbeMem;
    }

    public ISqlJetMemoryPointer valueText(SqlJetEncoding sqlJetEncoding) {
        SqlJetVdbeMem sqlJetVdbeMem = this;
        assert (sqlJetVdbeMem.db == null || SqlJetUtility.mutex_held(sqlJetVdbeMem.db.getMutex()));
        assert (!sqlJetVdbeMem.flags.contains((Object)SqlJetVdbeMemFlags.RowSet));
        if (sqlJetVdbeMem.flags.contains((Object)SqlJetVdbeMemFlags.Null)) {
            return null;
        }
        if (sqlJetVdbeMem.flags.contains((Object)SqlJetVdbeMemFlags.Blob)) {
            sqlJetVdbeMem.flags.add(SqlJetVdbeMemFlags.Str);
        }
        sqlJetVdbeMem.expandBlob();
        if (sqlJetVdbeMem.flags.contains((Object)SqlJetVdbeMemFlags.Str)) {
            sqlJetVdbeMem.changeEncoding(sqlJetEncoding);
            sqlJetVdbeMem.makeWriteable();
            sqlJetVdbeMem.nulTerminate();
        } else {
            assert (!sqlJetVdbeMem.flags.contains((Object)SqlJetVdbeMemFlags.Blob));
            sqlJetVdbeMem.stringify(sqlJetEncoding);
        }
        return sqlJetVdbeMem.z;
    }

    public void stringify(SqlJetEncoding sqlJetEncoding) {
        SqlJetVdbeMem sqlJetVdbeMem = this;
        EnumSet enumSet = sqlJetVdbeMem.flags;
        int n2 = 32;
        assert (sqlJetVdbeMem.db == null || SqlJetUtility.mutex_held(sqlJetVdbeMem.db.getMutex()));
        assert (!enumSet.contains((Object)SqlJetVdbeMemFlags.Zero));
        assert (!enumSet.contains((Object)SqlJetVdbeMemFlags.Str) && !enumSet.contains((Object)SqlJetVdbeMemFlags.Blob));
        assert (enumSet.contains((Object)SqlJetVdbeMemFlags.Int) || enumSet.contains((Object)SqlJetVdbeMemFlags.Real));
        assert (!sqlJetVdbeMem.flags.contains((Object)SqlJetVdbeMemFlags.RowSet));
        sqlJetVdbeMem.grow(32, false);
        if (enumSet.contains((Object)SqlJetVdbeMemFlags.Int)) {
            sqlJetVdbeMem.z.putBytes(Long.toString(sqlJetVdbeMem.i).getBytes());
        } else {
            assert (enumSet.contains((Object)SqlJetVdbeMemFlags.Real));
            sqlJetVdbeMem.z.putBytes(Double.toString(sqlJetVdbeMem.r).getBytes());
        }
        sqlJetVdbeMem.n = SqlJetUtility.strlen30(sqlJetVdbeMem.z);
        sqlJetVdbeMem.enc = SqlJetEncoding.UTF8;
        sqlJetVdbeMem.flags.add(SqlJetVdbeMemFlags.Str);
        sqlJetVdbeMem.flags.add(SqlJetVdbeMemFlags.Term);
        sqlJetVdbeMem.changeEncoding(sqlJetEncoding);
        this.type = SqlJetValueType.TEXT;
    }

    public void grow(int n2, boolean bl2) {
        SqlJetVdbeMem sqlJetVdbeMem = this;
        assert (1 >= (sqlJetVdbeMem.zMalloc != null && sqlJetVdbeMem.zMalloc == sqlJetVdbeMem.z ? 1 : 0) + (sqlJetVdbeMem.flags.contains((Object)SqlJetVdbeMemFlags.Dyn) && sqlJetVdbeMem.xDel != null ? 1 : 0) + (sqlJetVdbeMem.flags.contains((Object)SqlJetVdbeMemFlags.Ephem) ? 1 : 0) + (sqlJetVdbeMem.flags.contains((Object)SqlJetVdbeMemFlags.Static) ? 1 : 0));
        assert (!sqlJetVdbeMem.flags.contains((Object)SqlJetVdbeMemFlags.RowSet));
        if (n2 < 32) {
            n2 = 32;
        }
        sqlJetVdbeMem.zMalloc = SqlJetUtility.allocatePtr(n2);
        if (bl2 && sqlJetVdbeMem.z != null) {
            SqlJetUtility.memcpy(sqlJetVdbeMem.zMalloc, sqlJetVdbeMem.z, sqlJetVdbeMem.n);
        }
        if (sqlJetVdbeMem.flags.contains((Object)SqlJetVdbeMemFlags.Dyn) && sqlJetVdbeMem.xDel != null) {
            sqlJetVdbeMem.xDel.call(sqlJetVdbeMem.z);
        }
        sqlJetVdbeMem.z = sqlJetVdbeMem.zMalloc;
        if (sqlJetVdbeMem.z == null) {
            sqlJetVdbeMem.flags = SqlJetUtility.of(SqlJetVdbeMemFlags.Null);
        } else {
            sqlJetVdbeMem.flags.remove((Object)SqlJetVdbeMemFlags.Ephem);
            sqlJetVdbeMem.flags.remove((Object)SqlJetVdbeMemFlags.Static);
        }
        sqlJetVdbeMem.xDel = null;
    }

    public void nulTerminate() {
        SqlJetVdbeMem sqlJetVdbeMem = this;
        assert (sqlJetVdbeMem.db == null || SqlJetUtility.mutex_held(sqlJetVdbeMem.db.getMutex()));
        if (sqlJetVdbeMem.flags.contains((Object)SqlJetVdbeMemFlags.Term) || !sqlJetVdbeMem.flags.contains((Object)SqlJetVdbeMemFlags.Str)) {
            return;
        }
        sqlJetVdbeMem.grow(sqlJetVdbeMem.n + 2, true);
        sqlJetVdbeMem.z.putByte(sqlJetVdbeMem.n, (byte)0);
        sqlJetVdbeMem.z.putByte(sqlJetVdbeMem.n + 1, (byte)0);
        sqlJetVdbeMem.flags.add(SqlJetVdbeMemFlags.Term);
        sqlJetVdbeMem.z.limit(sqlJetVdbeMem.n);
    }

    public void changeEncoding(SqlJetEncoding sqlJetEncoding) {
        SqlJetVdbeMem sqlJetVdbeMem = this;
        assert (!sqlJetVdbeMem.flags.contains((Object)SqlJetVdbeMemFlags.RowSet));
        assert (sqlJetEncoding == SqlJetEncoding.UTF8 || sqlJetEncoding == SqlJetEncoding.UTF16LE || sqlJetEncoding == SqlJetEncoding.UTF16BE);
        if (!sqlJetVdbeMem.flags.contains((Object)SqlJetVdbeMemFlags.Str) || sqlJetVdbeMem.enc == sqlJetEncoding) {
            return;
        }
        assert (sqlJetVdbeMem.db == null || SqlJetUtility.mutex_held(sqlJetVdbeMem.db.getMutex()));
        sqlJetVdbeMem.translate(sqlJetEncoding);
    }

    public void translate(SqlJetEncoding sqlJetEncoding) {
        int n2;
        SqlJetVdbeMem sqlJetVdbeMem = this;
        assert (sqlJetVdbeMem.db == null || SqlJetUtility.mutex_held(sqlJetVdbeMem.db.getMutex()));
        assert (sqlJetVdbeMem.flags.contains((Object)SqlJetVdbeMemFlags.Str));
        assert (sqlJetVdbeMem.enc != sqlJetEncoding);
        assert (sqlJetVdbeMem.enc != null);
        assert (sqlJetVdbeMem.n >= 0);
        if (sqlJetVdbeMem.enc != SqlJetEncoding.UTF8 && sqlJetEncoding != SqlJetEncoding.UTF8) {
            sqlJetVdbeMem.makeWriteable();
            int n3 = sqlJetVdbeMem.n & 0xFFFFFFFE;
            for (int i2 = 0; i2 < n3; ++i2) {
                short s2 = (short)SqlJetUtility.getUnsignedByte(sqlJetVdbeMem.z, i2);
                SqlJetUtility.putUnsignedByte(sqlJetVdbeMem.z, i2, SqlJetUtility.getUnsignedByte(sqlJetVdbeMem.z, i2 + 1));
                int n4 = ++i2;
                SqlJetUtility.putUnsignedByte(sqlJetVdbeMem.z, n4, s2);
            }
            sqlJetVdbeMem.enc = sqlJetEncoding;
            return;
        }
        if (sqlJetEncoding == SqlJetEncoding.UTF8) {
            sqlJetVdbeMem.n &= 0xFFFFFFFE;
            n2 = sqlJetVdbeMem.n * 2 + 1;
        } else {
            n2 = sqlJetVdbeMem.n * 2 + 2;
        }
        ISqlJetMemoryPointer iSqlJetMemoryPointer = SqlJetUtility.translate(sqlJetVdbeMem.z, sqlJetVdbeMem.enc, sqlJetEncoding);
        sqlJetVdbeMem.n = iSqlJetMemoryPointer.remaining();
        assert (sqlJetVdbeMem.n + (sqlJetEncoding == SqlJetEncoding.UTF8 ? 1 : 2) <= n2);
        sqlJetVdbeMem.reset();
        sqlJetVdbeMem.flags.removeAll(SqlJetUtility.of((Enum)SqlJetVdbeMemFlags.Static, (Enum)SqlJetVdbeMemFlags.Dyn, (Enum)SqlJetVdbeMemFlags.Ephem));
        sqlJetVdbeMem.enc = sqlJetEncoding;
        sqlJetVdbeMem.flags.addAll(SqlJetUtility.of((Enum)SqlJetVdbeMemFlags.Term, (Enum)SqlJetVdbeMemFlags.Dyn));
        sqlJetVdbeMem.zMalloc = sqlJetVdbeMem.z = iSqlJetMemoryPointer;
    }

    public void expandBlob() {
        SqlJetVdbeMem sqlJetVdbeMem = this;
        if (sqlJetVdbeMem.flags.contains((Object)SqlJetVdbeMemFlags.Zero)) {
            assert (sqlJetVdbeMem.flags.contains((Object)SqlJetVdbeMemFlags.Blob));
            assert (!sqlJetVdbeMem.flags.contains((Object)SqlJetVdbeMemFlags.RowSet));
            assert (sqlJetVdbeMem.db == null || SqlJetUtility.mutex_held(sqlJetVdbeMem.db.getMutex()));
            int n2 = sqlJetVdbeMem.n + sqlJetVdbeMem.nZero;
            if (n2 <= 0) {
                n2 = 1;
            }
            sqlJetVdbeMem.grow(n2, true);
            SqlJetUtility.memset(sqlJetVdbeMem.z, sqlJetVdbeMem.n, (byte)0, sqlJetVdbeMem.nZero);
            sqlJetVdbeMem.n += sqlJetVdbeMem.nZero;
            sqlJetVdbeMem.flags.removeAll(SqlJetUtility.of((Enum)SqlJetVdbeMemFlags.Zero, (Enum)SqlJetVdbeMemFlags.Term));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void fromBtree(ISqlJetBtreeCursor iSqlJetBtreeCursor, int n2, int n3, boolean bl2) {
        block12: {
            assert (SqlJetUtility.mutex_held(iSqlJetBtreeCursor.getCursorDb().getMutex()));
            SqlJetVdbeMem sqlJetVdbeMem = this;
            int[] nArray = new int[]{0};
            ISqlJetMemoryPointer iSqlJetMemoryPointer = bl2 ? iSqlJetBtreeCursor.keyFetch(nArray) : iSqlJetBtreeCursor.dataFetch(nArray);
            assert (iSqlJetMemoryPointer != null);
            if (n2 + n3 <= nArray[0]) {
                sqlJetVdbeMem.reset();
                sqlJetVdbeMem.z = SqlJetUtility.pointer(iSqlJetMemoryPointer, n2);
                sqlJetVdbeMem.flags = SqlJetUtility.of((Enum)SqlJetVdbeMemFlags.Blob, (Enum)SqlJetVdbeMemFlags.Ephem);
            } else {
                sqlJetVdbeMem.grow(n3 + 2, false);
                sqlJetVdbeMem.flags = SqlJetUtility.of((Enum)SqlJetVdbeMemFlags.Blob, (Enum)SqlJetVdbeMemFlags.Dyn, (Enum)SqlJetVdbeMemFlags.Term);
                sqlJetVdbeMem.enc = null;
                sqlJetVdbeMem.type = SqlJetValueType.BLOB;
                try {
                    try {
                        if (bl2) {
                            iSqlJetBtreeCursor.key(n2, n3, sqlJetVdbeMem.z);
                        } else {
                            iSqlJetBtreeCursor.data(n2, n3, sqlJetVdbeMem.z);
                        }
                    }
                    catch (SqlJetException sqlJetException) {
                        sqlJetVdbeMem.reset();
                        throw sqlJetException;
                    }
                    Object var10_8 = null;
                    if (sqlJetVdbeMem.z == null) break block12;
                }
                catch (Throwable throwable) {
                    Object var10_9 = null;
                    if (sqlJetVdbeMem.z != null) {
                        SqlJetUtility.putUnsignedByte(sqlJetVdbeMem.z, n3, 0);
                        SqlJetUtility.putUnsignedByte(sqlJetVdbeMem.z, n3 + 1, 0);
                    }
                    throw throwable;
                }
                SqlJetUtility.putUnsignedByte(sqlJetVdbeMem.z, n3, 0);
                SqlJetUtility.putUnsignedByte(sqlJetVdbeMem.z, n3 + 1, 0);
            }
        }
        sqlJetVdbeMem.n = n3;
    }

    public void makeWriteable() {
        SqlJetVdbeMem sqlJetVdbeMem = this;
        assert (sqlJetVdbeMem.db == null || SqlJetUtility.mutex_held(sqlJetVdbeMem.db.getMutex()));
        assert (!sqlJetVdbeMem.flags.contains((Object)SqlJetVdbeMemFlags.RowSet));
        sqlJetVdbeMem.expandBlob();
        if ((sqlJetVdbeMem.flags.contains((Object)SqlJetVdbeMemFlags.Str) || sqlJetVdbeMem.flags.contains((Object)SqlJetVdbeMemFlags.Blob)) && sqlJetVdbeMem.z != sqlJetVdbeMem.zMalloc) {
            sqlJetVdbeMem.grow(sqlJetVdbeMem.n + 2, true);
            SqlJetUtility.putUnsignedByte(sqlJetVdbeMem.z, sqlJetVdbeMem.n, 0);
            SqlJetUtility.putUnsignedByte(sqlJetVdbeMem.z, sqlJetVdbeMem.n + 1, 0);
            sqlJetVdbeMem.flags.add(SqlJetVdbeMemFlags.Term);
            sqlJetVdbeMem.z.limit(sqlJetVdbeMem.n);
        }
    }

    public long intValue() {
        assert (this.db == null || SqlJetUtility.mutex_held(this.db.getMutex()));
        if (this.flags.contains((Object)SqlJetVdbeMemFlags.Int)) {
            return this.i;
        }
        if (this.flags.contains((Object)SqlJetVdbeMemFlags.Real)) {
            return (long)this.r;
        }
        if (this.flags.contains((Object)SqlJetVdbeMemFlags.Str) || this.flags.contains((Object)SqlJetVdbeMemFlags.Blob)) {
            long l2 = 0L;
            this.flags.add(SqlJetVdbeMemFlags.Str);
            try {
                this.changeEncoding(SqlJetEncoding.UTF8);
                this.nulTerminate();
            }
            catch (SqlJetException sqlJetException) {
                return 0L;
            }
            l2 = SqlJetUtility.atoi64(SqlJetUtility.toString(this.z));
            return l2;
        }
        return 0L;
    }

    public void setNull() {
        if (this.flags.contains((Object)SqlJetVdbeMemFlags.RowSet)) {
            // empty if block
        }
        this.flags = SqlJetUtility.of(SqlJetVdbeMemFlags.Null);
        this.type = SqlJetValueType.NULL;
    }

    public void setStr(ISqlJetMemoryPointer iSqlJetMemoryPointer, SqlJetEncoding sqlJetEncoding) {
        assert (this.db == null || SqlJetUtility.mutex_held(this.db.getMutex()));
        assert (!this.flags.contains((Object)SqlJetVdbeMemFlags.RowSet));
        if (iSqlJetMemoryPointer == null) {
            this.setNull();
            return;
        }
        int n2 = iSqlJetMemoryPointer.remaining();
        int n3 = 1000000000;
        this.flags = SqlJetUtility.noneOf(SqlJetVdbeMemFlags.class);
        this.flags.add(sqlJetEncoding == null ? SqlJetVdbeMemFlags.Blob : SqlJetVdbeMemFlags.Str);
        if (n2 > n3) {
            throw new SqlJetException(SqlJetErrorCode.TOOBIG);
        }
        this.z = iSqlJetMemoryPointer;
        this.n = n2;
        this.enc = sqlJetEncoding == null ? SqlJetEncoding.UTF8 : sqlJetEncoding;
        this.type = sqlJetEncoding == null ? SqlJetValueType.BLOB : SqlJetValueType.TEXT;
    }

    public void setInt64(long l2) {
        this.reset();
        this.i = l2;
        this.flags = SqlJetUtility.of(SqlJetVdbeMemFlags.Int);
        this.type = SqlJetValueType.INTEGER;
    }

    public double realValue() {
        SqlJetVdbeMem sqlJetVdbeMem = this;
        assert (sqlJetVdbeMem.db == null || sqlJetVdbeMem.db.getMutex().held());
        if (sqlJetVdbeMem.flags.contains((Object)SqlJetVdbeMemFlags.Real)) {
            return sqlJetVdbeMem.r;
        }
        if (sqlJetVdbeMem.flags.contains((Object)SqlJetVdbeMemFlags.Int)) {
            return sqlJetVdbeMem.i;
        }
        if (sqlJetVdbeMem.flags.contains((Object)SqlJetVdbeMemFlags.Str) || sqlJetVdbeMem.flags.contains((Object)SqlJetVdbeMemFlags.Blob)) {
            double d2 = 0.0;
            sqlJetVdbeMem.flags.add(SqlJetVdbeMemFlags.Str);
            try {
                sqlJetVdbeMem.changeEncoding(SqlJetEncoding.UTF8);
                sqlJetVdbeMem.nulTerminate();
            }
            catch (SqlJetException sqlJetException) {
                return 0.0;
            }
            assert (sqlJetVdbeMem.z != null);
            d2 = SqlJetUtility.atof(sqlJetVdbeMem.z);
            return d2;
        }
        return 0.0;
    }

    public void integerAffinity() {
        SqlJetVdbeMem sqlJetVdbeMem = this;
        assert (sqlJetVdbeMem.flags.contains((Object)SqlJetVdbeMemFlags.Real));
        assert (!sqlJetVdbeMem.flags.contains((Object)SqlJetVdbeMemFlags.RowSet));
        assert (sqlJetVdbeMem.db == null || sqlJetVdbeMem.db.getMutex().held());
        sqlJetVdbeMem.i = (long)sqlJetVdbeMem.r;
        if (sqlJetVdbeMem.r == (double)sqlJetVdbeMem.i) {
            sqlJetVdbeMem.flags.add(SqlJetVdbeMemFlags.Int);
            this.type = SqlJetValueType.INTEGER;
        }
    }

    public void integerify() {
        SqlJetVdbeMem sqlJetVdbeMem = this;
        assert (sqlJetVdbeMem.db == null || sqlJetVdbeMem.db.getMutex().held());
        assert (!sqlJetVdbeMem.flags.contains((Object)SqlJetVdbeMemFlags.RowSet));
        sqlJetVdbeMem.i = sqlJetVdbeMem.intValue();
        sqlJetVdbeMem.setTypeFlag(SqlJetVdbeMemFlags.Int);
        this.type = SqlJetValueType.INTEGER;
    }

    public void realify() {
        SqlJetVdbeMem sqlJetVdbeMem = this;
        assert (sqlJetVdbeMem.db == null || sqlJetVdbeMem.db.getMutex().held());
        sqlJetVdbeMem.r = sqlJetVdbeMem.realValue();
        sqlJetVdbeMem.setTypeFlag(SqlJetVdbeMemFlags.Real);
        this.type = SqlJetValueType.FLOAT;
    }

    public void numerify() {
        long l2;
        double d2;
        SqlJetVdbeMem sqlJetVdbeMem = this;
        assert (!(sqlJetVdbeMem.flags.contains((Object)SqlJetVdbeMemFlags.Int) || sqlJetVdbeMem.flags.contains((Object)SqlJetVdbeMemFlags.Real) || sqlJetVdbeMem.flags.contains((Object)SqlJetVdbeMemFlags.Null)));
        assert (sqlJetVdbeMem.flags.contains((Object)SqlJetVdbeMemFlags.Str) || sqlJetVdbeMem.flags.contains((Object)SqlJetVdbeMemFlags.Blob));
        assert (sqlJetVdbeMem.db == null || sqlJetVdbeMem.db.getMutex().held());
        double d3 = sqlJetVdbeMem.realValue();
        if (d3 == (d2 = (double)(l2 = (long)d3))) {
            sqlJetVdbeMem.integerify();
        } else {
            sqlJetVdbeMem.r = d3;
            sqlJetVdbeMem.setTypeFlag(SqlJetVdbeMemFlags.Real);
            this.type = SqlJetValueType.FLOAT;
        }
    }

    public void setTypeFlag(SqlJetVdbeMemFlags sqlJetVdbeMemFlags) {
        Iterator iterator = this.flags.iterator();
        while (iterator.hasNext()) {
            SqlJetVdbeMemFlags sqlJetVdbeMemFlags2 = (SqlJetVdbeMemFlags)((Object)iterator.next());
            if (sqlJetVdbeMemFlags2.ordinal() >= SqlJetVdbeMemFlags.TypeMask.ordinal() && sqlJetVdbeMemFlags2 != SqlJetVdbeMemFlags.Zero) continue;
            iterator.remove();
        }
        this.flags.add(sqlJetVdbeMemFlags);
    }

    public void setZeroBlob(int n2) {
        SqlJetVdbeMem sqlJetVdbeMem = this;
        sqlJetVdbeMem.reset();
        sqlJetVdbeMem.flags = SqlJetUtility.of((Enum)SqlJetVdbeMemFlags.Blob, (Enum)SqlJetVdbeMemFlags.Zero);
        sqlJetVdbeMem.type = SqlJetValueType.BLOB;
        sqlJetVdbeMem.n = 0;
        if (n2 < 0) {
            n2 = 0;
        }
        sqlJetVdbeMem.nZero = n2;
        sqlJetVdbeMem.enc = SqlJetEncoding.UTF8;
    }

    public void setDouble(double d2) {
        SqlJetVdbeMem sqlJetVdbeMem = this;
        if (Double.isNaN(d2)) {
            sqlJetVdbeMem.setNull();
        } else {
            sqlJetVdbeMem.reset();
            sqlJetVdbeMem.r = d2;
            sqlJetVdbeMem.flags = SqlJetUtility.of(SqlJetVdbeMemFlags.Real);
            sqlJetVdbeMem.type = SqlJetValueType.FLOAT;
        }
    }

    public void setRowSet() {
        SqlJetVdbeMem sqlJetVdbeMem = this;
        ISqlJetDbHandle iSqlJetDbHandle = sqlJetVdbeMem.db;
        assert (iSqlJetDbHandle != null);
        if (sqlJetVdbeMem.flags.contains((Object)SqlJetVdbeMemFlags.RowSet)) {
            sqlJetVdbeMem.pRowSet.clear();
        } else {
            sqlJetVdbeMem.reset();
            sqlJetVdbeMem.pRowSet = new SqlJetRowSet(iSqlJetDbHandle);
            sqlJetVdbeMem.flags.add(SqlJetVdbeMemFlags.RowSet);
        }
    }

    public boolean isTooBig() {
        SqlJetVdbeMem sqlJetVdbeMem = this;
        assert (sqlJetVdbeMem.db != null);
        if (sqlJetVdbeMem.flags.contains((Object)SqlJetVdbeMemFlags.Str) || sqlJetVdbeMem.flags.contains((Object)SqlJetVdbeMemFlags.Blob)) {
            int n2 = sqlJetVdbeMem.n;
            if (sqlJetVdbeMem.flags.contains((Object)SqlJetVdbeMemFlags.Zero)) {
                n2 += sqlJetVdbeMem.nZero;
            }
            return n2 > 1000000000;
        }
        return false;
    }

    public void sanity() {
        SqlJetVdbeMem sqlJetVdbeMem = this;
        EnumSet enumSet = sqlJetVdbeMem.flags;
        assert (enumSet != null && enumSet.size() > 0);
        if (enumSet.contains((Object)SqlJetVdbeMemFlags.Str) || enumSet.contains((Object)SqlJetVdbeMemFlags.Blob)) {
            int n2 = (enumSet.contains((Object)SqlJetVdbeMemFlags.Static) ? 1 : 0) + (enumSet.contains((Object)SqlJetVdbeMemFlags.Dyn) ? 1 : 0) + (enumSet.contains((Object)SqlJetVdbeMemFlags.Ephem) ? 1 : 0);
            assert (n2 == 1);
            assert (sqlJetVdbeMem.z != null);
            assert (sqlJetVdbeMem.xDel == null || enumSet.contains((Object)SqlJetVdbeMemFlags.Dyn));
            if (enumSet.contains((Object)SqlJetVdbeMemFlags.Str)) {
                assert (sqlJetVdbeMem.enc == SqlJetEncoding.UTF8 || sqlJetVdbeMem.enc == SqlJetEncoding.UTF16BE || sqlJetVdbeMem.enc == SqlJetEncoding.UTF16LE);
                if (sqlJetVdbeMem.enc == SqlJetEncoding.UTF8 && enumSet.contains((Object)SqlJetVdbeMemFlags.Term)) {
                    assert (SqlJetUtility.strlen30(sqlJetVdbeMem.z) <= sqlJetVdbeMem.n);
                    assert (SqlJetUtility.getUnsignedByte(sqlJetVdbeMem.z, sqlJetVdbeMem.n) == 0);
                }
            }
        } else {
            assert (!(sqlJetVdbeMem.flags.contains((Object)SqlJetVdbeMemFlags.Static) || sqlJetVdbeMem.flags.contains((Object)SqlJetVdbeMemFlags.Dyn) || sqlJetVdbeMem.flags.contains((Object)SqlJetVdbeMemFlags.Ephem)));
            assert (sqlJetVdbeMem.xDel == null);
        }
        assert (!sqlJetVdbeMem.flags.contains((Object)SqlJetVdbeMemFlags.Static) && !sqlJetVdbeMem.flags.contains((Object)SqlJetVdbeMemFlags.Dyn) && !sqlJetVdbeMem.flags.contains((Object)SqlJetVdbeMemFlags.Ephem) || !sqlJetVdbeMem.flags.contains((Object)SqlJetVdbeMemFlags.Null));
        assert (sqlJetVdbeMem.flags.contains((Object)SqlJetVdbeMemFlags.Int) && sqlJetVdbeMem.flags.contains((Object)SqlJetVdbeMemFlags.Real) && sqlJetVdbeMem.r == (double)sqlJetVdbeMem.i);
    }

    public int valueBytes(SqlJetEncoding sqlJetEncoding) {
        SqlJetVdbeMem sqlJetVdbeMem = this;
        if (sqlJetVdbeMem.flags.contains((Object)SqlJetVdbeMemFlags.Blob) || sqlJetVdbeMem.valueText(sqlJetEncoding) != null) {
            if (sqlJetVdbeMem.flags.contains((Object)SqlJetVdbeMemFlags.Zero)) {
                return sqlJetVdbeMem.n + sqlJetVdbeMem.nZero;
            }
            return sqlJetVdbeMem.n;
        }
        return 0;
    }

    public void handleBom() {
        SqlJetVdbeMem sqlJetVdbeMem = this;
        SqlJetEncoding sqlJetEncoding = null;
        if (sqlJetVdbeMem.n < 0 || sqlJetVdbeMem.n > 1) {
            short s2 = (short)SqlJetUtility.getUnsignedByte(sqlJetVdbeMem.z, 0);
            short s3 = (short)SqlJetUtility.getUnsignedByte(sqlJetVdbeMem.z, 1);
            if (s2 == 254 && s3 == 255) {
                sqlJetEncoding = SqlJetEncoding.UTF16BE;
            }
            if (s2 == 255 && s3 == 254) {
                sqlJetEncoding = SqlJetEncoding.UTF16LE;
            }
        }
        if (null != sqlJetEncoding) {
            sqlJetVdbeMem.makeWriteable();
            sqlJetVdbeMem.n -= 2;
            SqlJetUtility.memmove(sqlJetVdbeMem.z, 0, sqlJetVdbeMem.z, 2, sqlJetVdbeMem.n);
            SqlJetUtility.putUnsignedByte(sqlJetVdbeMem.z, sqlJetVdbeMem.n, 0);
            SqlJetUtility.putUnsignedByte(sqlJetVdbeMem.z, sqlJetVdbeMem.n + 1, 0);
            sqlJetVdbeMem.flags.add(SqlJetVdbeMemFlags.Term);
            sqlJetVdbeMem.enc = sqlJetEncoding;
        }
    }

    public Set getFlags() {
        return this.flags;
    }

    public boolean isNull() {
        if (null == this.flags) {
            return true;
        }
        return this.flags.contains((Object)SqlJetVdbeMemFlags.Null);
    }

    public SqlJetValueType getType() {
        return this.type;
    }

    public ISqlJetMemoryPointer valueBlob() {
        if (this.flags.contains((Object)SqlJetVdbeMemFlags.Str) || this.flags.contains((Object)SqlJetVdbeMemFlags.Blob)) {
            this.expandBlob();
            this.flags.remove((Object)SqlJetVdbeMemFlags.Str);
            this.flags.add(SqlJetVdbeMemFlags.Blob);
            this.z.limit(this.n);
            return this.z;
        }
        return this.valueText(SqlJetEncoding.UTF8);
    }

    public void applyAffinity(SqlJetTypeAffinity sqlJetTypeAffinity, SqlJetEncoding sqlJetEncoding) {
        if (sqlJetTypeAffinity == SqlJetTypeAffinity.TEXT) {
            if (!this.flags.contains((Object)SqlJetVdbeMemFlags.Str) && (this.flags.contains((Object)SqlJetVdbeMemFlags.Real) || this.flags.contains((Object)SqlJetVdbeMemFlags.Int))) {
                this.stringify(sqlJetEncoding);
            }
            this.flags.remove((Object)SqlJetVdbeMemFlags.Real);
            this.flags.remove((Object)SqlJetVdbeMemFlags.Int);
        } else if (sqlJetTypeAffinity != SqlJetTypeAffinity.NONE) {
            assert (sqlJetTypeAffinity == SqlJetTypeAffinity.INTEGER || sqlJetTypeAffinity == SqlJetTypeAffinity.REAL || sqlJetTypeAffinity == SqlJetTypeAffinity.NUMERIC);
            this.applyNumericAffinity();
        }
    }

    public void applyNumericAffinity() {
        if (!this.flags.contains((Object)SqlJetVdbeMemFlags.Real) && !this.flags.contains((Object)SqlJetVdbeMemFlags.Int)) {
            boolean[] blArray = new boolean[]{false};
            this.nulTerminate();
            if (this.flags.contains((Object)SqlJetVdbeMemFlags.Str) && SqlJetUtility.isNumber(SqlJetUtility.toString(this.z, this.enc), blArray)) {
                Long l2;
                this.changeEncoding(SqlJetEncoding.UTF8);
                if (!blArray[0] && (l2 = SqlJetUtility.atoi64(SqlJetUtility.toString(this.z))) != null) {
                    this.i = l2;
                    this.setTypeFlag(SqlJetVdbeMemFlags.Int);
                    this.type = SqlJetValueType.INTEGER;
                } else {
                    this.realify();
                }
            }
        } else if (this.type != SqlJetValueType.INTEGER && this.type != SqlJetValueType.FLOAT) {
            if (this.flags.contains((Object)SqlJetVdbeMemFlags.Int)) {
                this.type = SqlJetValueType.INTEGER;
            } else if (this.flags.contains((Object)SqlJetVdbeMemFlags.Real)) {
                this.type = SqlJetValueType.FLOAT;
            }
        }
    }

    void applyIntegerAffinity() {
        assert (this.flags.contains((Object)SqlJetVdbeMemFlags.Real));
        assert (!this.flags.contains((Object)SqlJetVdbeMemFlags.RowSet));
        assert (this.db == null || SqlJetUtility.mutex_held(this.db.getMutex()));
        Long l2 = SqlJetUtility.doubleToInt64(this.r);
        if (l2 != null) {
            this.i = l2;
            this.flags.add(SqlJetVdbeMemFlags.Int);
            this.type = SqlJetValueType.INTEGER;
        }
    }
}

