/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.vdbe;

import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.tmatesoft.sqljet.core.SqlJetEncoding;
import org.tmatesoft.sqljet.core.SqlJetErrorCode;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.internal.ISqlJetBtreeCursor;
import org.tmatesoft.sqljet.core.internal.ISqlJetMemoryPointer;
import org.tmatesoft.sqljet.core.internal.ISqlJetVdbeMem;
import org.tmatesoft.sqljet.core.internal.SqlJetUtility;
import org.tmatesoft.sqljet.core.internal.memory.SqlJetMemoryPointer;
import org.tmatesoft.sqljet.core.internal.table.ISqlJetBtreeRecord;
import org.tmatesoft.sqljet.core.internal.vdbe.SqlJetVdbeMem;
import org.tmatesoft.sqljet.core.internal.vdbe.SqlJetVdbeMemFlags;
import org.tmatesoft.sqljet.core.internal.vdbe.SqlJetVdbeSerialType;
import org.tmatesoft.sqljet.core.table.ISqlJetOptions;

public class SqlJetBtreeRecord
implements ISqlJetBtreeRecord {
    private ISqlJetBtreeCursor cursor;
    private boolean isIndex;
    private int fieldsCount = 0;
    private List aType = new ArrayList();
    private List aOffset = new ArrayList();
    private List fields = new ArrayList();
    private int file_format = ISqlJetOptions.SQLJET_DEFAULT_FILE_FORMAT;

    public List getFields() {
        return Collections.unmodifiableList(this.fields);
    }

    public SqlJetBtreeRecord(ISqlJetBtreeCursor iSqlJetBtreeCursor, boolean bl2, int n2) {
        this.cursor = iSqlJetBtreeCursor;
        this.isIndex = bl2;
        this.file_format = n2;
        this.read();
    }

    public SqlJetBtreeRecord(List list) {
        this.fields.addAll(list);
        this.fieldsCount = list.size();
    }

    public SqlJetBtreeRecord(ISqlJetVdbeMem ... iSqlJetVdbeMemArray) {
        this.initFields(iSqlJetVdbeMemArray);
    }

    private void initFields(ISqlJetVdbeMem[] iSqlJetVdbeMemArray) {
        this.fields.addAll(Arrays.asList(iSqlJetVdbeMemArray));
        this.fieldsCount = iSqlJetVdbeMemArray.length;
    }

    public static ISqlJetBtreeRecord getRecord(SqlJetEncoding sqlJetEncoding, Object ... objectArray) {
        ArrayList<SqlJetVdbeMem> arrayList = new ArrayList<SqlJetVdbeMem>(objectArray.length);
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            Object object = objectArray[i2];
            SqlJetVdbeMem sqlJetVdbeMem = SqlJetVdbeMem.obtainInstance();
            if (null == object) {
                sqlJetVdbeMem.setNull();
            } else if (object instanceof String) {
                sqlJetVdbeMem.setStr(SqlJetUtility.fromString((String)object, sqlJetEncoding), sqlJetEncoding);
            } else if (object instanceof Boolean) {
                sqlJetVdbeMem.setInt64((Boolean)object != false ? 1L : 0L);
            } else if (object instanceof Byte) {
                sqlJetVdbeMem.setInt64(((Byte)object).byteValue());
            } else if (object instanceof Short) {
                sqlJetVdbeMem.setInt64(((Short)object).shortValue());
            } else if (object instanceof Integer) {
                sqlJetVdbeMem.setInt64(((Integer)object).intValue());
            } else if (object instanceof Long) {
                sqlJetVdbeMem.setInt64((Long)object);
            } else if (object instanceof Float) {
                sqlJetVdbeMem.setDouble(((Float)object).floatValue());
            } else if (object instanceof Double) {
                sqlJetVdbeMem.setDouble((Double)object);
            } else if (object instanceof ByteBuffer) {
                sqlJetVdbeMem.setStr(SqlJetUtility.fromByteBuffer((ByteBuffer)object), sqlJetEncoding);
                sqlJetVdbeMem.setTypeFlag(SqlJetVdbeMemFlags.Blob);
            } else if (object instanceof InputStream) {
                sqlJetVdbeMem.setStr(SqlJetUtility.streamToBuffer((InputStream)object), sqlJetEncoding);
                sqlJetVdbeMem.setTypeFlag(SqlJetVdbeMemFlags.Blob);
            } else if ("byte[]".equalsIgnoreCase(object.getClass().getCanonicalName())) {
                sqlJetVdbeMem.setStr(SqlJetUtility.wrapPtr((byte[])object), sqlJetEncoding);
                sqlJetVdbeMem.setTypeFlag(SqlJetVdbeMemFlags.Blob);
            } else if (object instanceof SqlJetMemoryPointer) {
                sqlJetVdbeMem.setStr((SqlJetMemoryPointer)object, sqlJetEncoding);
                sqlJetVdbeMem.setTypeFlag(SqlJetVdbeMemFlags.Blob);
            } else {
                throw new SqlJetException(SqlJetErrorCode.MISUSE, "Bad value #" + i2 + " " + object.toString());
            }
            arrayList.add(sqlJetVdbeMem);
        }
        return new SqlJetBtreeRecord(arrayList);
    }

    public int getFieldsCount() {
        return this.fieldsCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void read() {
        this.cursor.enterCursor();
        try {
            long l2 = this.isIndex ? this.cursor.getKeySize() : (long)this.cursor.getDataSize();
            if (l2 == 0L) {
                Object var13_2 = null;
                this.cursor.leaveCursor();
                return;
            }
            SqlJetVdbeMem sqlJetVdbeMem = SqlJetVdbeMem.obtainInstance();
            int[] nArray = new int[]{0};
            int[] nArray2 = new int[]{0};
            assert (this.aType != null);
            assert (this.aOffset != null);
            ISqlJetMemoryPointer iSqlJetMemoryPointer = this.isIndex ? this.cursor.keyFetch(nArray2) : this.cursor.dataFetch(nArray2);
            byte by = SqlJetUtility.getVarint32(iSqlJetMemoryPointer, nArray);
            if (nArray2[0] < nArray[0]) {
                sqlJetVdbeMem.fromBtree(this.cursor, 0, nArray[0], this.isIndex);
                iSqlJetMemoryPointer = sqlJetVdbeMem.z;
            }
            ISqlJetMemoryPointer iSqlJetMemoryPointer2 = SqlJetUtility.pointer(iSqlJetMemoryPointer, nArray[0]);
            ISqlJetMemoryPointer iSqlJetMemoryPointer3 = SqlJetUtility.pointer(iSqlJetMemoryPointer, by);
            this.fieldsCount = 0;
            int n2 = 0;
            while (n2 < 2000 && iSqlJetMemoryPointer3.getPointer() < iSqlJetMemoryPointer2.getPointer() && (long)nArray[0] <= l2) {
                this.aOffset.add(n2, nArray[0]);
                int[] nArray3 = new int[]{0};
                SqlJetUtility.movePtr(iSqlJetMemoryPointer3, SqlJetUtility.getVarint32(iSqlJetMemoryPointer3, nArray3));
                this.aType.add(n2, nArray3[0]);
                nArray[0] = nArray[0] + SqlJetVdbeSerialType.serialTypeLen(nArray3[0]);
                this.fields.add(n2, this.getField(n2));
                ++n2;
                ++this.fieldsCount;
            }
            sqlJetVdbeMem.release();
            if (iSqlJetMemoryPointer3.getPointer() > iSqlJetMemoryPointer2.getPointer() || (long)nArray[0] > l2 || iSqlJetMemoryPointer3.getPointer() == iSqlJetMemoryPointer2.getPointer() && (long)nArray[0] != l2) {
                throw new SqlJetException(SqlJetErrorCode.CORRUPT);
            }
        }
        catch (Throwable throwable) {
            Object var13_4 = null;
            this.cursor.leaveCursor();
            throw throwable;
        }
        Object var13_3 = null;
        this.cursor.leaveCursor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ISqlJetVdbeMem getField(int n2) {
        SqlJetVdbeMem sqlJetVdbeMem;
        SqlJetVdbeMem sqlJetVdbeMem2;
        block8: {
            sqlJetVdbeMem2 = SqlJetVdbeMem.obtainInstance();
            sqlJetVdbeMem = SqlJetVdbeMem.obtainInstance();
            sqlJetVdbeMem.flags = SqlJetUtility.of(SqlJetVdbeMemFlags.Null);
            this.cursor.enterCursor();
            try {
                long l2 = this.isIndex ? this.cursor.getKeySize() : (long)this.cursor.getDataSize();
                if (l2 != 0L) break block8;
                sqlJetVdbeMem2.release();
                SqlJetVdbeMem sqlJetVdbeMem3 = sqlJetVdbeMem;
                Object var11_7 = null;
                this.cursor.leaveCursor();
                return sqlJetVdbeMem3;
            }
            catch (Throwable throwable) {
                Object var11_9 = null;
                this.cursor.leaveCursor();
                throw throwable;
            }
        }
        Integer n3 = (Integer)this.aOffset.get(n2);
        Integer n4 = (Integer)this.aType.get(n2);
        if (n3 != null && n4 != null && n3 != 0) {
            int n5 = SqlJetVdbeSerialType.serialTypeLen(n4);
            sqlJetVdbeMem2.fromBtree(this.cursor, (Integer)this.aOffset.get(n2), n5, this.isIndex);
            ISqlJetMemoryPointer iSqlJetMemoryPointer = sqlJetVdbeMem2.z;
            SqlJetVdbeSerialType.serialGet(iSqlJetMemoryPointer, n4, sqlJetVdbeMem);
            sqlJetVdbeMem.enc = this.cursor.getCursorDb().getOptions().getEncoding();
        }
        Object var11_8 = null;
        this.cursor.leaveCursor();
        if (sqlJetVdbeMem2.zMalloc != null) {
            assert (sqlJetVdbeMem2.z == sqlJetVdbeMem2.zMalloc);
            assert (!sqlJetVdbeMem.flags.contains((Object)SqlJetVdbeMemFlags.Dyn));
            assert (!sqlJetVdbeMem.flags.contains((Object)SqlJetVdbeMemFlags.Blob) && !sqlJetVdbeMem.flags.contains((Object)SqlJetVdbeMemFlags.Str) || sqlJetVdbeMem.z.getBuffer() == sqlJetVdbeMem2.z.getBuffer());
            sqlJetVdbeMem.flags.remove((Object)SqlJetVdbeMemFlags.Ephem);
            sqlJetVdbeMem.flags.remove((Object)SqlJetVdbeMemFlags.Static);
            sqlJetVdbeMem.flags.add(SqlJetVdbeMemFlags.Term);
        }
        sqlJetVdbeMem.makeWriteable();
        sqlJetVdbeMem2.release();
        return sqlJetVdbeMem;
    }

    public String getStringField(int n2, SqlJetEncoding sqlJetEncoding) {
        ISqlJetVdbeMem iSqlJetVdbeMem = (ISqlJetVdbeMem)this.fields.get(n2);
        if (null == iSqlJetVdbeMem) {
            return null;
        }
        ISqlJetMemoryPointer iSqlJetMemoryPointer = iSqlJetVdbeMem.valueText(sqlJetEncoding);
        if (null == iSqlJetMemoryPointer) {
            return null;
        }
        return SqlJetUtility.toString(iSqlJetMemoryPointer, sqlJetEncoding);
    }

    public long getIntField(int n2) {
        ISqlJetVdbeMem iSqlJetVdbeMem = (ISqlJetVdbeMem)this.fields.get(n2);
        if (null == iSqlJetVdbeMem) {
            return 0L;
        }
        return iSqlJetVdbeMem.intValue();
    }

    public double getRealField(int n2) {
        ISqlJetVdbeMem iSqlJetVdbeMem = (ISqlJetVdbeMem)this.fields.get(n2);
        if (null == iSqlJetVdbeMem) {
            return 0.0;
        }
        return iSqlJetVdbeMem.realValue();
    }

    public ISqlJetMemoryPointer getRawRecord() {
        int n2;
        SqlJetVdbeMem sqlJetVdbeMem;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        for (ISqlJetVdbeMem iSqlJetVdbeMem : this.fields) {
            sqlJetVdbeMem = (SqlJetVdbeMem)iSqlJetVdbeMem;
            if (sqlJetVdbeMem.flags.contains((Object)SqlJetVdbeMemFlags.Zero) && sqlJetVdbeMem.n > 0) {
                sqlJetVdbeMem.expandBlob();
            }
            n2 = SqlJetVdbeSerialType.serialType(sqlJetVdbeMem, this.file_format);
            int n7 = SqlJetVdbeSerialType.serialTypeLen(n2);
            n3 += n7;
            n4 += SqlJetUtility.varintLen(n2);
            if (sqlJetVdbeMem.flags.contains((Object)SqlJetVdbeMemFlags.Zero)) {
                n6 += sqlJetVdbeMem.nZero;
                continue;
            }
            if (n7 == 0) continue;
            n6 = 0;
        }
        int n8 = SqlJetUtility.varintLen(n4);
        if (n8 < SqlJetUtility.varintLen(n4 += n8)) {
            ++n4;
        }
        n5 = n4 + n3 - n6;
        ISqlJetMemoryPointer iSqlJetMemoryPointer = SqlJetUtility.allocatePtr(n5);
        int n9 = SqlJetUtility.putVarint32(iSqlJetMemoryPointer, n4);
        for (ISqlJetVdbeMem iSqlJetVdbeMem : this.fields) {
            sqlJetVdbeMem = (SqlJetVdbeMem)iSqlJetVdbeMem;
            n2 = SqlJetVdbeSerialType.serialType(sqlJetVdbeMem, this.file_format);
            n9 += SqlJetUtility.putVarint32(SqlJetUtility.pointer(iSqlJetMemoryPointer, n9), n2);
        }
        for (ISqlJetVdbeMem iSqlJetVdbeMem : this.fields) {
            sqlJetVdbeMem = (SqlJetVdbeMem)iSqlJetVdbeMem;
            n9 += SqlJetVdbeSerialType.serialPut(SqlJetUtility.pointer(iSqlJetMemoryPointer, n9), n5 - n9, sqlJetVdbeMem, this.file_format);
        }
        assert (n9 == n5);
        return iSqlJetMemoryPointer;
    }

    public void release() {
        for (ISqlJetVdbeMem iSqlJetVdbeMem : this.fields) {
            iSqlJetVdbeMem.release();
        }
    }
}

