/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.table;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.tmatesoft.sqljet.core.SqlJetErrorCode;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.internal.ISqlJetBtree;
import org.tmatesoft.sqljet.core.internal.SqlJetUtility;
import org.tmatesoft.sqljet.core.internal.table.ISqlJetBtreeIndexTable;
import org.tmatesoft.sqljet.core.internal.table.SqlJetBtreeDataTable;
import org.tmatesoft.sqljet.core.internal.table.SqlJetTable$1;
import org.tmatesoft.sqljet.core.internal.table.SqlJetTable$2;
import org.tmatesoft.sqljet.core.internal.table.SqlJetTable$3;
import org.tmatesoft.sqljet.core.internal.table.SqlJetTable$4;
import org.tmatesoft.sqljet.core.internal.table.SqlJetTable$5;
import org.tmatesoft.sqljet.core.internal.table.SqlJetTable$6;
import org.tmatesoft.sqljet.core.internal.table.SqlJetTable$7;
import org.tmatesoft.sqljet.core.internal.table.SqlJetTable$8;
import org.tmatesoft.sqljet.core.internal.table.SqlJetTable$9;
import org.tmatesoft.sqljet.core.internal.table.SqlJetTable$ISqlJetTableRun;
import org.tmatesoft.sqljet.core.schema.ISqlJetIndexDef;
import org.tmatesoft.sqljet.core.schema.ISqlJetTableDef;
import org.tmatesoft.sqljet.core.schema.SqlJetConflictAction;
import org.tmatesoft.sqljet.core.table.ISqlJetCursor;
import org.tmatesoft.sqljet.core.table.ISqlJetTable;
import org.tmatesoft.sqljet.core.table.SqlJetDb;
import org.tmatesoft.sqljet.core.table.SqlJetScope;

public class SqlJetTable
implements ISqlJetTable {
    private final SqlJetDb db;
    private ISqlJetBtree btree;
    private String tableName;
    private boolean write;

    public SqlJetTable(SqlJetDb sqlJetDb, ISqlJetBtree iSqlJetBtree, String string, boolean bl2) {
        this.db = sqlJetDb;
        this.btree = iSqlJetBtree;
        this.tableName = string;
        this.write = bl2;
        if (null == this.getDefinition()) {
            throw new SqlJetException(SqlJetErrorCode.ERROR, "Table not found: " + string);
        }
    }

    public SqlJetDb getDataBase() {
        return this.db;
    }

    public String getPrimaryKeyIndexName() {
        ISqlJetTableDef iSqlJetTableDef = this.getDefinition();
        return iSqlJetTableDef.isRowIdPrimaryKey() ? null : iSqlJetTableDef.getPrimaryKeyIndexName();
    }

    public ISqlJetTableDef getDefinition() {
        return this.btree.getSchema().getTable(this.tableName);
    }

    public Set getIndexesDefs() {
        return this.btree.getSchema().getIndexes(this.tableName);
    }

    public Set getIndexesNames() {
        TreeSet<String> treeSet = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        Set set = this.getIndexesDefs();
        if (null != set) {
            for (ISqlJetIndexDef iSqlJetIndexDef : set) {
                if (null == iSqlJetIndexDef) continue;
                treeSet.add(iSqlJetIndexDef.getName());
            }
        }
        return Collections.unmodifiableSet(treeSet);
    }

    public ISqlJetIndexDef getIndexDef(String string) {
        if (null == string && null == (string = this.getPrimaryKeyIndexName())) {
            return null;
        }
        Set set = this.getIndexesDefs();
        if (null != set) {
            for (ISqlJetIndexDef iSqlJetIndexDef : set) {
                if (null == iSqlJetIndexDef || !string.equalsIgnoreCase(iSqlJetIndexDef.getName())) continue;
                return iSqlJetIndexDef;
            }
        }
        return null;
    }

    public ISqlJetCursor open() {
        return (ISqlJetCursor)this.db.runWithLock(new SqlJetTable$1(this));
    }

    public ISqlJetCursor lookup(String string, Object ... objectArray) {
        Object[] objectArray2 = SqlJetUtility.adjustNumberTypes(objectArray);
        return (ISqlJetCursor)this.db.runWithLock(new SqlJetTable$2(this, string, objectArray2));
    }

    private Object runWriteTransaction(SqlJetTable$ISqlJetTableRun sqlJetTable$ISqlJetTableRun) {
        return this.db.runWriteTransaction(new SqlJetTable$3(this, sqlJetTable$ISqlJetTableRun));
    }

    public long insert(Object ... objectArray) {
        return this.insertOr(null, objectArray);
    }

    public long insertByFieldNames(Map map) {
        return this.insertByFieldNamesOr(null, map);
    }

    public long insertWithRowId(long l2, Object ... objectArray) {
        return this.insertWithRowIdOr(null, l2, objectArray);
    }

    public long insertOr(SqlJetConflictAction sqlJetConflictAction, Object ... objectArray) {
        return (Long)this.runWriteTransaction(new SqlJetTable$4(this, sqlJetConflictAction, objectArray));
    }

    public long insertByFieldNamesOr(SqlJetConflictAction sqlJetConflictAction, Map map) {
        return (Long)this.runWriteTransaction(new SqlJetTable$5(this, sqlJetConflictAction, map));
    }

    public long insertWithRowIdOr(SqlJetConflictAction sqlJetConflictAction, long l2, Object ... objectArray) {
        return (Long)this.runWriteTransaction(new SqlJetTable$6(this, sqlJetConflictAction, l2, objectArray));
    }

    public ISqlJetCursor order(String string) {
        return (ISqlJetCursor)this.db.runWithLock(new SqlJetTable$7(this, string));
    }

    public ISqlJetCursor scope(String string, Object[] objectArray, Object[] objectArray2) {
        return this.scope(string, new SqlJetScope(objectArray, objectArray2));
    }

    public ISqlJetCursor scope(String string, SqlJetScope sqlJetScope) {
        SqlJetScope sqlJetScope2 = SqlJetUtility.adjustScopeNumberTypes(sqlJetScope);
        return (ISqlJetCursor)this.db.runWithLock(new SqlJetTable$8(this, string, sqlJetScope2));
    }

    public void clear() {
        this.runWriteTransaction(new SqlJetTable$9(this));
    }

    private boolean isNeedReverse(ISqlJetBtreeIndexTable iSqlJetBtreeIndexTable, SqlJetScope sqlJetScope) {
        Object[] objectArray;
        Object[] objectArray2 = sqlJetScope.getLeftBound() != null ? sqlJetScope.getLeftBound().getValue() : null;
        Object[] objectArray3 = objectArray = sqlJetScope.getRightBound() != null ? sqlJetScope.getRightBound().getValue() : null;
        if (objectArray2 != null && objectArray != null && objectArray2.length > 0 && objectArray.length > 0) {
            if (iSqlJetBtreeIndexTable != null) {
                return iSqlJetBtreeIndexTable.compareKeys(objectArray2, objectArray) < 0;
            }
            if (objectArray2.length == 1 && objectArray.length == 1 && objectArray2[0] instanceof Long && objectArray[0] instanceof Long) {
                return ((Long)objectArray2[0]).compareTo((Long)objectArray[0]) > 0;
            }
        }
        return false;
    }

    private ISqlJetBtreeIndexTable getIndexTable(String string, SqlJetBtreeDataTable sqlJetBtreeDataTable) {
        String string2 = string == null ? sqlJetBtreeDataTable.getPrimaryKeyIndex() : string;
        return string2 != null ? sqlJetBtreeDataTable.getIndex(string2) : null;
    }

    private void checkIndexName(String string, SqlJetBtreeDataTable sqlJetBtreeDataTable) {
        if (!this.isIndexNameValid(string, sqlJetBtreeDataTable)) {
            throw new SqlJetException(SqlJetErrorCode.MISUSE, String.format("Index not exists: %s", string));
        }
    }

    private boolean isIndexNameValid(String string, SqlJetBtreeDataTable sqlJetBtreeDataTable) {
        if (string != null) {
            return this.getIndexTable(string, sqlJetBtreeDataTable) != null;
        }
        if (sqlJetBtreeDataTable.getDefinition().isRowIdPrimaryKey()) {
            return true;
        }
        return sqlJetBtreeDataTable.getPrimaryKeyIndex() != null;
    }

    static /* synthetic */ ISqlJetBtree access$000(SqlJetTable sqlJetTable) {
        return sqlJetTable.btree;
    }

    static /* synthetic */ String access$100(SqlJetTable sqlJetTable) {
        return sqlJetTable.tableName;
    }

    static /* synthetic */ boolean access$200(SqlJetTable sqlJetTable) {
        return sqlJetTable.write;
    }

    static /* synthetic */ void access$300(SqlJetTable sqlJetTable, String string, SqlJetBtreeDataTable sqlJetBtreeDataTable) {
        sqlJetTable.checkIndexName(string, sqlJetBtreeDataTable);
    }

    static /* synthetic */ ISqlJetBtreeIndexTable access$400(SqlJetTable sqlJetTable, String string, SqlJetBtreeDataTable sqlJetBtreeDataTable) {
        return sqlJetTable.getIndexTable(string, sqlJetBtreeDataTable);
    }

    static /* synthetic */ boolean access$500(SqlJetTable sqlJetTable, ISqlJetBtreeIndexTable iSqlJetBtreeIndexTable, SqlJetScope sqlJetScope) {
        return sqlJetTable.isNeedReverse(iSqlJetBtreeIndexTable, sqlJetScope);
    }
}

