/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.table;

import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.Tree;
import org.tmatesoft.sqljet.core.SqlJetEncoding;
import org.tmatesoft.sqljet.core.SqlJetErrorCode;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.internal.lang.SqlLexer;
import org.tmatesoft.sqljet.core.internal.lang.SqlParser;
import org.tmatesoft.sqljet.core.table.ISqlJetOptions;

public class SqlJetPragmasHandler {
    private final ISqlJetOptions options;

    public SqlJetPragmasHandler(ISqlJetOptions iSqlJetOptions) {
        this.options = iSqlJetOptions;
    }

    private ISqlJetOptions getOptions() {
        return this.options;
    }

    public Object pragma(String string) {
        return this.pragma(this.parsePragma(string));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object pragma(CommonTree commonTree) {
        assert ("pragma".equalsIgnoreCase(commonTree.getText()));
        String string = commonTree.getChild(0).getText();
        if (commonTree.getChildCount() > 1) {
            Object object = this.readPragmaValue(commonTree.getChild(1));
            if ("auto_vacuum".equals(string)) {
                int n2 = this.readAutovacuumMode(object);
                this.getOptions().setAutovacuum(n2 == 1);
                this.getOptions().setIncrementalVacuum(n2 == 2);
                return null;
            } else if ("cache_size".equals(string)) {
                if (!(object instanceof Number)) throw new SqlJetException(SqlJetErrorCode.ERROR, "Invalid cache_size value: " + object);
                this.getOptions().setCacheSize(((Number)object).intValue());
                return null;
            } else if ("encoding".equals(string)) {
                if (!(object instanceof String)) throw new SqlJetException(SqlJetErrorCode.ERROR, "Invalid encoding value: " + object);
                SqlJetEncoding sqlJetEncoding = SqlJetEncoding.decode((String)object);
                if (sqlJetEncoding == null) throw new SqlJetException(SqlJetErrorCode.ERROR, "Unknown encoding: " + object);
                this.getOptions().setEncoding(sqlJetEncoding);
                return null;
            } else if ("legacy_file_format".equals(string)) {
                this.getOptions().setLegacyFileFormat(this.toBooleanValue(object));
                return null;
            } else if ("schema_version".equals(string)) {
                if (!(object instanceof Number)) throw new SqlJetException(SqlJetErrorCode.ERROR, "Invalid schema_version value: " + object);
                int n3 = ((Number)object).intValue();
                this.getOptions().setSchemaVersion(n3);
                return null;
            } else {
                if (!"user_version".equals(string)) return null;
                if (!(object instanceof Number)) throw new SqlJetException(SqlJetErrorCode.ERROR, "Invalid user_version value: " + object);
                int n4 = ((Number)object).intValue();
                this.getOptions().setUserVersion(n4);
            }
            return null;
        }
        if ("auto_vacuum".equals(string)) {
            int n5 = 0;
            if (this.getOptions().isAutovacuum()) {
                n5 = 1;
            }
            if (!this.getOptions().isIncrementalVacuum()) return n5;
            n5 = 2;
            return n5;
        }
        if ("cache_size".equals(string)) {
            return this.getOptions().getCacheSize();
        }
        if ("encoding".equals(string)) {
            return this.getOptions().getEncoding();
        }
        if ("legacy_file_format".equals(string)) {
            return this.getOptions().isLegacyFileFormat();
        }
        if ("schema_version".equals(string)) {
            return this.getOptions().getSchemaVersion();
        }
        if (!"user_version".equals(string)) return null;
        return this.getOptions().getUserVersion();
    }

    private int readAutovacuumMode(Object object) {
        int n2;
        int n3 = -1;
        if (object instanceof String) {
            String string = (String)object;
            if ("none".equalsIgnoreCase(string)) {
                n3 = 0;
            } else if ("full".equalsIgnoreCase(string)) {
                n3 = 1;
            } else if ("incremental".equalsIgnoreCase(string)) {
                n3 = 2;
            }
        } else if (object instanceof Number && ((n2 = ((Number)object).intValue()) == 0 || n2 == 1 || n2 == 2)) {
            n3 = n2;
        }
        if (n3 < 0) {
            throw new SqlJetException(SqlJetErrorCode.ERROR, "Invalid auto_vacuum value: " + object);
        }
        return n3;
    }

    private CommonTree parsePragma(String string) {
        try {
            ANTLRStringStream aNTLRStringStream = new ANTLRStringStream(string);
            SqlLexer sqlLexer = new SqlLexer(aNTLRStringStream);
            CommonTokenStream commonTokenStream = new CommonTokenStream(sqlLexer);
            SqlParser sqlParser = new SqlParser(commonTokenStream);
            return (CommonTree)sqlParser.pragma_stmt().getTree();
        }
        catch (RecognitionException recognitionException) {
            throw new SqlJetException(SqlJetErrorCode.ERROR, "Invalid sql statement: " + string);
        }
    }

    private Object readPragmaValue(Tree tree) {
        String string = tree.getText();
        if (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("false")) {
            return Boolean.parseBoolean(string);
        }
        if (tree.getChild(0) == null) {
            return null;
        }
        String string2 = tree.getChild(0).getText();
        if ("float_literal".equalsIgnoreCase(string)) {
            return Double.valueOf(string2);
        }
        if ("id_literal".equalsIgnoreCase(string)) {
            return string2;
        }
        if ("string_literal".equalsIgnoreCase(string)) {
            return string2.substring(1, string2.length() - 1);
        }
        throw new IllegalStateException();
    }

    protected boolean toBooleanValue(Object object) {
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof Number) {
            int n2 = ((Number)object).intValue();
            if (n2 == 0) {
                return false;
            }
            if (n2 == 1) {
                return true;
            }
        } else if (object instanceof String) {
            String string = (String)object;
            if ("yes".equalsIgnoreCase(string) || "true".equalsIgnoreCase(string) || "on".equalsIgnoreCase(string)) {
                return true;
            }
            if ("no".equalsIgnoreCase(string) || "false".equalsIgnoreCase(string) || "off".equalsIgnoreCase(string)) {
                return false;
            }
        }
        throw new SqlJetException(SqlJetErrorCode.ERROR, "Boolean value is expected.");
    }

    protected Object toResult(boolean bl2) {
        return bl2 ? Integer.valueOf(1) : Integer.valueOf(0);
    }
}

