/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.table;

import org.tmatesoft.sqljet.core.SqlJetEncoding;
import org.tmatesoft.sqljet.core.SqlJetErrorCode;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.SqlJetTransactionMode;
import org.tmatesoft.sqljet.core.internal.ISqlJetBtree;
import org.tmatesoft.sqljet.core.internal.ISqlJetDbHandle;
import org.tmatesoft.sqljet.core.internal.SqlJetAutoVacuumMode;
import org.tmatesoft.sqljet.core.table.ISqlJetOptions;

public class SqlJetOptions
implements ISqlJetOptions {
    private static final int SCHEMA_COOKIE = 1;
    private static final int FILE_FORMAT = 2;
    private static final int PAGE_CACHE_SIZE = 3;
    private static final int AUTOVACUUM = 4;
    private static final int ENCODING = 5;
    private static final int USER_COOKIE = 6;
    private static final int INCREMENTAL_VACUUM = 7;
    private final ISqlJetBtree btree;
    private final ISqlJetDbHandle dbHandle;
    private int schemaCookie;
    private int fileFormat = SQLJET_DEFAULT_FILE_FORMAT;
    private int pageCacheSize = 2000;
    private boolean autovacuum = ISqlJetBtree.SQLJET_DEFAULT_AUTOVACUUM != SqlJetAutoVacuumMode.NONE;
    private SqlJetEncoding encoding = SQLJET_DEFAULT_ENCODING;
    private int userCookie;
    private boolean incrementalVacuum = ISqlJetBtree.SQLJET_DEFAULT_AUTOVACUUM == SqlJetAutoVacuumMode.INCR;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SqlJetOptions(ISqlJetBtree iSqlJetBtree, ISqlJetDbHandle iSqlJetDbHandle) {
        this.btree = iSqlJetBtree;
        this.dbHandle = iSqlJetDbHandle;
        if (this.readSchemaCookie() == 0) {
            try {
                this.initMeta();
                return;
            }
            catch (SqlJetException sqlJetException) {
                if (SqlJetErrorCode.READONLY == sqlJetException.getErrorCode()) return;
                throw sqlJetException;
            }
        } else {
            this.readMeta();
        }
    }

    private void readMeta() {
        this.schemaCookie = this.readSchemaCookie();
        this.autovacuum = this.readAutoVacuum();
        this.fileFormat = this.readFileFormat();
        this.incrementalVacuum = this.readIncrementalVacuum();
        this.userCookie = this.readUserCookie();
        this.pageCacheSize = this.readPageCacheSize();
        this.encoding = this.readEncoding();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ENCODING: " + (Object)((Object)this.encoding) + "\n");
        stringBuffer.append("SCHEMA VERSION: " + this.schemaCookie + "\n");
        stringBuffer.append("USER VERSION: " + this.userCookie + "\n");
        stringBuffer.append("FILE FORMAT: " + this.fileFormat + "\n");
        stringBuffer.append("AUTOVACUUM: " + this.autovacuum + "\n");
        stringBuffer.append("CACHE SIZE: " + this.pageCacheSize);
        return stringBuffer.toString();
    }

    private SqlJetEncoding readEncoding() {
        switch (this.btree.getMeta(5)) {
            case 0: {
                if (this.readSchemaCookie() != 0) {
                    throw new SqlJetException(SqlJetErrorCode.CORRUPT);
                }
            }
            case 1: {
                return SqlJetEncoding.UTF8;
            }
            case 2: {
                return SqlJetEncoding.UTF16LE;
            }
            case 3: {
                return SqlJetEncoding.UTF16BE;
            }
        }
        throw new SqlJetException(SqlJetErrorCode.CORRUPT);
    }

    private boolean readIncrementalVacuum() {
        return this.btree.getMeta(7) != 0;
    }

    private int readUserCookie() {
        return this.btree.getMeta(6);
    }

    private boolean readAutoVacuum() {
        return this.btree.getMeta(4) != 0;
    }

    private int readPageCacheSize() {
        int n2 = this.btree.getMeta(3);
        return n2 > 0 ? n2 : 2000;
    }

    private int readFileFormat() {
        int n2 = this.btree.getMeta(2);
        this.checkFileFormat(n2);
        return n2;
    }

    private void checkFileFormat(int n2) {
        if (n2 < 1 || n2 > 4) {
            throw new SqlJetException(SqlJetErrorCode.CORRUPT);
        }
    }

    private int readSchemaCookie() {
        return this.btree.getMeta(1);
    }

    public int getSchemaVersion() {
        return this.schemaCookie;
    }

    public int getFileFormat() {
        return this.fileFormat;
    }

    public int getCacheSize() {
        return this.pageCacheSize;
    }

    public boolean isAutovacuum() {
        return this.autovacuum;
    }

    public SqlJetEncoding getEncoding() {
        return this.encoding;
    }

    public boolean isLegacyFileFormat() {
        return this.fileFormat == 1;
    }

    public void setLegacyFileFormat(boolean bl2) {
        this.fileFormat = bl2 ? 1 : 4;
    }

    public int getUserVersion() {
        return this.userCookie;
    }

    public boolean isIncrementalVacuum() {
        return this.incrementalVacuum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSchemaVersion(int n2) {
        this.dbHandle.getMutex().enter();
        try {
            if (!this.btree.isInTrans()) {
                throw new SqlJetException("It can be performed only in active transaction");
            }
            this.verifySchemaVersion(true);
            this.schemaCookie = n2;
            this.writeSchemaCookie(this.schemaCookie);
            Object var3_2 = null;
            this.dbHandle.getMutex().leave();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.dbHandle.getMutex().leave();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verifySchemaVersion(boolean bl2) {
        this.dbHandle.getMutex().enter();
        try {
            boolean bl3;
            boolean bl4 = bl3 = this.schemaCookie != this.btree.getMeta(1);
            if (bl3 && bl2) {
                throw new SqlJetException(SqlJetErrorCode.SCHEMA);
            }
            boolean bl5 = !bl3;
            Object var5_4 = null;
            this.dbHandle.getMutex().leave();
            return bl5;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.dbHandle.getMutex().leave();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeSchemaVersion() {
        this.dbHandle.getMutex().enter();
        try {
            if (!this.btree.isInTrans()) {
                throw new SqlJetException("It can be performed only in active transaction");
            }
            this.verifySchemaVersion(true);
            ++this.schemaCookie;
            this.writeSchemaCookie(this.schemaCookie);
            Object var2_1 = null;
            this.dbHandle.getMutex().leave();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.dbHandle.getMutex().leave();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initMeta() {
        boolean bl2 = this.btree.isInTrans();
        SqlJetTransactionMode sqlJetTransactionMode = this.btree.getTransMode();
        try {
            if (!bl2 || sqlJetTransactionMode != SqlJetTransactionMode.EXCLUSIVE) {
                this.btree.beginTrans(SqlJetTransactionMode.EXCLUSIVE);
            }
            try {
                this.schemaCookie = 1;
                this.writeSchemaCookie(this.schemaCookie);
                this.writeFileFormat(this.fileFormat);
                this.writePageCacheSize(this.pageCacheSize);
                this.writeEncoding(this.encoding);
                SqlJetAutoVacuumMode sqlJetAutoVacuumMode = this.btree.getAutoVacuum();
                this.autovacuum = SqlJetAutoVacuumMode.NONE != sqlJetAutoVacuumMode;
                this.incrementalVacuum = SqlJetAutoVacuumMode.INCR == sqlJetAutoVacuumMode;
                this.writeAutoVacuum(this.autovacuum);
                this.writeIncrementalVacuum(this.incrementalVacuum);
                this.btree.commit();
            }
            catch (SqlJetException sqlJetException) {
                this.btree.rollback();
                throw sqlJetException;
            }
            Object var5_5 = null;
            if (bl2 && sqlJetTransactionMode != null) {
                if (!this.btree.isInTrans()) {
                    this.btree.beginTrans(sqlJetTransactionMode);
                } else if (this.btree.getTransMode() != sqlJetTransactionMode) {
                    this.btree.commit();
                    this.btree.beginTrans(sqlJetTransactionMode);
                }
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (bl2 && sqlJetTransactionMode != null) {
                if (!this.btree.isInTrans()) {
                    this.btree.beginTrans(sqlJetTransactionMode);
                } else if (this.btree.getTransMode() != sqlJetTransactionMode) {
                    this.btree.commit();
                    this.btree.beginTrans(sqlJetTransactionMode);
                }
            }
            throw throwable;
        }
    }

    private void writeSchemaCookie(int n2) {
        this.btree.updateMeta(1, n2);
    }

    private void writeEncoding(SqlJetEncoding sqlJetEncoding) {
        switch (sqlJetEncoding) {
            case UTF8: {
                this.btree.updateMeta(5, 1);
                break;
            }
            case UTF16LE: {
                this.btree.updateMeta(5, 2);
                break;
            }
            case UTF16BE: {
                this.btree.updateMeta(5, 3);
                break;
            }
            default: {
                throw new SqlJetException(SqlJetErrorCode.CORRUPT);
            }
        }
    }

    private void writeIncrementalVacuum(boolean bl2) {
        this.btree.updateMeta(7, bl2 ? 1 : 0);
    }

    private void writeAutoVacuum(boolean bl2) {
        this.btree.updateMeta(4, bl2 ? 1 : 0);
    }

    private void writePageCacheSize(int n2) {
        this.checkPageCacheSize();
        this.btree.updateMeta(3, n2);
    }

    private void checkPageCacheSize() {
        if (this.pageCacheSize < 10) {
            this.pageCacheSize = 2000;
        }
    }

    private void writeFileFormat(int n2) {
        this.checkFileFormat(n2);
        this.btree.updateMeta(2, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUserVersion(int n2) {
        this.dbHandle.getMutex().enter();
        try {
            if (!this.btree.isInTrans()) {
                throw new SqlJetException("It can be performed only in active transaction");
            }
            this.userCookie = n2;
            this.writeUserCookie(this.userCookie);
            Object var3_2 = null;
            this.dbHandle.getMutex().leave();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.dbHandle.getMutex().leave();
            throw throwable;
        }
    }

    private void writeUserCookie(int n2) {
        this.btree.updateMeta(6, n2);
    }

    private void checkSchema() {
        if (this.readSchemaCookie() != 1) {
            throw new SqlJetException(SqlJetErrorCode.MISUSE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFileFormat(int n2) {
        this.dbHandle.getMutex().enter();
        try {
            this.checkSchema();
            if (this.btree.isInTrans()) {
                throw new SqlJetException("It can't be performed in active transaction");
            }
            this.btree.beginTrans(SqlJetTransactionMode.EXCLUSIVE);
            try {
                this.fileFormat = n2;
                this.writeFileFormat(this.fileFormat);
                this.btree.commit();
            }
            catch (SqlJetException sqlJetException) {
                this.btree.rollback();
                throw sqlJetException;
            }
            Object var4_3 = null;
            this.dbHandle.getMutex().leave();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.dbHandle.getMutex().leave();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCacheSize(int n2) {
        this.dbHandle.getMutex().enter();
        try {
            if (!this.btree.isInTrans()) {
                throw new SqlJetException("It can be performed only in active transaction");
            }
            this.pageCacheSize = n2;
            this.writePageCacheSize(this.pageCacheSize);
            Object var3_2 = null;
            this.dbHandle.getMutex().leave();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.dbHandle.getMutex().leave();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAutovacuum(boolean bl2) {
        this.dbHandle.getMutex().enter();
        try {
            this.checkSchema();
            if (this.btree.isInTrans()) {
                throw new SqlJetException("It can't be performed in active transaction");
            }
            this.btree.beginTrans(SqlJetTransactionMode.EXCLUSIVE);
            try {
                this.autovacuum = bl2;
                this.writeAutoVacuum(this.autovacuum);
                this.btree.commit();
            }
            catch (SqlJetException sqlJetException) {
                this.btree.rollback();
                throw sqlJetException;
            }
            Object var4_3 = null;
            this.dbHandle.getMutex().leave();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.dbHandle.getMutex().leave();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEncoding(SqlJetEncoding sqlJetEncoding) {
        this.dbHandle.getMutex().enter();
        try {
            this.checkSchema();
            if (this.btree.isInTrans()) {
                throw new SqlJetException("It can't be performed in active transaction");
            }
            this.btree.beginTrans(SqlJetTransactionMode.EXCLUSIVE);
            try {
                this.encoding = sqlJetEncoding;
                this.writeEncoding(this.encoding);
                this.btree.commit();
            }
            catch (SqlJetException sqlJetException) {
                this.btree.rollback();
                throw sqlJetException;
            }
            Object var4_3 = null;
            this.dbHandle.getMutex().leave();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.dbHandle.getMutex().leave();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIncrementalVacuum(boolean bl2) {
        this.dbHandle.getMutex().enter();
        try {
            this.checkSchema();
            if (this.btree.isInTrans()) {
                throw new SqlJetException("It can't be performed in active transaction");
            }
            this.btree.beginTrans(SqlJetTransactionMode.EXCLUSIVE);
            try {
                this.incrementalVacuum = bl2;
                this.writeIncrementalVacuum(this.incrementalVacuum);
                this.btree.commit();
            }
            catch (SqlJetException sqlJetException) {
                this.btree.rollback();
                throw sqlJetException;
            }
            Object var4_3 = null;
            this.dbHandle.getMutex().leave();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.dbHandle.getMutex().leave();
            throw throwable;
        }
    }
}

