/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.table;

import java.util.List;
import java.util.Random;
import java.util.Stack;
import org.tmatesoft.sqljet.core.SqlJetEncoding;
import org.tmatesoft.sqljet.core.SqlJetErrorCode;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.SqlJetValueType;
import org.tmatesoft.sqljet.core.internal.ISqlJetBtree;
import org.tmatesoft.sqljet.core.internal.ISqlJetBtreeCursor;
import org.tmatesoft.sqljet.core.internal.ISqlJetMemoryPointer;
import org.tmatesoft.sqljet.core.internal.ISqlJetVdbeMem;
import org.tmatesoft.sqljet.core.internal.SqlJetBtreeTableCreateFlags;
import org.tmatesoft.sqljet.core.internal.SqlJetUtility;
import org.tmatesoft.sqljet.core.internal.table.ISqlJetBtreeRecord;
import org.tmatesoft.sqljet.core.internal.table.ISqlJetBtreeTable;
import org.tmatesoft.sqljet.core.internal.table.SqlJetBtreeTable$State;
import org.tmatesoft.sqljet.core.internal.vdbe.SqlJetBtreeRecord;
import org.tmatesoft.sqljet.core.internal.vdbe.SqlJetKeyInfo;

public class SqlJetBtreeTable
implements ISqlJetBtreeTable {
    protected ISqlJetBtree btree;
    protected int rootPage;
    protected boolean write;
    protected boolean index;
    private long priorNewRowid = 0L;
    private SqlJetBtreeRecord recordCache;
    private Object[] valueCache;
    private Object[] valuesCache;
    private Stack states;

    public SqlJetBtreeTable(ISqlJetBtree iSqlJetBtree, int n2, boolean bl2, boolean bl3) {
        this.init(iSqlJetBtree, n2, bl2, bl3);
    }

    private void init(ISqlJetBtree iSqlJetBtree, int n2, boolean bl2, boolean bl3) {
        this.states = new Stack();
        this.btree = iSqlJetBtree;
        this.rootPage = n2;
        this.write = bl2;
        this.index = bl3;
        this.pushState();
        this.first();
    }

    private SqlJetBtreeTable$State getCurrentState() {
        assert (!this.states.isEmpty());
        return (SqlJetBtreeTable$State)this.states.peek();
    }

    protected ISqlJetBtreeCursor getCursor() {
        return this.getCurrentState().getCursor();
    }

    protected SqlJetKeyInfo getKeyInfo() {
        return this.getCurrentState().getKeyInfo();
    }

    public void pushState() {
        SqlJetKeyInfo sqlJetKeyInfo = null;
        if (this.index) {
            sqlJetKeyInfo = new SqlJetKeyInfo();
            sqlJetKeyInfo.setEnc(this.btree.getDb().getOptions().getEncoding());
        }
        ISqlJetBtreeCursor iSqlJetBtreeCursor = this.btree.getCursor(this.rootPage, this.write, this.index ? sqlJetKeyInfo : null);
        this.states.push(new SqlJetBtreeTable$State(iSqlJetBtreeCursor, sqlJetKeyInfo));
        this.clearRecordCache();
        this.adjustKeyInfo();
    }

    protected void adjustKeyInfo() {
    }

    public boolean popState() {
        if (this.states.size() <= 1) {
            return false;
        }
        SqlJetBtreeTable$State sqlJetBtreeTable$State = (SqlJetBtreeTable$State)this.states.pop();
        sqlJetBtreeTable$State.close();
        this.clearRecordCache();
        return true;
    }

    public void close() {
        while (this.popState()) {
        }
        this.clearRecordCache();
        this.getCurrentState().close();
    }

    public void unlock() {
        this.getCursor().leaveCursor();
    }

    public void lock() {
        this.getCursor().enterCursor();
    }

    public boolean eof() {
        this.hasMoved();
        return this.getCursor().eof();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasMoved() {
        this.getCursor().enterCursor();
        try {
            boolean bl2 = this.getCursor().cursorHasMoved();
            Object var3_2 = null;
            this.getCursor().leaveCursor();
            return bl2;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.getCursor().leaveCursor();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean first() {
        this.lock();
        try {
            this.clearRecordCache();
            boolean bl2 = !this.getCursor().first();
            Object var3_2 = null;
            this.unlock();
            return bl2;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean last() {
        this.lock();
        try {
            this.clearRecordCache();
            boolean bl2 = !this.getCursor().last();
            Object var3_2 = null;
            this.unlock();
            return bl2;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean next() {
        this.lock();
        try {
            this.clearRecordCache();
            this.hasMoved();
            boolean bl2 = !this.getCursor().next();
            Object var3_2 = null;
            this.unlock();
            return bl2;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean previous() {
        this.lock();
        try {
            this.clearRecordCache();
            this.hasMoved();
            boolean bl2 = !this.getCursor().previous();
            Object var3_2 = null;
            this.unlock();
            return bl2;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISqlJetBtreeRecord getRecord() {
        if (this.eof()) {
            return null;
        }
        if (null == this.recordCache) {
            this.lock();
            try {
                this.recordCache = new SqlJetBtreeRecord(this.getCursor(), this.index, this.btree.getDb().getOptions().getFileFormat());
                Object var2_1 = null;
                this.unlock();
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.unlock();
                throw throwable;
            }
            this.valueCache = new Object[this.recordCache.getFieldsCount()];
        }
        return this.recordCache;
    }

    public void lockTable(boolean bl2) {
        this.btree.lockTable(this.rootPage, bl2);
    }

    public SqlJetEncoding getEncoding() {
        return this.getCursor().getCursorDb().getOptions().getEncoding();
    }

    protected static boolean checkField(ISqlJetBtreeRecord iSqlJetBtreeRecord, int n2) {
        return n2 >= 0 && iSqlJetBtreeRecord != null && n2 < iSqlJetBtreeRecord.getFieldsCount();
    }

    protected ISqlJetVdbeMem getValueMem(int n2) {
        ISqlJetBtreeRecord iSqlJetBtreeRecord = this.getRecord();
        if (null == iSqlJetBtreeRecord) {
            return null;
        }
        if (!SqlJetBtreeTable.checkField(iSqlJetBtreeRecord, n2)) {
            return null;
        }
        List list = iSqlJetBtreeRecord.getFields();
        if (null == list) {
            return null;
        }
        return (ISqlJetVdbeMem)list.get(n2);
    }

    public Object getValue(int n2) {
        Object object;
        if (this.valueCache != null && n2 < this.valueCache.length && (object = this.valueCache[n2]) != null) {
            return object;
        }
        object = this.getValueUncached(n2);
        if (object != null) {
            this.valueCache[n2] = object;
        }
        return object;
    }

    public Object getValueUncached(int n2) {
        ISqlJetVdbeMem iSqlJetVdbeMem = this.getValueMem(n2);
        if (iSqlJetVdbeMem == null || iSqlJetVdbeMem.isNull()) {
            return null;
        }
        switch (iSqlJetVdbeMem.getType()) {
            case INTEGER: {
                return iSqlJetVdbeMem.intValue();
            }
            case FLOAT: {
                return iSqlJetVdbeMem.realValue();
            }
            case TEXT: {
                return SqlJetUtility.toString(iSqlJetVdbeMem.valueText(this.getEncoding()), this.getEncoding());
            }
            case BLOB: {
                return iSqlJetVdbeMem.valueBlob();
            }
            case NULL: {
                break;
            }
        }
        return null;
    }

    public int getFieldsCount() {
        ISqlJetBtreeRecord iSqlJetBtreeRecord = this.getRecord();
        if (null == iSqlJetBtreeRecord) {
            return 0;
        }
        return iSqlJetBtreeRecord.getFieldsCount();
    }

    public boolean isNull(int n2) {
        ISqlJetVdbeMem iSqlJetVdbeMem = this.getValueMem(n2);
        if (null == iSqlJetVdbeMem) {
            return true;
        }
        return iSqlJetVdbeMem.isNull();
    }

    public String getString(int n2) {
        ISqlJetVdbeMem iSqlJetVdbeMem = this.getValueMem(n2);
        if (iSqlJetVdbeMem == null || iSqlJetVdbeMem.isNull()) {
            return null;
        }
        return SqlJetUtility.toString(iSqlJetVdbeMem.valueText(this.getEncoding()), this.getEncoding());
    }

    public long getInteger(int n2) {
        ISqlJetVdbeMem iSqlJetVdbeMem = this.getValueMem(n2);
        if (iSqlJetVdbeMem == null || iSqlJetVdbeMem.isNull()) {
            return 0L;
        }
        return iSqlJetVdbeMem.intValue();
    }

    public double getFloat(int n2) {
        ISqlJetVdbeMem iSqlJetVdbeMem = this.getValueMem(n2);
        if (iSqlJetVdbeMem == null || iSqlJetVdbeMem.isNull()) {
            return 0.0;
        }
        return iSqlJetVdbeMem.realValue();
    }

    public SqlJetValueType getFieldType(int n2) {
        ISqlJetVdbeMem iSqlJetVdbeMem = this.getValueMem(n2);
        if (iSqlJetVdbeMem == null) {
            return SqlJetValueType.NULL;
        }
        return iSqlJetVdbeMem.getType();
    }

    public ISqlJetMemoryPointer getBlob(int n2) {
        ISqlJetVdbeMem iSqlJetVdbeMem = this.getValueMem(n2);
        if (iSqlJetVdbeMem == null || iSqlJetVdbeMem.isNull()) {
            return null;
        }
        return iSqlJetVdbeMem.valueBlob();
    }

    public Object[] getValues() {
        if (this.valuesCache != null) {
            return this.valuesCache;
        }
        ISqlJetBtreeRecord iSqlJetBtreeRecord = this.getRecord();
        int n2 = iSqlJetBtreeRecord.getFieldsCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.valueCache[i2] = this.getValue(i2);
        }
        this.valuesCache = this.valueCache;
        return this.valueCache;
    }

    public long newRowId() {
        return this.newRowId(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long newRowId(long l2) {
        this.lock();
        try {
            boolean bl2 = false;
            long l3 = 0L;
            int n2 = 0;
            int n3 = 0;
            if ((this.getCursor().flags() & (SqlJetBtreeTableCreateFlags.INTKEY.getValue() | SqlJetBtreeTableCreateFlags.ZERODATA.getValue())) != SqlJetBtreeTableCreateFlags.INTKEY.getValue()) {
                throw new SqlJetException(SqlJetErrorCode.CORRUPT);
            }
            assert ((this.getCursor().flags() & SqlJetBtreeTableCreateFlags.INTKEY.getValue()) != 0);
            assert ((this.getCursor().flags() & SqlJetBtreeTableCreateFlags.ZERODATA.getValue()) == 0);
            long l4 = Integer.MAX_VALUE;
            boolean bl3 = this.getCursor().last();
            if (bl3) {
                l3 = 1L;
            } else {
                l3 = this.getCursor().getKeySize();
                if (l3 == l4) {
                    bl2 = true;
                } else {
                    ++l3;
                }
                if (l2 != 0L) {
                    if (l2 == l4 || bl2) {
                        throw new SqlJetException(SqlJetErrorCode.FULL);
                    }
                    if (l3 < l2) {
                        l3 = l2 + 1L;
                    }
                }
                if (bl2) {
                    l3 = this.priorNewRowid;
                    Random random = new Random();
                    assert (l2 == 0L);
                    n3 = 0;
                    do {
                        if (n3 == 0 && (l3 & 0xFFFFFFL) == l3) {
                            ++l3;
                        } else {
                            l3 = random.nextInt();
                            if (n3 < 5) {
                                l3 &= 0xFFFFFFL;
                            }
                        }
                        if (l3 == 0L) continue;
                        n2 = this.getCursor().moveToUnpacked(null, l3, false);
                        ++n3;
                    } while (n3 < 100 && n2 == 0);
                    this.priorNewRowid = l3;
                    if (n2 == 0) {
                        throw new SqlJetException(SqlJetErrorCode.FULL);
                    }
                }
            }
            long l5 = l3;
            Object var14_10 = null;
            this.unlock();
            return l5;
        }
        catch (Throwable throwable) {
            Object var14_11 = null;
            this.unlock();
            throw throwable;
        }
    }

    protected void clearRecordCache() {
        if (this.recordCache != null) {
            this.recordCache.release();
        }
        this.recordCache = null;
        this.valuesCache = null;
        this.valueCache = null;
    }

    public void clear() {
        this.btree.clearTable(this.rootPage, null);
    }

    public long getKeySize() {
        return this.getCursor().getKeySize();
    }

    public int moveTo(ISqlJetMemoryPointer iSqlJetMemoryPointer, long l2, boolean bl2) {
        this.clearRecordCache();
        return this.getCursor().moveTo(iSqlJetMemoryPointer, l2, bl2);
    }

    public void insert(ISqlJetMemoryPointer iSqlJetMemoryPointer, long l2, ISqlJetMemoryPointer iSqlJetMemoryPointer2, int n2, int n3, boolean bl2) {
        this.clearRecordCache();
        this.getCursor().insert(iSqlJetMemoryPointer, l2, iSqlJetMemoryPointer2, n2, n3, bl2);
    }

    public void delete() {
        this.clearRecordCache();
        this.getCursor().delete();
    }
}

