/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.table;

import java.util.List;
import java.util.Set;
import org.tmatesoft.sqljet.core.SqlJetEncoding;
import org.tmatesoft.sqljet.core.SqlJetErrorCode;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.internal.ISqlJetBtree;
import org.tmatesoft.sqljet.core.internal.ISqlJetMemoryPointer;
import org.tmatesoft.sqljet.core.internal.ISqlJetVdbeMem;
import org.tmatesoft.sqljet.core.internal.SqlJetUnpackedRecordFlags;
import org.tmatesoft.sqljet.core.internal.SqlJetUtility;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetBaseIndexDef;
import org.tmatesoft.sqljet.core.internal.table.ISqlJetBtreeIndexTable;
import org.tmatesoft.sqljet.core.internal.table.ISqlJetBtreeRecord;
import org.tmatesoft.sqljet.core.internal.table.SqlJetBtreeDataTable;
import org.tmatesoft.sqljet.core.internal.table.SqlJetBtreeTable;
import org.tmatesoft.sqljet.core.internal.vdbe.SqlJetBtreeRecord;
import org.tmatesoft.sqljet.core.internal.vdbe.SqlJetUnpackedRecord;
import org.tmatesoft.sqljet.core.schema.ISqlJetIndexDef;
import org.tmatesoft.sqljet.core.schema.ISqlJetIndexedColumn;
import org.tmatesoft.sqljet.core.schema.ISqlJetSchema;
import org.tmatesoft.sqljet.core.schema.SqlJetSortingOrder;

public class SqlJetBtreeIndexTable
extends SqlJetBtreeTable
implements ISqlJetBtreeIndexTable {
    private ISqlJetIndexDef indexDef;
    private List columns;

    public SqlJetBtreeIndexTable(ISqlJetBtree iSqlJetBtree, String string, boolean bl2) {
        super(iSqlJetBtree, ((SqlJetBaseIndexDef)iSqlJetBtree.getSchema().getIndex(string)).getPage(), bl2, true);
        this.indexDef = iSqlJetBtree.getSchema().getIndex(string);
        this.adjustKeyInfo();
    }

    public SqlJetBtreeIndexTable(ISqlJetBtree iSqlJetBtree, String string, List list, boolean bl2) {
        super(iSqlJetBtree, ((SqlJetBaseIndexDef)iSqlJetBtree.getSchema().getIndex(string)).getPage(), bl2, true);
        this.indexDef = iSqlJetBtree.getSchema().getIndex(string);
        this.columns = list;
        this.adjustKeyInfo();
    }

    public ISqlJetIndexDef getIndexDef() {
        return this.indexDef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long lookup(boolean bl2, Object ... objectArray) {
        long l2;
        this.lock();
        try {
            l2 = this.lookupSafe(bl2, false, false, objectArray);
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            this.unlock();
            throw throwable;
        }
        this.unlock();
        return l2;
    }

    private long lookupSafe(boolean bl2, boolean bl3, boolean bl4, Object ... objectArray) {
        SqlJetEncoding sqlJetEncoding = this.btree.getDb().getOptions().getEncoding();
        ISqlJetBtreeRecord iSqlJetBtreeRecord = SqlJetBtreeRecord.getRecord(sqlJetEncoding, objectArray);
        ISqlJetMemoryPointer iSqlJetMemoryPointer = iSqlJetBtreeRecord.getRawRecord();
        iSqlJetBtreeRecord.release();
        if (bl2) {
            if (!bl4) {
                this.next();
            } else {
                this.previous();
            }
        } else {
            int n2 = this.cursorMoveTo(iSqlJetMemoryPointer, bl4);
            if (n2 != 0) {
                if (!bl4) {
                    if (n2 < 0) {
                        this.next();
                    }
                } else if (n2 > 0) {
                    this.previous();
                }
            }
        }
        ISqlJetBtreeRecord iSqlJetBtreeRecord2 = this.getRecord();
        if (null == iSqlJetBtreeRecord2) {
            return 0L;
        }
        if (!bl3 && this.keyCompare(iSqlJetMemoryPointer, iSqlJetBtreeRecord2.getRawRecord()) != 0) {
            return 0L;
        }
        return this.getKeyRowId(iSqlJetBtreeRecord2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int cursorMoveTo(ISqlJetMemoryPointer iSqlJetMemoryPointer, boolean bl2) {
        int n2;
        SqlJetUnpackedRecord sqlJetUnpackedRecord;
        block8: {
            this.clearRecordCache();
            int n3 = iSqlJetMemoryPointer.remaining();
            if (!bl2) {
                return this.getCursor().moveTo(iSqlJetMemoryPointer, n3, false);
            }
            sqlJetUnpackedRecord = null;
            if (iSqlJetMemoryPointer != null) {
                assert ((long)n3 == (long)n3);
                sqlJetUnpackedRecord = this.getKeyInfo().recordUnpack(n3, iSqlJetMemoryPointer);
                if (sqlJetUnpackedRecord == null) {
                    throw new SqlJetException(SqlJetErrorCode.NOMEM);
                }
                sqlJetUnpackedRecord.getFlags().add(SqlJetUnpackedRecordFlags.INCRKEY);
            }
            try {
                n2 = this.getCursor().moveToUnpacked(sqlJetUnpackedRecord, n3, false);
                Object var7_6 = null;
                if (iSqlJetMemoryPointer == null) break block8;
            }
            catch (Throwable throwable) {
                block9: {
                    Object var7_7 = null;
                    if (iSqlJetMemoryPointer != null) {
                        SqlJetUnpackedRecord.delete(sqlJetUnpackedRecord);
                    }
                    if (sqlJetUnpackedRecord == null) break block9;
                    sqlJetUnpackedRecord.release();
                }
                throw throwable;
            }
            SqlJetUnpackedRecord.delete(sqlJetUnpackedRecord);
        }
        if (sqlJetUnpackedRecord != null) {
            sqlJetUnpackedRecord.release();
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int keyCompare(ISqlJetMemoryPointer iSqlJetMemoryPointer, ISqlJetMemoryPointer iSqlJetMemoryPointer2) {
        SqlJetUnpackedRecord sqlJetUnpackedRecord = this.getKeyInfo().recordUnpack(iSqlJetMemoryPointer.remaining(), iSqlJetMemoryPointer);
        Set set = sqlJetUnpackedRecord.getFlags();
        set.add(SqlJetUnpackedRecordFlags.IGNORE_ROWID);
        set.add(SqlJetUnpackedRecordFlags.PREFIX_MATCH);
        try {
            int n2 = sqlJetUnpackedRecord.recordCompare(iSqlJetMemoryPointer2.remaining(), iSqlJetMemoryPointer2);
            Object var7_6 = null;
            sqlJetUnpackedRecord.release();
            return n2;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            sqlJetUnpackedRecord.release();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int compareKeys(Object[] objectArray, Object[] objectArray2) {
        int n2;
        SqlJetEncoding sqlJetEncoding = this.btree.getDb().getOptions().getEncoding();
        ISqlJetBtreeRecord iSqlJetBtreeRecord = SqlJetBtreeRecord.getRecord(sqlJetEncoding, objectArray);
        ISqlJetBtreeRecord iSqlJetBtreeRecord2 = SqlJetBtreeRecord.getRecord(sqlJetEncoding, objectArray2);
        ISqlJetMemoryPointer iSqlJetMemoryPointer = iSqlJetBtreeRecord.getRawRecord();
        ISqlJetMemoryPointer iSqlJetMemoryPointer2 = iSqlJetBtreeRecord2.getRawRecord();
        SqlJetUnpackedRecord sqlJetUnpackedRecord = this.getKeyInfo().recordUnpack(iSqlJetMemoryPointer.remaining(), iSqlJetMemoryPointer);
        sqlJetUnpackedRecord.getFlags().add(SqlJetUnpackedRecordFlags.PREFIX_MATCH);
        try {
            n2 = sqlJetUnpackedRecord.recordCompare(iSqlJetMemoryPointer2.remaining(), iSqlJetMemoryPointer2);
            Object var11_10 = null;
            sqlJetUnpackedRecord.release();
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            sqlJetUnpackedRecord.release();
            iSqlJetBtreeRecord.release();
            iSqlJetBtreeRecord2.release();
            throw throwable;
        }
        iSqlJetBtreeRecord.release();
        iSqlJetBtreeRecord2.release();
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkKey(Object ... objectArray) {
        boolean bl2;
        if (this.eof()) {
            return false;
        }
        ISqlJetBtreeRecord iSqlJetBtreeRecord = SqlJetBtreeRecord.getRecord(this.btree.getDb().getOptions().getEncoding(), objectArray);
        ISqlJetMemoryPointer iSqlJetMemoryPointer = iSqlJetBtreeRecord.getRawRecord();
        try {
            bl2 = 0 == this.keyCompare(iSqlJetMemoryPointer, this.getRecord().getRawRecord());
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            iSqlJetBtreeRecord.release();
            throw throwable;
        }
        iSqlJetBtreeRecord.release();
        return bl2;
    }

    protected void adjustKeyInfo() {
        if (null == this.getKeyInfo()) {
            throw new SqlJetException(SqlJetErrorCode.INTERNAL);
        }
        if (this.indexDef != null) {
            if (null != this.columns) {
                this.getKeyInfo().setNField(this.columns.size());
            } else if (null != this.indexDef.getColumns()) {
                this.getKeyInfo().setNField(this.indexDef.getColumns().size());
                int n2 = 0;
                for (ISqlJetIndexedColumn iSqlJetIndexedColumn : this.indexDef.getColumns()) {
                    this.getKeyInfo().setSortOrder(n2++, iSqlJetIndexedColumn.getSortingOrder() == SqlJetSortingOrder.DESC);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(long l2, boolean bl2, Object ... objectArray) {
        this.lock();
        try {
            ISqlJetBtreeRecord iSqlJetBtreeRecord = SqlJetBtreeRecord.getRecord(this.btree.getDb().getOptions().getEncoding(), SqlJetUtility.addArrays(objectArray, new Object[]{l2}));
            ISqlJetMemoryPointer iSqlJetMemoryPointer = iSqlJetBtreeRecord.getRawRecord();
            this.getCursor().insert(iSqlJetMemoryPointer, iSqlJetMemoryPointer.remaining(), SqlJetUtility.allocatePtr(0), 0, 0, bl2);
            this.clearRecordCache();
            iSqlJetBtreeRecord.release();
            Object var8_6 = null;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            this.unlock();
            throw throwable;
        }
        this.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean delete(long l2, Object ... objectArray) {
        boolean bl2;
        block10: {
            boolean bl3;
            block9: {
                boolean bl4;
                block8: {
                    boolean bl5;
                    block7: {
                        this.lock();
                        try {
                            ISqlJetBtreeRecord iSqlJetBtreeRecord = SqlJetBtreeRecord.getRecord(this.btree.getDb().getOptions().getEncoding(), objectArray);
                            ISqlJetMemoryPointer iSqlJetMemoryPointer = iSqlJetBtreeRecord.getRawRecord();
                            iSqlJetBtreeRecord.release();
                            if (this.cursorMoveTo(iSqlJetMemoryPointer, false) < 0) {
                                this.next();
                            }
                            do {
                                ISqlJetBtreeRecord iSqlJetBtreeRecord2;
                                if (null == (iSqlJetBtreeRecord2 = this.getRecord())) {
                                    bl5 = false;
                                    Object var9_10 = null;
                                    break block7;
                                }
                                if (this.keyCompare(iSqlJetMemoryPointer, iSqlJetBtreeRecord2.getRawRecord()) != 0) {
                                    bl4 = false;
                                    break block8;
                                }
                                if (this.getKeyRowId(iSqlJetBtreeRecord2) != l2) continue;
                                this.getCursor().delete();
                                this.clearRecordCache();
                                if (this.cursorMoveTo(iSqlJetMemoryPointer, false) < 0) {
                                    this.next();
                                }
                                bl3 = true;
                                break block9;
                            } while (this.next());
                            bl2 = false;
                            break block10;
                        }
                        catch (Throwable throwable) {
                            Object var9_14 = null;
                            this.unlock();
                            throw throwable;
                        }
                    }
                    this.unlock();
                    return bl5;
                }
                Object var9_11 = null;
                this.unlock();
                return bl4;
            }
            Object var9_12 = null;
            this.unlock();
            return bl3;
        }
        Object var9_13 = null;
        this.unlock();
        return bl2;
    }

    private long getKeyRowId(ISqlJetBtreeRecord iSqlJetBtreeRecord) {
        if (null == iSqlJetBtreeRecord) {
            return 0L;
        }
        List list = iSqlJetBtreeRecord.getFields();
        if (null == list || 0 == list.size()) {
            return 0L;
        }
        return ((ISqlJetVdbeMem)list.get(list.size() - 1)).intValue();
    }

    public long getKeyRowId() {
        return this.getKeyRowId(this.getRecord());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reindex(ISqlJetSchema iSqlJetSchema) {
        this.lock();
        try {
            this.btree.clearTable(this.rootPage, null);
            SqlJetBtreeDataTable sqlJetBtreeDataTable = new SqlJetBtreeDataTable(this.btree, this.indexDef.getTableName(), false);
            try {
                sqlJetBtreeDataTable.first();
                while (!sqlJetBtreeDataTable.eof()) {
                    Object[] objectArray = sqlJetBtreeDataTable.getKeyForIndex(sqlJetBtreeDataTable.getValues(), this.indexDef);
                    this.insert(sqlJetBtreeDataTable.getRowId(), true, objectArray);
                    sqlJetBtreeDataTable.next();
                }
                Object var5_4 = null;
                sqlJetBtreeDataTable.close();
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                sqlJetBtreeDataTable.close();
                throw throwable;
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.unlock();
            throw throwable;
        }
        this.unlock();
    }

    public int compareKey(Object[] objectArray) {
        if (this.eof()) {
            return 1;
        }
        ISqlJetBtreeRecord iSqlJetBtreeRecord = SqlJetBtreeRecord.getRecord(this.btree.getDb().getOptions().getEncoding(), objectArray);
        ISqlJetMemoryPointer iSqlJetMemoryPointer = iSqlJetBtreeRecord.getRawRecord();
        iSqlJetBtreeRecord.release();
        return this.keyCompare(iSqlJetMemoryPointer, this.getRecord().getRawRecord());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long lookupNear(boolean bl2, Object[] objectArray) {
        long l2;
        this.lock();
        try {
            l2 = this.lookupSafe(bl2, true, false, objectArray);
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            this.unlock();
            throw throwable;
        }
        this.unlock();
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long lookupLastNear(Object[] objectArray) {
        long l2;
        this.lock();
        try {
            l2 = this.lookupSafe(false, true, true, objectArray);
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            this.unlock();
            throw throwable;
        }
        this.unlock();
        return l2;
    }
}

