/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.table;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.tmatesoft.sqljet.core.SqlJetEncoding;
import org.tmatesoft.sqljet.core.SqlJetErrorCode;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.internal.ISqlJetBtree;
import org.tmatesoft.sqljet.core.internal.ISqlJetMemoryPointer;
import org.tmatesoft.sqljet.core.internal.ISqlJetVdbeMem;
import org.tmatesoft.sqljet.core.internal.SqlJetUtility;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetColumnDef;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetTableDef;
import org.tmatesoft.sqljet.core.internal.table.ISqlJetBtreeDataTable;
import org.tmatesoft.sqljet.core.internal.table.ISqlJetBtreeIndexTable;
import org.tmatesoft.sqljet.core.internal.table.ISqlJetBtreeRecord;
import org.tmatesoft.sqljet.core.internal.table.SqlJetBtreeDataTable$1IndexKeys;
import org.tmatesoft.sqljet.core.internal.table.SqlJetBtreeDataTable$Action;
import org.tmatesoft.sqljet.core.internal.table.SqlJetBtreeIndexTable;
import org.tmatesoft.sqljet.core.internal.table.SqlJetBtreeTable;
import org.tmatesoft.sqljet.core.internal.vdbe.SqlJetBtreeRecord;
import org.tmatesoft.sqljet.core.schema.ISqlJetColumnConstraint;
import org.tmatesoft.sqljet.core.schema.ISqlJetColumnDef;
import org.tmatesoft.sqljet.core.schema.ISqlJetColumnDefault;
import org.tmatesoft.sqljet.core.schema.ISqlJetIndexDef;
import org.tmatesoft.sqljet.core.schema.ISqlJetIndexedColumn;
import org.tmatesoft.sqljet.core.schema.ISqlJetSchema;
import org.tmatesoft.sqljet.core.schema.ISqlJetTableDef;
import org.tmatesoft.sqljet.core.schema.SqlJetConflictAction;
import org.tmatesoft.sqljet.core.schema.SqlJetTypeAffinity;

public class SqlJetBtreeDataTable
extends SqlJetBtreeTable
implements ISqlJetBtreeDataTable {
    private static final String[] rowIdNames = new String[]{"ROWID", "_ROWID_", "OID"};
    private SqlJetTableDef tableDef;
    private Map indexesDefs;
    private Map indexesTables;
    private ISqlJetBtreeDataTable sequenceTable;
    private ISqlJetBtreeRecord defaults;

    public SqlJetBtreeDataTable(ISqlJetBtree iSqlJetBtree, String string, boolean bl2) {
        super(iSqlJetBtree, ((SqlJetTableDef)iSqlJetBtree.getSchema().getTable(string)).getPage(), bl2, false);
        this.tableDef = (SqlJetTableDef)iSqlJetBtree.getSchema().getTable(string);
        this.defaults = SqlJetBtreeRecord.getRecord(this.getEncoding(), this.getDefaults());
        this.openIndexes(iSqlJetBtree.getSchema());
    }

    public void close() {
        if (this.indexesTables != null) {
            for (String string : this.indexesTables.keySet()) {
                ISqlJetBtreeIndexTable iSqlJetBtreeIndexTable = (ISqlJetBtreeIndexTable)this.indexesTables.get(string);
                iSqlJetBtreeIndexTable.close();
            }
        }
        if (null != this.sequenceTable) {
            this.sequenceTable.close();
        }
        super.close();
        if (this.defaults != null) {
            this.defaults.release();
            this.defaults = null;
        }
    }

    private void openIndexes(ISqlJetSchema iSqlJetSchema) {
        this.indexesDefs = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        this.indexesTables = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        for (ISqlJetIndexDef iSqlJetIndexDef : iSqlJetSchema.getIndexes(this.tableDef.getName())) {
            SqlJetBtreeIndexTable sqlJetBtreeIndexTable;
            this.indexesDefs.put(iSqlJetIndexDef.getName(), iSqlJetIndexDef);
            if (iSqlJetIndexDef.getColumns().size() > 0) {
                sqlJetBtreeIndexTable = new SqlJetBtreeIndexTable(this.btree, iSqlJetIndexDef.getName(), this.write);
            } else {
                List<String> list;
                if (this.tableDef.getTableIndexConstraint(iSqlJetIndexDef.getName()) != null) {
                    list = this.tableDef.getTableIndexConstraint(iSqlJetIndexDef.getName()).getColumns();
                } else {
                    list = new ArrayList<String>();
                    list.add(this.tableDef.getColumnIndexConstraint(iSqlJetIndexDef.getName()).getColumn().getName());
                }
                sqlJetBtreeIndexTable = new SqlJetBtreeIndexTable(this.btree, iSqlJetIndexDef.getName(), list, this.write);
            }
            this.indexesTables.put(iSqlJetIndexDef.getName(), sqlJetBtreeIndexTable);
        }
    }

    public ISqlJetTableDef getDefinition() {
        return this.tableDef;
    }

    public Map getIndexDefinitions() {
        return Collections.unmodifiableMap(this.indexesDefs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean goToRow(long l2) {
        block4: {
            boolean bl2;
            this.lock();
            try {
                this.clearRecordCache();
                if (this.getRowId() != l2) break block4;
                bl2 = true;
                Object var6_4 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this.unlock();
                throw throwable;
            }
            this.unlock();
            return bl2;
        }
        int n2 = this.getCursor().moveTo(null, l2, false);
        if (n2 < 0) {
            this.next();
        }
        boolean bl3 = this.getRowId() == l2;
        Object var6_5 = null;
        this.unlock();
        return bl3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getRowId() {
        long l2;
        this.lock();
        try {
            l2 = this.getCursor().getKeySize();
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.unlock();
            throw throwable;
        }
        this.unlock();
        return l2;
    }

    public long insert(SqlJetConflictAction sqlJetConflictAction, Object ... objectArray) {
        return this.insertWithRowId(sqlJetConflictAction, 0L, objectArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long insertWithRowId(SqlJetConflictAction sqlJetConflictAction, long l2, Object[] objectArray) {
        long l3;
        this.lock();
        try {
            Object[] objectArray2 = this.getValuesRowForInsert(objectArray);
            this.adjustRowIdPosition(objectArray, objectArray2);
            if (sqlJetConflictAction == SqlJetConflictAction.REPLACE) {
                l2 = this.getRowIdForReplace(l2, objectArray, objectArray2);
            }
            if (l2 < 1L) {
                l2 = this.getRowIdForRow(objectArray2, true);
            }
            this.doInsert(sqlJetConflictAction, l2, objectArray2);
            l3 = l2;
            Object var9_6 = null;
        }
        catch (Throwable throwable) {
            Object var9_7 = null;
            this.unlock();
            throw throwable;
        }
        this.unlock();
        return l3;
    }

    private void adjustRowIdPosition(Object[] objectArray, Object[] objectArray2) {
        int n2;
        if (objectArray2 != null && objectArray2.length > 1 && this.tableDef.isRowIdPrimaryKey() && (objectArray == null || objectArray.length < objectArray2.length && objectArray2[objectArray.length] == null) && (n2 = this.tableDef.getColumnNumber(this.tableDef.getRowIdPrimaryKeyColumnName())) >= 0 && n2 < objectArray2.length && objectArray2[n2] != null) {
            System.arraycopy(objectArray2, n2, objectArray2, n2 + 1, objectArray.length - n2);
            objectArray2[n2] = null;
        }
    }

    private long getRowIdForReplace(long l2, Object[] objectArray, Object[] objectArray2) {
        String string = this.getPrimaryKeyIndex();
        if (string == null) {
            long l3;
            if (this.tableDef.isRowIdPrimaryKey() && (l3 = this.getRowIdForRow(objectArray2, false)) > 0L) {
                return l3;
            }
        } else {
            ISqlJetIndexDef iSqlJetIndexDef = (ISqlJetIndexDef)this.getIndexDefinitions().get(string);
            Object object = this.getKeyForIndex(objectArray, iSqlJetIndexDef);
            if (this.isNotUnique(string, false, (Object[])object)) {
                return this.getRowId();
            }
        }
        for (Object object : this.getIndexDefinitions().values()) {
            if (!object.isUnique()) continue;
            Object[] objectArray3 = this.getKeyForIndex(objectArray, (ISqlJetIndexDef)object);
            if (!this.isNotUnique(object.getName(), false, objectArray3)) continue;
            return this.getRowId();
        }
        return l2;
    }

    private boolean isNotUnique(String string, boolean bl2, Object ... objectArray) {
        if (this.hasNull(objectArray)) {
            return false;
        }
        return this.locate(string, bl2, objectArray);
    }

    private Object[] getValuesRowForInsert(Object ... objectArray) {
        Object[] objectArray2 = new Object[this.tableDef.getColumns().size()];
        if (null != objectArray && objectArray.length != 0) {
            if (objectArray.length > objectArray2.length) {
                throw new SqlJetException(SqlJetErrorCode.MISUSE, "Values count is more than columns in table");
            }
            Object[] objectArray3 = SqlJetUtility.adjustNumberTypes(objectArray);
            System.arraycopy(objectArray3, 0, objectArray2, 0, objectArray3.length);
        }
        return objectArray2;
    }

    private Object[] getValuesRowForUpdate(Object ... objectArray) {
        Object[] objectArray2 = new Object[this.tableDef.getColumns().size()];
        Object[] objectArray3 = this.getValues();
        System.arraycopy(objectArray3, 0, objectArray2, 0, Math.min(objectArray3.length, objectArray2.length));
        if (null != objectArray && objectArray.length != 0) {
            if (objectArray.length > objectArray2.length) {
                throw new SqlJetException(SqlJetErrorCode.MISUSE, "Values count is more than columns in table");
            }
            Object[] objectArray4 = SqlJetUtility.adjustNumberTypes(objectArray);
            System.arraycopy(objectArray4, 0, objectArray2, 0, objectArray4.length);
        }
        return objectArray2;
    }

    private Object[] getDefaults() {
        Object[] objectArray = new Object[this.tableDef.getColumns().size()];
        if (this.btree.getDb().getOptions().getFileFormat() > 2) {
            for (int i2 = 0; i2 < this.tableDef.getColumns().size(); ++i2) {
                ISqlJetColumnDef iSqlJetColumnDef = (ISqlJetColumnDef)this.tableDef.getColumns().get(i2);
                for (ISqlJetColumnConstraint iSqlJetColumnConstraint : iSqlJetColumnDef.getConstraints()) {
                    if (!(iSqlJetColumnConstraint instanceof ISqlJetColumnDefault)) continue;
                    ISqlJetColumnDefault iSqlJetColumnDefault = (ISqlJetColumnDefault)iSqlJetColumnConstraint;
                    objectArray[i2] = iSqlJetColumnDefault.getExpression().getValue();
                }
            }
        }
        return objectArray;
    }

    private long getRowIdForRow(Object[] objectArray, boolean bl2) {
        if (this.tableDef.isRowIdPrimaryKey()) {
            int n2 = this.tableDef.getColumnNumber(this.tableDef.getRowIdPrimaryKeyColumnName());
            if (n2 == -1 || n2 >= objectArray.length) {
                throw new SqlJetException(SqlJetErrorCode.ERROR);
            }
            Object object = objectArray[n2];
            if (null != object) {
                if (object instanceof Number) {
                    return ((Number)object).longValue();
                }
                throw new SqlJetException(SqlJetErrorCode.MISUSE, "INTEGER PRIMARY KEY column must have only integer value");
            }
        }
        if (bl2) {
            return this.newRowId();
        }
        return 0L;
    }

    public long newRowId() {
        if (!this.tableDef.isAutoincremented()) {
            return super.newRowId();
        }
        if (null == this.sequenceTable) {
            this.sequenceTable = this.btree.getSchema().openSequenceTable();
            if (null == this.sequenceTable) {
                return super.newRowId();
            }
            return this.locateSequence();
        }
        String string = this.sequenceTable.getString(0);
        if (null == string || !this.tableDef.getName().equalsIgnoreCase(string)) {
            return this.locateSequence();
        }
        return this.updateSequence();
    }

    private long locateSequence() {
        this.sequenceTable.first();
        while (!this.sequenceTable.eof()) {
            String string = this.sequenceTable.getString(0);
            if (null != string && this.tableDef.getName().equalsIgnoreCase(string)) {
                return this.updateSequence();
            }
            this.sequenceTable.next();
        }
        long l2 = super.newRowId();
        this.sequenceTable.insert(null, this.tableDef.getName(), l2);
        return l2;
    }

    private long updateSequence() {
        long l2 = this.sequenceTable.getInteger(1);
        long l3 = this.newRowId(l2);
        this.sequenceTable.updateCurrent(null, this.tableDef.getName(), l3);
        return l3;
    }

    private void doInsert(SqlJetConflictAction sqlJetConflictAction, long l2, Object[] objectArray) {
        ISqlJetMemoryPointer iSqlJetMemoryPointer;
        SqlJetEncoding sqlJetEncoding = this.btree.getDb().getOptions().getEncoding();
        if (!this.tableDef.isRowIdPrimaryKey()) {
            ISqlJetBtreeRecord iSqlJetBtreeRecord = SqlJetBtreeRecord.getRecord(sqlJetEncoding, objectArray);
            iSqlJetMemoryPointer = iSqlJetBtreeRecord.getRawRecord();
            iSqlJetBtreeRecord.release();
        } else {
            int n2 = this.tableDef.getColumnNumber(this.tableDef.getRowIdPrimaryKeyColumnName());
            if (n2 == -1 || n2 >= objectArray.length) {
                throw new SqlJetException(SqlJetErrorCode.ERROR);
            }
            objectArray[n2] = null;
            ISqlJetBtreeRecord iSqlJetBtreeRecord = SqlJetBtreeRecord.getRecord(sqlJetEncoding, objectArray);
            iSqlJetMemoryPointer = iSqlJetBtreeRecord.getRawRecord();
            iSqlJetBtreeRecord.release();
            objectArray[n2] = l2;
        }
        if (this.doActionWithIndexes(SqlJetBtreeDataTable$Action.INSERT, sqlJetConflictAction, l2, objectArray)) {
            this.getCursor().insert(null, l2, iSqlJetMemoryPointer, iSqlJetMemoryPointer.remaining(), 0, true);
            this.goToRow(l2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(SqlJetConflictAction sqlJetConflictAction, long l2, Object ... objectArray) {
        this.lock();
        try {
            if (l2 <= 0L || !this.goToRow(l2)) {
                throw new SqlJetException(SqlJetErrorCode.MISUSE, "Incorrect rowId value: " + l2);
            }
            Object[] objectArray2 = this.getValuesRowForUpdate(objectArray);
            if (l2 < 1L) {
                l2 = this.getRowIdForRow(objectArray2, false);
            }
            this.doUpdate(sqlJetConflictAction, l2, objectArray2);
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            this.unlock();
            throw throwable;
        }
        this.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCurrent(SqlJetConflictAction sqlJetConflictAction, Object ... objectArray) {
        this.lock();
        try {
            if (this.eof()) {
                throw new SqlJetException(SqlJetErrorCode.MISUSE, "No current record");
            }
            Object[] objectArray2 = this.getValuesRowForUpdate(objectArray);
            long l2 = this.getRowIdForRow(objectArray2, false);
            this.doUpdate(sqlJetConflictAction, l2, objectArray2);
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            this.unlock();
            throw throwable;
        }
        this.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long updateWithRowId(SqlJetConflictAction sqlJetConflictAction, long l2, long l3, Object ... objectArray) {
        long l4;
        this.lock();
        try {
            if (l2 <= 0L || !this.goToRow(l2)) {
                throw new SqlJetException(SqlJetErrorCode.MISUSE, "Incorrect rowId value: " + l2);
            }
            Object[] objectArray2 = this.getValuesRowForUpdate(objectArray);
            if (l3 < 1L) {
                l3 = this.getRowIdForRow(objectArray2, false);
            }
            this.doUpdate(sqlJetConflictAction, l3 > 0L ? l3 : l2, objectArray2);
            l4 = l3;
            Object var11_7 = null;
        }
        catch (Throwable throwable) {
            Object var11_8 = null;
            this.unlock();
            throw throwable;
        }
        this.unlock();
        return l4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long updateCurrentWithRowId(SqlJetConflictAction sqlJetConflictAction, long l2, Object ... objectArray) {
        long l3;
        this.lock();
        try {
            if (this.eof()) {
                throw new SqlJetException(SqlJetErrorCode.MISUSE, "No current record");
            }
            Object[] objectArray2 = this.getValuesRowForUpdate(objectArray);
            if (l2 < 1L) {
                l2 = this.getRowIdForRow(objectArray2, false);
            }
            this.doUpdate(sqlJetConflictAction, l2, this.getValuesRowForUpdate(objectArray));
            l3 = l2;
            Object var9_6 = null;
        }
        catch (Throwable throwable) {
            Object var9_7 = null;
            this.unlock();
            throw throwable;
        }
        this.unlock();
        return l3;
    }

    private void doUpdate(SqlJetConflictAction sqlJetConflictAction, long l2, Object[] objectArray) {
        ISqlJetMemoryPointer iSqlJetMemoryPointer;
        long l3;
        long l4 = this.getRowId();
        Object[] objectArray2 = this.getValues();
        long l5 = l3 = 0L < l2 ? l2 : l4;
        if (l3 == l4 && Arrays.equals(objectArray, objectArray2)) {
            return;
        }
        Object[] objectArray3 = this.completeRow(objectArray, objectArray2);
        if (l3 == l4 && Arrays.equals(objectArray3, objectArray2)) {
            return;
        }
        SqlJetEncoding sqlJetEncoding = this.btree.getDb().getOptions().getEncoding();
        if (!this.tableDef.isRowIdPrimaryKey()) {
            ISqlJetBtreeRecord iSqlJetBtreeRecord = SqlJetBtreeRecord.getRecord(sqlJetEncoding, objectArray3);
            iSqlJetMemoryPointer = iSqlJetBtreeRecord.getRawRecord();
            iSqlJetBtreeRecord.release();
        } else {
            int n2 = this.tableDef.getColumnNumber(this.tableDef.getRowIdPrimaryKeyColumnName());
            if (n2 == -1 || n2 >= objectArray3.length) {
                throw new SqlJetException(SqlJetErrorCode.ERROR);
            }
            objectArray3[n2] = null;
            ISqlJetBtreeRecord iSqlJetBtreeRecord = SqlJetBtreeRecord.getRecord(sqlJetEncoding, objectArray3);
            iSqlJetMemoryPointer = iSqlJetBtreeRecord.getRawRecord();
            iSqlJetBtreeRecord.release();
            objectArray3[n2] = l3;
        }
        if (this.doActionWithIndexes(SqlJetBtreeDataTable$Action.UPDATE, sqlJetConflictAction, l3, objectArray3)) {
            boolean bl2;
            boolean bl3 = bl2 = l3 != l4;
            if (bl2) {
                this.getCursor().delete();
            }
            this.getCursor().insert(null, l3, iSqlJetMemoryPointer, iSqlJetMemoryPointer.remaining(), 0, bl2);
            this.goToRow(l3);
        }
    }

    private Object[] completeRow(Object[] objectArray, Object[] objectArray2) {
        Object[] objectArray3;
        if (objectArray.length == objectArray2.length) {
            return objectArray;
        }
        if (objectArray.length > objectArray2.length) {
            objectArray3 = new Object[objectArray.length];
            System.arraycopy(objectArray, 0, objectArray3, 0, objectArray.length);
        } else {
            objectArray3 = new Object[objectArray2.length];
            System.arraycopy(objectArray, 0, objectArray3, 0, objectArray.length);
            System.arraycopy(objectArray2, objectArray.length, objectArray3, objectArray.length, objectArray2.length - objectArray.length);
        }
        return objectArray3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(long l2) {
        this.lock();
        try {
            if (l2 <= 0L || !this.goToRow(l2)) {
                throw new SqlJetException(SqlJetErrorCode.MISUSE, "Incorrect rowId value: " + l2);
            }
            this.doDelete();
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.unlock();
            throw throwable;
        }
        this.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete() {
        this.lock();
        try {
            if (this.eof()) {
                throw new SqlJetException(SqlJetErrorCode.MISUSE, "No current record");
            }
            this.doDelete();
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.unlock();
            throw throwable;
        }
        this.unlock();
    }

    private void doDelete() {
        this.doActionWithIndexes(SqlJetBtreeDataTable$Action.DELETE, null, 0L, new Object[0]);
        long l2 = this.getRowId();
        this.getCursor().delete();
        this.goToRow(l2);
    }

    private boolean isRowIdExists(long l2) {
        return this.isRowIdExists(l2, true);
    }

    private boolean isRowIdExists(long l2, boolean bl2) {
        long l3 = this.getRowId();
        if (l2 == l3) {
            return true;
        }
        boolean bl3 = this.goToRow(l2);
        if (bl2) {
            if (l3 > 0L) {
                this.goToRow(l3);
            } else {
                this.first();
            }
        }
        return bl3;
    }

    private boolean doActionWithIndexes(SqlJetBtreeDataTable$Action sqlJetBtreeDataTable$Action, SqlJetConflictAction sqlJetConflictAction, long l2, Object ... objectArray) {
        Object[] objectArray2;
        List list;
        if (null == sqlJetConflictAction) {
            sqlJetConflictAction = SqlJetConflictAction.ABORT;
        }
        boolean bl2 = false;
        long l3 = 0L;
        Object[] objectArray3 = null;
        if (SqlJetBtreeDataTable$Action.INSERT != sqlJetBtreeDataTable$Action) {
            l3 = this.getRowId();
            objectArray3 = this.getValues();
        }
        if (SqlJetBtreeDataTable$Action.INSERT == sqlJetBtreeDataTable$Action) {
            long l4 = this.getRowId();
            bl2 = this.isRowIdExists(l2, false);
            if (!bl2 && l4 > 0L) {
                this.goToRow(l4);
            }
        } else if (SqlJetBtreeDataTable$Action.UPDATE == sqlJetBtreeDataTable$Action && l3 != l2) {
            bl2 = this.isRowIdExists(l2);
        }
        if (bl2) {
            switch (sqlJetConflictAction) {
                case IGNORE: {
                    return false;
                }
                case REPLACE: {
                    if (!this.goToRow(l2)) break;
                    l3 = this.getRowId();
                    objectArray3 = this.getValues();
                    this.getCursor().delete();
                    break;
                }
                default: {
                    throw new SqlJetException(SqlJetErrorCode.CONSTRAINT, "Record with given ROWID already exists");
                }
            }
        }
        if (SqlJetBtreeDataTable$Action.DELETE != sqlJetBtreeDataTable$Action && this.hasNull(objectArray) && (list = this.tableDef.getNotNullColumns()) != null && list.size() != 0) {
            for (ISqlJetColumnDef object : list) {
                objectArray2 = object.getName();
                int n2 = object.getIndex();
                if (objectArray.length >= n2 && null != objectArray[n2] || SqlJetConflictAction.IGNORE == sqlJetConflictAction) continue;
                throw new SqlJetException(String.format("Field '%s' must be not NULL", new Object[]{objectArray2}));
            }
        }
        ArrayList<SqlJetBtreeDataTable$1IndexKeys> arrayList = new ArrayList<SqlJetBtreeDataTable$1IndexKeys>(this.indexesDefs.size());
        block13: for (ISqlJetIndexDef iSqlJetIndexDef : this.indexesDefs.values()) {
            long l4;
            Object[] objectArray4;
            objectArray2 = SqlJetBtreeDataTable$Action.INSERT == sqlJetBtreeDataTable$Action && SqlJetConflictAction.REPLACE != sqlJetConflictAction ? null : this.getKeyForIndex(objectArray3, iSqlJetIndexDef);
            Object[] objectArray5 = objectArray4 = SqlJetBtreeDataTable$Action.DELETE == sqlJetBtreeDataTable$Action ? null : this.getKeyForIndex(objectArray, iSqlJetIndexDef);
            if (SqlJetBtreeDataTable$Action.UPDATE == sqlJetBtreeDataTable$Action && l3 == l2 && Arrays.deepEquals(objectArray2, objectArray4)) continue;
            ISqlJetBtreeIndexTable iSqlJetBtreeIndexTable = (ISqlJetBtreeIndexTable)this.indexesTables.get(iSqlJetIndexDef.getName());
            arrayList.add(new SqlJetBtreeDataTable$1IndexKeys(this, iSqlJetBtreeIndexTable, objectArray2, objectArray4));
            if (SqlJetBtreeDataTable$Action.DELETE == sqlJetBtreeDataTable$Action || this.hasNull(objectArray4) || !iSqlJetIndexDef.isUnique() && this.tableDef.getColumnIndexConstraint(iSqlJetIndexDef.getName()) == null && this.tableDef.getTableIndexConstraint(iSqlJetIndexDef.getName()) == null || (l4 = iSqlJetBtreeIndexTable.lookup(false, objectArray4)) == 0L) continue;
            if (SqlJetBtreeDataTable$Action.INSERT == sqlJetBtreeDataTable$Action) {
                switch (sqlJetConflictAction) {
                    case IGNORE: {
                        return false;
                    }
                    case REPLACE: {
                        iSqlJetBtreeIndexTable.delete(l4, objectArray4);
                        if (l4 == l3 || !this.isRowIdExists(l4)) continue block13;
                        this.delete(l4);
                        continue block13;
                    }
                }
                throw new SqlJetException(SqlJetErrorCode.CONSTRAINT, "Insert fails: unique index " + iSqlJetIndexDef.getName());
            }
            if (SqlJetBtreeDataTable$Action.UPDATE != sqlJetBtreeDataTable$Action || l4 == l3) continue;
            switch (sqlJetConflictAction) {
                case IGNORE: {
                    return false;
                }
                case REPLACE: {
                    iSqlJetBtreeIndexTable.delete(l4, objectArray4);
                    continue block13;
                }
            }
            throw new SqlJetException(SqlJetErrorCode.CONSTRAINT, "Update fails: unique index " + iSqlJetIndexDef.getName());
        }
        for (SqlJetBtreeDataTable$1IndexKeys sqlJetBtreeDataTable$1IndexKeys : arrayList) {
            if ((SqlJetBtreeDataTable$Action.INSERT != sqlJetBtreeDataTable$Action || SqlJetConflictAction.REPLACE == sqlJetConflictAction) && l3 > 0L) {
                sqlJetBtreeDataTable$1IndexKeys.indexTable.delete(l3, sqlJetBtreeDataTable$1IndexKeys.currentKey);
            }
            if (SqlJetBtreeDataTable$Action.DELETE == sqlJetBtreeDataTable$Action) continue;
            sqlJetBtreeDataTable$1IndexKeys.indexTable.insert(l2, true, sqlJetBtreeDataTable$1IndexKeys.key);
        }
        return true;
    }

    private boolean hasNull(Object[] objectArray) {
        if (objectArray != null && objectArray.length > 0) {
            for (Object object : objectArray) {
                if (null != object) continue;
                return true;
            }
        }
        return false;
    }

    private Object getFieldByName(Object[] objectArray, String string) {
        int n2 = this.tableDef.getColumnNumber(string);
        if (n2 >= 0 && objectArray.length > n2) {
            return objectArray[n2];
        }
        return null;
    }

    private Object getColumnValue(Object[] objectArray, ISqlJetColumnDef iSqlJetColumnDef) {
        int n2 = iSqlJetColumnDef.getIndex();
        if (n2 >= 0 && objectArray.length > n2) {
            return objectArray[n2];
        }
        return null;
    }

    public Object[] getKeyForIndex(Object[] objectArray, ISqlJetIndexDef iSqlJetIndexDef) {
        if (null == objectArray) {
            return null;
        }
        if (this.tableDef.getColumnIndexConstraint(iSqlJetIndexDef.getName()) != null) {
            SqlJetColumnDef sqlJetColumnDef = this.tableDef.getColumnIndexConstraint(iSqlJetIndexDef.getName()).getColumn();
            return new Object[]{this.getColumnValue(objectArray, sqlJetColumnDef)};
        }
        if (this.tableDef.getTableIndexConstraint(iSqlJetIndexDef.getName()) != null) {
            List list = this.tableDef.getTableIndexConstraint(iSqlJetIndexDef.getName()).getColumns();
            int n2 = list.size();
            Object[] objectArray2 = new Object[n2];
            int n3 = 0;
            for (String string : list) {
                objectArray2[n3++] = this.getFieldByName(objectArray, string);
            }
            return objectArray2;
        }
        List list = iSqlJetIndexDef.getColumns();
        int n4 = list.size();
        Object[] objectArray3 = new Object[n4];
        int n5 = 0;
        for (ISqlJetIndexedColumn iSqlJetIndexedColumn : list) {
            objectArray3[n5++] = this.getColumnValue(objectArray, iSqlJetIndexedColumn.getTableColumn());
        }
        return objectArray3;
    }

    public boolean checkIndex(String string, Object[] objectArray) {
        if (!this.isIndexExists(string)) {
            throw new SqlJetException(SqlJetErrorCode.MISUSE);
        }
        if (null != string) {
            return Arrays.equals(objectArray, this.getKeyForIndex(this.getValues(), (ISqlJetIndexDef)this.indexesDefs.get(string)));
        }
        return this.getRowId() == this.getKeyForRowId(objectArray).longValue();
    }

    private Long getKeyForRowId(Object[] objectArray) {
        Object object;
        if (!this.tableDef.isRowIdPrimaryKey()) {
            throw new SqlJetException(SqlJetErrorCode.MISUSE, "Index not defined");
        }
        if (objectArray.length == 1 && (object = SqlJetUtility.adjustNumberType(objectArray[0])) instanceof Long) {
            return (Long)object;
        }
        throw new SqlJetException(SqlJetErrorCode.MISUSE, "Bad key");
    }

    public String getPrimaryKeyIndex() {
        return this.tableDef.isRowIdPrimaryKey() ? null : this.tableDef.getPrimaryKeyIndexName();
    }

    public boolean locate(String string, boolean bl2, Object ... objectArray) {
        if (null == objectArray) {
            throw new SqlJetException(SqlJetErrorCode.MISUSE, "Bad key");
        }
        if (null != string) {
            if (!this.indexesDefs.containsKey(string)) {
                throw new SqlJetException(SqlJetErrorCode.MISUSE, "Index not found: " + string);
            }
            ISqlJetBtreeIndexTable iSqlJetBtreeIndexTable = (ISqlJetBtreeIndexTable)this.indexesTables.get(string);
            long l2 = iSqlJetBtreeIndexTable.lookup(bl2, objectArray);
            return l2 != 0L && this.goToRow(l2);
        }
        if (bl2) {
            return this.next();
        }
        return this.goToRow(this.getKeyForRowId(objectArray));
    }

    public Map getIndexesTables() {
        return Collections.unmodifiableMap(this.indexesTables);
    }

    public long insert(SqlJetConflictAction sqlJetConflictAction, Map map) {
        return this.insertWithRowId(sqlJetConflictAction, SqlJetBtreeDataTable.getRowIdFromValues(map), this.unwrapValues(map));
    }

    public void update(SqlJetConflictAction sqlJetConflictAction, long l2, Map map) {
        this.updateWithRowId(sqlJetConflictAction, l2, SqlJetBtreeDataTable.getRowIdFromValues(map), this.unwrapValues(map, this.getValues()));
    }

    public void update(SqlJetConflictAction sqlJetConflictAction, Map map) {
        this.updateWithRowId(sqlJetConflictAction, this.getRowId(), SqlJetBtreeDataTable.getRowIdFromValues(map), this.unwrapValues(map, this.getValues()));
    }

    private Object[] unwrapValues(Map map) {
        return this.unwrapValues(map, null);
    }

    private Object[] unwrapValues(Map map, Object[] objectArray) {
        int n2 = 0;
        Object[] objectArray2 = new Object[this.tableDef.getColumns().size()];
        if (null != map) {
            for (ISqlJetColumnDef iSqlJetColumnDef : this.tableDef.getColumns()) {
                String string = iSqlJetColumnDef.getName();
                if (map.containsKey(string)) {
                    objectArray2[n2] = map.get(string);
                } else if (objectArray != null && objectArray.length > n2) {
                    objectArray2[n2] = objectArray[n2];
                }
                ++n2;
            }
        }
        return objectArray2;
    }

    public long getInteger(int n2) {
        if (n2 == this.tableDef.getRowIdPrimaryKeyColumnIndex()) {
            return this.getRowId();
        }
        return super.getInteger(n2);
    }

    public Object getValue(int n2) {
        if (n2 == this.tableDef.getRowIdPrimaryKeyColumnIndex()) {
            return this.getRowId();
        }
        return super.getValue(n2);
    }

    public boolean isIndexExists(String string) {
        return null == string || this.getIndexDefinitions().containsKey(string);
    }

    public static boolean isFieldNameRowId(String string) {
        if (null == string) {
            return false;
        }
        for (int i2 = 0; i2 < rowIdNames.length; ++i2) {
            if (!rowIdNames[i2].equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public static long getRowIdFromValues(Map map) {
        if (null == map) {
            return 0L;
        }
        for (Map.Entry entry : map.entrySet()) {
            String string = (String)entry.getKey();
            Object v2 = entry.getValue();
            for (int i2 = 0; i2 < rowIdNames.length; ++i2) {
                if (!rowIdNames[i2].equalsIgnoreCase(string) || null == v2) continue;
                if (v2 instanceof Long) {
                    return (Long)v2;
                }
                throw new SqlJetException(SqlJetErrorCode.MISUSE, "ROWID must be integer value");
            }
        }
        return 0L;
    }

    public void clear() {
        for (ISqlJetBtreeIndexTable iSqlJetBtreeIndexTable : this.indexesTables.values()) {
            iSqlJetBtreeIndexTable.clear();
        }
        super.clear();
    }

    protected ISqlJetVdbeMem getValueMem(int n2) {
        ISqlJetVdbeMem iSqlJetVdbeMem = super.getValueMem(n2);
        if (this.defaults == null) {
            this.defaults = SqlJetBtreeRecord.getRecord(this.getEncoding(), this.getDefaults());
        }
        if (n2 < this.defaults.getFieldsCount() && (iSqlJetVdbeMem == null || iSqlJetVdbeMem.isNull())) {
            iSqlJetVdbeMem = (ISqlJetVdbeMem)this.defaults.getFields().get(n2);
        }
        if (iSqlJetVdbeMem != null) {
            iSqlJetVdbeMem.applyAffinity(this.getFieldAffinity(n2), this.getEncoding());
        }
        return iSqlJetVdbeMem;
    }

    private SqlJetTypeAffinity getFieldAffinity(int n2) {
        List list = this.getDefinition().getColumns();
        if (n2 < 0 || n2 >= list.size()) {
            throw new SqlJetException(SqlJetErrorCode.MISUSE, "Bad value for field number");
        }
        return ((ISqlJetColumnDef)list.get(n2)).getTypeAffinity();
    }

    public ISqlJetBtreeIndexTable getIndex(String string) {
        return (ISqlJetBtreeIndexTable)this.indexesTables.get(string);
    }

    public boolean isNull(int n2) {
        if (n2 == this.tableDef.getRowIdPrimaryKeyColumnIndex()) {
            return this.eof();
        }
        return super.isNull(n2);
    }
}

