/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.schema;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.antlr.runtime.tree.CommonTree;
import org.tmatesoft.sqljet.core.SqlJetErrorCode;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.internal.lang.SqlParser;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetColumnDef;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetColumnDefault;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetColumnIndexConstraint;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetColumnPrimaryKey;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetColumnUnique;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetSchema;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetTableCheck;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetTableConstraint;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetTableForeignKey;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetTableIndexConstraint;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetTablePrimaryKey;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetTableUnique;
import org.tmatesoft.sqljet.core.schema.ISqlJetColumnDef;
import org.tmatesoft.sqljet.core.schema.ISqlJetColumnNotNull;
import org.tmatesoft.sqljet.core.schema.ISqlJetColumnPrimaryKey;
import org.tmatesoft.sqljet.core.schema.ISqlJetColumnUnique;
import org.tmatesoft.sqljet.core.schema.ISqlJetTableConstraint;
import org.tmatesoft.sqljet.core.schema.ISqlJetTableDef;
import org.tmatesoft.sqljet.core.schema.ISqlJetTablePrimaryKey;
import org.tmatesoft.sqljet.core.schema.ISqlJetTableUnique;

public class SqlJetTableDef
implements ISqlJetTableDef {
    private final String name;
    private final String quotedName;
    private final String databaseName;
    private final boolean temporary;
    private final boolean ifNotExists;
    private final List columns;
    private final List constraints;
    private int page;
    private long rowId;
    private boolean rowIdPrimaryKey;
    private boolean autoincremented;
    private String primaryKeyIndexName;
    private String rowIdPrimaryKeyColumnName;
    private int rowIdPrimaryKeyColumnIndex = -1;
    private final List primaryKeyColumns = new ArrayList();
    private final Map columnConstraintsIndexCache = new TreeMap(String.CASE_INSENSITIVE_ORDER);
    private final Map tableConstrainsIndexCache = new TreeMap(String.CASE_INSENSITIVE_ORDER);
    private final List notNullColumnsCache = new ArrayList();

    SqlJetTableDef(String string, String string2, boolean bl2, boolean bl3, List list, List list2, int n2, long l2) {
        this.name = SqlParser.unquoteId(string);
        this.quotedName = string;
        this.databaseName = string2;
        this.temporary = bl2;
        this.ifNotExists = bl3;
        this.columns = Collections.unmodifiableList(list);
        this.constraints = Collections.unmodifiableList(list2);
        this.page = n2;
        this.rowId = l2;
        this.resolveConstraints();
    }

    public SqlJetTableDef(CommonTree commonTree, int n2) {
        CommonTree commonTree2;
        CommonTree commonTree3 = (CommonTree)commonTree.getChild(0);
        this.temporary = SqlJetTableDef.hasOption(commonTree3, "temporary");
        this.ifNotExists = SqlJetTableDef.hasOption(commonTree3, "exists");
        CommonTree commonTree4 = (CommonTree)commonTree.getChild(1);
        this.name = commonTree4.getText();
        this.quotedName = SqlParser.quotedId(commonTree4);
        this.databaseName = commonTree4.getChildCount() > 0 ? commonTree4.getChild(0).getText() : null;
        ArrayList<SqlJetColumnDef> arrayList = new ArrayList<SqlJetColumnDef>();
        ArrayList<SqlJetTableConstraint> arrayList2 = new ArrayList<SqlJetTableConstraint>();
        if (commonTree.getChildCount() > 2 && "columns".equalsIgnoreCase((commonTree2 = (CommonTree)commonTree.getChild(2)).getText())) {
            for (int i2 = 0; i2 < commonTree2.getChildCount(); ++i2) {
                arrayList.add(new SqlJetColumnDef((CommonTree)commonTree2.getChild(i2)));
            }
            if (commonTree.getChildCount() > 3) {
                CommonTree commonTree5 = (CommonTree)commonTree.getChild(3);
                assert ("constraints".equalsIgnoreCase(commonTree5.getText()));
                for (int i3 = 0; i3 < commonTree5.getChildCount(); ++i3) {
                    String string;
                    CommonTree commonTree6 = (CommonTree)commonTree5.getChild(i3);
                    assert ("table_constraint".equalsIgnoreCase(commonTree6.getText()));
                    CommonTree commonTree7 = (CommonTree)commonTree6.getChild(0);
                    String string2 = commonTree7.getText();
                    String string3 = string = commonTree6.getChildCount() > 1 ? commonTree6.getChild(1).getText() : null;
                    if ("primary".equalsIgnoreCase(string2)) {
                        arrayList2.add(new SqlJetTablePrimaryKey(string, commonTree7));
                        continue;
                    }
                    if ("unique".equalsIgnoreCase(string2)) {
                        arrayList2.add(new SqlJetTableUnique(string, commonTree7));
                        continue;
                    }
                    if ("check".equalsIgnoreCase(string2)) {
                        arrayList2.add(new SqlJetTableCheck(string, commonTree7));
                        continue;
                    }
                    if ("foreign".equalsIgnoreCase(string2)) {
                        arrayList2.add(new SqlJetTableForeignKey(string, commonTree7));
                        continue;
                    }
                    assert (false);
                }
            }
        }
        this.columns = Collections.unmodifiableList(arrayList);
        this.constraints = Collections.unmodifiableList(arrayList2);
        this.page = n2;
        this.resolveConstraints();
    }

    private void resolveConstraints() {
        Object object;
        int n2 = 0;
        int n3 = 0;
        for (Object object2 : this.columns) {
            ((SqlJetColumnDef)object2).setIndex(n2);
            boolean bl2 = false;
            for (Object object3 : object2.getConstraints()) {
                if (object3 instanceof ISqlJetColumnPrimaryKey) {
                    object = (SqlJetColumnPrimaryKey)object3;
                    this.primaryKeyColumns.add(object2.getName());
                    if (object2.hasExactlyIntegerType()) {
                        this.rowIdPrimaryKeyColumnName = object2.getName();
                        this.rowIdPrimaryKeyColumnIndex = n2;
                        this.rowIdPrimaryKey = true;
                        this.autoincremented = ((SqlJetColumnPrimaryKey)object).isAutoincremented();
                        continue;
                    }
                    this.primaryKeyIndexName = SqlJetTableDef.generateAutoIndexName(this.getName(), ++n3);
                    ((SqlJetColumnIndexConstraint)object).setIndexName(this.primaryKeyIndexName);
                    this.columnConstraintsIndexCache.put(((SqlJetColumnIndexConstraint)object).getIndexName(), object);
                    continue;
                }
                if (object3 instanceof ISqlJetColumnUnique) {
                    object = (SqlJetColumnUnique)object3;
                    ((SqlJetColumnIndexConstraint)object).setIndexName(SqlJetTableDef.generateAutoIndexName(this.getName(), ++n3));
                    this.columnConstraintsIndexCache.put(((SqlJetColumnIndexConstraint)object).getIndexName(), object);
                    continue;
                }
                if (object3 instanceof ISqlJetColumnNotNull) {
                    bl2 = true;
                    continue;
                }
                if (!(object3 instanceof SqlJetColumnDefault) || !bl2) continue;
                object = (SqlJetColumnDefault)object3;
                bl2 = null == ((SqlJetColumnDefault)object).getExpression().getValue();
            }
            if (bl2) {
                this.notNullColumnsCache.add(object2);
            }
            ++n2;
        }
        for (Object object2 : this.constraints) {
            if (object2 instanceof ISqlJetTablePrimaryKey) {
                boolean bl3 = false;
                SqlJetTablePrimaryKey sqlJetTablePrimaryKey = (SqlJetTablePrimaryKey)object2;
                assert (this.primaryKeyColumns.isEmpty());
                this.primaryKeyColumns.addAll(sqlJetTablePrimaryKey.getColumns());
                if (sqlJetTablePrimaryKey.getColumns().size() == 1) {
                    Object object3;
                    object3 = (String)sqlJetTablePrimaryKey.getColumns().get(0);
                    object = this.getColumn((String)object3);
                    if (null == object) {
                        throw new SqlJetException(SqlJetErrorCode.ERROR, "Wrong column '" + (String)object3 + "' in PRIMARY KEY");
                    }
                    if (object.hasExactlyIntegerType()) {
                        this.rowIdPrimaryKeyColumnName = object3;
                        this.rowIdPrimaryKeyColumnIndex = this.getColumnNumber((String)object3);
                        this.rowIdPrimaryKey = true;
                        bl3 = true;
                    }
                }
                if (bl3) continue;
                this.primaryKeyIndexName = SqlJetTableDef.generateAutoIndexName(this.getName(), ++n3);
                sqlJetTablePrimaryKey.setIndexName(this.primaryKeyIndexName);
                this.tableConstrainsIndexCache.put(sqlJetTablePrimaryKey.getIndexName(), sqlJetTablePrimaryKey);
                continue;
            }
            if (!(object2 instanceof ISqlJetTableUnique)) continue;
            SqlJetTableUnique sqlJetTableUnique = (SqlJetTableUnique)object2;
            sqlJetTableUnique.setIndexName(SqlJetTableDef.generateAutoIndexName(this.getName(), ++n3));
            this.tableConstrainsIndexCache.put(sqlJetTableUnique.getIndexName(), sqlJetTableUnique);
        }
    }

    private static String generateAutoIndexName(String string, int n2) {
        return SqlJetSchema.generateAutoIndexName(string, n2);
    }

    static boolean hasOption(CommonTree commonTree, String string) {
        for (int i2 = 0; i2 < commonTree.getChildCount(); ++i2) {
            CommonTree commonTree2 = (CommonTree)commonTree.getChild(i2);
            if (!string.equalsIgnoreCase(commonTree2.getText())) continue;
            return true;
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public String getQuotedName() {
        return this.quotedName;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public boolean isTemporary() {
        return this.temporary;
    }

    public boolean isKeepExisting() {
        return this.ifNotExists;
    }

    public List getColumns() {
        return this.columns;
    }

    public ISqlJetColumnDef getColumn(String string) {
        for (ISqlJetColumnDef iSqlJetColumnDef : this.getColumns()) {
            if (!iSqlJetColumnDef.getName().equalsIgnoreCase(string)) continue;
            return iSqlJetColumnDef;
        }
        return null;
    }

    public int getColumnNumber(String string) {
        for (ISqlJetColumnDef iSqlJetColumnDef : this.getColumns()) {
            if (!iSqlJetColumnDef.getName().equalsIgnoreCase(string)) continue;
            return iSqlJetColumnDef.getIndex();
        }
        return -1;
    }

    public List getConstraints() {
        return this.constraints;
    }

    public boolean isRowIdPrimaryKey() {
        return this.rowIdPrimaryKey;
    }

    public boolean isAutoincremented() {
        return this.autoincremented;
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int n2) {
        this.page = n2;
    }

    public long getRowId() {
        return this.rowId;
    }

    public void setRowId(long l2) {
        this.rowId = l2;
    }

    public String getPrimaryKeyIndexName() {
        return this.primaryKeyIndexName;
    }

    public String getRowIdPrimaryKeyColumnName() {
        return this.rowIdPrimaryKeyColumnName;
    }

    public int getRowIdPrimaryKeyColumnIndex() {
        return this.rowIdPrimaryKeyColumnIndex;
    }

    public List getPrimaryKeyColumnNames() {
        return this.primaryKeyColumns;
    }

    public SqlJetColumnIndexConstraint getColumnIndexConstraint(String string) {
        return (SqlJetColumnIndexConstraint)this.columnConstraintsIndexCache.get(string);
    }

    public SqlJetTableIndexConstraint getTableIndexConstraint(String string) {
        return (SqlJetTableIndexConstraint)this.tableConstrainsIndexCache.get(string);
    }

    public List getNotNullColumns() {
        return this.notNullColumnsCache;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getPage());
        stringBuffer.append("/");
        stringBuffer.append(this.getRowId());
        stringBuffer.append(": ");
        stringBuffer.append(this.toSQL(false));
        return stringBuffer.toString();
    }

    public String toSQL() {
        return this.toSQL(true);
    }

    public String toSQL(boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CREATE ");
        if (this.isTemporary()) {
            stringBuffer.append("TEMPORARY ");
        }
        stringBuffer.append("TABLE ");
        if (!bl2) {
            if (this.isKeepExisting()) {
                stringBuffer.append("IF NOT EXISTS ");
            }
            if (this.getDatabaseName() != null) {
                stringBuffer.append(this.getDatabaseName());
                stringBuffer.append('.');
            }
        }
        stringBuffer.append(this.getQuotedName());
        stringBuffer.append(" (");
        List list = this.getColumns();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            if (i2 > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(((ISqlJetColumnDef)list.get(i2)).toString());
        }
        List list2 = this.getConstraints();
        for (int i3 = 0; i3 < list2.size(); ++i3) {
            stringBuffer.append(", ");
            stringBuffer.append(((ISqlJetTableConstraint)list2.get(i3)).toString());
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }
}

