/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.schema;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.ParserRuleReturnScope;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.RuleReturnScope;
import org.antlr.runtime.tree.CommonTree;
import org.tmatesoft.sqljet.core.SqlJetErrorCode;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.internal.ISqlJetBtree;
import org.tmatesoft.sqljet.core.internal.ISqlJetDbHandle;
import org.tmatesoft.sqljet.core.internal.SqlJetBtreeTableCreateFlags;
import org.tmatesoft.sqljet.core.internal.SqlJetUtility;
import org.tmatesoft.sqljet.core.internal.lang.SqlLexer;
import org.tmatesoft.sqljet.core.internal.lang.SqlParser;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetAlterTableDef;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetBaseIndexDef;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetIndexDef;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetSchema$SqlJetSchemaObjectType;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetTableDef;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetTriggerDef;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetViewDef;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetVirtualTableDef;
import org.tmatesoft.sqljet.core.internal.table.ISqlJetBtreeDataTable;
import org.tmatesoft.sqljet.core.internal.table.ISqlJetBtreeSchemaTable;
import org.tmatesoft.sqljet.core.internal.table.SqlJetBtreeDataTable;
import org.tmatesoft.sqljet.core.internal.table.SqlJetBtreeIndexTable;
import org.tmatesoft.sqljet.core.internal.table.SqlJetBtreeSchemaTable;
import org.tmatesoft.sqljet.core.schema.ISqlJetColumnConstraint;
import org.tmatesoft.sqljet.core.schema.ISqlJetColumnDef;
import org.tmatesoft.sqljet.core.schema.ISqlJetColumnDefault;
import org.tmatesoft.sqljet.core.schema.ISqlJetColumnNotNull;
import org.tmatesoft.sqljet.core.schema.ISqlJetColumnPrimaryKey;
import org.tmatesoft.sqljet.core.schema.ISqlJetColumnUnique;
import org.tmatesoft.sqljet.core.schema.ISqlJetIndexDef;
import org.tmatesoft.sqljet.core.schema.ISqlJetSchema;
import org.tmatesoft.sqljet.core.schema.ISqlJetTableConstraint;
import org.tmatesoft.sqljet.core.schema.ISqlJetTableDef;
import org.tmatesoft.sqljet.core.schema.ISqlJetTablePrimaryKey;
import org.tmatesoft.sqljet.core.schema.ISqlJetTableUnique;
import org.tmatesoft.sqljet.core.schema.ISqlJetTriggerDef;
import org.tmatesoft.sqljet.core.schema.ISqlJetViewDef;
import org.tmatesoft.sqljet.core.schema.ISqlJetVirtualTableDef;

public class SqlJetSchema
implements ISqlJetSchema {
    private static final String NAME_RESERVED = "Name '%s' is reserved to internal use";
    private static String AUTOINDEX_PREFIX = "sqlite_autoindex_";
    private static final String CANT_DELETE_IMPLICIT_INDEX = "Can't delete implicit index \"%s\"";
    private static final String CREATE_TABLE_SQLITE_SEQUENCE = "CREATE TABLE sqlite_sequence(name,seq)";
    private static final String SQLITE_SEQUENCE = "SQLITE_SEQUENCE";
    public static final Set BTREE_CREATE_TABLE_FLAGS = SqlJetUtility.of((Enum)SqlJetBtreeTableCreateFlags.INTKEY, (Enum)SqlJetBtreeTableCreateFlags.LEAFDATA);
    public static final Set BTREE_CREATE_INDEX_FLAGS = SqlJetUtility.of(SqlJetBtreeTableCreateFlags.ZERODATA);
    private static final String TABLE_TYPE = "table";
    private static final String INDEX_TYPE = "index";
    private static final String VIEW_TYPE = "view";
    private static final String TRIGGER_TYPE = "trigger";
    private final ISqlJetDbHandle db;
    private final ISqlJetBtree btree;
    private final Map tableDefs = new TreeMap(String.CASE_INSENSITIVE_ORDER);
    private final Map indexDefs = new TreeMap(String.CASE_INSENSITIVE_ORDER);
    private Map virtualTableDefs = new TreeMap(String.CASE_INSENSITIVE_ORDER);
    private Map viewDefs = new TreeMap(String.CASE_INSENSITIVE_ORDER);
    private Map triggerDefs = new TreeMap(String.CASE_INSENSITIVE_ORDER);

    public SqlJetSchema(ISqlJetDbHandle iSqlJetDbHandle, ISqlJetBtree iSqlJetBtree) {
        this.db = iSqlJetDbHandle;
        this.btree = iSqlJetBtree;
        this.init();
    }

    ISqlJetBtreeSchemaTable openSchemaTable(boolean bl2) {
        return new SqlJetBtreeSchemaTable(this.btree, bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        if (this.db.getOptions().getSchemaVersion() == 0) {
            return;
        }
        ISqlJetBtreeSchemaTable iSqlJetBtreeSchemaTable = this.openSchemaTable(false);
        try {
            iSqlJetBtreeSchemaTable.lock();
            try {
                this.readShema(iSqlJetBtreeSchemaTable);
                Object var3_2 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                iSqlJetBtreeSchemaTable.unlock();
                throw throwable;
            }
            iSqlJetBtreeSchemaTable.unlock();
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            iSqlJetBtreeSchemaTable.close();
            throw throwable;
        }
        iSqlJetBtreeSchemaTable.close();
    }

    public ISqlJetDbHandle getDb() {
        return this.db;
    }

    public ISqlJetBtree getBtree() {
        return this.btree;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getTableNames() {
        this.db.getMutex().enter();
        try {
            TreeSet treeSet = new TreeSet(String.CASE_INSENSITIVE_ORDER);
            treeSet.addAll(this.tableDefs.keySet());
            TreeSet treeSet2 = treeSet;
            Object var4_3 = null;
            this.db.getMutex().leave();
            return treeSet2;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.db.getMutex().leave();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISqlJetTableDef getTable(String string) {
        this.db.getMutex().enter();
        try {
            ISqlJetTableDef iSqlJetTableDef = (ISqlJetTableDef)this.tableDefs.get(string);
            Object var4_3 = null;
            this.db.getMutex().leave();
            return iSqlJetTableDef;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.db.getMutex().leave();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getIndexNames() {
        this.db.getMutex().enter();
        try {
            TreeSet treeSet = new TreeSet(String.CASE_INSENSITIVE_ORDER);
            treeSet.addAll(this.indexDefs.keySet());
            TreeSet treeSet2 = treeSet;
            Object var4_3 = null;
            this.db.getMutex().leave();
            return treeSet2;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.db.getMutex().leave();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISqlJetIndexDef getIndex(String string) {
        this.db.getMutex().enter();
        try {
            ISqlJetIndexDef iSqlJetIndexDef = (ISqlJetIndexDef)this.indexDefs.get(string);
            Object var4_3 = null;
            this.db.getMutex().leave();
            return iSqlJetIndexDef;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.db.getMutex().leave();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getIndexes(String string) {
        this.db.getMutex().enter();
        try {
            HashSet<ISqlJetIndexDef> hashSet = new HashSet<ISqlJetIndexDef>();
            for (ISqlJetIndexDef iSqlJetIndexDef : this.indexDefs.values()) {
                if (!iSqlJetIndexDef.getTableName().equals(string)) continue;
                hashSet.add(iSqlJetIndexDef);
            }
            Set set = Collections.unmodifiableSet(hashSet);
            Object var6_5 = null;
            this.db.getMutex().leave();
            return set;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.db.getMutex().leave();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getVirtualTableNames() {
        this.db.getMutex().enter();
        try {
            TreeSet treeSet = new TreeSet(String.CASE_INSENSITIVE_ORDER);
            treeSet.addAll(this.virtualTableDefs.keySet());
            TreeSet treeSet2 = treeSet;
            Object var4_3 = null;
            this.db.getMutex().leave();
            return treeSet2;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.db.getMutex().leave();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISqlJetVirtualTableDef getVirtualTable(String string) {
        this.db.getMutex().enter();
        try {
            ISqlJetVirtualTableDef iSqlJetVirtualTableDef = (ISqlJetVirtualTableDef)this.virtualTableDefs.get(string);
            Object var4_3 = null;
            this.db.getMutex().leave();
            return iSqlJetVirtualTableDef;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.db.getMutex().leave();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISqlJetViewDef getView(String string) {
        this.db.getMutex().enter();
        try {
            ISqlJetViewDef iSqlJetViewDef = (ISqlJetViewDef)this.viewDefs.get(string);
            Object var4_3 = null;
            this.db.getMutex().leave();
            return iSqlJetViewDef;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.db.getMutex().leave();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getViewNames() {
        this.db.getMutex().enter();
        try {
            TreeSet treeSet = new TreeSet(String.CASE_INSENSITIVE_ORDER);
            treeSet.addAll(this.viewDefs.keySet());
            TreeSet treeSet2 = treeSet;
            Object var4_3 = null;
            this.db.getMutex().leave();
            return treeSet2;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.db.getMutex().leave();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISqlJetTriggerDef getTrigger(String string) {
        this.db.getMutex().enter();
        try {
            ISqlJetTriggerDef iSqlJetTriggerDef = (ISqlJetTriggerDef)this.triggerDefs.get(string);
            Object var4_3 = null;
            this.db.getMutex().leave();
            return iSqlJetTriggerDef;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.db.getMutex().leave();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getTriggerNames() {
        this.db.getMutex().enter();
        try {
            TreeSet treeSet = new TreeSet(String.CASE_INSENSITIVE_ORDER);
            treeSet.addAll(this.triggerDefs.keySet());
            TreeSet treeSet2 = treeSet;
            Object var4_3 = null;
            this.db.getMutex().leave();
            return treeSet2;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.db.getMutex().leave();
            throw throwable;
        }
    }

    private void readShema(ISqlJetBtreeSchemaTable iSqlJetBtreeSchemaTable) {
        iSqlJetBtreeSchemaTable.first();
        while (!iSqlJetBtreeSchemaTable.eof()) {
            String string;
            String string2 = iSqlJetBtreeSchemaTable.getTypeField();
            if (null != string2 && null != (string = iSqlJetBtreeSchemaTable.getNameField())) {
                Object object;
                Object object2;
                Object object3;
                String string3;
                int n2 = iSqlJetBtreeSchemaTable.getPageField();
                if (TABLE_TYPE.equals(string2)) {
                    string3 = iSqlJetBtreeSchemaTable.getSqlField();
                    object3 = (CommonTree)this.parseTable(string3).getTree();
                    if (!this.isCreateVirtualTable((CommonTree)object3)) {
                        object2 = new SqlJetTableDef((CommonTree)object3, n2);
                        if (!string.equals(((SqlJetTableDef)object2).getName())) {
                            throw new SqlJetException(SqlJetErrorCode.CORRUPT);
                        }
                        ((SqlJetTableDef)object2).setRowId(iSqlJetBtreeSchemaTable.getRowId());
                        this.tableDefs.put(string, object2);
                    } else {
                        object2 = new SqlJetVirtualTableDef((CommonTree)object3, n2);
                        if (!string.equals(((SqlJetVirtualTableDef)object2).getTableName())) {
                            throw new SqlJetException(SqlJetErrorCode.CORRUPT);
                        }
                        ((SqlJetVirtualTableDef)object2).setRowId(iSqlJetBtreeSchemaTable.getRowId());
                        this.virtualTableDefs.put(string, object2);
                    }
                } else if (INDEX_TYPE.equals(string2)) {
                    string3 = iSqlJetBtreeSchemaTable.getTableField();
                    object3 = iSqlJetBtreeSchemaTable.getSqlField();
                    if (null != object3) {
                        object2 = (CommonTree)this.parseIndex((String)object3).getTree();
                        object = new SqlJetIndexDef((CommonTree)object2, n2);
                        if (!string.equals(((SqlJetBaseIndexDef)object).getName())) {
                            throw new SqlJetException(SqlJetErrorCode.CORRUPT);
                        }
                        if (!string3.equals(((SqlJetBaseIndexDef)object).getTableName())) {
                            throw new SqlJetException(SqlJetErrorCode.CORRUPT);
                        }
                        ((SqlJetBaseIndexDef)object).setRowId(iSqlJetBtreeSchemaTable.getRowId());
                        this.indexDefs.put(string, object);
                    } else {
                        object2 = new SqlJetBaseIndexDef(string, string3, n2);
                        ((SqlJetBaseIndexDef)object2).setRowId(iSqlJetBtreeSchemaTable.getRowId());
                        this.indexDefs.put(string, object2);
                    }
                } else if (VIEW_TYPE.equals(string2)) {
                    string3 = iSqlJetBtreeSchemaTable.getTableField();
                    object3 = iSqlJetBtreeSchemaTable.getSqlField();
                    object2 = (CommonTree)this.parseView((String)object3).getTree();
                    object = new SqlJetViewDef((String)object3, (CommonTree)object2);
                    ((SqlJetViewDef)object).setRowId(iSqlJetBtreeSchemaTable.getRowId());
                    this.viewDefs.put(string3, object);
                } else if (TRIGGER_TYPE.equals(string2)) {
                    string3 = iSqlJetBtreeSchemaTable.getNameField();
                    object3 = iSqlJetBtreeSchemaTable.getSqlField();
                    object2 = (CommonTree)this.parseTrigger((String)object3).getTree();
                    object = new SqlJetTriggerDef((String)object3, (CommonTree)object2);
                    ((SqlJetTriggerDef)object).setRowId(iSqlJetBtreeSchemaTable.getRowId());
                    this.triggerDefs.put(string3, object);
                }
            }
            iSqlJetBtreeSchemaTable.next();
        }
        this.bindIndexes();
    }

    private void bindIndexes() {
        for (ISqlJetIndexDef iSqlJetIndexDef : this.indexDefs.values()) {
            SqlJetIndexDef sqlJetIndexDef;
            String string;
            ISqlJetTableDef iSqlJetTableDef;
            if (!(iSqlJetIndexDef instanceof SqlJetIndexDef) || (iSqlJetTableDef = (ISqlJetTableDef)this.tableDefs.get(string = (sqlJetIndexDef = (SqlJetIndexDef)iSqlJetIndexDef).getTableName())) == null) continue;
            sqlJetIndexDef.bindColumns(iSqlJetTableDef);
        }
    }

    private boolean isCreateVirtualTable(CommonTree commonTree) {
        CommonTree commonTree2 = (CommonTree)commonTree.getChild(0);
        for (int i2 = 0; i2 < commonTree2.getChildCount(); ++i2) {
            CommonTree commonTree3 = (CommonTree)commonTree2.getChild(i2);
            if (!"virtual".equalsIgnoreCase(commonTree3.getText())) continue;
            return true;
        }
        return false;
    }

    private RuleReturnScope parseTable(String string) {
        try {
            ANTLRStringStream aNTLRStringStream = new ANTLRStringStream(string);
            SqlLexer sqlLexer = new SqlLexer(aNTLRStringStream);
            CommonTokenStream commonTokenStream = new CommonTokenStream(sqlLexer);
            SqlParser sqlParser = new SqlParser(commonTokenStream);
            return sqlParser.schema_create_table_stmt();
        }
        catch (RecognitionException recognitionException) {
            throw new SqlJetException(SqlJetErrorCode.ERROR, "Invalid sql statement: " + string);
        }
    }

    private RuleReturnScope parseView(String string) {
        try {
            ANTLRStringStream aNTLRStringStream = new ANTLRStringStream(string);
            SqlLexer sqlLexer = new SqlLexer(aNTLRStringStream);
            CommonTokenStream commonTokenStream = new CommonTokenStream(sqlLexer);
            SqlParser sqlParser = new SqlParser(commonTokenStream);
            return sqlParser.create_view_stmt();
        }
        catch (RecognitionException recognitionException) {
            throw new SqlJetException(SqlJetErrorCode.ERROR, "Invalid sql statement: " + string);
        }
    }

    private RuleReturnScope parseTrigger(String string) {
        try {
            ANTLRStringStream aNTLRStringStream = new ANTLRStringStream(string);
            SqlLexer sqlLexer = new SqlLexer(aNTLRStringStream);
            CommonTokenStream commonTokenStream = new CommonTokenStream(sqlLexer);
            SqlParser sqlParser = new SqlParser(commonTokenStream);
            return sqlParser.create_trigger_stmt();
        }
        catch (RecognitionException recognitionException) {
            throw new SqlJetException(SqlJetErrorCode.ERROR, "Invalid sql statement: " + string);
        }
    }

    private ParserRuleReturnScope parseIndex(String string) {
        try {
            ANTLRStringStream aNTLRStringStream = new ANTLRStringStream(string);
            SqlLexer sqlLexer = new SqlLexer(aNTLRStringStream);
            CommonTokenStream commonTokenStream = new CommonTokenStream(sqlLexer);
            SqlParser sqlParser = new SqlParser(commonTokenStream);
            return sqlParser.create_index_stmt();
        }
        catch (RecognitionException recognitionException) {
            throw new SqlJetException(SqlJetErrorCode.ERROR, "Invalid sql statement: " + string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        this.db.getMutex().enter();
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Tables:\n");
            for (Object object : this.tableDefs.values()) {
                stringBuffer.append(object.toString());
                stringBuffer.append('\n');
            }
            stringBuffer.append("Indexes:\n");
            for (Object object : this.indexDefs.values()) {
                stringBuffer.append(object.toString());
                stringBuffer.append('\n');
            }
            String string = stringBuffer.toString();
            Object var5_4 = null;
            this.db.getMutex().leave();
            return string;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.db.getMutex().leave();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISqlJetTableDef createTable(String string) {
        this.db.getMutex().enter();
        try {
            ISqlJetTableDef iSqlJetTableDef = this.createTableSafe(string, false);
            Object var4_3 = null;
            this.db.getMutex().leave();
            return iSqlJetTableDef;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.db.getMutex().leave();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ISqlJetTableDef createTableSafe(String string, boolean bl2) {
        SqlJetTableDef sqlJetTableDef;
        RuleReturnScope ruleReturnScope = this.parseTable(string);
        CommonTree commonTree = (CommonTree)ruleReturnScope.getTree();
        if (this.isCreateVirtualTable(commonTree)) {
            throw new SqlJetException(SqlJetErrorCode.ERROR);
        }
        SqlJetTableDef sqlJetTableDef2 = new SqlJetTableDef(commonTree, 0);
        if (null == sqlJetTableDef2.getName()) {
            throw new SqlJetException(SqlJetErrorCode.ERROR);
        }
        String string2 = sqlJetTableDef2.getName();
        if ("".equals(string2)) {
            throw new SqlJetException(SqlJetErrorCode.ERROR);
        }
        if (!bl2) {
            this.checkNameReserved(string2);
        }
        if (this.tableDefs.containsKey(string2)) {
            if (!sqlJetTableDef2.isKeepExisting()) throw new SqlJetException(SqlJetErrorCode.ERROR, "Table \"" + string2 + "\" exists already");
            return (ISqlJetTableDef)this.tableDefs.get(string2);
        }
        this.checkNameConflict(SqlJetSchema$SqlJetSchemaObjectType.TABLE, string2);
        this.checkFieldNamesRepeatsConflict(sqlJetTableDef2.getName(), sqlJetTableDef2.getColumns());
        List list = sqlJetTableDef2.getColumns();
        if (null == list) throw new SqlJetException(SqlJetErrorCode.ERROR);
        if (0 == list.size()) {
            throw new SqlJetException(SqlJetErrorCode.ERROR);
        }
        String string3 = this.getCreateTableSql(ruleReturnScope);
        ISqlJetBtreeSchemaTable iSqlJetBtreeSchemaTable = this.openSchemaTable(true);
        try {
            iSqlJetBtreeSchemaTable.lock();
            try {
                this.db.getOptions().changeSchemaVersion();
                int n2 = this.btree.createTable(BTREE_CREATE_TABLE_FLAGS);
                long l2 = iSqlJetBtreeSchemaTable.newRowId();
                iSqlJetBtreeSchemaTable.insert(null, l2, null, 0, 0, false);
                this.addConstraints(iSqlJetBtreeSchemaTable, sqlJetTableDef2);
                iSqlJetBtreeSchemaTable.updateRecord(l2, TABLE_TYPE, string2, string2, n2, string3);
                sqlJetTableDef2.setPage(n2);
                sqlJetTableDef2.setRowId(l2);
                this.tableDefs.put(string2, sqlJetTableDef2);
                sqlJetTableDef = sqlJetTableDef2;
                Object var15_13 = null;
            }
            catch (Throwable throwable) {
                Object var15_14 = null;
                iSqlJetBtreeSchemaTable.unlock();
                throw throwable;
            }
            iSqlJetBtreeSchemaTable.unlock();
            Object var17_15 = null;
        }
        catch (Throwable throwable) {
            Object var17_16 = null;
            iSqlJetBtreeSchemaTable.close();
            throw throwable;
        }
        iSqlJetBtreeSchemaTable.close();
        return sqlJetTableDef;
    }

    private void checkFieldNamesRepeatsConflict(String string, List list) {
        HashSet<String> hashSet = new HashSet<String>();
        for (ISqlJetColumnDef iSqlJetColumnDef : list) {
            String string2 = iSqlJetColumnDef.getName();
            if (hashSet.contains(string2)) {
                throw new SqlJetException(SqlJetErrorCode.ERROR, String.format("Definition for table '%s' has conflict of repeating fields named '%s'", string, string2));
            }
            hashSet.add(string2);
        }
    }

    private String getCreateTableSql(RuleReturnScope ruleReturnScope) {
        return String.format("CREATE TABLE %s", this.getCoreSQL(ruleReturnScope));
    }

    private String getCreateIndexSql(RuleReturnScope ruleReturnScope) {
        return String.format("CREATE INDEX %s", this.getCoreSQL(ruleReturnScope));
    }

    private String getCreateIndexUniqueSql(RuleReturnScope ruleReturnScope) {
        return String.format("CREATE UNIQUE INDEX %s", this.getCoreSQL(ruleReturnScope));
    }

    private String getCreateVirtualTableSql(RuleReturnScope ruleReturnScope) {
        return String.format("CREATE VIRTUAL TABLE %s", this.getCoreSQL(ruleReturnScope));
    }

    private String getCoreSQL(RuleReturnScope ruleReturnScope) {
        CommonTree commonTree = (CommonTree)ruleReturnScope.getTree();
        CommonToken commonToken = (CommonToken)((CommonTree)commonTree.getChild(1)).getToken();
        CharStream charStream = commonToken.getInputStream();
        CommonToken commonToken2 = (CommonToken)ruleReturnScope.getStop();
        return charStream.substring(commonToken.getStartIndex(), commonToken2.getStopIndex());
    }

    static String generateAutoIndexName(String string, int n2) {
        return AUTOINDEX_PREFIX + string + "_" + Integer.toString(n2);
    }

    private void addConstraints(ISqlJetBtreeSchemaTable iSqlJetBtreeSchemaTable, SqlJetTableDef sqlJetTableDef) {
        Object object;
        Object object2;
        Object object3;
        String string = sqlJetTableDef.getName();
        List list = sqlJetTableDef.getColumns();
        int n2 = 0;
        for (Object object4 : list) {
            object3 = object4.getConstraints();
            if (null == object3) continue;
            Iterator iterator = object3.iterator();
            while (iterator.hasNext()) {
                object2 = (ISqlJetColumnConstraint)iterator.next();
                if (object2 instanceof ISqlJetColumnPrimaryKey) {
                    object = (ISqlJetColumnPrimaryKey)object2;
                    if (!object4.hasExactlyIntegerType()) {
                        if (object.isAutoincremented()) {
                            throw new SqlJetException(SqlJetErrorCode.ERROR, "AUTOINCREMENT is allowed only for INTEGER PRIMARY KEY fields");
                        }
                        this.createAutoIndex(iSqlJetBtreeSchemaTable, string, SqlJetSchema.generateAutoIndexName(string, ++n2));
                        continue;
                    }
                    if (!object.isAutoincremented()) continue;
                    this.checkSequenceTable();
                    continue;
                }
                if (!(object2 instanceof ISqlJetColumnUnique)) continue;
                this.createAutoIndex(iSqlJetBtreeSchemaTable, string, SqlJetSchema.generateAutoIndexName(string, ++n2));
            }
        }
        List list2 = sqlJetTableDef.getConstraints();
        if (null != list2) {
            Object object4;
            object4 = list2.iterator();
            while (object4.hasNext()) {
                object3 = (ISqlJetTableConstraint)object4.next();
                if (object3 instanceof ISqlJetTablePrimaryKey) {
                    boolean bl2 = false;
                    object2 = (ISqlJetTablePrimaryKey)object3;
                    if (object2.getColumns().size() == 1) {
                        object = (String)object2.getColumns().get(0);
                        ISqlJetColumnDef iSqlJetColumnDef = sqlJetTableDef.getColumn((String)object);
                        boolean bl3 = bl2 = iSqlJetColumnDef != null && iSqlJetColumnDef.hasExactlyIntegerType();
                    }
                    if (bl2) continue;
                    this.createAutoIndex(iSqlJetBtreeSchemaTable, string, SqlJetSchema.generateAutoIndexName(string, ++n2));
                    continue;
                }
                if (!(object3 instanceof ISqlJetTableUnique)) continue;
                this.createAutoIndex(iSqlJetBtreeSchemaTable, string, SqlJetSchema.generateAutoIndexName(string, ++n2));
            }
        }
    }

    private void checkSequenceTable() {
        if (!this.tableDefs.containsKey(SQLITE_SEQUENCE)) {
            this.createTableSafe(CREATE_TABLE_SQLITE_SEQUENCE, true);
        }
    }

    public ISqlJetBtreeDataTable openSequenceTable() {
        if (this.tableDefs.containsKey(SQLITE_SEQUENCE)) {
            return new SqlJetBtreeDataTable(this.btree, SQLITE_SEQUENCE, true);
        }
        return null;
    }

    private ISqlJetIndexDef createAutoIndex(ISqlJetBtreeSchemaTable iSqlJetBtreeSchemaTable, String string, String string2) {
        int n2 = this.btree.createTable(BTREE_CREATE_INDEX_FLAGS);
        SqlJetBaseIndexDef sqlJetBaseIndexDef = new SqlJetBaseIndexDef(string2, string, n2);
        sqlJetBaseIndexDef.setRowId(iSqlJetBtreeSchemaTable.insertRecord(INDEX_TYPE, string2, string, n2, null));
        this.indexDefs.put(string2, sqlJetBaseIndexDef);
        return sqlJetBaseIndexDef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISqlJetIndexDef createIndex(String string) {
        this.db.getMutex().enter();
        try {
            ISqlJetIndexDef iSqlJetIndexDef = this.createIndexSafe(string);
            Object var4_3 = null;
            this.db.getMutex().leave();
            return iSqlJetIndexDef;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.db.getMutex().leave();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ISqlJetIndexDef createIndexSafe(String string) {
        SqlJetIndexDef sqlJetIndexDef;
        Object object2;
        ParserRuleReturnScope parserRuleReturnScope = this.parseIndex(string);
        CommonTree commonTree = (CommonTree)parserRuleReturnScope.getTree();
        SqlJetIndexDef sqlJetIndexDef2 = new SqlJetIndexDef(commonTree, 0);
        if (null == sqlJetIndexDef2.getName()) {
            throw new SqlJetException(SqlJetErrorCode.ERROR);
        }
        String string2 = sqlJetIndexDef2.getName();
        if ("".equals(string2)) {
            throw new SqlJetException(SqlJetErrorCode.ERROR);
        }
        this.checkNameReserved(string2);
        if (this.indexDefs.containsKey(string2)) {
            if (!sqlJetIndexDef2.isKeepExisting()) throw new SqlJetException(SqlJetErrorCode.ERROR, "Index \"" + string2 + "\" exists already");
            return (ISqlJetIndexDef)this.indexDefs.get(string2);
        }
        this.checkNameConflict(SqlJetSchema$SqlJetSchemaObjectType.INDEX, string2);
        if (null == sqlJetIndexDef2.getTableName()) {
            throw new SqlJetException(SqlJetErrorCode.ERROR);
        }
        String string3 = sqlJetIndexDef2.getTableName();
        if ("".equals(string3)) {
            throw new SqlJetException(SqlJetErrorCode.ERROR);
        }
        List list = sqlJetIndexDef2.getColumns();
        if (null == list) {
            throw new SqlJetException(SqlJetErrorCode.ERROR);
        }
        ISqlJetTableDef iSqlJetTableDef = this.getTable(string3);
        if (null == iSqlJetTableDef) {
            throw new SqlJetException(SqlJetErrorCode.ERROR);
        }
        for (Object object2 : list) {
            if (null == object2.getName()) {
                throw new SqlJetException(SqlJetErrorCode.ERROR);
            }
            String string4 = object2.getName();
            if ("".equals(string4)) {
                throw new SqlJetException(SqlJetErrorCode.ERROR);
            }
            if (null != iSqlJetTableDef.getColumn(string4)) continue;
            throw new SqlJetException(SqlJetErrorCode.ERROR, "Column \"" + string4 + "\" not found in table \"" + string3 + "\"");
        }
        ISqlJetBtreeSchemaTable iSqlJetBtreeSchemaTable = this.openSchemaTable(true);
        object2 = sqlJetIndexDef2.isUnique() ? this.getCreateIndexUniqueSql(parserRuleReturnScope) : this.getCreateIndexSql(parserRuleReturnScope);
        try {
            iSqlJetBtreeSchemaTable.lock();
            try {
                this.db.getOptions().changeSchemaVersion();
                int n2 = this.btree.createTable(BTREE_CREATE_INDEX_FLAGS);
                long l2 = iSqlJetBtreeSchemaTable.insertRecord(INDEX_TYPE, string2, string3, n2, (String)object2);
                sqlJetIndexDef2.setPage(n2);
                sqlJetIndexDef2.setRowId(l2);
                sqlJetIndexDef2.bindColumns(iSqlJetTableDef);
                this.indexDefs.put(string2, sqlJetIndexDef2);
                SqlJetBtreeIndexTable sqlJetBtreeIndexTable = new SqlJetBtreeIndexTable(this.btree, sqlJetIndexDef2.getName(), true);
                try {
                    sqlJetBtreeIndexTable.reindex(this);
                    Object var16_15 = null;
                }
                catch (Throwable throwable) {
                    Object var16_16 = null;
                    sqlJetBtreeIndexTable.close();
                    throw throwable;
                }
                sqlJetBtreeIndexTable.close();
                sqlJetIndexDef = sqlJetIndexDef2;
                Object var18_19 = null;
            }
            catch (Throwable throwable) {
                Object var18_20 = null;
                iSqlJetBtreeSchemaTable.unlock();
                throw throwable;
            }
            iSqlJetBtreeSchemaTable.unlock();
            Object var20_21 = null;
        }
        catch (Throwable throwable) {
            Object var20_22 = null;
            iSqlJetBtreeSchemaTable.close();
            throw throwable;
        }
        iSqlJetBtreeSchemaTable.close();
        return sqlJetIndexDef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropTable(String string) {
        this.db.getMutex().enter();
        try {
            this.dropTableSafe(string);
            Object var3_2 = null;
            this.db.getMutex().leave();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.db.getMutex().leave();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropTableSafe(String string) {
        if (null == string || "".equals(string)) {
            throw new SqlJetException(SqlJetErrorCode.MISUSE, "Table name must be not empty");
        }
        if (!this.tableDefs.containsKey(string)) {
            throw new SqlJetException(SqlJetErrorCode.MISUSE, "Table not found: " + string);
        }
        SqlJetTableDef sqlJetTableDef = (SqlJetTableDef)this.tableDefs.get(string);
        this.dropTableIndexes(sqlJetTableDef);
        ISqlJetBtreeSchemaTable iSqlJetBtreeSchemaTable = this.openSchemaTable(true);
        try {
            iSqlJetBtreeSchemaTable.lock();
            try {
                this.db.getOptions().changeSchemaVersion();
                if (!iSqlJetBtreeSchemaTable.goToRow(sqlJetTableDef.getRowId()) || !TABLE_TYPE.equals(iSqlJetBtreeSchemaTable.getTypeField())) {
                    throw new SqlJetException(SqlJetErrorCode.CORRUPT);
                }
                String string2 = iSqlJetBtreeSchemaTable.getNameField();
                if (null == string2 || !string.equals(string2)) {
                    throw new SqlJetException(SqlJetErrorCode.CORRUPT);
                }
                iSqlJetBtreeSchemaTable.delete();
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                iSqlJetBtreeSchemaTable.unlock();
                throw throwable;
            }
            iSqlJetBtreeSchemaTable.unlock();
            Object var8_10 = null;
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            iSqlJetBtreeSchemaTable.close();
            throw throwable;
        }
        iSqlJetBtreeSchemaTable.close();
        int n2 = sqlJetTableDef.getPage();
        int n3 = this.btree.dropTable(n2);
        if (n3 != 0) {
            this.movePage(n2, n3);
        }
        this.tableDefs.remove(string);
    }

    private void dropTableIndexes(SqlJetTableDef sqlJetTableDef) {
        String string = sqlJetTableDef.getName();
        Iterator iterator = this.indexDefs.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string2 = (String)entry.getKey();
            ISqlJetIndexDef iSqlJetIndexDef = (ISqlJetIndexDef)entry.getValue();
            if (!iSqlJetIndexDef.getTableName().equals(string) || !this.doDropIndex(string2, true, false)) continue;
            iterator.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean doDropIndex(String string, boolean bl2, boolean bl3) {
        if (!this.indexDefs.containsKey(string)) {
            if (bl3) {
                throw new SqlJetException(SqlJetErrorCode.MISUSE);
            }
            return false;
        }
        SqlJetBaseIndexDef sqlJetBaseIndexDef = (SqlJetBaseIndexDef)this.indexDefs.get(string);
        if (!bl2 && sqlJetBaseIndexDef.isImplicit()) {
            if (bl3) {
                throw new SqlJetException(SqlJetErrorCode.MISUSE, String.format(CANT_DELETE_IMPLICIT_INDEX, string));
            }
            return false;
        }
        ISqlJetBtreeSchemaTable iSqlJetBtreeSchemaTable = this.openSchemaTable(true);
        try {
            block17: {
                block16: {
                    block15: {
                        boolean bl4;
                        iSqlJetBtreeSchemaTable.lock();
                        try {
                            if (iSqlJetBtreeSchemaTable.goToRow(sqlJetBaseIndexDef.getRowId()) && INDEX_TYPE.equals(iSqlJetBtreeSchemaTable.getTypeField())) break block15;
                            if (bl3) {
                                throw new SqlJetException(SqlJetErrorCode.INTERNAL);
                            }
                            bl4 = false;
                            Object var9_9 = null;
                        }
                        catch (Throwable throwable) {
                            Object var9_13 = null;
                            iSqlJetBtreeSchemaTable.unlock();
                            throw throwable;
                        }
                        iSqlJetBtreeSchemaTable.unlock();
                        Object var11_14 = null;
                        iSqlJetBtreeSchemaTable.close();
                        return bl4;
                    }
                    String string2 = iSqlJetBtreeSchemaTable.getNameField();
                    if (null != string2 && string.equals(string2)) break block16;
                    if (bl3) {
                        throw new SqlJetException(SqlJetErrorCode.INTERNAL);
                    }
                    boolean bl5 = false;
                    Object var9_10 = null;
                    iSqlJetBtreeSchemaTable.unlock();
                    Object var11_15 = null;
                    iSqlJetBtreeSchemaTable.close();
                    return bl5;
                }
                if (bl2 || !iSqlJetBtreeSchemaTable.isNull(4)) break block17;
                if (bl3) {
                    throw new SqlJetException(SqlJetErrorCode.MISUSE, String.format(CANT_DELETE_IMPLICIT_INDEX, string));
                }
                boolean bl6 = false;
                Object var9_11 = null;
                iSqlJetBtreeSchemaTable.unlock();
                Object var11_16 = null;
                iSqlJetBtreeSchemaTable.close();
                return bl6;
            }
            iSqlJetBtreeSchemaTable.delete();
            Object var9_12 = null;
            iSqlJetBtreeSchemaTable.unlock();
            Object var11_17 = null;
            iSqlJetBtreeSchemaTable.close();
        }
        catch (Throwable throwable) {
            Object var11_18 = null;
            iSqlJetBtreeSchemaTable.close();
            throw throwable;
        }
        int n2 = sqlJetBaseIndexDef.getPage();
        int n3 = this.btree.dropTable(n2);
        if (n3 != 0) {
            this.movePage(n2, n3);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void movePage(int var1_1, int var2_2) {
        var3_3 = this.openSchemaTable(true);
        try {
            block11: {
                var3_3.lock();
                try {
                    var3_3.first();
lbl7:
                    // 2 sources

                    while (!var3_3.eof()) {
                        var4_4 = var3_3.getPageField();
                        if (var4_4 == (long)var2_2) {
                            var6_5 = var3_3.getNameField();
                            var3_3.updateRecord(var3_3.getRowId(), var3_3.getTypeField(), var6_5, var3_3.getTableField(), var1_1, var3_3.getSqlField());
                            var7_6 = this.getIndex(var6_5);
                            if (var7_6 != null) {
                                if (var7_6 instanceof SqlJetBaseIndexDef) {
                                    ((SqlJetBaseIndexDef)var7_6).setPage(var1_1);
                                }
                            } else {
                                var8_7 = this.getTable(var6_5);
                                if (var8_7 != null && var8_7 instanceof SqlJetTableDef) {
                                    ((SqlJetTableDef)var8_7).setPage(var1_1);
                                }
                            }
                            var10_8 = null;
                            break block11;
                        }
                        ** GOTO lbl-1000
                    }
                    ** GOTO lbl39
                }
                catch (Throwable var9_14) {
                    var10_10 = null;
                    var3_3.unlock();
                    throw var9_14;
                }
            }
            var3_3.unlock();
            var12_11 = null;
            var3_3.close();
            return;
lbl-1000:
            // 1 sources

            {
                var3_3.next();
                ** GOTO lbl7
lbl39:
                // 1 sources

                var10_9 = null;
                var3_3.unlock();
            }
            var12_12 = null;
            var3_3.close();
            return;
        }
        catch (Throwable var11_15) {
            var12_13 = null;
            var3_3.close();
            throw var11_15;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropIndex(String string) {
        this.db.getMutex().enter();
        try {
            this.dropIndexSafe(string);
            Object var3_2 = null;
            this.db.getMutex().leave();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.db.getMutex().leave();
            throw throwable;
        }
    }

    private void dropIndexSafe(String string) {
        if (null == string || "".equals(string)) {
            throw new SqlJetException(SqlJetErrorCode.MISUSE, "Index name must be not empty");
        }
        if (!this.indexDefs.containsKey(string)) {
            throw new SqlJetException(SqlJetErrorCode.MISUSE, "Index not found: " + string);
        }
        if (this.doDropIndex(string, false, true)) {
            this.db.getOptions().changeSchemaVersion();
            this.indexDefs.remove(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ISqlJetTableDef alterTableSafe(SqlJetAlterTableDef sqlJetAlterTableDef) {
        SqlJetTableDef sqlJetTableDef;
        assert (null != sqlJetAlterTableDef);
        String string = sqlJetAlterTableDef.getTableName();
        String string2 = sqlJetAlterTableDef.getTableQuotedName();
        String string3 = sqlJetAlterTableDef.getNewTableName();
        String string4 = sqlJetAlterTableDef.getNewTableQuotedName();
        ISqlJetColumnDef iSqlJetColumnDef = sqlJetAlterTableDef.getNewColumnDef();
        if (null == string) {
            throw new SqlJetException(SqlJetErrorCode.MISUSE, "Table name isn't defined");
        }
        if (null == string3 && null == iSqlJetColumnDef) {
            throw new SqlJetException(SqlJetErrorCode.MISUSE, "Not defined any altering");
        }
        boolean bl2 = false;
        if (null != string3) {
            bl2 = true;
        } else {
            string3 = string;
            string4 = string2;
        }
        if (bl2 && this.tableDefs.containsKey(string3)) {
            throw new SqlJetException(SqlJetErrorCode.MISUSE, String.format("Table \"%s\" already exists", string3));
        }
        SqlJetTableDef sqlJetTableDef2 = (SqlJetTableDef)this.tableDefs.get(string);
        if (null == sqlJetTableDef2) {
            throw new SqlJetException(SqlJetErrorCode.MISUSE, String.format("Table \"%s\" not found", string));
        }
        ArrayList<ISqlJetColumnDef> arrayList = sqlJetTableDef2.getColumns();
        if (null != iSqlJetColumnDef) {
            String string5 = iSqlJetColumnDef.getName();
            if (sqlJetTableDef2.getColumn(string5) != null) {
                throw new SqlJetException(SqlJetErrorCode.MISUSE, String.format("Field \"%s\" already exists in table \"%s\"", string5, string));
            }
            List list = iSqlJetColumnDef.getConstraints();
            if (null != list && 0 != list.size()) {
                boolean bl3 = false;
                boolean bl4 = false;
                for (Object object : list) {
                    if (object instanceof ISqlJetColumnNotNull) {
                        bl3 = true;
                        continue;
                    }
                    if (!(object instanceof ISqlJetColumnDefault)) {
                        throw new SqlJetException(SqlJetErrorCode.MISUSE, String.format("Invalid constraint: %s", object.toString()));
                    }
                    bl4 = true;
                }
                if (bl3 && !bl4) {
                    throw new SqlJetException(SqlJetErrorCode.MISUSE, "NOT NULL requires to have DEFAULT value");
                }
            }
            arrayList = new ArrayList<ISqlJetColumnDef>(arrayList);
            arrayList.add(iSqlJetColumnDef);
        }
        int n2 = sqlJetTableDef2.getPage();
        long l2 = sqlJetTableDef2.getRowId();
        SqlJetTableDef sqlJetTableDef3 = new SqlJetTableDef(string4, null, sqlJetTableDef2.isTemporary(), false, arrayList, sqlJetTableDef2.getConstraints(), n2, l2);
        ISqlJetBtreeSchemaTable iSqlJetBtreeSchemaTable = this.openSchemaTable(true);
        try {
            iSqlJetBtreeSchemaTable.lock();
            try {
                Object object;
                if (!iSqlJetBtreeSchemaTable.goToRow(l2)) {
                    throw new SqlJetException(SqlJetErrorCode.CORRUPT);
                }
                object = iSqlJetBtreeSchemaTable.getTypeField();
                String string6 = iSqlJetBtreeSchemaTable.getNameField();
                String string7 = iSqlJetBtreeSchemaTable.getTableField();
                int n3 = iSqlJetBtreeSchemaTable.getPageField();
                if (null == object) throw new SqlJetException(SqlJetErrorCode.CORRUPT);
                if (!TABLE_TYPE.equals(object)) {
                    throw new SqlJetException(SqlJetErrorCode.CORRUPT);
                }
                if (null == string6) throw new SqlJetException(SqlJetErrorCode.CORRUPT);
                if (!string.equals(string6)) {
                    throw new SqlJetException(SqlJetErrorCode.CORRUPT);
                }
                if (null == string7) throw new SqlJetException(SqlJetErrorCode.CORRUPT);
                if (!string.equals(string7)) {
                    throw new SqlJetException(SqlJetErrorCode.CORRUPT);
                }
                if (0 == n3) throw new SqlJetException(SqlJetErrorCode.CORRUPT);
                if (n3 != n2) {
                    throw new SqlJetException(SqlJetErrorCode.CORRUPT);
                }
                String string8 = sqlJetTableDef3.toSQL();
                this.db.getOptions().changeSchemaVersion();
                iSqlJetBtreeSchemaTable.updateRecord(l2, TABLE_TYPE, string3, string3, n2, string8);
                if (bl2 && !string.equals(string3)) {
                    this.renameTablesIndices(iSqlJetBtreeSchemaTable, string, string3, string4);
                }
                this.tableDefs.remove(string);
                this.tableDefs.put(string3, sqlJetTableDef3);
                sqlJetTableDef = sqlJetTableDef3;
                Object var22_24 = null;
            }
            catch (Throwable throwable) {
                Object var22_25 = null;
                iSqlJetBtreeSchemaTable.unlock();
                throw throwable;
            }
            iSqlJetBtreeSchemaTable.unlock();
            Object var24_26 = null;
        }
        catch (Throwable throwable) {
            Object var24_27 = null;
            iSqlJetBtreeSchemaTable.close();
            throw throwable;
        }
        iSqlJetBtreeSchemaTable.close();
        return sqlJetTableDef;
    }

    private void renameTablesIndices(ISqlJetBtreeSchemaTable iSqlJetBtreeSchemaTable, String string, String string2, String string3) {
        Set set = this.getIndexes(string);
        if (null == set || 0 == set.size()) {
            return;
        }
        int n2 = 0;
        for (ISqlJetIndexDef iSqlJetIndexDef : set) {
            if (iSqlJetIndexDef instanceof SqlJetBaseIndexDef) {
                SqlJetBaseIndexDef sqlJetBaseIndexDef = (SqlJetBaseIndexDef)iSqlJetIndexDef;
                String string4 = sqlJetBaseIndexDef.getName();
                long l2 = sqlJetBaseIndexDef.getRowId();
                int n3 = sqlJetBaseIndexDef.getPage();
                if (!iSqlJetBtreeSchemaTable.goToRow(l2)) {
                    throw new SqlJetException(SqlJetErrorCode.CORRUPT);
                }
                String string5 = iSqlJetBtreeSchemaTable.getTypeField();
                String string6 = iSqlJetBtreeSchemaTable.getNameField();
                String string7 = iSqlJetBtreeSchemaTable.getTableField();
                int n4 = iSqlJetBtreeSchemaTable.getPageField();
                if (null == string5 || !INDEX_TYPE.equals(string5)) {
                    throw new SqlJetException(SqlJetErrorCode.CORRUPT);
                }
                if (null == string6 || !string4.equals(string6)) {
                    throw new SqlJetException(SqlJetErrorCode.CORRUPT);
                }
                if (null == string7 || !string.equals(string7)) {
                    throw new SqlJetException(SqlJetErrorCode.CORRUPT);
                }
                if (0 == n4 || n4 != n3) {
                    throw new SqlJetException(SqlJetErrorCode.CORRUPT);
                }
                sqlJetBaseIndexDef.setTableName(string2);
                String string8 = string4;
                String string9 = null;
                if (iSqlJetIndexDef.isImplicit()) {
                    string8 = SqlJetSchema.generateAutoIndexName(string, ++n2);
                    sqlJetBaseIndexDef.setName(string8);
                    this.indexDefs.remove(string4);
                    this.indexDefs.put(string8, sqlJetBaseIndexDef);
                } else {
                    string9 = this.getAlteredIndexSql(iSqlJetBtreeSchemaTable.getSqlField(), string3);
                }
                iSqlJetBtreeSchemaTable.updateRecord(l2, INDEX_TYPE, string8, string2, n3, string9);
                continue;
            }
            throw new SqlJetException(SqlJetErrorCode.INTERNAL);
        }
    }

    private String getAlteredIndexSql(String string, String string2) {
        ParserRuleReturnScope parserRuleReturnScope = this.parseIndex(string);
        CommonTree commonTree = (CommonTree)((RuleReturnScope)parserRuleReturnScope).getTree();
        CommonToken commonToken = (CommonToken)((CommonTree)commonTree.getChild(2)).getToken();
        CharStream charStream = commonToken.getInputStream();
        CommonToken commonToken2 = (CommonToken)((RuleReturnScope)parserRuleReturnScope).getStop();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(charStream.substring(0, commonToken.getStartIndex() - 1));
        stringBuilder.append(string2);
        stringBuilder.append(charStream.substring(commonToken.getStopIndex() + 1, commonToken2.getStopIndex()));
        return stringBuilder.toString();
    }

    private ParserRuleReturnScope parseSqlStatement(String string) {
        try {
            ANTLRStringStream aNTLRStringStream = new ANTLRStringStream(string);
            SqlLexer sqlLexer = new SqlLexer(aNTLRStringStream);
            CommonTokenStream commonTokenStream = new CommonTokenStream(sqlLexer);
            SqlParser sqlParser = new SqlParser(commonTokenStream);
            return sqlParser.sql_stmt_itself();
        }
        catch (RecognitionException recognitionException) {
            throw new SqlJetException(SqlJetErrorCode.ERROR, "Invalid sql statement: " + string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISqlJetTableDef alterTable(String string) {
        SqlJetAlterTableDef sqlJetAlterTableDef = new SqlJetAlterTableDef(this.parseSqlStatement(string));
        this.db.getMutex().enter();
        try {
            ISqlJetTableDef iSqlJetTableDef = this.alterTableSafe(sqlJetAlterTableDef);
            Object var5_4 = null;
            this.db.getMutex().leave();
            return iSqlJetTableDef;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.db.getMutex().leave();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISqlJetVirtualTableDef createVirtualTable(String string, int n2) {
        this.db.getMutex().enter();
        try {
            ISqlJetVirtualTableDef iSqlJetVirtualTableDef = this.createVirtualTableSafe(string, n2);
            Object var5_4 = null;
            this.db.getMutex().leave();
            return iSqlJetVirtualTableDef;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.db.getMutex().leave();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ISqlJetVirtualTableDef createVirtualTableSafe(String string, int n2) {
        SqlJetVirtualTableDef sqlJetVirtualTableDef;
        RuleReturnScope ruleReturnScope = this.parseTable(string);
        CommonTree commonTree = (CommonTree)ruleReturnScope.getTree();
        if (!this.isCreateVirtualTable(commonTree)) {
            throw new SqlJetException(SqlJetErrorCode.ERROR);
        }
        SqlJetVirtualTableDef sqlJetVirtualTableDef2 = new SqlJetVirtualTableDef(commonTree, 0);
        if (null == sqlJetVirtualTableDef2.getTableName()) {
            throw new SqlJetException(SqlJetErrorCode.ERROR);
        }
        String string2 = sqlJetVirtualTableDef2.getTableName();
        if ("".equals(string2)) {
            throw new SqlJetException(SqlJetErrorCode.ERROR);
        }
        this.checkNameReserved(string2);
        this.checkFieldNamesRepeatsConflict(sqlJetVirtualTableDef2.getTableName(), sqlJetVirtualTableDef2.getModuleColumns());
        if (this.virtualTableDefs.containsKey(string2)) {
            throw new SqlJetException(SqlJetErrorCode.ERROR, "Virtual table \"" + string2 + "\" exists already");
        }
        this.checkNameConflict(SqlJetSchema$SqlJetSchemaObjectType.VIRTUAL_TABLE, string2);
        ISqlJetBtreeSchemaTable iSqlJetBtreeSchemaTable = this.openSchemaTable(true);
        String string3 = this.getCreateVirtualTableSql(ruleReturnScope);
        try {
            iSqlJetBtreeSchemaTable.lock();
            try {
                this.db.getOptions().changeSchemaVersion();
                long l2 = iSqlJetBtreeSchemaTable.insertRecord(TABLE_TYPE, string2, string2, n2, string3);
                sqlJetVirtualTableDef2.setPage(n2);
                sqlJetVirtualTableDef2.setRowId(l2);
                this.virtualTableDefs.put(string2, sqlJetVirtualTableDef2);
                sqlJetVirtualTableDef = sqlJetVirtualTableDef2;
                Object var13_11 = null;
            }
            catch (Throwable throwable) {
                Object var13_12 = null;
                iSqlJetBtreeSchemaTable.unlock();
                throw throwable;
            }
            iSqlJetBtreeSchemaTable.unlock();
            Object var15_13 = null;
        }
        catch (Throwable throwable) {
            Object var15_14 = null;
            iSqlJetBtreeSchemaTable.close();
            throw throwable;
        }
        iSqlJetBtreeSchemaTable.close();
        return sqlJetVirtualTableDef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISqlJetViewDef createView(String string) {
        this.db.getMutex().enter();
        try {
            ISqlJetViewDef iSqlJetViewDef = this.createViewSafe(string);
            Object var4_3 = null;
            this.db.getMutex().leave();
            return iSqlJetViewDef;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.db.getMutex().leave();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ISqlJetViewDef createViewSafe(String string) {
        SqlJetViewDef sqlJetViewDef;
        SqlJetViewDef sqlJetViewDef2;
        RuleReturnScope ruleReturnScope = this.parseView(string);
        CommonTree commonTree = (CommonTree)ruleReturnScope.getTree();
        if ((string = string.trim()).endsWith(";")) {
            string = string.substring(0, string.length() - 1);
        }
        if (null == (sqlJetViewDef2 = new SqlJetViewDef(string, commonTree)).getName()) {
            throw new SqlJetException(SqlJetErrorCode.ERROR);
        }
        String string2 = sqlJetViewDef2.getName();
        if ("".equals(string2)) {
            throw new SqlJetException(SqlJetErrorCode.ERROR);
        }
        if (this.viewDefs.containsKey(string2)) {
            if (!sqlJetViewDef2.isKeepExisting()) throw new SqlJetException(SqlJetErrorCode.ERROR, "View \"" + string2 + "\" exists already");
            return (ISqlJetViewDef)this.viewDefs.get(string2);
        }
        this.checkNameConflict(SqlJetSchema$SqlJetSchemaObjectType.VIEW, string2);
        ISqlJetBtreeSchemaTable iSqlJetBtreeSchemaTable = this.openSchemaTable(true);
        try {
            iSqlJetBtreeSchemaTable.lock();
            try {
                this.db.getOptions().changeSchemaVersion();
                long l2 = iSqlJetBtreeSchemaTable.insertRecord(VIEW_TYPE, string2, string2, 0, string);
                sqlJetViewDef2.setRowId(l2);
                this.viewDefs.put(string2, sqlJetViewDef2);
                sqlJetViewDef = sqlJetViewDef2;
                Object var11_9 = null;
            }
            catch (Throwable throwable) {
                Object var11_10 = null;
                iSqlJetBtreeSchemaTable.unlock();
                throw throwable;
            }
            iSqlJetBtreeSchemaTable.unlock();
            Object var13_11 = null;
        }
        catch (Throwable throwable) {
            Object var13_12 = null;
            iSqlJetBtreeSchemaTable.close();
            throw throwable;
        }
        iSqlJetBtreeSchemaTable.close();
        return sqlJetViewDef;
    }

    private void checkNameReserved(String string) {
        if (this.isNameReserved(string)) {
            throw new SqlJetException(String.format(NAME_RESERVED, string));
        }
    }

    public boolean isNameReserved(String string) {
        return string.startsWith("sqlite_");
    }

    private void checkNameConflict(SqlJetSchema$SqlJetSchemaObjectType sqlJetSchema$SqlJetSchemaObjectType, String string) {
        if (this.isNameConflict(sqlJetSchema$SqlJetSchemaObjectType, string)) {
            throw new SqlJetException(String.format("Name conflict: %s named '%s' exists already", sqlJetSchema$SqlJetSchemaObjectType.getName(), string));
        }
    }

    private boolean isNameConflict(SqlJetSchema$SqlJetSchemaObjectType sqlJetSchema$SqlJetSchemaObjectType, String string) {
        if (sqlJetSchema$SqlJetSchemaObjectType != SqlJetSchema$SqlJetSchemaObjectType.TABLE && this.tableDefs.containsKey(string)) {
            return true;
        }
        if (sqlJetSchema$SqlJetSchemaObjectType != SqlJetSchema$SqlJetSchemaObjectType.INDEX && this.indexDefs.containsKey(string)) {
            return true;
        }
        if (sqlJetSchema$SqlJetSchemaObjectType != SqlJetSchema$SqlJetSchemaObjectType.VIRTUAL_TABLE && this.virtualTableDefs.containsKey(string)) {
            return true;
        }
        if (sqlJetSchema$SqlJetSchemaObjectType != SqlJetSchema$SqlJetSchemaObjectType.VIEW && this.viewDefs.containsKey(string)) {
            return true;
        }
        return sqlJetSchema$SqlJetSchemaObjectType != SqlJetSchema$SqlJetSchemaObjectType.TRIGGER && this.triggerDefs.containsKey(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISqlJetIndexDef createIndexForVirtualTable(String string, String string2) {
        this.db.getMutex().enter();
        try {
            ISqlJetIndexDef iSqlJetIndexDef = this.createIndexForVirtualTableSafe(string, string2);
            Object var5_4 = null;
            this.db.getMutex().leave();
            return iSqlJetIndexDef;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.db.getMutex().leave();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ISqlJetIndexDef createIndexForVirtualTableSafe(String string, String string2) {
        ISqlJetIndexDef iSqlJetIndexDef;
        if (null == string) throw new SqlJetException(SqlJetErrorCode.ERROR);
        if ("".equals(string)) {
            throw new SqlJetException(SqlJetErrorCode.ERROR);
        }
        if (null == string2) throw new SqlJetException(SqlJetErrorCode.ERROR);
        if ("".equals(string2)) {
            throw new SqlJetException(SqlJetErrorCode.ERROR);
        }
        this.checkNameReserved(string2);
        if (this.indexDefs.containsKey(string2)) {
            throw new SqlJetException(SqlJetErrorCode.ERROR, "Index \"" + string2 + "\" exists already");
        }
        this.checkNameConflict(SqlJetSchema$SqlJetSchemaObjectType.INDEX, string2);
        ISqlJetVirtualTableDef iSqlJetVirtualTableDef = this.getVirtualTable(string);
        if (null == iSqlJetVirtualTableDef) {
            throw new SqlJetException(SqlJetErrorCode.ERROR);
        }
        ISqlJetBtreeSchemaTable iSqlJetBtreeSchemaTable = this.openSchemaTable(true);
        try {
            iSqlJetBtreeSchemaTable.lock();
            try {
                this.db.getOptions().changeSchemaVersion();
                ISqlJetIndexDef iSqlJetIndexDef2 = this.createAutoIndex(iSqlJetBtreeSchemaTable, iSqlJetVirtualTableDef.getTableName(), string2);
                this.indexDefs.put(string2, iSqlJetIndexDef2);
                iSqlJetIndexDef = iSqlJetIndexDef2;
                Object var8_7 = null;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                iSqlJetBtreeSchemaTable.unlock();
                throw throwable;
            }
            iSqlJetBtreeSchemaTable.unlock();
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            iSqlJetBtreeSchemaTable.close();
            throw throwable;
        }
        iSqlJetBtreeSchemaTable.close();
        return iSqlJetIndexDef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropView(String string) {
        this.db.getMutex().enter();
        try {
            this.dropViewSafe(string);
            Object var3_2 = null;
            this.db.getMutex().leave();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.db.getMutex().leave();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropViewSafe(String string) {
        if (null == string || "".equals(string)) {
            throw new SqlJetException(SqlJetErrorCode.MISUSE, "View name must be not empty");
        }
        if (!this.viewDefs.containsKey(string)) {
            throw new SqlJetException(SqlJetErrorCode.MISUSE, "View not found: " + string);
        }
        SqlJetViewDef sqlJetViewDef = (SqlJetViewDef)this.viewDefs.get(string);
        ISqlJetBtreeSchemaTable iSqlJetBtreeSchemaTable = this.openSchemaTable(true);
        try {
            iSqlJetBtreeSchemaTable.lock();
            try {
                this.db.getOptions().changeSchemaVersion();
                if (!iSqlJetBtreeSchemaTable.goToRow(sqlJetViewDef.getRowId()) || !VIEW_TYPE.equals(iSqlJetBtreeSchemaTable.getTypeField())) {
                    throw new SqlJetException(SqlJetErrorCode.CORRUPT);
                }
                String string2 = iSqlJetBtreeSchemaTable.getNameField();
                if (null == string2 || !string.equals(string2)) {
                    throw new SqlJetException(SqlJetErrorCode.CORRUPT);
                }
                iSqlJetBtreeSchemaTable.delete();
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                iSqlJetBtreeSchemaTable.unlock();
                throw throwable;
            }
            iSqlJetBtreeSchemaTable.unlock();
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            iSqlJetBtreeSchemaTable.close();
            throw throwable;
        }
        iSqlJetBtreeSchemaTable.close();
        this.viewDefs.remove(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropTrigger(String string) {
        this.db.getMutex().enter();
        try {
            this.dropTriggerSafe(string);
            Object var3_2 = null;
            this.db.getMutex().leave();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.db.getMutex().leave();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropTriggerSafe(String string) {
        if (null == string || "".equals(string)) {
            throw new SqlJetException(SqlJetErrorCode.MISUSE, "Trigger name must be not empty");
        }
        if (!this.triggerDefs.containsKey(string)) {
            throw new SqlJetException(SqlJetErrorCode.MISUSE, "Trigger not found: " + string);
        }
        SqlJetTriggerDef sqlJetTriggerDef = (SqlJetTriggerDef)this.triggerDefs.get(string);
        ISqlJetBtreeSchemaTable iSqlJetBtreeSchemaTable = this.openSchemaTable(true);
        try {
            iSqlJetBtreeSchemaTable.lock();
            try {
                this.db.getOptions().changeSchemaVersion();
                if (!iSqlJetBtreeSchemaTable.goToRow(sqlJetTriggerDef.getRowId()) || !TRIGGER_TYPE.equals(iSqlJetBtreeSchemaTable.getTypeField())) {
                    throw new SqlJetException(SqlJetErrorCode.CORRUPT);
                }
                String string2 = iSqlJetBtreeSchemaTable.getNameField();
                if (null == string2 || !string.equals(string2)) {
                    throw new SqlJetException(SqlJetErrorCode.CORRUPT);
                }
                iSqlJetBtreeSchemaTable.delete();
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                iSqlJetBtreeSchemaTable.unlock();
                throw throwable;
            }
            iSqlJetBtreeSchemaTable.unlock();
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            iSqlJetBtreeSchemaTable.close();
            throw throwable;
        }
        iSqlJetBtreeSchemaTable.close();
        this.triggerDefs.remove(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISqlJetTriggerDef createTrigger(String string) {
        this.db.getMutex().enter();
        try {
            ISqlJetTriggerDef iSqlJetTriggerDef = this.createTriggerSafe(string);
            Object var4_3 = null;
            this.db.getMutex().leave();
            return iSqlJetTriggerDef;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.db.getMutex().leave();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ISqlJetTriggerDef createTriggerSafe(String string) {
        SqlJetTriggerDef sqlJetTriggerDef;
        SqlJetTriggerDef sqlJetTriggerDef2;
        RuleReturnScope ruleReturnScope = this.parseTrigger(string);
        CommonTree commonTree = (CommonTree)ruleReturnScope.getTree();
        if ((string = string.trim()).endsWith(";")) {
            string = string.substring(0, string.length() - 1);
        }
        if (null == (sqlJetTriggerDef2 = new SqlJetTriggerDef(string, commonTree)).getName()) {
            throw new SqlJetException(SqlJetErrorCode.ERROR);
        }
        String string2 = sqlJetTriggerDef2.getName();
        if ("".equals(string2)) {
            throw new SqlJetException(SqlJetErrorCode.ERROR);
        }
        String string3 = sqlJetTriggerDef2.getTableName();
        if ("".equals(string3)) {
            throw new SqlJetException(SqlJetErrorCode.ERROR);
        }
        if (this.triggerDefs.containsKey(string2)) {
            if (!sqlJetTriggerDef2.isKeepExisting()) throw new SqlJetException(SqlJetErrorCode.ERROR, "Trigger \"" + string2 + "\" already exists");
            return (ISqlJetTriggerDef)this.triggerDefs.get(string2);
        }
        this.checkNameConflict(SqlJetSchema$SqlJetSchemaObjectType.TRIGGER, string2);
        ISqlJetBtreeSchemaTable iSqlJetBtreeSchemaTable = this.openSchemaTable(true);
        try {
            iSqlJetBtreeSchemaTable.lock();
            try {
                this.db.getOptions().changeSchemaVersion();
                long l2 = iSqlJetBtreeSchemaTable.insertRecord(TRIGGER_TYPE, string2, string3, 0, string);
                sqlJetTriggerDef2.setRowId(l2);
                this.triggerDefs.put(string2, sqlJetTriggerDef2);
                sqlJetTriggerDef = sqlJetTriggerDef2;
                Object var12_10 = null;
            }
            catch (Throwable throwable) {
                Object var12_11 = null;
                iSqlJetBtreeSchemaTable.unlock();
                throw throwable;
            }
            iSqlJetBtreeSchemaTable.unlock();
            Object var14_12 = null;
        }
        catch (Throwable throwable) {
            Object var14_13 = null;
            iSqlJetBtreeSchemaTable.close();
            throw throwable;
        }
        iSqlJetBtreeSchemaTable.close();
        return sqlJetTriggerDef;
    }
}

