/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.schema;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.antlr.runtime.tree.CommonTree;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetBaseIndexDef;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetIndexedColumn;
import org.tmatesoft.sqljet.core.schema.ISqlJetColumnDef;
import org.tmatesoft.sqljet.core.schema.ISqlJetIndexedColumn;
import org.tmatesoft.sqljet.core.schema.ISqlJetTableDef;

public class SqlJetIndexDef
extends SqlJetBaseIndexDef {
    private final String databaseName;
    private final boolean unique;
    private final boolean ifNotExists;
    private final List columns;

    SqlJetIndexDef(String string, String string2, int n2, String string3, boolean bl2, boolean bl3, List list) {
        super(string, string2, n2);
        this.databaseName = string3;
        this.unique = bl2;
        this.ifNotExists = bl3;
        this.columns = Collections.unmodifiableList(list);
    }

    public SqlJetIndexDef(CommonTree commonTree, int n2) {
        super(null, null, n2);
        CommonTree commonTree2 = (CommonTree)commonTree.getChild(0);
        this.unique = this.hasOption(commonTree2, "unique");
        this.ifNotExists = this.hasOption(commonTree2, "exists");
        CommonTree commonTree3 = (CommonTree)commonTree.getChild(1);
        this.setName(commonTree3.getText());
        this.databaseName = commonTree3.getChildCount() > 0 ? commonTree3.getChild(0).getText() : null;
        CommonTree commonTree4 = (CommonTree)commonTree.getChild(2);
        this.setTableName(commonTree4.getText());
        ArrayList<SqlJetIndexedColumn> arrayList = new ArrayList<SqlJetIndexedColumn>();
        CommonTree commonTree5 = (CommonTree)commonTree.getChild(3);
        for (int i2 = 0; i2 < commonTree5.getChildCount(); ++i2) {
            arrayList.add(new SqlJetIndexedColumn((CommonTree)commonTree5.getChild(i2)));
        }
        this.columns = Collections.unmodifiableList(arrayList);
    }

    private boolean hasOption(CommonTree commonTree, String string) {
        for (int i2 = 0; i2 < commonTree.getChildCount(); ++i2) {
            CommonTree commonTree2 = (CommonTree)commonTree.getChild(i2);
            if (!string.equalsIgnoreCase(commonTree2.getText())) continue;
            return true;
        }
        return false;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public boolean isKeepExisting() {
        return this.ifNotExists;
    }

    public List getColumns() {
        return this.columns;
    }

    public ISqlJetIndexedColumn getColumn(String string) {
        for (ISqlJetIndexedColumn iSqlJetIndexedColumn : this.getColumns()) {
            if (!iSqlJetIndexedColumn.getName().equalsIgnoreCase(string)) continue;
            return iSqlJetIndexedColumn;
        }
        return null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getPage());
        stringBuffer.append("/");
        stringBuffer.append(this.getRowId());
        stringBuffer.append(": ");
        stringBuffer.append(this.toSQL());
        return stringBuffer.toString();
    }

    public String toSQL() {
        return this.toSQL(true);
    }

    public String toSQL(boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CREATE ");
        if (this.isUnique()) {
            stringBuffer.append("UNIQUE ");
        }
        stringBuffer.append("INDEX ");
        if (!bl2) {
            if (this.isKeepExisting()) {
                stringBuffer.append("IF NOT EXISTS ");
            }
            if (this.getDatabaseName() != null) {
                stringBuffer.append(this.getDatabaseName());
                stringBuffer.append('.');
            }
        }
        stringBuffer.append(this.getName());
        stringBuffer.append(" ON ");
        stringBuffer.append(this.getTableName());
        stringBuffer.append(" (");
        List list = this.getColumns();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            if (i2 > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(((ISqlJetIndexedColumn)list.get(i2)).toString());
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public boolean isImplicit() {
        return false;
    }

    public void bindColumns(ISqlJetTableDef iSqlJetTableDef) {
        for (ISqlJetColumnDef iSqlJetColumnDef : iSqlJetTableDef.getColumns()) {
            for (ISqlJetIndexedColumn iSqlJetIndexedColumn : this.columns) {
                if (!iSqlJetIndexedColumn.getName().equalsIgnoreCase(iSqlJetColumnDef.getName())) continue;
                ((SqlJetIndexedColumn)iSqlJetIndexedColumn).setTableColumn(iSqlJetColumnDef);
            }
        }
    }
}

