/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.schema;

import org.antlr.runtime.tree.CommonTree;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetExpression;
import org.tmatesoft.sqljet.core.schema.ISqlJetExpression;
import org.tmatesoft.sqljet.core.schema.ISqlJetInTableExpression;

public class SqlJetInTableExpression
extends SqlJetExpression
implements ISqlJetInTableExpression {
    private final ISqlJetExpression expression;
    private final boolean not;
    private final String tableName;
    private final String databaseName;

    public SqlJetInTableExpression(CommonTree commonTree) {
        CommonTree commonTree2;
        assert ("in_table".equalsIgnoreCase(commonTree.getText()));
        int n2 = 0;
        if ("not".equalsIgnoreCase((commonTree2 = (CommonTree)commonTree.getChild(n2++)).getText())) {
            this.not = true;
            commonTree2 = (CommonTree)commonTree.getChild(n2++);
        } else {
            this.not = false;
        }
        assert ("in".equalsIgnoreCase(commonTree2.getText()));
        CommonTree commonTree3 = (CommonTree)commonTree2.getChild(0);
        this.tableName = commonTree3.getText();
        this.databaseName = commonTree3.getChildCount() > 0 ? commonTree3.getChild(0).getText() : null;
        this.expression = SqlJetInTableExpression.create((CommonTree)commonTree.getChild(n2));
    }

    public ISqlJetExpression getExpression() {
        return this.expression;
    }

    public boolean isNot() {
        return this.not;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getExpression());
        if (this.isNot()) {
            stringBuffer.append(" NOT");
        }
        stringBuffer.append(" IN ");
        if (this.getDatabaseName() != null) {
            stringBuffer.append(this.getDatabaseName());
            stringBuffer.append('.');
        }
        stringBuffer.append(this.getTableName());
        return stringBuffer.toString();
    }
}

