/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.schema;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.antlr.runtime.tree.CommonTree;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetExpression;
import org.tmatesoft.sqljet.core.schema.ISqlJetExpression;
import org.tmatesoft.sqljet.core.schema.ISqlJetFunctionExpression;

public class SqlJetFunctionExpression
extends SqlJetExpression
implements ISqlJetFunctionExpression {
    private final String name;
    private final boolean distinct;
    private final boolean all;
    private final List arguments;

    public SqlJetFunctionExpression(CommonTree commonTree) {
        assert ("function_expression".equalsIgnoreCase(commonTree.getText()));
        this.name = commonTree.getChild(0).getText();
        if ("*".equals(commonTree.getChild(1).getText())) {
            this.all = true;
            this.distinct = false;
            this.arguments = Collections.emptyList();
        } else {
            this.all = false;
            ArrayList<ISqlJetExpression> arrayList = new ArrayList<ISqlJetExpression>();
            int n2 = 1;
            CommonTree commonTree2 = (CommonTree)commonTree.getChild(n2);
            if (commonTree2 != null && "distinct".equalsIgnoreCase(commonTree2.getText())) {
                this.distinct = true;
                ++n2;
            } else {
                this.distinct = false;
            }
            while (n2 < commonTree.getChildCount()) {
                commonTree2 = (CommonTree)commonTree.getChild(n2);
                if (!"distinct".equalsIgnoreCase(commonTree2.getText())) {
                    ISqlJetExpression iSqlJetExpression = SqlJetFunctionExpression.create(commonTree2);
                    arrayList.add(iSqlJetExpression);
                }
                ++n2;
            }
            this.arguments = Collections.unmodifiableList(arrayList);
        }
    }

    public String getName() {
        return this.name;
    }

    public boolean areDistinctArguments() {
        return this.distinct;
    }

    public List getArguments() {
        return this.arguments;
    }

    public boolean isAll() {
        return this.all;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getName());
        stringBuffer.append(" (");
        if (this.isAll()) {
            stringBuffer.append('*');
        } else {
            if (this.areDistinctArguments()) {
                stringBuffer.append("DISTINCT ");
            }
            for (int i2 = 0; i2 < this.getArguments().size(); ++i2) {
                if (i2 > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(this.getArguments().get(i2));
            }
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }
}

