/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.schema;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.antlr.runtime.tree.CommonTree;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetForeignKeyDeferrable;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetForeignKeyMatchAction;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetForeignKeyUpdateAction;
import org.tmatesoft.sqljet.core.schema.ISqlJetForeignKey;
import org.tmatesoft.sqljet.core.schema.ISqlJetForeignKeyAction;
import org.tmatesoft.sqljet.core.schema.ISqlJetForeignKeyDeferrable;

public class SqlJetForeignKey
implements ISqlJetForeignKey {
    private final String foreignTableName;
    private final List columnNames;
    private final List actions;
    private final ISqlJetForeignKeyDeferrable deferrable;

    public SqlJetForeignKey(CommonTree commonTree) {
        assert ("references".equalsIgnoreCase(commonTree.getText()));
        this.foreignTableName = commonTree.getChild(0).getText();
        CommonTree commonTree2 = (CommonTree)commonTree.getChild(1);
        assert ("columns".equalsIgnoreCase(commonTree2.getText()));
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i2 = 0; i2 < commonTree2.getChildCount(); ++i2) {
            arrayList.add(commonTree2.getChild(i2).getText());
        }
        this.columnNames = Collections.unmodifiableList(arrayList);
        ArrayList<ISqlJetForeignKeyAction> arrayList2 = new ArrayList<ISqlJetForeignKeyAction>();
        SqlJetForeignKeyDeferrable sqlJetForeignKeyDeferrable = null;
        for (int i3 = 2; i3 < commonTree.getChildCount(); ++i3) {
            CommonTree commonTree3 = (CommonTree)commonTree.getChild(i3);
            if ("deferrable".equalsIgnoreCase(commonTree3.getText())) {
                assert (sqlJetForeignKeyDeferrable == null);
                sqlJetForeignKeyDeferrable = new SqlJetForeignKeyDeferrable(commonTree3);
                continue;
            }
            if ("on".equalsIgnoreCase(commonTree3.getText())) {
                arrayList2.add(new SqlJetForeignKeyUpdateAction(commonTree3));
                continue;
            }
            if ("match".equalsIgnoreCase(commonTree3.getText())) {
                arrayList2.add(new SqlJetForeignKeyMatchAction(commonTree3));
                continue;
            }
            assert (false);
        }
        this.actions = Collections.unmodifiableList(arrayList2);
        this.deferrable = sqlJetForeignKeyDeferrable;
    }

    public String getForeignTableName() {
        return this.foreignTableName;
    }

    public List getColumnNames() {
        return this.columnNames;
    }

    public List getActions() {
        return this.actions;
    }

    public ISqlJetForeignKeyDeferrable getDeferrable() {
        return this.deferrable;
    }

    public String toString() {
        int n2;
        StringBuffer stringBuffer = new StringBuffer("REFERENCES ");
        stringBuffer.append(this.getForeignTableName());
        stringBuffer.append(" (");
        for (n2 = 0; n2 < this.getColumnNames().size(); ++n2) {
            if (n2 > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append((String)this.getColumnNames().get(n2));
        }
        stringBuffer.append(")");
        for (n2 = 0; n2 < this.getActions().size(); ++n2) {
            stringBuffer.append(' ');
            stringBuffer.append(this.getActions().get(n2));
        }
        if (this.getDeferrable() != null) {
            stringBuffer.append(' ');
            stringBuffer.append(this.getDeferrable());
        }
        return stringBuffer.toString();
    }
}

