/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.schema;

import org.antlr.runtime.tree.CommonTree;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetColumnDef;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetColumnIndexConstraint;
import org.tmatesoft.sqljet.core.schema.ISqlJetColumnPrimaryKey;
import org.tmatesoft.sqljet.core.schema.SqlJetConflictAction;

public class SqlJetColumnPrimaryKey
extends SqlJetColumnIndexConstraint
implements ISqlJetColumnPrimaryKey {
    private Boolean ascending;
    private boolean autoincremented;
    private SqlJetConflictAction conflictAction;

    public SqlJetColumnPrimaryKey(SqlJetColumnDef sqlJetColumnDef, String string, CommonTree commonTree) {
        super(sqlJetColumnDef, string);
        assert ("primary".equalsIgnoreCase(commonTree.getText()));
        for (int i2 = 0; i2 < commonTree.getChildCount(); ++i2) {
            CommonTree commonTree2 = (CommonTree)commonTree.getChild(i2);
            if ("asc".equalsIgnoreCase(commonTree2.getText())) {
                this.ascending = Boolean.TRUE;
                continue;
            }
            if ("desc".equalsIgnoreCase(commonTree2.getText())) {
                this.ascending = Boolean.FALSE;
                continue;
            }
            if ("autoincrement".equalsIgnoreCase(commonTree2.getText())) {
                this.autoincremented = true;
                continue;
            }
            if ("conflict".equalsIgnoreCase(commonTree2.getText())) {
                assert (commonTree2.getChildCount() == 1);
                commonTree2 = (CommonTree)commonTree2.getChild(0);
                this.conflictAction = SqlJetConflictAction.decode(commonTree2.getText());
                continue;
            }
            assert (false);
        }
    }

    public Boolean isAscending() {
        return this.ascending;
    }

    public boolean isAutoincremented() {
        return this.autoincremented;
    }

    public SqlJetConflictAction getConflictAction() {
        return this.conflictAction;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        if (stringBuffer.length() > 0) {
            stringBuffer.append(' ');
        }
        stringBuffer.append("PRIMARY KEY");
        if (this.ascending == Boolean.TRUE) {
            stringBuffer.append(" ASC");
        }
        if (this.ascending == Boolean.FALSE) {
            stringBuffer.append(" DESC");
        }
        if (this.conflictAction != null) {
            stringBuffer.append(" ON CONFLICT ");
            stringBuffer.append((Object)this.conflictAction);
        }
        if (this.autoincremented) {
            stringBuffer.append(" AUTOINCREMENT");
        }
        return stringBuffer.toString();
    }
}

