/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.schema;

import org.antlr.runtime.tree.CommonTree;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetExpression;
import org.tmatesoft.sqljet.core.schema.ISqlJetColumnExpression;

public class SqlJetColumnExpression
extends SqlJetExpression
implements ISqlJetColumnExpression {
    private final String columnName;
    private final String tableName;
    private final String databaseName;

    public SqlJetColumnExpression(CommonTree commonTree) {
        assert ("column_expression".equalsIgnoreCase(commonTree.getText()));
        CommonTree commonTree2 = (CommonTree)commonTree.getChild(0);
        this.columnName = commonTree2.getText();
        if (commonTree2.getChildCount() > 0) {
            CommonTree commonTree3 = (CommonTree)commonTree2.getChild(0);
            this.tableName = commonTree3.getText();
            this.databaseName = commonTree3.getChildCount() > 0 ? commonTree3.getChild(0).getText() : null;
        } else {
            this.tableName = null;
            this.databaseName = null;
        }
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getDatabaseName() != null) {
            stringBuffer.append(this.getDatabaseName());
            stringBuffer.append('.');
        }
        if (this.getTableName() != null) {
            stringBuffer.append(this.getTableName());
            stringBuffer.append('.');
        }
        stringBuffer.append(this.getColumnName());
        return stringBuffer.toString();
    }
}

