/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.schema;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.antlr.runtime.tree.CommonTree;
import org.tmatesoft.sqljet.core.internal.lang.SqlParser;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetColumnCheck;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetColumnCollate;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetColumnDefault;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetColumnForeignKey;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetColumnNotNull;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetColumnNull;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetColumnPrimaryKey;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetColumnUnique;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetTypeDef;
import org.tmatesoft.sqljet.core.schema.ISqlJetColumnConstraint;
import org.tmatesoft.sqljet.core.schema.ISqlJetColumnDef;
import org.tmatesoft.sqljet.core.schema.ISqlJetTypeDef;
import org.tmatesoft.sqljet.core.schema.SqlJetTypeAffinity;

public class SqlJetColumnDef
implements ISqlJetColumnDef {
    private final String name;
    private final String quotedName;
    private final ISqlJetTypeDef type;
    private final List constraints;
    private int index;

    public SqlJetColumnDef(CommonTree commonTree) {
        this.name = commonTree.getText();
        this.quotedName = SqlParser.quotedId(commonTree);
        CommonTree commonTree2 = (CommonTree)commonTree.getChild(0);
        assert ("constraints".equalsIgnoreCase(commonTree2.getText()));
        ArrayList<ISqlJetColumnConstraint> arrayList = new ArrayList<ISqlJetColumnConstraint>();
        for (int i2 = 0; i2 < commonTree2.getChildCount(); ++i2) {
            String string;
            CommonTree commonTree3 = (CommonTree)commonTree2.getChild(i2);
            assert ("column_constraint".equalsIgnoreCase(commonTree3.getText()));
            CommonTree commonTree4 = (CommonTree)commonTree3.getChild(0);
            String string2 = commonTree4.getText();
            String string3 = string = commonTree3.getChildCount() > 1 ? commonTree3.getChild(1).getText() : null;
            if ("primary".equalsIgnoreCase(string2)) {
                arrayList.add(new SqlJetColumnPrimaryKey(this, string, commonTree4));
                continue;
            }
            if ("not_null".equalsIgnoreCase(string2)) {
                arrayList.add(new SqlJetColumnNotNull(this, string, commonTree4));
                continue;
            }
            if ("unique".equalsIgnoreCase(string2)) {
                arrayList.add(new SqlJetColumnUnique(this, string, commonTree4));
                continue;
            }
            if ("check".equalsIgnoreCase(string2)) {
                arrayList.add(new SqlJetColumnCheck(this, string, commonTree4));
                continue;
            }
            if ("default".equalsIgnoreCase(string2)) {
                arrayList.add(new SqlJetColumnDefault(this, string, commonTree4));
                continue;
            }
            if ("collate".equalsIgnoreCase(string2)) {
                arrayList.add(new SqlJetColumnCollate(this, string, commonTree4));
                continue;
            }
            if ("references".equalsIgnoreCase(string2)) {
                arrayList.add(new SqlJetColumnForeignKey(string, commonTree4));
                continue;
            }
            if ("is_null".equalsIgnoreCase(string2)) {
                arrayList.add(new SqlJetColumnNull(this, string, commonTree4));
                continue;
            }
            assert (false);
        }
        this.constraints = Collections.unmodifiableList(arrayList);
        if (commonTree.getChildCount() > 1) {
            CommonTree commonTree5 = (CommonTree)commonTree.getChild(1);
            assert ("type".equalsIgnoreCase(commonTree5.getText()));
            this.type = new SqlJetTypeDef(commonTree5);
        } else {
            this.type = null;
        }
    }

    public String getName() {
        return this.name;
    }

    public String getQuotedName() {
        return this.quotedName;
    }

    public ISqlJetTypeDef getType() {
        return this.type;
    }

    public SqlJetTypeAffinity getTypeAffinity() {
        ISqlJetTypeDef iSqlJetTypeDef = this.getType();
        if (iSqlJetTypeDef == null) {
            return SqlJetTypeAffinity.decode(null);
        }
        List list = iSqlJetTypeDef.getNames();
        if (list.size() == 1) {
            return SqlJetTypeAffinity.decode((String)list.get(0));
        }
        String string = "";
        for (String string2 : this.getType().getNames()) {
            string = string + string2 + ' ';
        }
        return SqlJetTypeAffinity.decode(string);
    }

    public boolean hasExactlyIntegerType() {
        if (this.getTypeAffinity() != SqlJetTypeAffinity.INTEGER) {
            return false;
        }
        ISqlJetTypeDef iSqlJetTypeDef = this.getType();
        if (iSqlJetTypeDef == null || iSqlJetTypeDef.getNames() == null || iSqlJetTypeDef.getNames().size() == 0) {
            return false;
        }
        return "INTEGER".equals(((String)iSqlJetTypeDef.getNames().get(0)).toUpperCase());
    }

    public List getConstraints() {
        return this.constraints;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getQuotedName());
        if (this.getType() != null) {
            stringBuffer.append(' ');
            stringBuffer.append(this.getType());
        }
        for (int i2 = 0; i2 < this.getConstraints().size(); ++i2) {
            stringBuffer.append(' ');
            stringBuffer.append(this.getConstraints().get(i2));
        }
        return stringBuffer.toString();
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int n2) {
        this.index = n2;
    }
}

