/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.schema;

import java.util.Locale;
import org.antlr.runtime.tree.CommonTree;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetExpression;
import org.tmatesoft.sqljet.core.schema.ISqlJetBlobLiteral;

public class SqlJetBlobLiteral
extends SqlJetExpression
implements ISqlJetBlobLiteral {
    private final byte[] value;

    public SqlJetBlobLiteral(CommonTree commonTree) {
        assert ("blob_literal".equalsIgnoreCase(commonTree.getText()));
        this.value = SqlJetBlobLiteral.parseBlob(commonTree.getChild(0).getText());
    }

    public byte[] getValue() {
        return this.value;
    }

    public String toString() {
        return SqlJetBlobLiteral.asBlob(this.value);
    }

    public static byte[] parseBlob(String string) {
        string = string.substring(2, string.length() - 1).toLowerCase(Locale.ENGLISH);
        byte[] byArray = new byte[string.length() / 2];
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            char c2 = string.charAt(i2 * 2);
            char c3 = string.charAt(i2 * 2 + 1);
            int n2 = c2 - (c2 >= 'a' ? 97 : 48);
            int n3 = c3 - (c3 >= 'a' ? 97 : 48);
            byArray[i2] = (byte)(n2 * 16 + n3);
        }
        return byArray;
    }

    public static String asBlob(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer("x'");
        for (byte by : byArray) {
            stringBuffer.append((char)(by / 16 > 9 ? 97 + by / 16 - 10 : 48 + by / 16));
            stringBuffer.append((char)(by % 16 > 9 ? 97 + by % 16 - 10 : 48 + by % 16));
        }
        stringBuffer.append("'");
        return stringBuffer.toString();
    }
}

