/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.schema;

import org.antlr.runtime.ParserRuleReturnScope;
import org.antlr.runtime.tree.CommonTree;
import org.tmatesoft.sqljet.core.SqlJetErrorCode;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.internal.lang.SqlParser;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetColumnDef;
import org.tmatesoft.sqljet.core.schema.ISqlJetColumnDef;

public class SqlJetAlterTableDef {
    private static final String INVALID_ALTER_TABLE_STATEMENT = "Invalid ALTER TABLE statement";
    private final String tableName;
    private final String newTableName;
    private final String tableQuotedName;
    private final String newTableQuotedName;
    private final ISqlJetColumnDef newColumnDef;
    private ParserRuleReturnScope parsedSql;

    public SqlJetAlterTableDef(ParserRuleReturnScope parserRuleReturnScope) {
        this.parsedSql = parserRuleReturnScope;
        CommonTree commonTree = (CommonTree)parserRuleReturnScope.getTree();
        int n2 = commonTree.getChildCount();
        if (n2 < 5) {
            throw new SqlJetException(SqlJetErrorCode.MISUSE, INVALID_ALTER_TABLE_STATEMENT);
        }
        CommonTree commonTree2 = (CommonTree)commonTree.getChild(0);
        CommonTree commonTree3 = (CommonTree)commonTree.getChild(1);
        if (!"alter".equalsIgnoreCase(commonTree2.getText()) || !"table".equalsIgnoreCase(commonTree3.getText())) {
            throw new SqlJetException(SqlJetErrorCode.MISUSE, INVALID_ALTER_TABLE_STATEMENT);
        }
        CommonTree commonTree4 = (CommonTree)commonTree.getChild(2);
        this.tableName = commonTree4.getText();
        this.tableQuotedName = SqlParser.quotedId(commonTree4);
        CommonTree commonTree5 = (CommonTree)commonTree.getChild(3);
        String string = commonTree5.getText();
        CommonTree commonTree6 = (CommonTree)commonTree.getChild(4);
        if ("add".equalsIgnoreCase(string)) {
            CommonTree commonTree7;
            this.newTableName = null;
            this.newTableQuotedName = null;
            if ("column".equalsIgnoreCase(commonTree6.getText())) {
                if (n2 != 6) {
                    throw new SqlJetException(SqlJetErrorCode.MISUSE, INVALID_ALTER_TABLE_STATEMENT);
                }
                commonTree7 = (CommonTree)commonTree.getChild(5);
            } else {
                if (n2 != 5) {
                    throw new SqlJetException(SqlJetErrorCode.MISUSE, INVALID_ALTER_TABLE_STATEMENT);
                }
                commonTree7 = commonTree6;
            }
            this.newColumnDef = new SqlJetColumnDef(commonTree7);
        } else if ("rename".equalsIgnoreCase(string)) {
            this.newColumnDef = null;
            assert ("to".equalsIgnoreCase(commonTree6.getText()));
            if (n2 < 6) {
                throw new SqlJetException(SqlJetErrorCode.MISUSE, INVALID_ALTER_TABLE_STATEMENT);
            }
            CommonTree commonTree8 = (CommonTree)commonTree.getChild(5);
            this.newTableName = commonTree8.getText();
            this.newTableQuotedName = SqlParser.quotedId(commonTree8);
        } else {
            this.newTableName = null;
            this.newTableQuotedName = null;
            this.newColumnDef = null;
            throw new SqlJetException(SqlJetErrorCode.MISUSE, INVALID_ALTER_TABLE_STATEMENT);
        }
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getNewTableName() {
        return this.newTableName;
    }

    public String getTableQuotedName() {
        return this.tableQuotedName;
    }

    public String getNewTableQuotedName() {
        return this.newTableQuotedName;
    }

    public ISqlJetColumnDef getNewColumnDef() {
        return this.newColumnDef;
    }

    public ParserRuleReturnScope getParsedSql() {
        return this.parsedSql;
    }
}

