/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.pager;

import java.io.File;
import java.util.AbstractSet;
import java.util.BitSet;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import org.tmatesoft.sqljet.core.SqlJetErrorCode;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.SqlJetIOErrorCode;
import org.tmatesoft.sqljet.core.SqlJetIOException;
import org.tmatesoft.sqljet.core.internal.ISqlJetFile;
import org.tmatesoft.sqljet.core.internal.ISqlJetFileSystem;
import org.tmatesoft.sqljet.core.internal.ISqlJetLimits;
import org.tmatesoft.sqljet.core.internal.ISqlJetMemoryPointer;
import org.tmatesoft.sqljet.core.internal.ISqlJetPage;
import org.tmatesoft.sqljet.core.internal.ISqlJetPageCallback;
import org.tmatesoft.sqljet.core.internal.ISqlJetPager;
import org.tmatesoft.sqljet.core.internal.SqlJetCloneable;
import org.tmatesoft.sqljet.core.internal.SqlJetDeviceCharacteristics;
import org.tmatesoft.sqljet.core.internal.SqlJetFileAccesPermission;
import org.tmatesoft.sqljet.core.internal.SqlJetFileOpenPermission;
import org.tmatesoft.sqljet.core.internal.SqlJetFileType;
import org.tmatesoft.sqljet.core.internal.SqlJetLockType;
import org.tmatesoft.sqljet.core.internal.SqlJetPageFlags;
import org.tmatesoft.sqljet.core.internal.SqlJetPagerFlags;
import org.tmatesoft.sqljet.core.internal.SqlJetPagerJournalMode;
import org.tmatesoft.sqljet.core.internal.SqlJetPagerLockingMode;
import org.tmatesoft.sqljet.core.internal.SqlJetSafetyLevel;
import org.tmatesoft.sqljet.core.internal.SqlJetSavepointOperation;
import org.tmatesoft.sqljet.core.internal.SqlJetSyncFlags;
import org.tmatesoft.sqljet.core.internal.SqlJetUtility;
import org.tmatesoft.sqljet.core.internal.pager.SqlJetPage;
import org.tmatesoft.sqljet.core.internal.pager.SqlJetPageCache;
import org.tmatesoft.sqljet.core.internal.pager.SqlJetPager$PagerSavepoint;
import org.tmatesoft.sqljet.core.internal.pager.SqlJetPagerState;
import org.tmatesoft.sqljet.core.table.ISqlJetBusyHandler;

public class SqlJetPager
implements ISqlJetLimits,
ISqlJetPageCallback,
ISqlJetPager {
    private static Logger pagerLogger = Logger.getLogger("SQLJET_LOG_PAGER");
    private static final boolean SQLJET_LOG_PAGER = SqlJetUtility.getBoolSysProp("SQLJET_LOG_PAGER", false);
    private static final int MAX_SECTOR_SIZE = 0x100000;
    ISqlJetFileSystem fileSystem;
    SqlJetFileType type;
    Set permissions;
    SqlJetPagerState state = SqlJetPagerState.UNLOCK;
    SqlJetPagerJournalMode journalMode = SqlJetPagerJournalMode.DELETE;
    SqlJetPagerLockingMode lockingMode = SqlJetPagerLockingMode.NORMAL;
    boolean journalOpen;
    boolean journalStarted;
    boolean useJournal;
    boolean noReadlock;
    boolean noSync;
    boolean fullSync;
    Set syncFlags;
    boolean tempFile;
    boolean readOnly;
    boolean needSync;
    boolean dirtyCache;
    boolean memDb;
    boolean setMaster;
    boolean doNotSync;
    boolean dbModified;
    boolean changeCountDone;
    boolean dbSizeValid;
    int dbSize;
    int dbOrigSize;
    int dbFileSize;
    int nRec;
    long cksumInit;
    int stmtNRec;
    int pageSize;
    int nPage;
    int mxPage;
    int mxPgno;
    BitSet pagesInJournal;
    BitSet pagesAlwaysRollback;
    File fileName;
    File journal;
    File directory;
    ISqlJetFile fd;
    ISqlJetFile jfd;
    ISqlJetFile sjfd;
    long journalOff;
    long journalHdr;
    int sectorSize;
    ISqlJetMemoryPointer tmpSpace;
    ISqlJetMemoryPointer dbFileVers = SqlJetUtility.allocatePtr(16);
    long journalSizeLimit;
    SqlJetPageCache pageCache;
    SqlJetSafetyLevel safetyLevel;
    ISqlJetPageCallback reiniter;
    ISqlJetBusyHandler busyHandler;
    SqlJetErrorCode errCode;
    SqlJetPager$PagerSavepoint[] aSavepoint;
    int nSavepoint;

    static void PAGERTRACE(String string, Object ... objectArray) {
        if (SQLJET_LOG_PAGER) {
            SqlJetUtility.log(pagerLogger, string, objectArray);
        }
    }

    String PAGERID() {
        return this.fileName != null ? this.fileName.getPath() : null;
    }

    String FILEHANDLEID() {
        return this.PAGERID();
    }

    private int JOURNAL_PG_SZ() {
        return this.pageSize + 8;
    }

    private int JOURNAL_HDR_SZ() {
        return this.sectorSize;
    }

    long PAGER_MJ_PGNO() {
        return 0x40000000L / (long)this.pageSize + 1L;
    }

    int int_PAGER_MJ_PGNO() {
        return Long.valueOf(this.PAGER_MJ_PGNO()).intValue();
    }

    static boolean subjRequiresPage(SqlJetPage sqlJetPage) {
        int n2 = sqlJetPage.pgno;
        SqlJetPager sqlJetPager = sqlJetPage.pPager;
        for (int i2 = 0; i2 < sqlJetPager.nSavepoint; ++i2) {
            SqlJetPager$PagerSavepoint sqlJetPager$PagerSavepoint = sqlJetPager.aSavepoint[i2];
            if (sqlJetPager$PagerSavepoint.nOrig < n2 || SqlJetUtility.bitSetTest(sqlJetPager$PagerSavepoint.pInSavepoint, n2)) continue;
            return true;
        }
        return false;
    }

    static boolean pageInJournal(SqlJetPage sqlJetPage) {
        return SqlJetUtility.bitSetTest(sqlJetPage.pPager.pagesInJournal, sqlJetPage.pgno);
    }

    public void open(ISqlJetFileSystem iSqlJetFileSystem, File file, Set set, SqlJetFileType sqlJetFileType, Set set2) {
        this.fileSystem = iSqlJetFileSystem;
        this.type = sqlJetFileType;
        this.permissions = EnumSet.copyOf(set2);
        this.tempFile = false;
        this.memDb = false;
        this.readOnly = false;
        int n2 = 1024;
        this.useJournal = null == set || !set.contains((Object)SqlJetPagerFlags.OMIT_JOURNAL);
        this.fileName = null;
        if (null != file) {
            if (":memory:".equals(file.getPath())) {
                this.memDb = true;
            } else {
                this.fileName = file;
            }
        }
        if (null != this.fileName && !this.memDb) {
            this.directory = this.fileName.getParentFile();
            this.journal = new File(this.directory, this.fileName.getName() + "-journal");
            this.fd = this.fileSystem.open(this.fileName, this.type, this.permissions);
            this.readOnly = this.fd.getPermissions().contains((Object)SqlJetFileOpenPermission.READONLY);
            if (!this.readOnly) {
                Set set3;
                this.setSectorSize();
                if (n2 < this.sectorSize) {
                    n2 = this.sectorSize;
                }
                if (null != (set3 = this.fd.deviceCharacteristics())) {
                    for (SqlJetDeviceCharacteristics sqlJetDeviceCharacteristics : set3) {
                        if (sqlJetDeviceCharacteristics.getIoCapAtomicSize() <= 0) continue;
                        n2 = sqlJetDeviceCharacteristics.getIoCapAtomicSize();
                    }
                }
                if (n2 > 8192) {
                    n2 = 8192;
                }
            }
        } else {
            this.tempFile = true;
            this.state = SqlJetPagerState.EXCLUSIVE;
        }
        this.tmpSpace = SqlJetUtility.allocatePtr(n2);
        this.pageCache = new SqlJetPageCache();
        this.pageCache.open(n2, !this.memDb, !this.memDb ? this : null);
        SqlJetPager.PAGERTRACE("OPEN %s %s\n", this.FILEHANDLEID(), file);
        this.noReadlock = null != set && set.contains((Object)SqlJetPagerFlags.NO_READLOCK) && this.readOnly;
        this.dbSizeValid = this.memDb;
        this.pageSize = n2;
        this.mxPage = 100;
        this.mxPgno = 0x3FFFFFFF;
        assert (this.state == (this.tempFile ? SqlJetPagerState.EXCLUSIVE : SqlJetPagerState.UNLOCK));
        this.lockingMode = this.tempFile ? SqlJetPagerLockingMode.EXCLUSIVE : SqlJetPagerLockingMode.NORMAL;
        this.noSync = this.tempFile || !this.useJournal;
        this.fullSync = !this.noSync;
        this.syncFlags = SqlJetUtility.of(SqlJetSyncFlags.NORMAL);
        this.journalSizeLimit = SQLJET_DEFAULT_JOURNAL_SIZE_LIMIT;
        this.setSectorSize();
        if (this.memDb) {
            this.journalMode = SqlJetPagerJournalMode.MEMORY;
        }
        this.setSafetyLevel(SqlJetSafetyLevel.NORMAL);
    }

    private void setSectorSize() {
        assert (null != this.fd || this.tempFile);
        if (!this.tempFile && null != this.fd) {
            this.sectorSize = this.fd.sectorSize();
        }
        if (this.sectorSize < SQLJET_MIN_SECTOR_SIZE) {
            this.sectorSize = SQLJET_MIN_SECTOR_SIZE;
        }
        if (this.sectorSize > 0x100000) {
            this.sectorSize = 0x100000;
        }
    }

    public File getDirectoryName() {
        return this.directory;
    }

    public File getFileName() {
        return this.fileName;
    }

    public ISqlJetFileSystem getFileSystem() {
        return this.fileSystem;
    }

    public ISqlJetFile getFile() {
        return this.fd;
    }

    public File getJournalName() {
        return this.journal;
    }

    public boolean isNoSync() {
        return this.noSync;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public SqlJetPagerLockingMode getLockingMode() {
        return this.lockingMode;
    }

    public void setLockingMode(SqlJetPagerLockingMode sqlJetPagerLockingMode) {
        this.lockingMode = sqlJetPagerLockingMode;
    }

    public SqlJetPagerJournalMode getJournalMode() {
        return this.journalMode;
    }

    public void setJournalMode(SqlJetPagerJournalMode sqlJetPagerJournalMode) {
        this.journalMode = sqlJetPagerJournalMode;
    }

    public long getJournalSizeLimit() {
        return this.journalSizeLimit;
    }

    public void setJournalSizeLimit(long l2) {
        if (l2 >= -1L) {
            this.journalSizeLimit = l2;
        }
    }

    public SqlJetSafetyLevel getSafetyLevel() {
        return this.safetyLevel;
    }

    public void setSafetyLevel(SqlJetSafetyLevel sqlJetSafetyLevel) {
        this.safetyLevel = sqlJetSafetyLevel;
        this.noSync = sqlJetSafetyLevel == SqlJetSafetyLevel.OFF || this.tempFile;
        boolean bl2 = this.fullSync = sqlJetSafetyLevel == SqlJetSafetyLevel.FULL && !this.tempFile;
        if (this.noSync) {
            this.needSync = false;
        }
    }

    public ISqlJetMemoryPointer getTempSpace() {
        return this.tmpSpace;
    }

    public void setBusyhandler(ISqlJetBusyHandler iSqlJetBusyHandler) {
        this.busyHandler = iSqlJetBusyHandler;
    }

    public void setReiniter(ISqlJetPageCallback iSqlJetPageCallback) {
        this.reiniter = iSqlJetPageCallback;
    }

    public int setPageSize(int n2) {
        this.checkErrorCode();
        assert (n2 >= 512 && n2 <= 32768);
        if (!(n2 == this.pageSize || this.memDb && this.dbSize != 0 || this.pageCache.getRefCount() != 0)) {
            this.reset();
            this.pageSize = n2;
            if (!this.memDb) {
                this.setSectorSize();
            }
            this.tmpSpace = SqlJetUtility.allocatePtr(n2);
            this.pageCache.setPageSize(n2);
        }
        return this.pageSize;
    }

    private void checkErrorCode() {
        if (null != this.errCode) {
            throw new SqlJetException(this.errCode);
        }
    }

    public int getPageSize() {
        return this.pageSize;
    }

    ISqlJetPage lookup(int n2) {
        return this.pageCache.fetch(n2, false);
    }

    private void reset() {
        if (null != this.errCode) {
            return;
        }
        if (this.pageCache != null) {
            this.pageCache.clear();
        }
    }

    public void setMaxPageCount(int n2) {
        if (n2 > 0) {
            this.mxPgno = n2;
        }
        this.getPageCount();
    }

    public int getMaxPageCount() {
        return this.mxPgno;
    }

    public void setCacheSize(int n2) {
        this.pageCache.setCacheSize(n2);
    }

    public int getCacheSize() {
        return this.pageCache.getCachesize();
    }

    public void readFileHeader(int n2, ISqlJetMemoryPointer iSqlJetMemoryPointer) {
        block4: {
            assert (null != this.fd || this.tempFile);
            if (null != this.fd) {
                try {
                    this.fd.read(iSqlJetMemoryPointer, n2, 0L);
                }
                catch (SqlJetIOException sqlJetIOException) {
                    if (SqlJetIOErrorCode.IOERR_SHORT_READ == sqlJetIOException.getIoErrorCode()) break block4;
                    throw sqlJetIOException;
                }
            }
        }
    }

    public int getPageCount() {
        this.checkErrorCode();
        int n2 = 0;
        if (this.dbSizeValid) {
            n2 = this.dbSize;
        } else {
            assert (null != this.fd || this.tempFile);
            long l2 = 0L;
            if (null != this.fd) {
                try {
                    l2 = this.fd.fileSize();
                }
                catch (SqlJetException sqlJetException) {
                    this.error(sqlJetException);
                    throw sqlJetException;
                }
            }
            n2 = l2 > 0L && l2 < (long)this.pageSize ? 1 : (int)(l2 /= (long)this.pageSize);
            if (SqlJetPagerState.UNLOCK != this.state) {
                this.dbSize = n2;
                this.dbFileSize = n2;
                this.dbSizeValid = true;
            }
        }
        if ((long)n2 == 0x40000000L / (long)this.pageSize) {
            ++n2;
        }
        if (n2 > this.mxPgno) {
            this.mxPgno = n2;
        }
        return n2;
    }

    private void error(SqlJetException sqlJetException) {
        SqlJetErrorCode sqlJetErrorCode = sqlJetException.getErrorCode();
        if (SqlJetErrorCode.FULL == sqlJetErrorCode || SqlJetErrorCode.IOERR == sqlJetErrorCode || SqlJetErrorCode.CORRUPT == sqlJetErrorCode) {
            this.errCode = sqlJetErrorCode;
            if (SqlJetPagerState.UNLOCK == this.state && this.pageCache.getRefCount() == 0) {
                this.unlock();
            }
        }
    }

    private void releaseAllSavepoint() {
        for (int i2 = 0; i2 < this.nSavepoint; ++i2) {
            this.aSavepoint[i2].pInSavepoint = null;
        }
        if (!this.exclusiveMode() && this.sjfd != null) {
            try {
                this.sjfd.close();
            }
            catch (SqlJetException sqlJetException) {
                // empty catch block
            }
        }
        this.aSavepoint = null;
        this.nSavepoint = 0;
        this.stmtNRec = 0;
    }

    void addToSavepointBitSets(int n2) {
        for (int i2 = 0; i2 < this.nSavepoint; ++i2) {
            SqlJetPager$PagerSavepoint sqlJetPager$PagerSavepoint = this.aSavepoint[i2];
            if (n2 > sqlJetPager$PagerSavepoint.nOrig) continue;
            sqlJetPager$PagerSavepoint.pInSavepoint.set(n2);
        }
    }

    private void unlock() {
        if (SqlJetPagerLockingMode.EXCLUSIVE != this.lockingMode) {
            if (this.journalOpen) {
                if (null != this.jfd) {
                    try {
                        this.jfd.close();
                    }
                    catch (SqlJetException sqlJetException) {
                        // empty catch block
                    }
                }
                this.journalOpen = false;
                this.pagesInJournal = null;
                this.pagesAlwaysRollback = null;
            }
            try {
                if (null != this.fd) {
                    this.fd.unlock(SqlJetLockType.NONE);
                }
            }
            catch (SqlJetException sqlJetException) {
                this.errCode = sqlJetException.getErrorCode();
            }
            this.dbSizeValid = false;
            SqlJetPager.PAGERTRACE("UNLOCK %s\n", this.PAGERID());
            if (null != this.errCode) {
                this.errCode = null;
                this.reset();
                this.releaseAllSavepoint();
                this.journalOff = 0L;
                this.journalStarted = false;
                this.dbOrigSize = 0;
            }
            this.state = SqlJetPagerState.UNLOCK;
            this.changeCountDone = false;
        }
    }

    public void close() {
        this.errCode = null;
        this.lockingMode = SqlJetPagerLockingMode.NORMAL;
        this.reset();
        if (!this.memDb) {
            this.journalHdr = -1L;
            this.unlockAndRollback();
        }
        SqlJetPager.PAGERTRACE("CLOSE %s\n", this.PAGERID());
        if (this.journalOpen && null != this.jfd) {
            this.jfd.close();
        }
        this.pagesInJournal = null;
        this.pagesAlwaysRollback = null;
        this.releaseAllSavepoint();
        if (null != this.fd) {
            this.fd.close();
        }
        this.tmpSpace = null;
        if (this.pageCache != null) {
            this.pageCache.close();
        }
    }

    public ISqlJetPage acquirePage(int n2, boolean bl2) {
        assert (this.state == SqlJetPagerState.UNLOCK || this.pageCache.getRefCount() > 0 || n2 == 1);
        if (n2 > Integer.MAX_VALUE || n2 == 0 || (long)n2 == 0x40000000L / (long)this.pageSize + 1L) {
            throw new SqlJetException(SqlJetErrorCode.CORRUPT);
        }
        this.sharedLock();
        assert (this.state != SqlJetPagerState.UNLOCK);
        ISqlJetPage iSqlJetPage = this.pageCache.fetch(n2, true);
        if (null == iSqlJetPage) {
            throw new SqlJetException(SqlJetErrorCode.INTERNAL, "Page cache is overflow");
        }
        if (null == iSqlJetPage.getPager()) {
            block19: {
                int n3;
                iSqlJetPage.setPager(this);
                try {
                    n3 = this.getPageCount();
                }
                catch (SqlJetException sqlJetException) {
                    iSqlJetPage.unref();
                    throw sqlJetException;
                }
                if (n3 < n2 || this.memDb || !bl2) {
                    if (n2 > this.mxPgno) {
                        iSqlJetPage.unref();
                        throw new SqlJetException(SqlJetErrorCode.FULL);
                    }
                    SqlJetUtility.memset(iSqlJetPage.getData(), (byte)0, this.pageSize);
                    if (!bl2) {
                        if (null == iSqlJetPage.getFlags()) {
                            iSqlJetPage.setFlags(SqlJetUtility.noneOf(SqlJetPageFlags.class));
                        }
                        iSqlJetPage.getFlags().add(SqlJetPageFlags.NEED_READ);
                    }
                    SqlJetPager.PAGERTRACE("ZERO %s %d\n", this.PAGERID(), n2);
                } else {
                    try {
                        this.readDbPage(iSqlJetPage, n2);
                    }
                    catch (SqlJetIOException sqlJetIOException) {
                        if (SqlJetIOErrorCode.IOERR_SHORT_READ == sqlJetIOException.getIoErrorCode()) break block19;
                        this.dropPage(iSqlJetPage);
                        throw sqlJetIOException;
                    }
                }
            }
            iSqlJetPage.setHash(this.pageHash(iSqlJetPage));
        } else {
            assert (this.pageCache.getRefCount() > 0 || 1 == n2);
            if (bl2) {
                try {
                    this.getContent(iSqlJetPage);
                }
                catch (SqlJetException sqlJetException) {
                    iSqlJetPage.unref();
                    throw sqlJetException;
                }
            }
        }
        return iSqlJetPage;
    }

    void getContent(ISqlJetPage iSqlJetPage) {
        Set set = iSqlJetPage.getFlags();
        if (null != set && set.contains((Object)SqlJetPageFlags.NEED_READ)) {
            this.readDbPage(iSqlJetPage, iSqlJetPage.getPageNumber());
            set.remove((Object)SqlJetPageFlags.NEED_READ);
        }
    }

    long pageHash(ISqlJetPage iSqlJetPage) {
        return this.dataHash(this.pageSize, iSqlJetPage.getData());
    }

    private long dataHash(int n2, ISqlJetMemoryPointer iSqlJetMemoryPointer) {
        long l2 = 0L;
        return l2;
    }

    private void dropPage(ISqlJetPage iSqlJetPage) {
        this.pageCache.drop(iSqlJetPage);
        this.unlockIfUnused();
    }

    void unlockIfUnused() {
        if (this.pageCache.getRefCount() == 0 && (SqlJetPagerLockingMode.EXCLUSIVE != this.lockingMode || this.journalOff > 0L)) {
            this.unlockAndRollback();
        }
    }

    private void unlockAndRollback() {
        if (this.errCode == null && SqlJetPagerState.RESERVED.compareTo(this.state) <= 0) {
            this.rollback();
        }
        this.unlock();
    }

    private void readDbPage(ISqlJetPage iSqlJetPage, int n2) {
        assert (!this.memDb);
        assert (null != this.fd || this.tempFile);
        if (null == this.fd) {
            throw new SqlJetIOException(SqlJetIOErrorCode.IOERR_SHORT_READ);
        }
        long l2 = (long)(n2 - 1) * (long)this.pageSize;
        ISqlJetMemoryPointer iSqlJetMemoryPointer = iSqlJetPage.getData();
        this.fd.read(iSqlJetMemoryPointer, this.pageSize, l2);
        if (1 == n2) {
            SqlJetUtility.memcpy(this.dbFileVers, 0, iSqlJetMemoryPointer, 24, this.dbFileVers.remaining());
        }
        SqlJetPager.PAGERTRACE("FETCH %s page %d hash(%08x)\n", this.PAGERID(), iSqlJetPage.getPageNumber(), this.pageHash(iSqlJetPage));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void sharedLock() {
        boolean bl2 = false;
        if (!this.memDb && this.lockingMode == SqlJetPagerLockingMode.EXCLUSIVE && this.pageCache.getRefCount() == 0 && null != this.errCode) {
            if (this.journalOpen) {
                bl2 = true;
            }
            this.errCode = null;
            this.reset();
        }
        if (null != this.errCode && this.errCode != SqlJetErrorCode.FULL) {
            throw new SqlJetException(this.errCode);
        }
        if (SqlJetPagerState.UNLOCK != this.state) {
            if (!bl2) return;
        }
        try {
            block42: {
                block41: {
                    block43: {
                        boolean bl3 = false;
                        assert (!this.memDb);
                        assert (this.pageCache.getRefCount() == 0);
                        if (!this.noReadlock) {
                            try {
                                this.waitOnLock(SqlJetLockType.SHARED);
                            }
                            catch (SqlJetException sqlJetException) {
                                assert (this.state == SqlJetPagerState.UNLOCK);
                                this.error(sqlJetException);
                                throw sqlJetException;
                            }
                        } else if (this.state == SqlJetPagerState.UNLOCK) {
                            this.state = SqlJetPagerState.SHARED;
                        }
                        assert (SqlJetPagerState.SHARED == this.state);
                        if (!bl2) {
                            bl3 = this.hasHotJournal();
                        }
                        if (!bl2 && !bl3) break block42;
                        if (SqlJetPagerState.EXCLUSIVE.compareTo(this.state) > 0) {
                            try {
                                this.fd.lock(SqlJetLockType.EXCLUSIVE);
                            }
                            catch (SqlJetException sqlJetException) {
                                this.error(sqlJetException);
                                throw sqlJetException;
                            }
                            this.state = SqlJetPagerState.EXCLUSIVE;
                        }
                        if (null == this.jfd) {
                            if (this.fileSystem.access(this.journal, SqlJetFileAccesPermission.EXISTS)) {
                                assert (!this.tempFile);
                                this.jfd = this.fileSystem.open(this.journal, SqlJetFileType.MAIN_JOURNAL, SqlJetUtility.of(SqlJetFileOpenPermission.READWRITE));
                                if (null != this.jfd) {
                                    try {
                                        Set set = this.jfd.getPermissions();
                                        if (set.contains((Object)SqlJetFileOpenPermission.READONLY)) {
                                            throw new SqlJetException(SqlJetErrorCode.CANTOPEN);
                                        }
                                    }
                                    catch (SqlJetException sqlJetException) {
                                        this.jfd.close();
                                        throw sqlJetException;
                                    }
                                    this.journalOpen = true;
                                }
                            }
                            this.journalStarted = false;
                            this.journalOff = 0L;
                            this.setMaster = false;
                            this.journalHdr = 0L;
                        }
                        if (!this.journalOpen) break block43;
                        this.syncJournal();
                        try {
                            this.pageCache.clear();
                            Object var5_10 = null;
                            if (null == this.jfd) break block41;
                        }
                        catch (Throwable throwable) {
                            Object var5_11 = null;
                            if (null == this.jfd) throw throwable;
                            try {
                                this.playback(!this.tempFile);
                                throw throwable;
                            }
                            catch (SqlJetException sqlJetException) {
                                this.error(sqlJetException);
                                throw sqlJetException;
                            }
                        }
                        try {}
                        catch (SqlJetException sqlJetException) {
                            this.error(sqlJetException);
                            throw sqlJetException;
                        }
                        this.playback(!this.tempFile);
                        break block41;
                    }
                    if (!this.exclusiveMode()) {
                        boolean bl4 = this.fd.unlock(SqlJetLockType.SHARED);
                        assert (bl4);
                        this.state = SqlJetPagerState.SHARED;
                    }
                }
                if (!$assertionsDisabled && SqlJetPagerState.SHARED != this.state) {
                    if (SqlJetPagerLockingMode.EXCLUSIVE != this.lockingMode) throw new AssertionError();
                    if (SqlJetPagerState.SHARED.compareTo(this.state) >= 0) {
                        throw new AssertionError();
                    }
                }
            }
            if (this.pageCache.getPageCount() > 0) {
                ISqlJetMemoryPointer iSqlJetMemoryPointer = SqlJetUtility.allocatePtr(this.dbFileVers.remaining());
                this.getPageCount();
                if (null != this.errCode) {
                    throw new SqlJetException(this.errCode);
                }
                assert (this.dbSizeValid);
                if (this.dbSize > 0) {
                    SqlJetPager.PAGERTRACE("CKVERS %s %d\n", this.PAGERID(), iSqlJetMemoryPointer.remaining());
                    this.fd.read(iSqlJetMemoryPointer, iSqlJetMemoryPointer.remaining(), 24L);
                } else {
                    SqlJetUtility.memset(iSqlJetMemoryPointer, (byte)0, iSqlJetMemoryPointer.remaining());
                }
                if (SqlJetUtility.memcmp(this.dbFileVers, iSqlJetMemoryPointer, iSqlJetMemoryPointer.remaining()) != 0) {
                    this.reset();
                }
            }
            if ($assertionsDisabled) return;
            if (SqlJetPagerLockingMode.EXCLUSIVE == this.lockingMode) return;
            if (SqlJetPagerState.SHARED == this.state) return;
            throw new AssertionError();
        }
        catch (SqlJetException sqlJetException) {
            this.unlock();
            throw sqlJetException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void playback(boolean var1_1) {
        block55: {
            block60: {
                block59: {
                    block49: {
                        block58: {
                            block47: {
                                block48: {
                                    var2_2 = null;
                                    var5_3 = -1;
                                    var7_4 = 0;
                                    var8_5 = true;
                                    var9_6 = null;
                                    if (!SqlJetPager.$assertionsDisabled && !this.journalOpen) {
                                        throw new AssertionError();
                                    }
                                    try {
                                        try {
                                            var3_7 = this.jfd.fileSize();
                                            if (var3_7 == 0L) {
                                                var12_8 = null;
                                                if (var2_2 != null) break block47;
                                                break block48;
                                            }
                                            var9_6 = this.readMasterJournal(this.jfd);
                                            if (null != var9_6) {
                                                var8_5 = this.fileSystem.access(new File(var9_6), SqlJetFileAccesPermission.EXISTS);
                                            }
                                            if (!var8_5) {
                                                break block49;
                                            }
                                            this.journalOff = 0L;
                                            block26: while (true) {
                                                block50: {
                                                    try {
                                                        var10_19 = this.readJournalHdr(var3_7);
                                                        var5_3 = var10_19[0];
                                                        var7_4 = var10_19[1];
                                                    }
                                                    catch (SqlJetException var10_20) {
                                                        if (SqlJetErrorCode.DONE != var10_20.getErrorCode()) break block50;
                                                        var12_10 = null;
                                                        if (var2_2 == null) {
                                                            try {
                                                                var9_6 = this.readMasterJournal(this.jfd);
                                                            }
                                                            catch (SqlJetException var13_15) {
                                                                var2_2 = var13_15;
                                                            }
                                                        }
                                                        if (var2_2 == null) {
                                                            try {
                                                                this.endTransaction(var9_6 != null);
                                                            }
                                                            catch (SqlJetException var13_15) {
                                                                var2_2 = var13_15;
                                                            }
                                                        }
                                                        if (var2_2 != null) return;
                                                        if (var9_6 == null) return;
                                                        if (var8_5 == false) return;
                                                        try {
                                                            this.deleteMaster(var9_6);
                                                            return;
                                                        }
                                                        catch (SqlJetException var13_15) {
                                                            var2_2 = var13_15;
                                                        }
                                                        return;
                                                    }
                                                }
                                                if (var5_3 == -1) {
                                                    if (!SqlJetPager.$assertionsDisabled && this.journalOff != (long)this.JOURNAL_HDR_SZ()) {
                                                        throw new AssertionError();
                                                    }
                                                    var5_3 = (int)((var3_7 - (long)this.JOURNAL_HDR_SZ()) / (long)this.JOURNAL_PG_SZ());
                                                }
                                                if (var5_3 == 0 && !var1_1 && this.journalHdr + (long)this.JOURNAL_HDR_SZ() == this.journalOff) {
                                                    var5_3 = (int)((var3_7 - this.journalOff) / (long)this.JOURNAL_PG_SZ());
                                                }
                                                if (this.journalOff == (long)this.JOURNAL_HDR_SZ()) {
                                                    this.doTruncate(var7_4);
                                                    this.dbSize = var7_4;
                                                }
                                                if (var1_1) {
                                                    this.reset();
                                                }
                                                var6_18 = 0;
                                                while (true) {
                                                    if (var6_18 >= var5_3) continue block26;
                                                    try {
                                                        this.journalOff = this.playbackOnePage(true, this.journalOff, false, null);
                                                    }
                                                    catch (SqlJetException var10_21) {
                                                        if (var10_21.getErrorCode() != SqlJetErrorCode.DONE) throw new SqlJetException(SqlJetErrorCode.CORRUPT);
                                                        this.journalOff = var3_7;
                                                        continue block26;
                                                    }
                                                    ++var6_18;
                                                }
                                                break;
                                            }
                                        }
                                        catch (SqlJetException var10_22) {
                                            block54: {
                                                block53: {
                                                    var2_2 = var10_22;
                                                    var12_11 = null;
                                                    if (var2_2 == null) {
                                                        ** try [egrp 4[TRYBLOCK] [11 : 362->375)] { 
lbl86:
                                                        // 1 sources

                                                        var9_6 = this.readMasterJournal(this.jfd);
                                                        break block53;
lbl88:
                                                        // 1 sources

                                                        catch (SqlJetException var13_16) {
                                                            var2_2 = var13_16;
                                                        }
                                                    }
                                                }
                                                if (var2_2 == null) {
                                                    ** try [egrp 5[TRYBLOCK] [12 : 384->401)] { 
lbl93:
                                                    // 1 sources

                                                    this.endTransaction(var9_6 != null);
                                                    break block54;
lbl95:
                                                    // 1 sources

                                                    catch (SqlJetException var13_16) {
                                                        var2_2 = var13_16;
                                                    }
                                                }
                                            }
                                            if (var2_2 == null && var9_6 != null && var8_5) {
                                                ** try [egrp 6[TRYBLOCK] [13 : 420->429)] { 
lbl100:
                                                // 1 sources

                                                this.deleteMaster(var9_6);
lbl102:
                                                // 1 sources

                                                catch (SqlJetException var13_16) {
                                                    var2_2 = var13_16;
                                                }
                                            }
                                            break block55;
                                        }
                                    }
                                    catch (Throwable var11_23) {
                                        block57: {
                                            block56: {
                                                var12_12 = null;
                                                if (var2_2 == null) {
                                                    ** try [egrp 4[TRYBLOCK] [11 : 362->375)] { 
lbl110:
                                                    // 1 sources

                                                    var9_6 = this.readMasterJournal(this.jfd);
                                                    break block56;
lbl112:
                                                    // 1 sources

                                                    catch (SqlJetException var13_17) {
                                                        var2_2 = var13_17;
                                                    }
                                                }
                                            }
                                            if (var2_2 == null) {
                                                ** try [egrp 5[TRYBLOCK] [12 : 384->401)] { 
lbl117:
                                                // 1 sources

                                                this.endTransaction(var9_6 != null);
                                                break block57;
lbl119:
                                                // 1 sources

                                                catch (SqlJetException var13_17) {
                                                    var2_2 = var13_17;
                                                }
                                            }
                                        }
                                        if (var2_2 != null) throw var11_23;
                                        if (var9_6 == null) throw var11_23;
                                        if (var8_5 == false) throw var11_23;
                                        ** try [egrp 6[TRYBLOCK] [13 : 420->429)] { 
lbl126:
                                        // 1 sources

                                        this.deleteMaster(var9_6);
                                        throw var11_23;
lbl128:
                                        // 1 sources

                                        catch (SqlJetException var13_17) {
                                            var2_2 = var13_17;
                                        }
                                        throw var11_23;
                                    }
                                }
                                ** try [egrp 4[TRYBLOCK] [11 : 362->375)] { 
lbl133:
                                // 1 sources

                                var9_6 = this.readMasterJournal(this.jfd);
                                break block47;
lbl135:
                                // 1 sources

                                catch (SqlJetException var13_13) {
                                    var2_2 = var13_13;
                                }
                            }
                            if (var2_2 == null) {
                                ** try [egrp 5[TRYBLOCK] [12 : 384->401)] { 
lbl140:
                                // 1 sources

                                this.endTransaction(var9_6 != null);
                                break block58;
lbl142:
                                // 1 sources

                                catch (SqlJetException var13_13) {
                                    var2_2 = var13_13;
                                }
                            }
                        }
                        if (var2_2 != null) return;
                        if (var9_6 == null) return;
                        if (var8_5 == false) return;
                        ** try [egrp 6[TRYBLOCK] [13 : 420->429)] { 
lbl149:
                        // 1 sources

                        this.deleteMaster(var9_6);
                        return;
lbl151:
                        // 1 sources

                        catch (SqlJetException var13_13) {
                            var2_2 = var13_13;
                        }
                        return;
                    }
                    var12_9 = null;
                    if (var2_2 == null) {
                        ** try [egrp 4[TRYBLOCK] [11 : 362->375)] { 
lbl158:
                        // 1 sources

                        var9_6 = this.readMasterJournal(this.jfd);
                        break block59;
lbl160:
                        // 1 sources

                        catch (SqlJetException var13_14) {
                            var2_2 = var13_14;
                        }
                    }
                }
                if (var2_2 == null) {
                    ** try [egrp 5[TRYBLOCK] [12 : 384->401)] { 
lbl165:
                    // 1 sources

                    this.endTransaction(var9_6 != null);
                    break block60;
lbl167:
                    // 1 sources

                    catch (SqlJetException var13_14) {
                        var2_2 = var13_14;
                    }
                }
            }
            if (var2_2 != null) return;
            if (var9_6 == null) return;
            if (var8_5 == false) return;
            ** try [egrp 6[TRYBLOCK] [13 : 420->429)] { 
lbl174:
            // 1 sources

            this.deleteMaster(var9_6);
            return;
lbl176:
            // 1 sources

            catch (SqlJetException var13_14) {
                var2_2 = var13_14;
            }
            return;
        }
        this.setSectorSize();
        if (var2_2 == null) return;
        throw var2_2;
    }

    private void playbackSavepoint(SqlJetPager$PagerSavepoint sqlJetPager$PagerSavepoint) {
        int n2;
        SqlJetException sqlJetException = null;
        BitSet bitSet = null;
        if (sqlJetPager$PagerSavepoint != null) {
            bitSet = new BitSet(sqlJetPager$PagerSavepoint.nOrig);
        }
        int n3 = this.dbSize = sqlJetPager$PagerSavepoint != null ? sqlJetPager$PagerSavepoint.nOrig : this.dbOrigSize;
        assert (this.state.compareTo(SqlJetPagerState.SHARED) >= 0);
        long l2 = this.journalOff;
        if (sqlJetPager$PagerSavepoint != null) {
            long l3 = sqlJetPager$PagerSavepoint.iHdrOffset > 0L ? sqlJetPager$PagerSavepoint.iHdrOffset : l2;
            this.journalOff = sqlJetPager$PagerSavepoint.iOffset;
            while (sqlJetException == null && this.journalOff < l3) {
                try {
                    this.journalOff = this.playbackOnePage(true, this.journalOff, true, bitSet);
                }
                catch (SqlJetException sqlJetException2) {
                    sqlJetException = sqlJetException2;
                    assert (sqlJetException2.getErrorCode() != SqlJetErrorCode.DONE);
                }
            }
        } else {
            this.journalOff = 0L;
        }
        while (sqlJetException == null && this.journalOff < l2) {
            long l4;
            block25: {
                l4 = 0L;
                try {
                    int[] nArray = this.readJournalHdr(l2);
                    l4 = nArray[0];
                }
                catch (SqlJetException sqlJetException3) {
                    sqlJetException = sqlJetException3;
                    if ($assertionsDisabled || sqlJetException3.getErrorCode() != SqlJetErrorCode.DONE) break block25;
                    throw new AssertionError();
                }
            }
            assert (l4 != 0L || this.journalHdr + (long)this.JOURNAL_HDR_SZ() == this.journalOff || (l2 - this.journalOff) / (long)this.JOURNAL_PG_SZ() <= 0L);
            if (l4 == 0L && this.journalHdr + (long)this.JOURNAL_HDR_SZ() == this.journalOff) {
                l4 = (l2 - this.journalOff) / (long)this.JOURNAL_PG_SZ();
            }
            n2 = 0;
            while (sqlJetException == null && (long)n2 < l4 && this.journalOff < l2) {
                block26: {
                    try {
                        this.playbackOnePage(true, this.journalOff, true, bitSet);
                    }
                    catch (SqlJetException sqlJetException4) {
                        sqlJetException = sqlJetException4;
                        if ($assertionsDisabled || sqlJetException4.getErrorCode() != SqlJetErrorCode.DONE) break block26;
                        throw new AssertionError();
                    }
                }
                ++n2;
            }
        }
        assert (sqlJetException != null || this.journalOff == l2);
        if (sqlJetPager$PagerSavepoint != null) {
            long l5 = (long)sqlJetPager$PagerSavepoint.iSubRec * (long)(4 + this.pageSize);
            for (n2 = sqlJetPager$PagerSavepoint.iSubRec; sqlJetException == null && n2 < this.stmtNRec; ++n2) {
                assert (l5 == (long)n2 * (long)(4 + this.pageSize));
                try {
                    this.playbackOnePage(false, l5, true, bitSet);
                    continue;
                }
                catch (SqlJetException sqlJetException5) {
                    sqlJetException = sqlJetException5;
                    assert (sqlJetException5.getErrorCode() != SqlJetErrorCode.DONE);
                    continue;
                }
            }
        }
        bitSet = null;
        if (sqlJetException == null) {
            this.journalOff = l2;
        }
        if (sqlJetException != null) {
            throw sqlJetException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteMaster(String string) {
        boolean bl2 = false;
        ISqlJetFile iSqlJetFile = null;
        ISqlJetMemoryPointer iSqlJetMemoryPointer = null;
        try {
            iSqlJetFile = this.fileSystem.open(new File(string), SqlJetFileType.MASTER_JOURNAL, SqlJetUtility.of(SqlJetFileOpenPermission.READONLY));
            bl2 = true;
            int n2 = Long.valueOf(iSqlJetFile.fileSize()).intValue();
            if (n2 > 0) {
                int n3;
                iSqlJetMemoryPointer = SqlJetUtility.allocatePtr(n2);
                iSqlJetFile.read(iSqlJetMemoryPointer, n2, 0L);
                for (int i2 = 0; i2 < n2; i2 += n3 + 1) {
                    Object var14_13;
                    ISqlJetFile iSqlJetFile2;
                    block10: {
                        n3 = SqlJetUtility.strlen(iSqlJetMemoryPointer, i2);
                        String string2 = SqlJetUtility.toString(SqlJetUtility.pointer(iSqlJetMemoryPointer, i2));
                        File file = new File(string2);
                        boolean bl3 = this.fileSystem.access(file, SqlJetFileAccesPermission.EXISTS);
                        if (!bl3) continue;
                        iSqlJetFile2 = this.fileSystem.open(file, SqlJetFileType.MAIN_JOURNAL, SqlJetUtility.of(SqlJetFileOpenPermission.READONLY));
                        try {
                            String string3 = this.readMasterJournal(iSqlJetFile2);
                            if (string3 == null || !string3.equals(string)) break block10;
                            var14_13 = null;
                            iSqlJetFile2.close();
                        }
                        catch (Throwable throwable) {
                            var14_13 = null;
                            iSqlJetFile2.close();
                            throw throwable;
                        }
                        Object var16_14 = null;
                        if (bl2 && iSqlJetFile != null) {
                            iSqlJetFile.close();
                        }
                        return;
                    }
                    var14_13 = null;
                    iSqlJetFile2.close();
                    continue;
                }
            }
            this.fileSystem.delete(new File(string), false);
        }
        catch (Throwable throwable) {
            Object var16_16 = null;
            if (bl2 && iSqlJetFile != null) {
                iSqlJetFile.close();
            }
            throw throwable;
        }
        Object var16_15 = null;
        if (bl2 && iSqlJetFile != null) {
            iSqlJetFile.close();
        }
    }

    private void endTransaction(boolean bl2) {
        SqlJetException sqlJetException = null;
        SqlJetException sqlJetException2 = null;
        if (this.state.compareTo(SqlJetPagerState.RESERVED) < 0) {
            return;
        }
        this.releaseAllSavepoint();
        if (this.journalOpen) {
            if (this.journalMode == SqlJetPagerJournalMode.MEMORY) {
                boolean bl3 = this.jfd.isMemJournal();
                try {
                    this.jfd.close();
                }
                catch (SqlJetException sqlJetException3) {
                    // empty catch block
                }
                this.journalOpen = false;
                if (!bl3) {
                    try {
                        this.fileSystem.delete(this.journal, false);
                    }
                    catch (SqlJetException sqlJetException4) {
                        sqlJetException = sqlJetException4;
                    }
                }
            } else if (this.journalMode == SqlJetPagerJournalMode.TRUNCATE) {
                try {
                    this.jfd.truncate(0L);
                    this.journalOff = 0L;
                    this.journalStarted = false;
                }
                catch (SqlJetException sqlJetException5) {
                    sqlJetException = sqlJetException5;
                    try {
                        this.jfd.close();
                    }
                    catch (SqlJetException sqlJetException6) {
                        // empty catch block
                    }
                    this.journalOpen = false;
                }
            } else if (this.exclusiveMode() || this.journalMode == SqlJetPagerJournalMode.PERSIST) {
                try {
                    this.zeroJournalHdr(bl2);
                }
                catch (SqlJetException sqlJetException7) {
                    sqlJetException = sqlJetException7;
                }
                if (sqlJetException != null) {
                    this.error(sqlJetException);
                }
                this.journalOff = 0L;
                this.journalStarted = false;
            } else {
                assert (this.journalMode == SqlJetPagerJournalMode.DELETE);
                try {
                    this.jfd.truncate(0L);
                }
                catch (SqlJetIOException sqlJetIOException) {
                    // empty catch block
                }
                try {
                    this.jfd.close();
                }
                catch (SqlJetException sqlJetException8) {
                    // empty catch block
                }
                this.journalOpen = false;
                if (sqlJetException == null && !this.tempFile) {
                    try {
                        if (!this.fileSystem.delete(this.journal, true)) {
                            sqlJetException = new SqlJetIOException(SqlJetIOErrorCode.IOERR_DELETE);
                        }
                    }
                    catch (SqlJetException sqlJetException9) {
                        sqlJetException = sqlJetException9;
                    }
                }
            }
            this.pagesInJournal = null;
            this.pagesAlwaysRollback = null;
            this.pageCache.cleanAll();
            this.dirtyCache = false;
            this.nRec = 0;
        } else assert (null == this.pagesInJournal);
        if (!this.exclusiveMode()) {
            if (null != this.fd) {
                try {
                    this.fd.unlock(SqlJetLockType.SHARED);
                }
                catch (SqlJetException sqlJetException10) {
                    sqlJetException2 = sqlJetException10;
                }
            }
            this.state = SqlJetPagerState.SHARED;
            this.changeCountDone = false;
        } else if (this.state == SqlJetPagerState.SYNCED) {
            this.state = SqlJetPagerState.EXCLUSIVE;
        }
        this.dbOrigSize = 0;
        this.setMaster = false;
        this.needSync = false;
        this.pageCache.truncate(this.dbSize);
        if (!this.memDb) {
            this.dbSizeValid = false;
        }
        this.dbModified = false;
        if (sqlJetException != null) {
            throw sqlJetException;
        }
        if (sqlJetException2 != null) {
            throw sqlJetException2;
        }
    }

    private void zeroJournalHdr(boolean bl2) {
        SqlJetException sqlJetException = null;
        ISqlJetMemoryPointer iSqlJetMemoryPointer = SqlJetUtility.allocatePtr(28);
        if (this.journalOff > 0L) {
            long l2 = this.journalSizeLimit;
            if (bl2 || l2 == 0L) {
                try {
                    this.jfd.truncate(0L);
                }
                catch (SqlJetException sqlJetException2) {
                    sqlJetException = sqlJetException2;
                }
            } else {
                try {
                    this.jfd.write(iSqlJetMemoryPointer, iSqlJetMemoryPointer.remaining(), 0L);
                }
                catch (SqlJetException sqlJetException3) {
                    sqlJetException = sqlJetException3;
                }
            }
            if (sqlJetException == null && !this.noSync) {
                this.jfd.sync(this.syncFlags);
            }
            if (sqlJetException == null && l2 > 0L) {
                long l3 = 0L;
                try {
                    l3 = this.jfd.fileSize();
                }
                catch (SqlJetException sqlJetException4) {
                    sqlJetException = sqlJetException4;
                }
                if (sqlJetException == null && l3 > l2) {
                    try {
                        this.jfd.truncate(l2);
                    }
                    catch (SqlJetException sqlJetException5) {
                        sqlJetException = sqlJetException5;
                    }
                }
            }
        }
        if (null != sqlJetException) {
            throw sqlJetException;
        }
    }

    private boolean exclusiveMode() {
        return this.lockingMode == SqlJetPagerLockingMode.EXCLUSIVE;
    }

    private long playbackOnePage(boolean bl2, long l2, boolean bl3, BitSet bitSet) {
        assert (bl2 || bitSet != null);
        assert (bl3 || bitSet == null);
        ISqlJetMemoryPointer iSqlJetMemoryPointer = this.tmpSpace;
        assert (iSqlJetMemoryPointer != null);
        ISqlJetFile iSqlJetFile = bl2 ? this.jfd : this.sjfd;
        int n2 = this.read32bits(iSqlJetFile, l2);
        iSqlJetFile.read(iSqlJetMemoryPointer, this.pageSize, l2 + 4L);
        l2 += (long)(this.pageSize + 4 + (bl2 ? 4 : 0));
        if (n2 == 0 || (long)n2 == this.PAGER_MJ_PGNO()) {
            throw new SqlJetException(SqlJetErrorCode.DONE);
        }
        if (n2 > this.dbSize || SqlJetUtility.bitSetTest(bitSet, n2)) {
            return l2;
        }
        if (bl2) {
            long l3 = this.read32bitsUnsigned(iSqlJetFile, l2 - 4L);
            if (!bl3 && this.cksum(iSqlJetMemoryPointer) != l3) {
                throw new SqlJetException(SqlJetErrorCode.DONE);
            }
        }
        if (bitSet != null) {
            bitSet.set(n2);
        }
        assert (this.state == SqlJetPagerState.RESERVED || this.state.compareTo(SqlJetPagerState.EXCLUSIVE) >= 0);
        ISqlJetPage iSqlJetPage = this.lookup(n2);
        SqlJetPager.PAGERTRACE("PLAYBACK %s page %d hash(%08x) %s\n", this.PAGERID(), n2, this.dataHash(this.pageSize, iSqlJetMemoryPointer), bl2 ? "main-journal" : "sub-journal");
        if (!(this.state.compareTo(SqlJetPagerState.EXCLUSIVE) < 0 || iSqlJetPage != null && iSqlJetPage.getFlags().contains((Object)SqlJetPageFlags.NEED_SYNC) || null == this.fd)) {
            long l4 = (long)(n2 - 1) * (long)this.pageSize;
            this.fd.write(iSqlJetMemoryPointer, this.pageSize, l4);
            if (n2 > this.dbFileSize) {
                this.dbFileSize = n2;
            }
        } else if (!bl2 && iSqlJetPage == null) {
            assert (bl3);
            iSqlJetPage = this.acquirePage(n2, true);
            iSqlJetPage.getFlags().remove((Object)SqlJetPageFlags.NEED_READ);
            this.pageCache.makeDirty(iSqlJetPage);
        }
        if (null != iSqlJetPage) {
            ISqlJetMemoryPointer iSqlJetMemoryPointer2 = iSqlJetPage.getData();
            SqlJetUtility.memcpy(iSqlJetMemoryPointer2, iSqlJetMemoryPointer, this.pageSize);
            if (null != this.reiniter) {
                this.reiniter.pageCallback(iSqlJetPage);
            }
            if (bl2 && (!bl3 || this.journalOff <= this.journalHdr)) {
                this.pageCache.makeClean(iSqlJetPage);
            }
            iSqlJetPage.setHash(this.pageHash(iSqlJetPage));
            if (n2 == 1) {
                SqlJetUtility.memcpy(this.dbFileVers, 0, iSqlJetMemoryPointer2, 24, this.dbFileVers.remaining());
            }
            this.pageCache.release(iSqlJetPage);
        }
        return l2;
    }

    long cksum(ISqlJetMemoryPointer iSqlJetMemoryPointer) {
        long l2 = this.cksumInit;
        for (int i2 = this.pageSize - 200; i2 > 0; i2 -= 200) {
            l2 += (long)SqlJetUtility.getUnsignedByte(iSqlJetMemoryPointer, i2);
        }
        return l2;
    }

    private String readMasterJournal(ISqlJetFile iSqlJetFile) {
        ISqlJetMemoryPointer iSqlJetMemoryPointer = SqlJetUtility.allocatePtr(8);
        long l2 = iSqlJetFile.fileSize();
        if (l2 < 16L) {
            return null;
        }
        int n2 = this.read32bits(iSqlJetFile, l2 - 16L);
        long l3 = this.read32bitsUnsigned(iSqlJetFile, l2 - 12L);
        iSqlJetFile.read(iSqlJetMemoryPointer, iSqlJetMemoryPointer.remaining(), l2 - 8L);
        if (0 != SqlJetUtility.memcmp(iSqlJetMemoryPointer, aJournalMagic, iSqlJetMemoryPointer.remaining())) {
            return null;
        }
        ISqlJetMemoryPointer iSqlJetMemoryPointer2 = SqlJetUtility.allocatePtr(n2);
        iSqlJetFile.read(iSqlJetMemoryPointer2, n2, l2 - 16L - (long)n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            l3 -= (long)SqlJetUtility.getUnsignedByte(iSqlJetMemoryPointer2, i2);
        }
        if (l3 > 0L) {
            return null;
        }
        return SqlJetUtility.toString(iSqlJetMemoryPointer2);
    }

    private int read32bits(ISqlJetFile iSqlJetFile, long l2) {
        ISqlJetMemoryPointer iSqlJetMemoryPointer = SqlJetUtility.allocatePtr(4);
        iSqlJetFile.read(iSqlJetMemoryPointer, iSqlJetMemoryPointer.remaining(), l2);
        return SqlJetUtility.get4byte(iSqlJetMemoryPointer);
    }

    private long read32bitsUnsigned(ISqlJetFile iSqlJetFile, long l2) {
        ISqlJetMemoryPointer iSqlJetMemoryPointer = SqlJetUtility.allocatePtr(4);
        iSqlJetFile.read(iSqlJetMemoryPointer, iSqlJetMemoryPointer.remaining(), l2);
        return SqlJetUtility.get4byteUnsigned(iSqlJetMemoryPointer);
    }

    private int[] readJournalHdr(long l2) {
        int[] nArray = new int[2];
        ISqlJetMemoryPointer iSqlJetMemoryPointer = SqlJetUtility.allocatePtr(8);
        this.seekJournalHdr();
        if (this.journalOff + (long)this.JOURNAL_HDR_SZ() > l2) {
            throw new SqlJetException(SqlJetErrorCode.DONE);
        }
        long l3 = this.journalOff;
        this.jfd.read(iSqlJetMemoryPointer, iSqlJetMemoryPointer.remaining(), l3);
        l3 += (long)iSqlJetMemoryPointer.remaining();
        if (0 != SqlJetUtility.memcmp(iSqlJetMemoryPointer, aJournalMagic, iSqlJetMemoryPointer.remaining())) {
            throw new SqlJetException(SqlJetErrorCode.DONE);
        }
        int n2 = this.read32bits(this.jfd, l3);
        this.cksumInit = this.read32bitsUnsigned(this.jfd, l3 + 4L);
        int n3 = this.read32bits(this.jfd, l3 + 8L);
        nArray[0] = n2;
        nArray[1] = n3;
        if (this.journalOff == 0L) {
            int n4 = this.read32bits(this.jfd, l3 + 16L);
            if (n4 < 512 || n4 > 32768 || (n4 - 1 & n4) != 0) {
                throw new SqlJetException(SqlJetErrorCode.DONE);
            }
            this.setPageSize(n4);
            assert (this.pageSize == n4);
            int n5 = this.read32bits(this.jfd, l3 + 12L);
            if ((n5 & n5 - 1) != 0 || n5 < 512 || n5 > 32768) {
                throw new SqlJetException(SqlJetErrorCode.DONE);
            }
            this.sectorSize = n5;
        }
        this.journalOff += (long)this.JOURNAL_HDR_SZ();
        return nArray;
    }

    private long journalHdrOffset() {
        long l2 = 0L;
        long l3 = this.journalOff;
        if (l3 > 0L) {
            l2 = ((l3 - 1L) / (long)this.JOURNAL_HDR_SZ() + 1L) * (long)this.JOURNAL_HDR_SZ();
        }
        assert (l2 % (long)this.JOURNAL_HDR_SZ() == 0L);
        assert (l2 >= l3);
        assert (l2 - l3 < (long)this.JOURNAL_HDR_SZ());
        return l2;
    }

    private void seekJournalHdr() {
        this.journalOff = this.journalHdrOffset();
    }

    private boolean hasHotJournal() {
        boolean bl2 = false;
        boolean bl3 = false;
        assert (this.useJournal);
        assert (null != this.fd);
        bl2 = this.fileSystem.access(this.journal, SqlJetFileAccesPermission.EXISTS);
        if (bl2) {
            bl3 = this.fd.checkReservedLock();
        }
        if (bl2 && !bl3) {
            if (0 == this.getPageCount()) {
                this.fileSystem.delete(this.journal, false);
            } else {
                return true;
            }
        }
        return false;
    }

    private void waitOnLock(SqlJetLockType sqlJetLockType) {
        assert (SqlJetPagerState.SHARED.compareTo(this.state) <= 0 || !this.dbSizeValid);
        if (this.state.getLockType().compareTo(sqlJetLockType) < 0) {
            boolean bl2;
            boolean bl3 = false;
            int n2 = 0;
            while (((bl3 = this.fd.lock(sqlJetLockType)) || null == this.busyHandler || (bl2 = this.busyHandler.call(n2++))) && !bl3) {
            }
            if (bl3) {
                this.state = SqlJetPagerState.getPagerState(sqlJetLockType);
            } else {
                throw new SqlJetException(SqlJetErrorCode.BUSY);
            }
        }
    }

    public ISqlJetPage getPage(int n2) {
        return this.acquirePage(n2, true);
    }

    public ISqlJetPage lookupPage(int n2) {
        assert (n2 != 0);
        if (this.state != SqlJetPagerState.UNLOCK && (this.errCode == null || this.errCode == SqlJetErrorCode.FULL)) {
            return this.pageCache.fetch(n2, false);
        }
        return null;
    }

    public void truncateImage(int n2) {
        assert (this.dbSizeValid);
        assert (this.dbSize >= n2);
        this.dbSize = n2;
    }

    public int imageSize() {
        assert (this.dbSizeValid);
        return this.dbSize;
    }

    private void doTruncate(int n2) {
        long l2;
        long l3;
        if (this.state.compareTo(SqlJetPagerState.EXCLUSIVE) >= 0 && null != this.fd && (l3 = this.fd.fileSize()) != (l2 = (long)this.pageSize * (long)n2)) {
            if (l3 > l2) {
                this.fd.truncate(l2);
            } else {
                ISqlJetMemoryPointer iSqlJetMemoryPointer = SqlJetUtility.allocatePtr(1);
                this.fd.write(iSqlJetMemoryPointer, 1, l2 - 1L);
            }
            this.dbFileSize = this.nPage;
        }
    }

    private void syncJournal() {
        if (this.needSync) {
            assert (!this.tempFile);
            if (this.journalMode != SqlJetPagerJournalMode.MEMORY) {
                assert (this.journalOpen);
                Set set = this.fd.deviceCharacteristics();
                if (!set.contains((Object)SqlJetDeviceCharacteristics.IOCAP_SAFE_APPEND)) {
                    long l2;
                    block10: {
                        l2 = this.journalHdrOffset();
                        ISqlJetMemoryPointer iSqlJetMemoryPointer = SqlJetUtility.allocatePtr(8);
                        try {
                            this.jfd.read(iSqlJetMemoryPointer, 8, l2);
                            if (0 == SqlJetUtility.memcmp(iSqlJetMemoryPointer, aJournalMagic, 8)) {
                                ISqlJetMemoryPointer iSqlJetMemoryPointer2 = SqlJetUtility.allocatePtr(1);
                                this.jfd.write(iSqlJetMemoryPointer2, 1, l2);
                            }
                        }
                        catch (SqlJetIOException sqlJetIOException) {
                            if (sqlJetIOException.getIoErrorCode() == SqlJetIOErrorCode.IOERR_SHORT_READ) break block10;
                            throw sqlJetIOException;
                        }
                    }
                    if (this.fullSync && !set.contains((Object)SqlJetDeviceCharacteristics.IOCAP_SEQUENTIAL)) {
                        SqlJetPager.PAGERTRACE("SYNC journal of %s\n", this.PAGERID());
                        this.jfd.sync(this.syncFlags);
                    }
                    l2 = this.journalHdr + (long)aJournalMagic.remaining();
                    SqlJetPager.PAGERTRACE("JHDR %s %d %d\n", this.PAGERID(), l2, 4);
                    SqlJetPager.write32bits(this.jfd, l2, this.nRec);
                }
                if (!set.contains((Object)SqlJetDeviceCharacteristics.IOCAP_SEQUENTIAL)) {
                    SqlJetPager.PAGERTRACE("SYNC journal of %s\n", this.PAGERID());
                    this.jfd.sync(this.syncFlags);
                }
                this.journalStarted = true;
            }
            this.needSync = false;
            this.pageCache.clearSyncFlags();
        }
    }

    void subjournalPage(SqlJetPage sqlJetPage) {
        ISqlJetMemoryPointer iSqlJetMemoryPointer = sqlJetPage.getData();
        long l2 = (long)this.stmtNRec * (long)(4 + this.pageSize);
        SqlJetPager.PAGERTRACE("STMT-JOURNAL %s page %d\n", this.PAGERID(), sqlJetPage.pgno);
        assert (SqlJetPager.pageInJournal(sqlJetPage) || sqlJetPage.pgno > this.dbOrigSize);
        SqlJetPager.write32bits(this.sjfd, l2, sqlJetPage.pgno);
        this.sjfd.write(iSqlJetMemoryPointer, this.pageSize, l2 + 4L);
        ++this.stmtNRec;
        assert (this.nSavepoint > 0);
        this.addToSavepointBitSets(sqlJetPage.pgno);
    }

    static void write32bits(ISqlJetFile iSqlJetFile, long l2, int n2) {
        ISqlJetMemoryPointer iSqlJetMemoryPointer = SqlJetUtility.put4byte(n2);
        iSqlJetFile.write(iSqlJetMemoryPointer, iSqlJetMemoryPointer.remaining(), l2);
    }

    static void write32bitsUnsigned(ISqlJetFile iSqlJetFile, long l2, long l3) {
        ISqlJetMemoryPointer iSqlJetMemoryPointer = SqlJetUtility.put4byteUnsigned(l3);
        iSqlJetFile.write(iSqlJetMemoryPointer, iSqlJetMemoryPointer.remaining(), l2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void begin(boolean bl2) {
        assert (this.state != SqlJetPagerState.UNLOCK);
        if (this.state == SqlJetPagerState.SHARED) {
            assert (this.pagesInJournal == null);
            assert (!this.memDb);
            if (!this.fd.lock(SqlJetLockType.RESERVED)) throw new SqlJetException(SqlJetErrorCode.BUSY);
            this.state = SqlJetPagerState.RESERVED;
            if (bl2) {
                this.waitOnLock(SqlJetLockType.EXCLUSIVE);
            }
            this.dirtyCache = false;
            SqlJetPager.PAGERTRACE("TRANSACTION %s\n", this.PAGERID());
            if (this.useJournal && !this.tempFile && this.journalMode != SqlJetPagerJournalMode.OFF) {
                this.openJournal();
            }
        } else if (this.journalOpen && this.journalOff == 0L) {
            assert (this.nRec == 0);
            assert (this.dbOrigSize == 0);
            assert (this.pagesInJournal == null);
            this.getPageCount();
            this.pagesInJournal = new BitSet(this.dbSize);
            this.dbOrigSize = this.dbSize;
            this.writeJournalHdr();
        }
        assert (!this.journalOpen || this.journalOff > 0L);
        return;
    }

    private void writeJournalHdr() {
        SqlJetException sqlJetException = null;
        ISqlJetMemoryPointer iSqlJetMemoryPointer = this.tmpSpace;
        int n2 = this.pageSize;
        if (n2 > this.JOURNAL_HDR_SZ()) {
            n2 = this.JOURNAL_HDR_SZ();
        }
        for (int i2 = 0; i2 < this.nSavepoint; ++i2) {
            if (this.aSavepoint[i2].iHdrOffset != 0L) continue;
            this.aSavepoint[i2].iHdrOffset = this.journalOff;
        }
        this.seekJournalHdr();
        this.journalHdr = this.journalOff;
        SqlJetUtility.memcpy(iSqlJetMemoryPointer, aJournalMagic, aJournalMagic.remaining());
        assert (this.fd != null || this.noSync);
        if (this.noSync || this.journalMode == SqlJetPagerJournalMode.MEMORY || this.fd.deviceCharacteristics().contains((Object)SqlJetDeviceCharacteristics.IOCAP_SAFE_APPEND)) {
            this.put32bits(iSqlJetMemoryPointer, aJournalMagic.remaining(), -1);
        } else {
            this.put32bits(iSqlJetMemoryPointer, aJournalMagic.remaining(), 0);
        }
        this.cksumInit = this.randomnessInt();
        this.put32bitsUnsigned(iSqlJetMemoryPointer, aJournalMagic.remaining() + 4, this.cksumInit);
        this.put32bits(iSqlJetMemoryPointer, aJournalMagic.remaining() + 8, this.dbOrigSize);
        this.put32bits(iSqlJetMemoryPointer, aJournalMagic.remaining() + 12, this.sectorSize);
        SqlJetUtility.memset(iSqlJetMemoryPointer, aJournalMagic.remaining() + 16, (byte)0, n2 - (aJournalMagic.remaining() + 16));
        if (this.journalHdr == 0L) {
            this.put32bits(iSqlJetMemoryPointer, aJournalMagic.remaining() + 16, this.pageSize);
        }
        for (int i3 = 0; sqlJetException == null && i3 < this.JOURNAL_HDR_SZ(); i3 += n2) {
            try {
                this.jfd.write(iSqlJetMemoryPointer, n2, this.journalOff);
            }
            catch (SqlJetException sqlJetException2) {
                sqlJetException = sqlJetException2;
            }
            this.journalOff += (long)n2;
        }
        if (sqlJetException != null) {
            throw sqlJetException;
        }
    }

    private long randomnessInt() {
        return SqlJetUtility.get4byteUnsigned(this.fileSystem.randomness(4));
    }

    private void put32bits(ISqlJetMemoryPointer iSqlJetMemoryPointer, int n2, int n3) {
        SqlJetUtility.put4byte(iSqlJetMemoryPointer, n2, n3);
    }

    private void put32bits(ISqlJetMemoryPointer iSqlJetMemoryPointer, int n2) {
        this.put32bits(iSqlJetMemoryPointer, 0, n2);
    }

    private void put32bitsUnsigned(ISqlJetMemoryPointer iSqlJetMemoryPointer, int n2, long l2) {
        SqlJetUtility.put4byteUnsigned(iSqlJetMemoryPointer, n2, l2);
    }

    private void openSubJournal() {
        if (this.journalOpen && this.sjfd == null) {
            this.sjfd = this.journalMode == SqlJetPagerJournalMode.MEMORY ? this.fileSystem.memJournalOpen() : this.openTemp(SqlJetFileType.SUBJOURNAL, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void openJournal() {
        block23: {
            SqlJetFileType sqlJetFileType = null;
            EnumSet enumSet = SqlJetUtility.of((Enum)SqlJetFileOpenPermission.READWRITE, (Enum)SqlJetFileOpenPermission.EXCLUSIVE, (Enum)SqlJetFileOpenPermission.CREATE);
            SqlJetException sqlJetException = null;
            assert (this.state.compareTo(SqlJetPagerState.RESERVED) >= 0);
            assert (this.useJournal);
            assert (this.pagesInJournal == null);
            this.getPageCount();
            this.pagesInJournal = new BitSet(this.dbSize);
            try {
                if (!this.journalOpen) {
                    if (this.tempFile) {
                        enumSet.add(SqlJetFileOpenPermission.DELETEONCLOSE);
                        sqlJetFileType = SqlJetFileType.TEMP_JOURNAL;
                    } else {
                        sqlJetFileType = SqlJetFileType.MAIN_JOURNAL;
                    }
                    try {
                        this.jfd = this.journalMode == SqlJetPagerJournalMode.MEMORY ? this.fileSystem.memJournalOpen() : this.fileSystem.open(this.journal, sqlJetFileType, enumSet);
                    }
                    catch (SqlJetException sqlJetException2) {
                        sqlJetException = sqlJetException2;
                    }
                    assert (sqlJetException != null || this.jfd != null);
                    this.journalOff = 0L;
                    this.setMaster = false;
                    this.journalHdr = 0L;
                    if (sqlJetException != null) {
                        this.fileSystem.delete(this.journal, false);
                        throw sqlJetException;
                    }
                }
                this.journalOpen = true;
                this.journalStarted = false;
                this.needSync = false;
                this.nRec = 0;
                if (this.errCode != null) {
                    sqlJetException = new SqlJetException(this.errCode);
                    throw sqlJetException;
                }
                this.dbOrigSize = this.dbSize;
                try {
                    this.writeJournalHdr();
                }
                catch (SqlJetException sqlJetException3) {
                    sqlJetException = sqlJetException3;
                }
                if (this.nSavepoint > 0 && sqlJetException == null) {
                    try {
                        this.openSubJournal();
                    }
                    catch (SqlJetException sqlJetException4) {
                        sqlJetException = sqlJetException4;
                    }
                }
                if (sqlJetException != null) {
                    sqlJetException = null;
                    try {
                        this.endTransaction(false);
                    }
                    catch (SqlJetException sqlJetException5) {
                        sqlJetException = sqlJetException5;
                    }
                    if (sqlJetException == null) {
                        sqlJetException = new SqlJetException(SqlJetErrorCode.FULL);
                        throw sqlJetException;
                    }
                }
                Object var6_9 = null;
                if (sqlJetException == null) break block23;
                this.pagesInJournal = null;
            }
            catch (Throwable throwable) {
                Object var6_10 = null;
                if (sqlJetException != null) {
                    this.pagesInJournal = null;
                    throw sqlJetException;
                }
                throw throwable;
            }
            throw sqlJetException;
        }
    }

    public void commitPhaseOne(String string, boolean bl2) {
        block13: {
            if (this.errCode != null) {
                throw new SqlJetException(this.errCode);
            }
            if (!this.dbModified && (this.journalMode != SqlJetPagerJournalMode.DELETE || this.exclusiveMode())) {
                assert (!this.dirtyCache || !this.journalOpen);
                return;
            }
            SqlJetPager.PAGERTRACE("DATABASE SYNC: File=%s zMaster=%s nSize=%d\n", this.fileName, string, this.dbSize);
            try {
                if (this.state != SqlJetPagerState.SYNCED && !this.memDb && this.dirtyCache) {
                    if (!this.setMaster) {
                        this.incrChangeCounter();
                        if (this.journalMode != SqlJetPagerJournalMode.OFF) {
                            if (this.dbSize < this.dbOrigSize) {
                                long l2 = this.PAGER_MJ_PGNO();
                                int n2 = this.dbSize;
                                this.dbSize = this.dbOrigSize;
                                for (int i2 = n2 + 1; i2 <= this.dbOrigSize; ++i2) {
                                    if (SqlJetUtility.bitSetTest(this.pagesInJournal, i2) || (long)i2 == l2) continue;
                                    ISqlJetPage iSqlJetPage = this.getPage(i2);
                                    iSqlJetPage.write();
                                    iSqlJetPage.unref();
                                }
                                this.dbSize = n2;
                            }
                            this.writeMasterJournal(string);
                            this.syncJournal();
                        }
                    }
                    ISqlJetPage iSqlJetPage = this.pageCache.getDirtyList();
                    this.writePageList(iSqlJetPage);
                    this.pageCache.cleanAll();
                    if (this.dbSize != this.dbFileSize) {
                        assert (this.state.compareTo(SqlJetPagerState.EXCLUSIVE) >= 0);
                        this.doTruncate(this.dbSize - ((long)this.dbSize == this.PAGER_MJ_PGNO() ? 1 : 0));
                    }
                    if (!this.noSync && !bl2) {
                        this.fd.sync(this.syncFlags);
                    }
                    this.state = SqlJetPagerState.SYNCED;
                }
            }
            catch (SqlJetIOException sqlJetIOException) {
                if (sqlJetIOException.getIoErrorCode() != SqlJetIOErrorCode.IOERR_BLOCKED) break block13;
                throw new SqlJetException(SqlJetErrorCode.BUSY);
            }
        }
    }

    private void writePageList(ISqlJetPage iSqlJetPage) {
        if (iSqlJetPage == null) {
            return;
        }
        this.waitOnLock(SqlJetLockType.EXCLUSIVE);
        for (ISqlJetPage iSqlJetPage2 = iSqlJetPage; iSqlJetPage2 != null; iSqlJetPage2 = iSqlJetPage2.getDirty()) {
            if (null == this.fd) {
                assert (this.tempFile);
                this.fd = this.openTemp(this.type, this.permissions);
            }
            if (iSqlJetPage2.getPageNumber() <= this.dbSize && !iSqlJetPage2.getFlags().contains((Object)SqlJetPageFlags.DONT_WRITE)) {
                long l2 = (long)(iSqlJetPage2.getPageNumber() - 1) * (long)this.pageSize;
                SqlJetPager.PAGERTRACE("STORE %s page %d hash(%08x)\n", this.PAGERID(), iSqlJetPage.getPageNumber(), this.pageHash(iSqlJetPage));
                ISqlJetMemoryPointer iSqlJetMemoryPointer = iSqlJetPage2.getData();
                this.fd.write(iSqlJetMemoryPointer, this.pageSize, l2);
                if (iSqlJetPage2.getPageNumber() == 1) {
                    SqlJetUtility.memcpy(this.dbFileVers, 0, iSqlJetMemoryPointer, 24, this.dbFileVers.remaining());
                }
                if (iSqlJetPage2.getPageNumber() > this.dbFileSize) {
                    this.dbFileSize = iSqlJetPage2.getPageNumber();
                }
            } else {
                SqlJetPager.PAGERTRACE("NOSTORE %s page %d\n", this.PAGERID(), iSqlJetPage.getPageNumber());
            }
            iSqlJetPage2.setHash(this.pageHash(iSqlJetPage2));
        }
    }

    private ISqlJetFile openTemp(SqlJetFileType sqlJetFileType, Set set) {
        AbstractSet abstractSet = null;
        if (set != null) {
            abstractSet = new HashSet();
            for (SqlJetFileOpenPermission sqlJetFileOpenPermission : set) {
                abstractSet.add(sqlJetFileOpenPermission);
            }
        } else {
            abstractSet = SqlJetUtility.noneOf(SqlJetFileOpenPermission.class);
        }
        abstractSet.add(SqlJetFileOpenPermission.READWRITE);
        abstractSet.add(SqlJetFileOpenPermission.CREATE);
        abstractSet.add(SqlJetFileOpenPermission.EXCLUSIVE);
        abstractSet.add(SqlJetFileOpenPermission.DELETEONCLOSE);
        return this.fileSystem.open(null, sqlJetFileType, abstractSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeMasterJournal(String string) {
        int n2 = 0;
        ISqlJetMemoryPointer iSqlJetMemoryPointer = SqlJetUtility.allocatePtr(aJournalMagic.remaining() + 8);
        if (null == string || this.setMaster) {
            return;
        }
        if (this.journalMode == SqlJetPagerJournalMode.MEMORY) {
            return;
        }
        this.setMaster = true;
        ISqlJetMemoryPointer iSqlJetMemoryPointer2 = SqlJetUtility.wrapPtr(string.getBytes());
        int n3 = iSqlJetMemoryPointer2.remaining();
        for (int i2 = 0; i2 < n3; ++i2) {
            n2 += SqlJetUtility.getUnsignedByte(iSqlJetMemoryPointer2, i2);
        }
        if (this.fullSync) {
            this.seekJournalHdr();
        }
        long l2 = this.journalOff;
        this.journalOff += (long)(n3 + 20);
        SqlJetPager.write32bits(this.jfd, l2, this.int_PAGER_MJ_PGNO());
        this.jfd.write(iSqlJetMemoryPointer2, n3, l2 += 4L);
        l2 += (long)n3;
        this.put32bits(iSqlJetMemoryPointer, n3);
        this.put32bits(iSqlJetMemoryPointer, 4, n2);
        SqlJetUtility.memcpy(iSqlJetMemoryPointer, 8, aJournalMagic, 0, aJournalMagic.remaining());
        try {
            this.jfd.write(iSqlJetMemoryPointer, iSqlJetMemoryPointer.remaining(), l2);
            Object var12_8 = null;
        }
        catch (Throwable throwable) {
            Object var12_9 = null;
            l2 += (long)iSqlJetMemoryPointer.remaining();
            this.needSync = !this.noSync;
            throw throwable;
        }
        this.needSync = !this.noSync;
        long l3 = this.jfd.fileSize();
        if (l3 > (l2 += (long)iSqlJetMemoryPointer.remaining())) {
            this.jfd.truncate(l2);
        }
    }

    private void incrChangeCounter() {
        if (!this.changeCountDone && this.dbSize > 0) {
            ISqlJetPage iSqlJetPage = this.getPage(1);
            try {
                iSqlJetPage.write();
            }
            catch (SqlJetException sqlJetException) {
                iSqlJetPage.unref();
                throw sqlJetException;
            }
            int n2 = SqlJetUtility.get4byte(this.dbFileVers);
            this.put32bits(iSqlJetPage.getData(), 24, ++n2);
            iSqlJetPage.unref();
            this.changeCountDone = true;
        }
    }

    public void commitPhaseTwo() {
        if (null != this.errCode) {
            throw new SqlJetException(this.errCode);
        }
        if (this.state.compareTo(SqlJetPagerState.RESERVED) < 0) {
            throw new SqlJetException(SqlJetErrorCode.ERROR);
        }
        if (!(this.dbModified || this.journalMode == SqlJetPagerJournalMode.DELETE && this.exclusiveMode())) {
            assert (!this.dirtyCache || !this.journalOpen);
            return;
        }
        SqlJetPager.PAGERTRACE("COMMIT %s\n", this.PAGERID());
        assert (this.state == SqlJetPagerState.SYNCED || this.memDb || !this.dirtyCache);
        try {
            this.endTransaction(this.setMaster);
        }
        catch (SqlJetException sqlJetException) {
            this.error(sqlJetException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() {
        block10: {
            SqlJetPager.PAGERTRACE("ROLLBACK %s\n", this.PAGERID());
            if (!this.dirtyCache || !this.journalOpen) {
                this.endTransaction(this.setMaster);
            } else {
                if (null != this.errCode && this.errCode != SqlJetErrorCode.FULL) {
                    if (this.state.compareTo(SqlJetPagerState.EXCLUSIVE) >= 0) {
                        this.playback(false);
                    }
                    throw new SqlJetException(this.errCode);
                }
                try {
                    if (this.state == SqlJetPagerState.RESERVED) {
                        try {
                            this.playback(false);
                            Object var2_1 = null;
                            this.endTransaction(this.setMaster);
                            break block10;
                        }
                        catch (Throwable throwable) {
                            Object var2_2 = null;
                            this.endTransaction(this.setMaster);
                            throw throwable;
                        }
                    }
                    this.playback(false);
                }
                catch (SqlJetException sqlJetException) {
                    if (!this.memDb) {
                        this.dbSizeValid = false;
                    }
                    this.error(sqlJetException);
                }
            }
        }
    }

    public void sync() {
        if (!this.memDb) {
            this.fd.sync(this.syncFlags);
        }
    }

    public int getRefCount() {
        return this.pageCache.getRefCount();
    }

    public void pageCallback(ISqlJetPage iSqlJetPage) {
        if (!(iSqlJetPage instanceof SqlJetPage)) {
            return;
        }
        SqlJetPage sqlJetPage = (SqlJetPage)iSqlJetPage;
        if (this.doNotSync) {
            return;
        }
        assert (sqlJetPage.getFlags().contains((Object)SqlJetPageFlags.DIRTY));
        if (this.errCode == null) {
            try {
                if (sqlJetPage.getFlags().contains((Object)SqlJetPageFlags.NEED_SYNC)) {
                    this.syncJournal();
                    if (this.fullSync && this.journalMode != SqlJetPagerJournalMode.MEMORY && !this.fd.deviceCharacteristics().contains((Object)SqlJetDeviceCharacteristics.IOCAP_SAFE_APPEND)) {
                        this.nRec = 0;
                        this.writeJournalHdr();
                    }
                }
                sqlJetPage.pDirty = null;
                if (sqlJetPage.getPageNumber() > this.dbSize && SqlJetPager.subjRequiresPage(sqlJetPage)) {
                    this.subjournalPage(sqlJetPage);
                }
                this.writePageList(sqlJetPage);
            }
            catch (SqlJetException sqlJetException) {
                this.error(sqlJetException);
            }
        }
        SqlJetPager.PAGERTRACE("STRESS %s page %d\n", this.PAGERID(), sqlJetPage.pgno);
        this.pageCache.makeClean(sqlJetPage);
    }

    public void openSavepoint(int n2) {
        if (n2 > this.nSavepoint && this.useJournal) {
            assert (this.nSavepoint == 0 || this.sjfd != null || this.journalMode == SqlJetPagerJournalMode.MEMORY);
            SqlJetCloneable[] sqlJetCloneableArray = new SqlJetPager$PagerSavepoint[n2];
            SqlJetUtility.memcpy(sqlJetCloneableArray, this.aSavepoint, n2);
            this.aSavepoint = sqlJetCloneableArray;
            this.nSavepoint = n2;
            for (int i2 = this.nSavepoint; i2 < n2; ++i2) {
                assert (this.dbSizeValid);
                ((SqlJetPager$PagerSavepoint)sqlJetCloneableArray[i2]).nOrig = this.dbSize;
                ((SqlJetPager$PagerSavepoint)sqlJetCloneableArray[i2]).iOffset = this.journalOpen && this.journalOff > 0L ? this.journalOff : (long)this.JOURNAL_HDR_SZ();
                ((SqlJetPager$PagerSavepoint)sqlJetCloneableArray[i2]).iSubRec = this.stmtNRec;
                ((SqlJetPager$PagerSavepoint)sqlJetCloneableArray[i2]).pInSavepoint = new BitSet(this.dbSize);
            }
            this.openSubJournal();
        }
    }

    public void savepoint(SqlJetSavepointOperation sqlJetSavepointOperation, int n2) {
        SqlJetException sqlJetException = null;
        assert (sqlJetSavepointOperation == SqlJetSavepointOperation.RELEASE || sqlJetSavepointOperation == SqlJetSavepointOperation.ROLLBACK);
        if (n2 < this.nSavepoint) {
            int n3;
            block11: {
                for (int i2 = n3 = n2 + (sqlJetSavepointOperation == SqlJetSavepointOperation.ROLLBACK ? 1 : 0); i2 < this.nSavepoint; ++i2) {
                    this.aSavepoint[i2].pInSavepoint = null;
                }
                this.nSavepoint = n3;
                if (sqlJetSavepointOperation == SqlJetSavepointOperation.ROLLBACK && this.jfd != null) {
                    SqlJetPager$PagerSavepoint sqlJetPager$PagerSavepoint = n3 == 0 ? null : this.aSavepoint[n3 - 1];
                    try {
                        this.playbackSavepoint(sqlJetPager$PagerSavepoint);
                    }
                    catch (SqlJetException sqlJetException2) {
                        sqlJetException = sqlJetException2;
                        if ($assertionsDisabled || sqlJetException.getErrorCode() != SqlJetErrorCode.DONE) break block11;
                        throw new AssertionError();
                    }
                }
            }
            if (n3 == 0 && sqlJetSavepointOperation == SqlJetSavepointOperation.RELEASE && this.sjfd != null) {
                assert (sqlJetException == null);
                try {
                    this.sjfd.truncate(0L);
                }
                catch (SqlJetException sqlJetException3) {
                    sqlJetException = sqlJetException3;
                }
                this.stmtNRec = 0;
            }
        }
        if (sqlJetException != null) {
            throw sqlJetException;
        }
    }
}

